/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.CallableTime;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionTime
extends AbstractInjectionMonobit<CallableTime> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isTimeInjectable = true;

    public InjectionTime(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode booleanMode) {
        super(injectionModel, booleanMode);
        if (this.falseTests.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetTimeTagFalse");
        ArrayList<CallableTime> callablesFalseTest = new ArrayList<CallableTime>();
        for (String falseTest : this.falseTests) {
            callablesFalseTest.add(new CallableTime(falseTest, injectionModel, this, booleanMode, "time#falsy"));
        }
        try {
            List futuresFalseTest = taskExecutor.invokeAll(callablesFalseTest);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future futureFalseTest : futuresFalseTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (!((CallableTime)futureFalseTest.get()).isTrue()) continue;
                this.isTimeInjectable = false;
                return;
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.checkTrueTests(booleanMode);
    }

    private void checkTrueTests(AbstractInjectionBoolean.BooleanMode booleanMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetTimeTagTrue");
        ArrayList<CallableTime> callablesTrueTest = new ArrayList<CallableTime>();
        for (String trueTest : this.trueTests) {
            callablesTrueTest.add(new CallableTime(trueTest, this.injectionModel, this, booleanMode, "time#truthy"));
        }
        try {
            List futuresTrueTest = taskExecutor.invokeAll(callablesTrueTest);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future futureTrueTest : futuresTrueTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (((CallableTime)futureTrueTest.get()).isTrue()) continue;
                this.isTimeInjectable = false;
                return;
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableTime getCallableBitTest(String sqlQuery, int indexCharacter, int bit) {
        return new CallableTime(sqlQuery, indexCharacter, bit, this.injectionModel, this, this.booleanMode, "bit#" + indexCharacter + "~" + bit);
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableTime timeTest = new CallableTime(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBooleanInitialization(), this.injectionModel, this, this.booleanMode, "time#confirm");
        try {
            timeTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return this.isTimeInjectable && timeTest.isTrue();
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Time: query True when delaying for 5s\n\n";
    }
}

