/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractCallableBoolean;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractInjectionBoolean<T extends AbstractCallableBoolean<T>> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected final List<String> falseTests;
    protected final List<String> trueTests;
    protected final InjectionModel injectionModel;
    protected final BooleanMode booleanMode;

    protected AbstractInjectionBoolean(InjectionModel injectionModel, BooleanMode booleanMode) {
        this.injectionModel = injectionModel;
        this.booleanMode = booleanMode;
        this.falseTests = this.injectionModel.getMediatorVendor().getVendor().instance().getListFalseTest();
        this.trueTests = this.injectionModel.getMediatorVendor().getVendor().instance().getListTrueTest();
    }

    public abstract boolean isInjectable() throws StoppedByUserSlidingException;

    public abstract void initializeNextCharacters(String var1, List<char[]> var2, AtomicInteger var3, CompletionService<T> var4, AtomicInteger var5);

    public abstract char[] initializeBinaryMask(List<char[]> var1, T var2);

    public abstract String getInfoMessage();

    public String inject(String sqlQuery, AbstractSuspendable suspendable) throws StoppedByUserSlidingException {
        ArrayList<char[]> bytes = new ArrayList<char[]>();
        AtomicInteger indexCharacter = new AtomicInteger(0);
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableAbstractBoolean");
        ExecutorCompletionService taskCompletionService = new ExecutorCompletionService(taskExecutor);
        AtomicInteger countTasksSubmitted = new AtomicInteger(0);
        AtomicInteger countBadAsciiCode = new AtomicInteger(0);
        this.initializeNextCharacters(sqlQuery, bytes, indexCharacter, taskCompletionService, countTasksSubmitted);
        while (countTasksSubmitted.get() > 0) {
            if (suspendable.isSuspended()) {
                String result = this.stop(bytes, taskExecutor);
                throw new StoppedByUserSlidingException(result);
            }
            try {
                AbstractCallableBoolean currentCallable = (AbstractCallableBoolean)taskCompletionService.take().get();
                countTasksSubmitted.decrementAndGet();
                this.injectCharacter(bytes, countTasksSubmitted, countBadAsciiCode, currentCallable);
                this.initializeNextCharacters(sqlQuery, bytes, indexCharacter, taskCompletionService, countTasksSubmitted);
                String result = AbstractInjectionBoolean.convert(bytes);
                if (!result.matches("(?s).*\\x01\\x03\\x03\\x07.*")) continue;
                countTasksSubmitted.set(0);
                break;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            catch (InjectionFailureException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, e.getMessage());
                break;
            }
        }
        return this.stop(bytes, taskExecutor);
    }

    private static String convert(List<char[]> bytes) {
        StringBuilder result = new StringBuilder();
        for (char[] c : bytes) {
            try {
                int charCode = Integer.parseInt(new String(c), 2);
                String str = Character.toString((char)charCode);
                result.append(str);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result.toString();
    }

    private void injectCharacter(List<char[]> bytes, AtomicInteger countTasksSubmitted, AtomicInteger countBadAsciiCode, T currentCallable) throws InjectionFailureException {
        char[] asciiCodeMask = this.initializeBinaryMask(bytes, currentCallable);
        String asciiCodeBinary = new String(asciiCodeMask);
        if (asciiCodeBinary.matches("^[01]{8}$")) {
            String charText;
            int asciiCode = Integer.parseInt(asciiCodeBinary, 2);
            if (asciiCode == 127 || asciiCode == 0) {
                if (countTasksSubmitted.get() != 0 && countBadAsciiCode.get() > 15) {
                    throw new InjectionFailureException("Boolean false positive, stopping...");
                }
                countBadAsciiCode.incrementAndGet();
            }
            ((AbstractCallableBoolean)currentCallable).charText = charText = Character.toString((char)asciiCode);
            Request interaction = new Request();
            interaction.setMessage(Interaction.MESSAGE_BINARY);
            interaction.setParameters(asciiCodeBinary + "=" + charText.replace("\\n", "\\\\\\n").replace("\\r", "\\\\\\r").replace("\\t", "\\\\\\t"));
            this.injectionModel.sendToViews(interaction);
        }
    }

    private String stop(List<char[]> bytes, ExecutorService taskExecutor) {
        boolean isTerminated = false;
        try {
            taskExecutor.shutdown();
            isTerminated = taskExecutor.awaitTermination(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!isTerminated) {
            taskExecutor.shutdownNow();
        }
        StringBuilder result = new StringBuilder();
        for (char[] c : bytes) {
            try {
                int charCode = Integer.parseInt(new String(c), 2);
                String str = Character.toString((char)charCode);
                result.append(str);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result.toString();
    }

    public String callUrl(String urlString, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess);
    }

    public String callUrl(String urlString, String metadataInjectionProcess, AbstractCallableBoolean<?> callableBoolean) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess, callableBoolean);
    }

    public BooleanMode getBooleanMode() {
        return this.booleanMode;
    }

    public static enum BooleanMode {
        AND,
        OR,
        STACKED;

    }
}

