/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.util;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.dialog.DialogAbout;
import com.jsql.view.swing.text.JPlaceholder;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.tree.model.NodeModelEmpty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;

public class I18nViewUtil {
    private static final Map<String, Set<Object>> COMPONENTS_LOCALIZED = new HashMap<String, Set<Object>>();

    private I18nViewUtil() {
    }

    public static Set<String> keys() {
        return COMPONENTS_LOCALIZED.keySet();
    }

    public static Set<Object> componentsByKey(String key) {
        return COMPONENTS_LOCALIZED.get(key);
    }

    public static void switchI18nComponents() {
        LinkedHashMap<Class<JTextComponent>, BiConsumer<Object, String>> classHandlers = new LinkedHashMap<Class<JTextComponent>, BiConsumer<Object, String>>();
        classHandlers.put(JPlaceholder.class, (c, s) -> ((JPlaceholder)c).setPlaceholderText(I18nUtil.valueByKey(s)));
        classHandlers.put(DialogAbout.class, (c, s) -> ((DialogAbout)c).setTitle(I18nUtil.valueByKey(s) + " jSQL Injection"));
        classHandlers.put(JToolTipI18n.class, (c, s) -> ((JToolTipI18n)c).setText(I18nViewUtil.valueByKey(s)));
        classHandlers.put(NodeModelEmpty.class, (c, s) -> ((NodeModelEmpty)c).setText(I18nViewUtil.valueByKey(s)));
        classHandlers.put(JLabel.class, (c, s) -> ((JLabel)c).setText(I18nViewUtil.valueByKey(s)));
        classHandlers.put(JMenuItem.class, (c, s) -> ((JMenuItem)c).setText(I18nViewUtil.valueByKey(s)));
        classHandlers.put(JButton.class, (c, s) -> ((JButton)c).setText(I18nViewUtil.valueByKey(s)));
        classHandlers.put(JComboBox.class, (c, s) -> ((JComboBox)c).setToolTipText(I18nViewUtil.valueByKey(s)));
        classHandlers.put(JTextComponent.class, (c, s) -> ((JTextComponent)c).setText(I18nViewUtil.valueByKey(s)));
        for (String key : I18nViewUtil.keys()) {
            for (Object component : I18nViewUtil.componentsByKey(key)) {
                classHandlers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(component)).findFirst().ifPresent(entry -> ((BiConsumer)entry.getValue()).accept(component, key));
            }
        }
    }

    public static void addComponentForKey(String key, Object component) {
        COMPONENTS_LOCALIZED.get(key.replace(" ", "_")).add(component);
    }

    public static String valueByKey(String key) {
        return I18nViewUtil.isNonUbuntu(I18nUtil.getCurrentLocale()) ? I18nViewUtil.formatNonLatin(I18nUtil.valueByKey(key)) : I18nUtil.valueByKey(key);
    }

    public static boolean isNonUbuntu(Locale locale) {
        return Locale.forLanguageTag("zh").getLanguage().equals(locale.getLanguage()) || Locale.forLanguageTag("ko").getLanguage().equals(locale.getLanguage()) || Locale.forLanguageTag("ja").getLanguage().equals(locale.getLanguage());
    }

    public static String formatNonLatin(String label) {
        return I18nViewUtil.formatNonLatin(label, "");
    }

    public static String formatNonLatin(String label, String custom) {
        return String.format("<html><span style=\"font-family:'%s';%s\">%s</span></html>", "Monospace", custom, label);
    }

    static {
        for (String keyI18n : I18nUtil.BUNDLE_ROOT.keySet()) {
            COMPONENTS_LOCALIZED.put(keyI18n, new HashSet());
        }
    }
}

