/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab.dnd;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.tab.dnd.DnDTabData;
import com.jsql.view.swing.tab.dnd.DnDTabbedPane;
import com.jsql.view.swing.tab.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabTransferHandler
extends TransferHandler {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected final DataFlavor localObjectFlavor = new DataFlavor(DnDTabData.class, "DnDTabData");
    protected DnDTabbedPane source;

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof DnDTabbedPane) {
            this.source = (DnDTabbedPane)c;
        }
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{TabTransferHandler.this.localObjectFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return Objects.equals(TabTransferHandler.this.localObjectFlavor, flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return new DnDTabData(TabTransferHandler.this.source);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean isAreaContains;
        if (!support.isDrop() || !support.isDataFlavorSupported(this.localObjectFlavor)) {
            return false;
        }
        support.setDropAction(2);
        TransferHandler.DropLocation tdl = support.getDropLocation();
        Point pt = tdl.getDropPoint();
        DnDTabbedPane target = (DnDTabbedPane)support.getComponent();
        target.autoScrollTest(pt);
        DnDTabbedPane.DnDDropLocation dl = target.dropLocationForPointDnD(pt);
        int idx = dl.getIndex();
        boolean isDroppable = false;
        boolean bl = isAreaContains = target.getTabAreaBounds().contains(pt) && idx >= 0;
        isDroppable = target.equals(this.source) ? isAreaContains && idx != target.dragTabIndex && idx != target.dragTabIndex + 1 : Optional.ofNullable(this.source).map(c -> !c.isAncestorOf(target)).orElse(false) != false && isAreaContains;
        Cursor cursor = isDroppable ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
        Component glassPane = target.getRootPane().getGlassPane();
        glassPane.setCursor(cursor);
        target.setCursor(cursor);
        support.setShowDropLocation(isDroppable);
        dl.setDroppable(isDroppable);
        target.setDropLocation(dl, isDroppable);
        return isDroppable;
    }

    private BufferedImage makeDragTabImage(DnDTabbedPane tabbedPane) {
        Rectangle rect = tabbedPane.getBoundsAt(tabbedPane.dragTabIndex);
        BufferedImage image = new BufferedImage(tabbedPane.getWidth(), tabbedPane.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        tabbedPane.paint(g2);
        g2.dispose();
        if (rect.x < 0) {
            rect.translate(-rect.x, 0);
        }
        if (rect.y < 0) {
            rect.translate(0, -rect.y);
        }
        if (rect.x + rect.width > image.getWidth()) {
            rect.width = image.getWidth() - rect.x;
        }
        if (rect.y + rect.height > image.getHeight()) {
            rect.height = image.getHeight() - rect.y;
        }
        return image.getSubimage(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c instanceof DnDTabbedPane) {
            DnDTabbedPane src = (DnDTabbedPane)c;
            c.getRootPane().setGlassPane(new GhostGlassPane(src));
            if (src.dragTabIndex < 0) {
                return 0;
            }
            this.setDragImage(this.makeDragTabImage(src));
            c.getRootPane().getGlassPane().setVisible(true);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        DnDTabbedPane target = (DnDTabbedPane)support.getComponent();
        DnDTabbedPane.DnDDropLocation dl = target.getDropLocation();
        try {
            DnDTabData data = (DnDTabData)support.getTransferable().getTransferData(this.localObjectFlavor);
            DnDTabbedPane src = data.tabbedPane;
            int index = dl.getIndex();
            if (target.equals(src)) {
                src.convertTab(src.dragTabIndex, index);
            } else {
                src.exportTab(src.dragTabIndex, target, index);
            }
            return true;
        }
        catch (UnsupportedFlavorException | IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        DnDTabbedPane src = (DnDTabbedPane)c;
        src.getRootPane().getGlassPane().setVisible(false);
        src.setDropLocation(null, false);
        src.repaint();
        src.setCursor(Cursor.getPredefinedCursor(0));
    }
}

