/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.dialog;

import com.jsql.util.GitUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.dialog.translate.Language;
import com.jsql.view.swing.dialog.translate.WorkerTranslateInto;
import com.jsql.view.swing.popupmenu.JPopupMenuText;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextAreaPlaceholder;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogTranslate
extends JDialog {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final JButton buttonSend = new JButton();
    private Language languageInto;
    private final JLabel labelTranslation = new JLabel();
    private final JTextArea textToTranslate = (JTextArea)new JPopupTextArea(new JTextAreaPlaceholder(I18nViewUtil.valueByKey("TRANSLATION_PLACEHOLDER"))).getProxy();
    private final JProgressBar progressBarTranslation = new JProgressBar();
    private String textBeforeChange = "";
    private JPanel lastLine;

    public DialogTranslate() {
        super((Window)MediatorHelper.frame(), Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.setIconImages(UiUtil.getIcons());
        ActionListener escapeListener = actionEvent -> this.dispose();
        this.getRootPane().registerKeyboardAction(escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.initLastLine();
        this.labelTranslation.setBorder(UiUtil.BORDER_5PX);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.labelTranslation, "North");
        contentPane.add((Component)this.lastLine, "South");
        this.initTextToTranslate();
        contentPane.add((Component)new JScrollPane(this.textToTranslate), "Center");
    }

    public final void initDialog(Language language) {
        this.progressBarTranslation.setValue(0);
        this.progressBarTranslation.setString("Loading...");
        this.languageInto = language;
        ResourceBundle bundleInto = ResourceBundle.getBundle("i18n.jsql", Locale.forLanguageTag(language.getLanguageTag()));
        Locale localeInto = Locale.forLanguageTag(language.getLanguageTag());
        this.labelTranslation.setText(String.format(bundleInto.getString("TRANSLATION_TEXT"), localeInto.getDisplayLanguage(localeInto), localeInto.getDisplayLanguage(localeInto)));
        ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.forLanguageTag(language.getLanguageTag()));
        this.labelTranslation.setComponentOrientation(orientation);
        this.progressBarTranslation.setComponentOrientation(orientation);
        this.lastLine.setComponentOrientation(orientation);
        this.buttonSend.setText(ResourceBundle.getBundle("i18n.jsql", Locale.forLanguageTag(language.getLanguageTag())).getString("TRANSLATION_SEND"));
        this.textToTranslate.setText(null);
        this.textToTranslate.setEditable(false);
        this.buttonSend.setEnabled(false);
        this.textToTranslate.setFont(new Font("Monospaced", 0, UIManager.getDefaults().getFont("TextField.font").getSize()));
        new WorkerTranslateInto(this).execute();
        this.setIconImage(language.getFlag().getImage());
        this.setTitle(bundleInto.getString("TRANSLATION_TITLE") + " " + localeInto.getDisplayLanguage(localeInto));
        if (!this.isVisible()) {
            this.setSize(640, 460);
            this.setLocationRelativeTo(MediatorHelper.frame());
            this.getRootPane().setDefaultButton(this.getButtonSend());
        }
        this.setVisible(true);
    }

    private void initLastLine() {
        this.lastLine = new JPanel();
        this.lastLine.setLayout(new BoxLayout(this.lastLine, 2));
        this.lastLine.setBorder(UiUtil.BORDER_5PX);
        this.buttonSend.setToolTipText(String.join((CharSequence)"", "<html>", "<b>Send your translation to the developer</b><br>", "Your translation will be integrated in the next version of jSQL", "</html>"));
        this.buttonSend.addActionListener(actionEvent -> {
            if (this.textToTranslate.getText().equals(this.textBeforeChange)) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Nothing changed, translate a piece of text then click on Send");
                return;
            }
            String clientDescription = this.textToTranslate.getText().replace("\\\\", "\\\\\\\\").replaceAll("(?m)^#", "\\\\#").replace("<", "\\<");
            MediatorHelper.model().getMediatorUtils().getGitUtil().sendReport(clientDescription, GitUtil.ShowOnConsole.YES, String.valueOf((Object)this.languageInto) + " translation");
            this.setVisible(false);
        });
        this.setLayout(new BorderLayout());
        this.progressBarTranslation.setStringPainted(true);
        this.progressBarTranslation.setValue(0);
        this.lastLine.add(this.progressBarTranslation);
        this.lastLine.add(Box.createGlue());
        this.lastLine.add(this.buttonSend);
    }

    private void initTextToTranslate() {
        this.textToTranslate.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                DialogTranslate.this.textToTranslate.requestFocusInWindow();
            }
        });
        this.textToTranslate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DialogTranslate.this.textToTranslate.getCaret().setVisible(true);
                DialogTranslate.this.textToTranslate.getCaret().setSelectionVisible(true);
            }
        });
        this.textToTranslate.setBorder(UiUtil.BORDER_5PX);
        this.textToTranslate.setDragEnabled(true);
        this.textToTranslate.getCaret().setBlinkRate(500);
        this.textToTranslate.setComponentPopupMenu(new JPopupMenuText(this.textToTranslate));
    }

    public Language getLanguageInto() {
        return this.languageInto;
    }

    public String getTextBeforeChange() {
        return this.textBeforeChange;
    }

    public void setTextBeforeChange(String textBeforeChange) {
        this.textBeforeChange = textBeforeChange;
    }

    public JButton getButtonSend() {
        return this.buttonSend;
    }

    public JTextArea getTextToTranslate() {
        return this.textToTranslate;
    }

    public JProgressBar getProgressBarTranslation() {
        return this.progressBarTranslation;
    }
}

