/*************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/
#ifdef MBX_FIPS_MODE

#include <crypto_mb/fips_cert.h>
#include <internal/fips_cert/common.h>
#include <internal/rsa/ifma_rsa_method.h>

#include <crypto_mb/rsa.h>

/* KAT TEST (generated via internal tests) */
/* moduli */
static const int8u moduli[MBX_RSA2K_DATA_BYTE_LEN] = {
  0xbd,0x04,0xa0,0xc5,0xff,0x93,0x74,0xba,0x75,0xe8,0x35,0x4e,0xad,0x87,0x9c,0xbc,
  0x8e,0xf4,0x8a,0x48,0x96,0x20,0xd3,0x5d,0x52,0x5b,0x4b,0x11,0x96,0x97,0x98,0x9a,
  0x8d,0xa4,0x97,0xc0,0x7b,0xd3,0x40,0x23,0xe1,0x7b,0x21,0x11,0xc9,0x0c,0x56,0x53,
  0xca,0x1c,0x3d,0xd3,0x34,0x4d,0xbd,0x18,0xe4,0x19,0xdf,0xeb,0x3b,0x70,0x2a,0x83,
  0xbc,0x07,0xb5,0xd9,0xe5,0xa9,0x34,0x4a,0xab,0x12,0x4e,0xaf,0x70,0xdc,0x2a,0xe8,
  0x7c,0xbf,0xe9,0xae,0x5c,0x18,0x57,0xa5,0xf4,0x10,0x5d,0xb7,0x5b,0x2d,0x30,0x8a,
  0xf6,0xa5,0x02,0x43,0xb0,0xcc,0x88,0x66,0xa1,0x1b,0x32,0x52,0x05,0x32,0x54,0x6f,
  0xb4,0x70,0x77,0x87,0xa6,0x8a,0xe0,0x11,0x55,0x92,0x19,0x79,0x12,0x35,0x47,0x0a,
  0x70,0x7f,0x40,0x7b,0xa1,0x00,0x69,0x9b,0x87,0x4b,0xcb,0x82,0x8c,0xa0,0x26,0x9e,
  0xb1,0xe3,0xce,0x53,0xd4,0xf1,0xb7,0x17,0x4c,0x30,0x85,0x7e,0xbb,0x0a,0xca,0xe0,
  0x35,0xb2,0x48,0x6a,0x0b,0x64,0xd7,0x1d,0xa5,0xaa,0x16,0x43,0xc8,0xe1,0x6a,0xa8,
  0x2f,0x29,0x96,0x7e,0x5f,0x8d,0x50,0x3e,0x25,0xf9,0x83,0xee,0x81,0xd8,0xd2,0xf2,
  0xe8,0xa6,0x38,0xa5,0x12,0xc2,0xfc,0xa4,0x99,0x67,0x35,0x36,0x20,0x92,0xca,0x4d,
  0x54,0xf4,0x49,0xe7,0x51,0x83,0xd8,0xbc,0x3a,0xf8,0xca,0x39,0xd0,0x18,0xb7,0x44,
  0x0d,0x7f,0xef,0xdf,0x0f,0x10,0x21,0x2d,0x63,0xf5,0x6d,0xfc,0xfb,0x1f,0xe4,0x02,
  0xa0,0x2b,0xd4,0xc9,0xa6,0x81,0x0e,0x20,0xbf,0x00,0x0d,0xd9,0xce,0x5f,0xda,0xa0};
/* private exponent */
static const int8u d[MBX_RSA2K_DATA_BYTE_LEN] = {
  0xe1,0xe4,0x56,0xf8,0x27,0x35,0x72,0x59,0x8b,0xa9,0x05,0xee,0xbf,0xd0,0x45,0xa2,
  0xe3,0xa0,0x35,0xc2,0x8a,0xed,0x5d,0xe5,0x1e,0x43,0x80,0x16,0x07,0xe8,0x2f,0x58,
  0xa6,0xfd,0x58,0x81,0xbc,0x9e,0x60,0xd0,0x4b,0x93,0xf2,0x5e,0x19,0x9b,0xca,0x9c,
  0x6e,0xcf,0x55,0x79,0xb6,0x28,0xf2,0x79,0x23,0x65,0xa7,0x57,0xb9,0x03,0x3a,0xa1,
  0x8e,0x9a,0x17,0x54,0xc7,0xdb,0x3c,0x27,0x1d,0xd4,0x17,0x93,0x79,0x56,0x25,0xba,
  0x31,0xb2,0xa1,0x1e,0x69,0xe5,0xc1,0x02,0x83,0x26,0xa4,0x76,0x69,0x35,0xcb,0xad,
  0x0f,0xe2,0x97,0xfa,0x71,0xa2,0x86,0xa0,0x0b,0x13,0x1d,0x1b,0x68,0xa3,0xd8,0xdf,
  0xea,0x28,0x57,0xd3,0x38,0x07,0x26,0x85,0x78,0xe4,0x91,0x0b,0xf0,0xd0,0xc3,0x4e,
  0x5f,0x63,0x60,0x95,0x83,0x49,0x85,0x5a,0xe8,0x22,0xe7,0x4f,0xbe,0xc0,0x16,0x0f,
  0xf8,0x4c,0x58,0xe6,0xf9,0x3a,0x8e,0x3e,0xec,0xfb,0x46,0x00,0x3b,0x1d,0x12,0x35,
  0xfa,0x2b,0xd1,0x81,0xbd,0x70,0xc0,0xca,0x92,0xb7,0xb0,0x5c,0x62,0x97,0x63,0x7f,
  0xb8,0x0a,0x64,0x99,0xdb,0x9b,0x22,0x2e,0x2a,0x7f,0x03,0xfc,0xd3,0x27,0xb3,0xc6,
  0xfa,0xbe,0x12,0xd5,0x86,0xd0,0x4e,0xb0,0x2b,0x1c,0xee,0x13,0x89,0x59,0xcb,0x86,
  0x9a,0xb3,0x73,0x42,0x57,0xc5,0x96,0x94,0x3b,0xae,0x2f,0x88,0xc1,0x66,0x4f,0x98,
  0x29,0xcf,0x29,0x2d,0xe8,0x2a,0x80,0xa5,0xfb,0xaf,0xe0,0x4a,0x83,0x0c,0xa3,0x06,
  0x22,0xb9,0x53,0x89,0x7d,0x7f,0x4b,0x61,0x0c,0x5b,0xc1,0xe7,0x80,0x01,0x83,0x5b};
/* plaintext */
static const int8u plaintext[MBX_RSA2K_DATA_BYTE_LEN] = {
  0x7c,0x79,0x2d,0xc8,0xfb,0x14,0x69,0x62,0x7c,0xcc,0xfd,0xc3,0xde,0x0b,0xc1,0x16,
  0x8e,0xca,0xe8,0x6f,0x93,0x3f,0xbc,0x7c,0x0a,0xd4,0x46,0xd8,0x15,0xbd,0x9e,0xe1,
  0x06,0x28,0x35,0x49,0x63,0xac,0x38,0x76,0xf1,0x3c,0x68,0xfb,0x42,0x1e,0x33,0xf9,
  0x9f,0x53,0xe6,0xd6,0x33,0x90,0x55,0xbe,0xc7,0x05,0xc8,0xed,0xa5,0x4b,0xa3,0x83,
  0xb9,0x78,0x19,0x55,0xd0,0x03,0x0a,0xad,0x3c,0xc3,0x44,0x03,0xf0,0x27,0x25,0xe4,
  0xb8,0xe0,0x59,0xf9,0xda,0xb5,0xeb,0x9f,0x5d,0x63,0xb6,0x21,0xfc,0x29,0xe2,0xa9,
  0xf3,0x8e,0x7b,0xb1,0x36,0xf8,0xb9,0x67,0x91,0x14,0xef,0x75,0xeb,0x95,0x37,0xd3,
  0x03,0x5f,0x94,0x61,0xc6,0x42,0xe1,0x8a,0x36,0x36,0xb3,0xe4,0x3f,0x99,0x97,0x68,
  0x75,0x85,0x9a,0xb9,0xd8,0x3c,0xa4,0x80,0xa4,0xdf,0xe5,0x16,0xfb,0x00,0x2c,0x18,
  0x6b,0xa4,0x91,0x7d,0x6e,0x32,0xca,0xdb,0xd1,0xb5,0xae,0x78,0x1d,0x46,0x87,0xaf,
  0xb9,0x10,0x8c,0x8a,0x3b,0x09,0x59,0x43,0x92,0x39,0xec,0x01,0xe0,0xb8,0x9e,0xad,
  0x30,0x5b,0x0e,0x0d,0x62,0x1a,0xdb,0xdb,0xdf,0xcd,0x05,0x19,0x41,0x77,0xc7,0xf8,
  0xd8,0x0c,0x41,0x57,0x67,0xa2,0x0a,0x56,0x67,0x77,0x04,0x5f,0xfd,0xc4,0x7b,0x0d,
  0x41,0x22,0xdc,0x50,0x11,0x3b,0x0e,0xe1,0x6a,0x91,0x1e,0x5f,0x4c,0x01,0xf1,0xec,
  0x8a,0x66,0x1b,0xf6,0xd3,0xbe,0xc9,0x98,0xad,0xa8,0x36,0x62,0xca,0x00,0xcb,0x76,
  0xa4,0xb8,0xb4,0x94,0x3c,0x60,0xc8,0xdf,0xc9,0x6a,0xcd,0x9b,0x7d,0xb7,0x55,0x73};
/* ciphertext */
static const int8u ciphertext[MBX_RSA2K_DATA_BYTE_LEN] = {
  0x8a,0x9b,0xf5,0xc2,0x9f,0xda,0x1b,0x63,0xd9,0x01,0xae,0x44,0xf5,0x7e,0x2c,0xec,
  0xf4,0x5e,0x3a,0x02,0x20,0x43,0x39,0xd4,0x87,0xed,0x46,0x8e,0xc0,0x02,0x74,0x77,
  0x5e,0x5e,0xaf,0xcd,0xe4,0x3a,0x70,0xd4,0xc7,0x47,0x9b,0xc3,0x9d,0x23,0x72,0xc7,
  0x7c,0x0a,0x00,0xc9,0xa8,0xc8,0xe4,0x4c,0xd2,0x0f,0x26,0xd3,0x3f,0x03,0x87,0xbc,
  0x8b,0xf8,0xe6,0x6c,0x9e,0xe8,0x18,0x88,0xfc,0xd2,0x1f,0x31,0xda,0xd6,0x09,0x63,
  0x02,0xa9,0xf2,0x8c,0x3b,0x77,0x3f,0x2c,0xdc,0x1a,0x29,0xb1,0x06,0xb8,0xbf,0x98,
  0x25,0xcd,0x70,0xd9,0x9d,0xf1,0xc2,0x19,0x8b,0x65,0x3e,0xce,0x49,0x25,0x4e,0x9f,
  0x23,0x41,0x28,0x8e,0x90,0x46,0x91,0x2a,0xae,0xe2,0xd2,0x5c,0x46,0x28,0x87,0x94,
  0x56,0xca,0x13,0x55,0x92,0xb4,0x7e,0x3a,0x0e,0xe4,0x28,0xf8,0xd4,0xa8,0x86,0x47,
  0x29,0xc0,0xdc,0xdc,0xc6,0x98,0xb4,0x29,0x3e,0x9b,0x51,0x97,0x13,0x11,0xac,0x4d,
  0x21,0x50,0x30,0xe8,0x44,0xcf,0xef,0x87,0x91,0xba,0x93,0x2e,0x2d,0xde,0xb5,0x87,
  0x42,0x76,0x8f,0x66,0x74,0xf0,0xa8,0x0f,0x6b,0x37,0x74,0x91,0x82,0x78,0x8a,0x41,
  0x31,0x29,0x5d,0x0d,0x4f,0x31,0x9f,0x04,0x3f,0xfa,0x6f,0x70,0x25,0xc3,0x21,0x7d,
  0xb6,0x29,0x5f,0x84,0x8e,0xc3,0x12,0x7c,0xe6,0x8b,0xbd,0xf7,0x85,0x82,0x26,0xd8,
  0x46,0x89,0xdb,0xa7,0x5e,0xd8,0x1d,0x8a,0xd8,0x17,0xcd,0x9c,0x62,0xf5,0x0c,0x1b,
  0xa0,0x49,0xe9,0x19,0x81,0xaf,0x8c,0x80,0xaf,0x8f,0x8f,0x57,0x7f,0x4e,0xc9,0xb7};

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa2k_private_mb8(void) {
  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output plaintext */
  int8u out_plaintext[MBX_LANES][MBX_RSA2K_DATA_BYTE_LEN];
  /* key operation */
  const mbx_RSA_Method* method = mbx_RSA2K_private_Method();

  /* function input parameters */
  // ciphertext
  const int8u *pa_ciphertext[MBX_LANES] = {
    ciphertext, ciphertext, ciphertext, ciphertext,
    ciphertext, ciphertext, ciphertext, ciphertext};
  // plaintext
  int8u *pa_plaintext[MBX_LANES] = {
    out_plaintext[0], out_plaintext[1], out_plaintext[2], out_plaintext[3],
    out_plaintext[4], out_plaintext[5], out_plaintext[6], out_plaintext[7]};
  // private exponent
  const int64u *pa_d[MBX_LANES]= {
    (int64u *)d, (int64u *)d, (int64u *)d, (int64u *)d,
    (int64u *)d, (int64u *)d, (int64u *)d, (int64u *)d};
  // moduli
  const int64u *pa_moduli[MBX_LANES] = {
    (int64u *)moduli, (int64u *)moduli, (int64u *)moduli, (int64u *)moduli,
    (int64u *)moduli, (int64u *)moduli, (int64u *)moduli, (int64u *)moduli};

  /* test function */
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);

  mbx_status sts;
  sts = mbx_rsa_private_mb8(pa_ciphertext, pa_plaintext, pa_d, pa_moduli, MBX_RSA2K_DATA_BIT_LEN, method, NULL);
  if (expected_status_mb8 != sts) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
  }
  // compare output plaintext to known answer
  int output_status;
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_plaintext[i], MBX_RSA2K_DATA_BYTE_LEN, plaintext, MBX_RSA2K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  return test_result;
}

#ifndef BN_OPENSSL_DISABLE

// memory free macro
#define MEM_FREE(BN_PTR1, BN_PTR2) { \
  BN_free(BN_PTR1);                  \
  BN_free(BN_PTR2); }

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa2k_private_ssl_mb8(void) {

  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output plaintext */
  int8u out_plaintext[MBX_LANES][MBX_RSA2K_DATA_BYTE_LEN];
  /* ssl private exponent */
  BIGNUM* BN_d = BN_new();
  /* ssl moduli */
  BIGNUM* BN_moduli = BN_new();
  /* check if allocated memory is valid */
  if(NULL == BN_d || NULL == BN_moduli) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
    MEM_FREE(BN_d, BN_moduli)
    return test_result;
  }
  /* function status and expected status */
  mbx_status sts;
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);
  /* output validity status */
  int output_status;

  /* set ssl parameters */
  BN_lebin2bn(d, MBX_RSA2K_DATA_BYTE_LEN, BN_d);
  BN_lebin2bn(moduli, MBX_RSA2K_DATA_BYTE_LEN, BN_moduli);

  /* function input parameters */
  // ciphertext
  const int8u *pa_ciphertext[MBX_LANES] = {
    ciphertext, ciphertext, ciphertext, ciphertext,
    ciphertext, ciphertext, ciphertext, ciphertext};
  // plaintext
  int8u *pa_plaintext[MBX_LANES] = {
    out_plaintext[0], out_plaintext[1], out_plaintext[2], out_plaintext[3],
    out_plaintext[4], out_plaintext[5], out_plaintext[6], out_plaintext[7]};
  // moduli
  const BIGNUM *pa_moduli[MBX_LANES] = {
    (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli,
    (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli};
  // private exponent
  const BIGNUM *pa_d[MBX_LANES] = {
    (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d,
    (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d};

  /* test function */
  sts = mbx_rsa_private_ssl_mb8(pa_ciphertext, pa_plaintext, pa_d, pa_moduli, MBX_RSA2K_DATA_BIT_LEN);
  if (expected_status_mb8 != sts) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
  }
  // compare output signature to known answer
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_plaintext[i], MBX_RSA2K_DATA_BYTE_LEN, plaintext, MBX_RSA2K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  // memory free
  MEM_FREE(BN_d, BN_moduli)

  return test_result;
}

#endif // BN_OPENSSL_DISABLE
#endif // MBX_FIPS_MODE
