// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.0
// - protoc             v6.33.2
// source: peer/peer.proto

package peer

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Peer_Notify_FullMethodName = "/peer.Peer/Notify"
)

// PeerClient is the client API for Peer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Peer lists  hubble peers and notifies of changes.
type PeerClient interface {
	// Notify sends information about hubble peers in the cluster.
	// When Notify is called, it sends information about all the peers that are
	// already part of the cluster (with the type as PEER_ADDED). It
	// subsequently notifies of any change.
	Notify(ctx context.Context, in *NotifyRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ChangeNotification], error)
}

type peerClient struct {
	cc grpc.ClientConnInterface
}

func NewPeerClient(cc grpc.ClientConnInterface) PeerClient {
	return &peerClient{cc}
}

func (c *peerClient) Notify(ctx context.Context, in *NotifyRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ChangeNotification], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &Peer_ServiceDesc.Streams[0], Peer_Notify_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[NotifyRequest, ChangeNotification]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Peer_NotifyClient = grpc.ServerStreamingClient[ChangeNotification]

// PeerServer is the server API for Peer service.
// All implementations should embed UnimplementedPeerServer
// for forward compatibility.
//
// Peer lists  hubble peers and notifies of changes.
type PeerServer interface {
	// Notify sends information about hubble peers in the cluster.
	// When Notify is called, it sends information about all the peers that are
	// already part of the cluster (with the type as PEER_ADDED). It
	// subsequently notifies of any change.
	Notify(*NotifyRequest, grpc.ServerStreamingServer[ChangeNotification]) error
}

// UnimplementedPeerServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedPeerServer struct{}

func (UnimplementedPeerServer) Notify(*NotifyRequest, grpc.ServerStreamingServer[ChangeNotification]) error {
	return status.Error(codes.Unimplemented, "method Notify not implemented")
}
func (UnimplementedPeerServer) testEmbeddedByValue() {}

// UnsafePeerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PeerServer will
// result in compilation errors.
type UnsafePeerServer interface {
	mustEmbedUnimplementedPeerServer()
}

func RegisterPeerServer(s grpc.ServiceRegistrar, srv PeerServer) {
	// If the following call panics, it indicates UnimplementedPeerServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Peer_ServiceDesc, srv)
}

func _Peer_Notify_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(NotifyRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PeerServer).Notify(m, &grpc.GenericServerStream[NotifyRequest, ChangeNotification]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Peer_NotifyServer = grpc.ServerStreamingServer[ChangeNotification]

// Peer_ServiceDesc is the grpc.ServiceDesc for Peer service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Peer_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "peer.Peer",
	HandlerType: (*PeerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Notify",
			Handler:       _Peer_Notify_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "peer/peer.proto",
}
