/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.pcc.defines.BatteryStatus;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.internal.compatibility.LegacyGeocacheCompat;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusGeocachePcc
extends AntPluginPcc {
    private static final String TAG = AntPlusGeocachePcc.class.getSimpleName();
    IAvailableDeviceListReceiver mAvailableDeviceListReceiver;
    ISimpleProgressUpdateReceiver mSimpleProgressUpdateReceiver;
    IProgrammingFinishedReceiver mProgrammingFinishedReceiver;
    IDataDownloadFinishedReceiver mDataDownloadFinishedReceiver;
    IAuthTokenRequestFinishedReceiver mAuthTokenRequestFinishedReceiver;
    Semaphore mCommandLock = new Semaphore(1);

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 0;
    }

    public static PccReleaseHandle<AntPlusGeocachePcc> requestListAndRequestAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusGeocachePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IAvailableDeviceListReceiver availableDeviceListRecevier) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 300);
        AntPlusGeocachePcc possibleRetObj = new AntPlusGeocachePcc();
        possibleRetObj.mAvailableDeviceListReceiver = availableDeviceListRecevier;
        return AntPlusGeocachePcc.requestAccess_Helper_Main(bindToContext, b, possibleRetObj, new AntPluginPcc.RequestAccessResultHandler(), resultReceiver, stateReceiver);
    }

    private AntPlusGeocachePcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.geocache.GeocacheService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Geocache";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mAvailableDeviceListReceiver == null) break;
                Bundle b = eventMsg.getData();
                int[] deviceIDs = b.getIntArray("arrayInt_deviceIDs");
                String[] deviceIdentifierStrings = b.getStringArray("arrayString_deviceIdentifierStrings");
                DeviceChangingCode changeCode = DeviceChangingCode.getValueFromInt(b.getInt("int_changeCode"));
                int changingDeviceID = b.getInt("int_changingDeviceID");
                this.mAvailableDeviceListReceiver.onNewAvailableDeviceList(deviceIDs, deviceIdentifierStrings, changeCode, changingDeviceID);
                break;
            }
            case 202: {
                if (this.mSimpleProgressUpdateReceiver == null) break;
                Bundle b = eventMsg.getData();
                int workUnitsFinished = b.getInt("int_workUnitsFinished");
                int totalUnitsWork = b.getInt("int_totalUnitsWork");
                this.mSimpleProgressUpdateReceiver.onNewSimpleProgressUpdate(workUnitsFinished, totalUnitsWork);
                break;
            }
            case 203: {
                if (this.mProgrammingFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                GeocacheRequestStatus statusCode = GeocacheRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                this.mProgrammingFinishedReceiver.onNewProgrammingFinished(statusCode);
                break;
            }
            case 204: {
                if (this.mDataDownloadFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                GeocacheRequestStatus statusCode = GeocacheRequestStatus.getValueFromInt(b.getInt("int_statusCode"));
                if (statusCode.getIntValue() >= 0) {
                    Bundle downloadedData = b.getBundle("bundle_downloadedData");
                    GeocacheDeviceData d = this.reportedServiceVersion == 0 ? LegacyGeocacheCompat.GeocacheDeviceDataCompat_v1.readGddFromBundleCompat_v1(downloadedData) : (GeocacheDeviceData)downloadedData.getParcelable("parcelable_GeocacheDeviceData");
                    this.mDataDownloadFinishedReceiver.onNewDataDownloadFinished(statusCode, d);
                    break;
                }
                this.mDataDownloadFinishedReceiver.onNewDataDownloadFinished(statusCode, null);
                break;
            }
            case 205: {
                if (this.mAuthTokenRequestFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                int statusCode = b.getInt("int_statusCode");
                long authToken = b.getLong("long_authToken");
                this.mAuthTokenRequestFinishedReceiver.onNewAuthTokenRequestFinished(GeocacheRequestStatus.getValueFromInt(statusCode), authToken);
                break;
            }
            default: {
                LogAnt.d(TAG, "Unrecognized event received: " + eventMsg.arg1);
            }
        }
    }

    public boolean requestCurrentDeviceList() {
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20002;
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestCurrentDeviceList died in sendPluginCommand()");
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestCurrentDeviceList failed with code " + ret.arg1);
            throw new RuntimeException("requestCurrentDeviceList cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean requestDeviceData(int targetDeviceID, boolean updateVisitCount, IDataDownloadFinishedReceiver resultReceiver, ISimpleProgressUpdateReceiver progressReceiver) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd failed to start because a local command is still processing.");
            return false;
        }
        this.mDataDownloadFinishedReceiver = resultReceiver;
        this.mSimpleProgressUpdateReceiver = progressReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20003;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_TARGETDEVICEID", targetDeviceID);
        params.putBoolean("bool_updateVisitCount", updateVisitCount);
        params.putBoolean("bool_subscribeProgressUpdates", progressReceiver != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestDeviceData died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestDeviceData failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestDeviceData cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean requestAuthToken(int targetDeviceID, int nonce, long serialNumber, IAuthTokenRequestFinishedReceiver resultReceiver, ISimpleProgressUpdateReceiver progressReceiver) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd failed to start because a local command is still processing.");
            return false;
        }
        this.mAuthTokenRequestFinishedReceiver = resultReceiver;
        this.mSimpleProgressUpdateReceiver = progressReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20004;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_TARGETDEVICEID", targetDeviceID);
        params.putInt("int_nonce", nonce);
        params.putLong("long_serialNumber", serialNumber);
        params.putBoolean("bool_subscribeProgressUpdates", progressReceiver != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestAuthToken died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestAuthToken failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestAuthToken cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public boolean requestDeviceProgramming(int targetDeviceID, long programmingPIN, boolean clearAllExistingData, ProgrammableGeocacheDeviceData programmingData, IProgrammingFinishedReceiver resultReceiver, ISimpleProgressUpdateReceiver progressReceiver) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd failed to start because a local command is still processing.");
            return false;
        }
        this.mProgrammingFinishedReceiver = resultReceiver;
        this.mSimpleProgressUpdateReceiver = progressReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20005;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_TARGETDEVICEID", targetDeviceID);
        params.putLong("long_ProgrammingPIN", programmingPIN);
        params.putBoolean("bool_clearAllExistingData", clearAllExistingData);
        if (this.reportedServiceVersion == 0) {
            Bundle programDataBundle = new Bundle();
            LegacyGeocacheCompat.GeocacheDeviceDataCompat_v1.writePgddToBundle(programmingData, programDataBundle);
            params.putBundle("bundle_programmingData", programDataBundle);
        } else {
            params.putParcelable("parcelable_ProgrammableGeocacheDeviceData", (Parcelable)programmingData);
        }
        params.putBoolean("bool_subscribeProgressUpdates", progressReceiver != null);
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd requestDeviceProgramming died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd requestDeviceProgramming failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("requestDeviceProgramming cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    public static interface IAuthTokenRequestFinishedReceiver {
        public void onNewAuthTokenRequestFinished(GeocacheRequestStatus var1, long var2);
    }

    public static interface IDataDownloadFinishedReceiver {
        public void onNewDataDownloadFinished(GeocacheRequestStatus var1, GeocacheDeviceData var2);
    }

    public static interface IProgrammingFinishedReceiver {
        public void onNewProgrammingFinished(GeocacheRequestStatus var1);
    }

    public static interface ISimpleProgressUpdateReceiver {
        public void onNewSimpleProgressUpdate(int var1, int var2);
    }

    public static interface IAvailableDeviceListReceiver {
        public void onNewAvailableDeviceList(int[] var1, String[] var2, DeviceChangingCode var3, int var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GeocacheRequestStatus {
        SUCCESS(0),
        FAIL_CANCELLED(-2),
        UNRECOGNIZED(-3),
        FAIL_OTHER(-10),
        FAIL_ALREADY_BUSY_EXTERNAL(-20),
        FAIL_DEVICE_COMMUNICATION_FAILURE(-40),
        FAIL_DEVICE_TRANSMISSION_LOST(-41),
        FAIL_BAD_PARAMS(-50),
        FAIL_NO_PERMISSION(-60),
        FAIL_NOT_SUPPORTED(-61),
        FAIL_DEVICE_NOT_IN_LIST(10030),
        FAIL_DEVICE_DATA_NOT_DOWNLOADED(10070);

        private int intValue;

        private GeocacheRequestStatus(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static GeocacheRequestStatus getValueFromInt(int intValue) {
            for (GeocacheRequestStatus status : GeocacheRequestStatus.values()) {
                if (status.getIntValue() != intValue) continue;
                return status;
            }
            GeocacheRequestStatus unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceChangingCode {
        NO_CHANGE(0),
        ADDED_TO_LIST(10),
        REMOVED_FROM_LIST(20),
        PROGRAMMED(100),
        UNRECOGNIZED(-1);

        private int intValue;

        private DeviceChangingCode(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static DeviceChangingCode getValueFromInt(int intValue) {
            for (DeviceChangingCode code : DeviceChangingCode.values()) {
                if (code.getIntValue() != intValue) continue;
                return code;
            }
            DeviceChangingCode unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_GEOCACHEPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_GEOCACHEPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.geocache.GeocacheService";
        public static final int MSG_REQACC_PARAM_MODE_iCONTINUOUSSEARCH = 300;
        public static final int MSG_EVENT_GEOCACHE_whatAVAILABLEDEVICELIST = 201;
        public static final String MSG_EVENT_GEOCACHE_AVAILABLEDEVICELIST_PARAM_arrayIntDEVICEIDS = "arrayInt_deviceIDs";
        public static final String MSG_EVENT_GEOCACHE_AVAILABLEDEVICELIST_PARAM_arrayStringDEVICEIDENTIFIERSTRINGS = "arrayString_deviceIdentifierStrings";
        public static final String MSG_EVENT_GEOCACHE_AVAILABLEDEVICELIST_PARAM_intCHANGECODE = "int_changeCode";
        public static final String MSG_EVENT_GEOCACHE_AVAILABLEDEVICELIST_PARAM_intCHANGINGDEVICEID = "int_changingDeviceID";
        public static final int MSG_EVENT_GEOCACHE_whatSIMPLEPROGRESSUPDATE = 202;
        public static final String MSG_EVENT_GEOCACHE_SIMPLEPROGRESSUPDATE_PARAM_intWORKUNITSFINISHED = "int_workUnitsFinished";
        public static final String MSG_EVENT_GEOCACHE_SIMPLEPROGRESSUPDATE_PARAM_intTOTALUNITSWORK = "int_totalUnitsWork";
        public static final int MSG_EVENT_GEOCACHE_whatPROGRAMMINGFINISHED = 203;
        public static final String MSG_EVENT_GEOCACHE_PROGRAMMINGFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final int MSG_EVENT_GEOCACHE_whatDATADOWNLOADFINISHED = 204;
        public static final String MSG_EVENT_GEOCACHE_DATADOWNLOADFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final String MSG_EVENT_GEOCACHE_DATADOWNLOADFINISHED_PARAM_bundleDOWNLOADEDDATA = "bundle_downloadedData";
        public static final int MSG_EVENT_GEOCACHE_whatAUTHTOKENREQUESTFINISHED = 205;
        public static final String MSG_EVENT_GEOCACHE_AUTHTOKENREQUESTFINISHED_PARAM_intSTATUSCODE = "int_statusCode";
        public static final String MSG_EVENT_GEOCACHE_AUTHTOKENREQUESTFINISHED_PARAM_longAUTHTOKEN = "long_authToken";
        public static final int MSG_CMD_GEOCACHE_whatREQUESTCURRENTDEVICELIST = 20002;
        public static final int MSG_CMD_GEOCACHE_whatREQUESTDEVICEDATA = 20003;
        public static final String MSG_CMD_GEOCACHE_REQUESTDEVICEDATA_PARAM_boolUPDATEVISITCOUNT = "bool_updateVisitCount";
        public static final int MSG_CMD_GEOCACHE_whatREQUESTAUTHTOKEN = 20004;
        public static final String MSG_CMD_GEOCACHE_REQUESTAUTHTOKEN_PARAM_intNONCE = "int_nonce";
        public static final String MSG_CMD_GEOCACHE_REQUESTAUTHTOKEN_PARAM_longSERIALNUMBER = "long_serialNumber";
        public static final int MSG_CMD_GEOCACHE_whatREQUESTDEVICEPROGRAMMING = 20005;
        public static final String MSG_CMD_GEOCACHE_REQUESTDEVICEPROGRAMMING_PARAM_longPROGRAMMINGPIN = "long_ProgrammingPIN";
        public static final String MSG_CMD_GEOCACHE_REQUESTDEVICEPROGRAMMING_PARAM_boolCLEARALLEXISTINGDATA = "bool_clearAllExistingData";
        public static final String MSG_CMD_GEOCACHE_REQUESTS_PARAM_boolSUBSCRIBEPROGRESSUPDATES = "bool_subscribeProgressUpdates";
        public static final String MSG_CMD_GEOCACHE_REQUESTS_PARAM_intTARGETDEVICEID = "int_TARGETDEVICEID";
    }

    public static class ProgrammableGeocacheDeviceData
    implements Parcelable {
        public static final String KEY_DEFAULT_PROGRAMMABLEGEOCACHEDEVICEDATAKEY = "parcelable_ProgrammableGeocacheDeviceData";
        private final int ipcVersionNumber;
        public String identificationString = null;
        public Long PIN = null;
        public BigDecimal latitude = null;
        public BigDecimal longitude = null;
        public String hintString = null;
        public GregorianCalendar lastVisitTimestamp = null;
        public Integer numberOfVisits = null;
        public static final Parcelable.Creator<ProgrammableGeocacheDeviceData> CREATOR = new Parcelable.Creator<ProgrammableGeocacheDeviceData>(){

            public ProgrammableGeocacheDeviceData createFromParcel(Parcel in) {
                return new ProgrammableGeocacheDeviceData(in);
            }

            public ProgrammableGeocacheDeviceData[] newArray(int size) {
                return new ProgrammableGeocacheDeviceData[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeString(this.identificationString);
            dest.writeValue((Object)this.PIN);
            dest.writeValue((Object)this.latitude);
            dest.writeValue((Object)this.longitude);
            dest.writeString(this.hintString);
            dest.writeValue((Object)this.lastVisitTimestamp);
            dest.writeValue((Object)this.numberOfVisits);
        }

        public ProgrammableGeocacheDeviceData(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " ProgrammableGeocacheDeviceData parcel with version 1 parser.");
            }
            this.identificationString = in.readString();
            this.PIN = (Long)in.readValue(null);
            this.latitude = (BigDecimal)in.readValue(null);
            this.longitude = (BigDecimal)in.readValue(null);
            this.hintString = in.readString();
            this.lastVisitTimestamp = (GregorianCalendar)in.readValue(null);
            this.numberOfVisits = (Integer)in.readValue(null);
        }

        public ProgrammableGeocacheDeviceData() {
            this.ipcVersionNumber = 1;
        }
    }

    public static class GeocacheDeviceData
    implements Parcelable {
        public static final String KEY_DEFAULT_GEOCACHEDEVICEDATAKEY = "parcelable_GeocacheDeviceData";
        private final int ipcVersionNumber;
        public int deviceId;
        public int hardwareRevision;
        public int manufacturerID;
        public int modelNumber;
        public int softwareRevision;
        public long serialNumber;
        public long cumulativeOperatingTime;
        public BigDecimal batteryVoltage;
        public BatteryStatus batteryStatus = BatteryStatus.INVALID;
        public int cumulativeOperatingTimeResolution;
        public ProgrammableGeocacheDeviceData programmableData = new ProgrammableGeocacheDeviceData();
        public static final Parcelable.Creator<GeocacheDeviceData> CREATOR = new Parcelable.Creator<GeocacheDeviceData>(){

            public GeocacheDeviceData createFromParcel(Parcel in) {
                return new GeocacheDeviceData(in);
            }

            public GeocacheDeviceData[] newArray(int size) {
                return new GeocacheDeviceData[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeInt(this.deviceId);
            dest.writeInt(this.hardwareRevision);
            dest.writeInt(this.manufacturerID);
            dest.writeInt(this.modelNumber);
            dest.writeInt(this.softwareRevision);
            dest.writeLong(this.serialNumber);
            dest.writeLong(this.cumulativeOperatingTime);
            dest.writeValue((Object)this.batteryVoltage);
            dest.writeInt(this.batteryStatus.getIntValue());
            dest.writeInt(this.cumulativeOperatingTimeResolution);
            Bundle b = new Bundle();
            b.putParcelable("parcelable_ProgrammableGeocacheDeviceData", (Parcelable)this.programmableData);
            dest.writeBundle(b);
        }

        public GeocacheDeviceData(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " GeocacheDeviceData parcel with version 1 parser.");
            }
            this.deviceId = in.readInt();
            this.hardwareRevision = in.readInt();
            this.manufacturerID = in.readInt();
            this.modelNumber = in.readInt();
            this.softwareRevision = in.readInt();
            this.serialNumber = in.readLong();
            this.cumulativeOperatingTime = in.readLong();
            this.batteryVoltage = (BigDecimal)in.readValue(null);
            this.batteryStatus = BatteryStatus.getValueFromInt(in.readInt());
            this.cumulativeOperatingTimeResolution = in.readInt();
            Bundle b = in.readBundle();
            b.setClassLoader(this.getClass().getClassLoader());
            this.programmableData = (ProgrammableGeocacheDeviceData)b.getParcelable("parcelable_ProgrammableGeocacheDeviceData");
        }

        public GeocacheDeviceData() {
            this.ipcVersionNumber = 1;
        }

        public GeocacheDeviceData(int ipcVersionNumber) {
            this.ipcVersionNumber = ipcVersionNumber;
        }
    }
}

