//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package monitorlegacy

import original "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2016-03-01-preview/monitorlegacy"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ConditionOperator = original.ConditionOperator

const (
	GreaterThan        ConditionOperator = original.GreaterThan
	GreaterThanOrEqual ConditionOperator = original.GreaterThanOrEqual
	LessThan           ConditionOperator = original.LessThan
	LessThanOrEqual    ConditionOperator = original.LessThanOrEqual
)

type DataStatus = original.DataStatus

const (
	NotPresent DataStatus = original.NotPresent
	Present    DataStatus = original.Present
)

type OdataType = original.OdataType

const (
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource          OdataType = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource
	OdataTypeRuleDataSource                                                      OdataType = original.OdataTypeRuleDataSource
)

type OdataTypeBasicRuleAction = original.OdataTypeBasicRuleAction

const (
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction   OdataTypeBasicRuleAction = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataTypeBasicRuleAction = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction
	OdataTypeRuleAction                                              OdataTypeBasicRuleAction = original.OdataTypeRuleAction
)

type OdataTypeBasicRuleCondition = original.OdataTypeBasicRuleCondition

const (
	OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataTypeBasicRuleCondition = original.OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition
	OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition   OdataTypeBasicRuleCondition = original.OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition
	OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition         OdataTypeBasicRuleCondition = original.OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition
	OdataTypeRuleCondition                                                        OdataTypeBasicRuleCondition = original.OdataTypeRuleCondition
)

type OnboardingStatus = original.OnboardingStatus

const (
	NotOnboarded OnboardingStatus = original.NotOnboarded
	Onboarded    OnboardingStatus = original.Onboarded
	Unknown      OnboardingStatus = original.Unknown
)

type TimeAggregationOperator = original.TimeAggregationOperator

const (
	Average TimeAggregationOperator = original.Average
	Last    TimeAggregationOperator = original.Last
	Maximum TimeAggregationOperator = original.Maximum
	Minimum TimeAggregationOperator = original.Minimum
	Total   TimeAggregationOperator = original.Total
)

type AlertRule = original.AlertRule
type AlertRuleIncidentsClient = original.AlertRuleIncidentsClient
type AlertRuleResource = original.AlertRuleResource
type AlertRuleResourceCollection = original.AlertRuleResourceCollection
type AlertRuleResourcePatch = original.AlertRuleResourcePatch
type AlertRulesClient = original.AlertRulesClient
type BaseClient = original.BaseClient
type BasicRuleAction = original.BasicRuleAction
type BasicRuleCondition = original.BasicRuleCondition
type BasicRuleDataSource = original.BasicRuleDataSource
type DataContainer = original.DataContainer
type Error = original.Error
type ErrorResponse = original.ErrorResponse
type EventCategoriesClient = original.EventCategoriesClient
type EventCategoryCollection = original.EventCategoryCollection
type Incident = original.Incident
type IncidentListResult = original.IncidentListResult
type LocalizableString = original.LocalizableString
type LocationThresholdRuleCondition = original.LocationThresholdRuleCondition
type LogProfileCollection = original.LogProfileCollection
type LogProfileProperties = original.LogProfileProperties
type LogProfileResource = original.LogProfileResource
type LogProfileResourcePatch = original.LogProfileResourcePatch
type LogProfilesClient = original.LogProfilesClient
type ManagementEventAggregationCondition = original.ManagementEventAggregationCondition
type ManagementEventRuleCondition = original.ManagementEventRuleCondition
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ResponseWithError = original.ResponseWithError
type RetentionPolicy = original.RetentionPolicy
type RuleAction = original.RuleAction
type RuleCondition = original.RuleCondition
type RuleDataSource = original.RuleDataSource
type RuleEmailAction = original.RuleEmailAction
type RuleManagementEventClaimsDataSource = original.RuleManagementEventClaimsDataSource
type RuleManagementEventDataSource = original.RuleManagementEventDataSource
type RuleMetricDataSource = original.RuleMetricDataSource
type RuleWebhookAction = original.RuleWebhookAction
type ThresholdRuleCondition = original.ThresholdRuleCondition
type VMInsightsClient = original.VMInsightsClient
type VMInsightsOnboardingStatus = original.VMInsightsOnboardingStatus
type VMInsightsOnboardingStatusProperties = original.VMInsightsOnboardingStatusProperties
type WorkspaceInfo = original.WorkspaceInfo
type WorkspaceInfoProperties = original.WorkspaceInfoProperties

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAlertRuleIncidentsClient(subscriptionID string) AlertRuleIncidentsClient {
	return original.NewAlertRuleIncidentsClient(subscriptionID)
}
func NewAlertRuleIncidentsClientWithBaseURI(baseURI string, subscriptionID string) AlertRuleIncidentsClient {
	return original.NewAlertRuleIncidentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRulesClient(subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClient(subscriptionID)
}
func NewAlertRulesClientWithBaseURI(baseURI string, subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEventCategoriesClient(subscriptionID string) EventCategoriesClient {
	return original.NewEventCategoriesClient(subscriptionID)
}
func NewEventCategoriesClientWithBaseURI(baseURI string, subscriptionID string) EventCategoriesClient {
	return original.NewEventCategoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLogProfilesClient(subscriptionID string) LogProfilesClient {
	return original.NewLogProfilesClient(subscriptionID)
}
func NewLogProfilesClientWithBaseURI(baseURI string, subscriptionID string) LogProfilesClient {
	return original.NewLogProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVMInsightsClient(subscriptionID string) VMInsightsClient {
	return original.NewVMInsightsClient(subscriptionID)
}
func NewVMInsightsClientWithBaseURI(baseURI string, subscriptionID string) VMInsightsClient {
	return original.NewVMInsightsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleConditionOperatorValues() []ConditionOperator {
	return original.PossibleConditionOperatorValues()
}
func PossibleDataStatusValues() []DataStatus {
	return original.PossibleDataStatusValues()
}
func PossibleOdataTypeBasicRuleActionValues() []OdataTypeBasicRuleAction {
	return original.PossibleOdataTypeBasicRuleActionValues()
}
func PossibleOdataTypeBasicRuleConditionValues() []OdataTypeBasicRuleCondition {
	return original.PossibleOdataTypeBasicRuleConditionValues()
}
func PossibleOdataTypeValues() []OdataType {
	return original.PossibleOdataTypeValues()
}
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return original.PossibleOnboardingStatusValues()
}
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return original.PossibleTimeAggregationOperatorValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
