/*
 * FILE : gle_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.2 (alpha 1)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header: /cvsroot/gle/gle/swig/gle_wrap.c,v 1.1 2001/05/17 20:40:13 linas Exp $
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log: gle_wrap.c,v $
 * Revision 1.1  2001/05/17 20:40:13  linas
 * initial checkin of custom, autogenerated SWIG/python bindings.
 *
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef WIN32
#define SWIGEXPORT(a,b) __declspec(dllexport) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header: /cvsroot/gle/gle/swig/gle_wrap.c,v 1.1 2001/05/17 20:40:13 linas Exp $
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initglec

#define SWIG_name    "glec"

#include "arrayobject.h"

#define Get2D(arr, dims, i, j)        arr[(i * dims[1]) + j]
#define Get3D(arr, dims, i, j, k)     arr[(i * dims[1] * dims[2]) + \
                                                (j * dims[2]) + k]
#define Get4D(arr, dims, i, j, k, l)  arr[(i * dims[1] * dims[2] * dims[3]) + \
                                          (j * dims[2] * dims[3]) +  \
                                          (k * dims[3]) + l]

/********************************************************************
  Tries to create a contiguous numeric array of type typecode from a 
  Python object. Works for list, tuples and numeric arrays.

  obj: Numeric array Python object
  typecode: data type PyArray_{ CHAR, UBYTE, SBYTE, SHORT, INT, LONG, FLOAT,
                                DOUBLE, CFLOAT, CDOUBLE }
  expectnd: required number of dimensions. Used for checking. Ignored if <=0.
  expectdims: array of expected extends. Used for checking. Ignored if <=0.

  Raises ValueError exceptions if:
  - the PyArray_ContiguousFromObject fails
  - the array has a bad shape
  - the extent of a given dimension doesn't match the specified extent.
********************************************************************/

static PyArrayObject *contiguous_typed_array(PyObject *obj, int typecode,
                                      int expectnd, int *expectdims)
{
  PyArrayObject *arr;
  int i, numitems, itemsize;
  char buf[255];

  /* if the shape and type are OK, this function increments the reference
     count and arr points to obj */
  if((arr = (PyArrayObject *)PyArray_ContiguousFromObject(obj,
                                                          typecode, 0,
                                                          10)) == NULL)
    {
      sprintf(buf,"Failed to make a contiguous array of type %d\n", typecode);
      PyErr_SetString(PyExc_ValueError, buf);
      return NULL;
    }

  if(expectnd>0)
    {
      if(arr->nd > expectnd + 1 || arr->nd < expectnd)
        {
          Py_DECREF((PyObject *)arr);
          PyErr_SetString(PyExc_ValueError,
                          "Array has wrong number of dimensions");
          return NULL;
        }
      if(arr->nd == expectnd + 1)
        {
          if(arr->dimensions[arr->nd - 1] != 1)
            {
              Py_DECREF((PyObject *)arr);
              PyErr_SetString(PyExc_ValueError,
                              "Array has wrong number of dimensions");
              return NULL;
            }
        }
      if(expectdims)
        {
          for(i = 0; i < expectnd; i++)
            if(expectdims[i]>0)
              if(expectdims[i] != arr->dimensions[i])
                {
                  Py_DECREF((PyObject *)arr);
                  sprintf(buf,"The extent of dimension %d is %d while %d was expected\n",
                          i, arr->dimensions[i], expectdims[i]);
                  PyErr_SetString(PyExc_ValueError, buf);
                  return NULL;
                }
                  
        }
    }

  return arr;
}


static PyObject* l_output_helper1(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;
    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyList_Check(target)) {
            o2 = target;
            target = PyList_New(0);
            PyList_Append(target, o2);
            Py_XDECREF(o2);
        }
        PyList_Append(target,o);
        Py_XDECREF(o);
    }
    return target;
}

#define gleDouble double
typedef gleDouble gleAffine[2][3];
extern int gleGetJoinStyle();
extern void gleSetJoinStyle(int );
extern void glePolyCylinder(int ,double [1][3],float [1][3],double );
extern void glePolyCone(int ,double [1][3],float [1][3],double [1]);
extern void gleExtrusion(int ,double [1][2],double [1][2],double [3],int ,double [1][3],float [1][3]);
extern void gleTwistExtrusion(int ,double [1][2],double [1][2],double [3],int ,double [1][3],float [1][3],double [1]);
extern void gleSuperExtrusion(int ,double [1][2],double [1][2],double [3],int ,double [1][3],float [1][3],double [1][2][3]);
extern void gleSpiral(int ,double [1][2],double [1][2],double [3],double ,double ,double ,double ,double [2][3],double [2][3],double ,double );
extern void gleLathe(int ,double [1][2],double [1][2],double [3],double ,double ,double ,double ,double [2][3],double [2][3],double ,double );
extern void gleHelicoid(double ,double ,double ,double ,double ,double [2][3],double [2][3],double ,double );
extern void gleToroid(double ,double ,double ,double ,double ,double [2][3],double [2][3],double ,double );
extern void gleScrew(int ,double [1][2],double [1][2],double [3],double ,double ,double );
extern void gleTextureMode(int );
extern void rot_axis(double ,double [3]);
extern void rot_about_axis(double ,double [3]);
extern void rot_omega(double [3]);
extern void rot_prince(double ,char );
extern void urot_axis(double [4][4],double ,double [3]);
extern void urot_about_axis(double [4][4],double ,double [3]);
extern void urot_omega(double [4][4],double [3]);
extern void urot_prince(double [4][4],double ,char );
extern void uview_direction(double [4][4],double [3],double [3]);
extern void uviewpoint(double [4][4],double [3],double [3],double [3]);

#ifndef WIN32
#include <unistd.h>
#endif
#if defined(_WIN32) && !defined(__clang__)
# include <malloc.h>
#endif
#include "port.h"
#include "tube_gc.h"

void _gleFeedback (  
   void (*bgn_feedback) (int, double),
   void (*n3d_feedback) (double *),
   void (*v3d_feedback) (double *, int, int),
   void (*end_feedback) ()
   )
{
      INIT_GC(); 

      _gle_gc -> bgn_gen_texture = bgn_feedback;
      _gle_gc -> n3d_gen_texture = n3d_feedback;
      _gle_gc -> v3d_gen_texture = v3d_feedback;
      _gle_gc -> end_gen_texture = end_feedback;

}

#include <stdio.h>
static int nbpts = 0;
static int max_nbpts = 0;
static int nbnorm = 0;
static int max_norm = 0;
static int nbstrip = 0;
static int max_strip = 0;
static double *vertices = NULL;
static double *normals = NULL;
static int *strips = NULL;

double *growDouble(double *array, int n, int *max, int dim)
{
  double *p;
  /* fixme ... catch memory allocation error, return error code */
  (*max) += n;
  p = (double *)realloc( array, (*max)*dim*sizeof(double));
/*  printf("allocate %d %p\n", (*max), p ); */
  return p;
}

int *growInt(int *array, int n, int *max, int dim)
{
  int *p;
  /* fixme ... catch memory allocation error, return error code */
  (*max) += n;
  p = (int *)realloc( array, (*max)*dim*sizeof(int));
/*  printf("allocate %d %p\n", (*max), p ); */
  return p;
}

static void add_Vertex(double v[3])
{
  if (nbpts >= max_nbpts) vertices = growDouble(vertices, 1000, &max_nbpts, 3);
  vertices[nbpts*3] = v[0];
  vertices[(nbpts*3)+1] = v[1];
  vertices[(nbpts*3)+2] = v[2];
  /*printf("V %d %d %p, %g %g %g\n", nbpts, max_nbpts, vertices, 
	 vertices[nbpts*3], vertices[(nbpts*3)+1], vertices[(nbpts*3)+2]);*/
  nbpts++;
}

static void add_Normal(double v[3])
{
  if (nbnorm >= max_norm) normals = growDouble(normals, 1000, &max_norm, 3);
  normals[nbnorm*3] = v[0];
  normals[(nbnorm*3)+1] = v[1];
  normals[(nbnorm*3)+2] = v[2];
/*  printf("N %d %d %p %g %g %g\n", nbnorm, max_norm, normals,
	 normals[nbnorm*3], normals[(nbnorm*3)+1], normals[(nbnorm*3)+2]); */
  nbnorm++;
}


#include <GL/gl.h>

static void add_Strip()
{
  /*
  printf("addStrip %d %d %d\n", nbstrip, nbpts, nbnorm);
  */
  if (nbstrip >= max_strip) strips = growInt(strips, 100, &max_strip, 2);
  strips[nbstrip*2] = nbpts;
  strips[(nbstrip*2)+1] = nbnorm;
  /*
  printf("addStrip %d %d %d\n", nbstrip, strips[nbstrip*2], strips[(nbstrip*2)+1]);
  */
  nbstrip++;
}

static double _mat_[16];

static void bgn_feedback (int inext, double len) {
  int i;
    glGetDoublev(GL_MODELVIEW_MATRIX, (double *)_mat_);
  /*
  printf("Begin mod ");
  for (i=0; i<16; i++)
    printf("%7.3f",_mat_[i]);
  printf("\n");*/
  
 
}

static void end_feedback () {
   add_Strip();
}

static void multmat(double v[3], double mat[16], double vm[3], int homo)
{
    int i;
    vm[0] = mat[0]*v[0] + mat[4]*v[1] + mat[8]*v[2] + homo*mat[12];
    vm[1] = mat[1]*v[0] + mat[5]*v[1] + mat[9]*v[2] + homo*mat[13];
    vm[2] = mat[2]*v[0] + mat[6]*v[1] + mat[10]*v[2] + homo*mat[14];
}

static void normal_feedback (double v[3]) {
   GLdouble vt[3];
   /*
   printf("n1 %lf %lf %lf\n", v[0], v[1], v[2]);
   */
   multmat(v, _mat_, &vt[0], 0);
   /*
   printf("n2 %lf %lf %lf\n", vt[0], vt[1], vt[2]);
   */
   /* printf("%lf %lf %lf\n", vt[0], vt[1], vt[2]); */
   add_Normal(vt);
}

static void vertex_feedback (double v[3], int jcnt, int end)
{
   GLdouble vt[3];

   /*
   printf("v %lf %lf %lf\n", v[0], v[1], v[2]);
   */
   multmat(v, _mat_, &vt[0], 1);
   /*
   printf("%7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n", v[0], v[1], v[2],
           vt[0], vt[1], vt[2]);
   */
   add_Vertex(vt);
}

  void gleFeedBack() {
    nbpts = nbnorm = nbstrip = max_nbpts = max_norm = max_strip = 0;
    _gleFeedback(bgn_feedback, normal_feedback, vertex_feedback, end_feedback);
  }

 void gleFreeFeedbackBuffers() {
/*
   if (vertices) free(vertices);
   if (normals) free(normals);
   if (strips) free(strips);
*/
 }

static PyObject *gleGetTriangleMesh(PyObject *self, PyObject *args)
{
  PyArrayObject *v_array, *n_array, *s_array;
  int dims[2];

  dims[0] = nbpts;
  dims[1] = 3;
  v_array = (PyArrayObject *)PyArray_FromDimsAndData(2, dims, PyArray_DOUBLE,
						     (char *)vertices);
  v_array->flags |= OWN_DATA;

  dims[0] = nbnorm;
  dims[1] = 3;
  n_array = (PyArrayObject *)PyArray_FromDimsAndData(2, dims, PyArray_DOUBLE,
						     (char *)normals);
  n_array->flags |= OWN_DATA;

  dims[0] = nbstrip;
  dims[1] = 2;
  s_array = (PyArrayObject *)PyArray_FromDimsAndData(2, dims, PyArray_INT,
						     (char *)strips);
  s_array->flags |= OWN_DATA;

  return Py_BuildValue("OOO", v_array, n_array, s_array);
}

static PyObject *_wrap_gleGetJoinStyle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gleGetJoinStyle")) 
        return NULL;
    _result = (int )gleGetJoinStyle();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gleSetJoinStyle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gleSetJoinStyle",&_arg0)) 
        return NULL;
    gleSetJoinStyle(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glePolyCylinder(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    float * _arg2;
    double  _arg3;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOd:glePolyCylinder",&_obj1,&_obj2,&_arg3)) 
        return NULL;
{
  int expected_dims[2] = {1, 3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  if (_obj2 = Py_None) {
    _arg2 = NULL;
  } else {
    int expected_dims[2] = {1, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array0 = contiguous_typed_array(_obj2, PyArray_FLOAT, 2, expected_dims);
    if (! array0) return NULL;
    _obj2 = (PyObject *)array0;
    _arg2 = (float *)array0->data;
  }
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
    glePolyCylinder(_arg0,(double  (*)[3])_arg1,(float  (*)[3])_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
    return _resultobj;
}

static PyObject *_wrap_glePolyCone(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    float * _arg2;
    double * _arg3;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:glePolyCone",&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
  int expected_dims[2] = {1, 3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  if (_obj2 = Py_None) {
    _arg2 = NULL;
  } else {
    int expected_dims[2] = {1, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array0 = contiguous_typed_array(_obj2, PyArray_FLOAT, 2, expected_dims);
    if (! array0) return NULL;
    _obj2 = (PyObject *)array0;
    _arg2 = (float *)array0->data;
  }
}
    if (_obj3)
{
  int expected_dims[1] = {1};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
  if (! array1) return NULL;
  _obj3 = (PyObject *)array1;
  _arg3 = (double *)array1->data;
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
    glePolyCone(_arg0,(double  (*)[3])_arg1,(float  (*)[3])_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj3);
}
    return _resultobj;
}

static PyObject *_wrap_gleExtrusion(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    int  _arg4;
    double * _arg5;
    float * _arg6;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;
    PyArrayObject * array2;
    PyObject * _obj5 = 0;
    PyArrayObject * array3;
    PyObject * _obj6 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOO:gleExtrusion",&_obj1,&_obj2,&_obj3,&_obj5,&_obj6)) 
        return NULL;
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 2, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
{
  if (_obj3 == Py_None) {
    _arg3 = NULL;
  } else {
    int expected_dims[1] = {3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
    if (! array1) return NULL;
    _obj3 = (PyObject *)array1;
    _arg3 = (double *)array1->data;
  }
}
    if (_obj5)
{
  int expected_dims[2] = {1, 3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array2 = contiguous_typed_array(_obj5, PyArray_DOUBLE, 2, expected_dims);
  if (! array2) return NULL;
  _obj5 = (PyObject *)array2;
  _arg5 = (double *)array2->data;
}
    if (_obj6)
{
  if (_obj6 = Py_None) {
    _arg6 = NULL;
  } else {
    int expected_dims[2] = {1, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array3 = contiguous_typed_array(_obj6, PyArray_FLOAT, 2, expected_dims);
    if (! array3) return NULL;
    _obj6 = (PyObject *)array3;
    _arg6 = (float *)array3->data;
  }
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
{
   _arg4 = ((PyArrayObject *)(_obj5))->dimensions[0];
}
    gleExtrusion(_arg0,(double  (*)[2])_arg1,(double  (*)[2])_arg2,_arg3,_arg4,(double  (*)[3])_arg5,(float  (*)[3])_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
{
   Py_DECREF(_obj5);
}
    return _resultobj;
}

static PyObject *_wrap_gleTwistExtrusion(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    int  _arg4;
    double * _arg5;
    float * _arg6;
    double * _arg7;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;
    PyArrayObject * array2;
    PyObject * _obj5 = 0;
    PyArrayObject * array3;
    PyObject * _obj6 = 0;
    PyArrayObject * array4;
    PyObject * _obj7 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOOO:gleTwistExtrusion",&_obj1,&_obj2,&_obj3,&_obj5,&_obj6,&_obj7)) 
        return NULL;
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 2, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
{
  if (_obj3 == Py_None) {
    _arg3 = NULL;
  } else {
    int expected_dims[1] = {3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
    if (! array1) return NULL;
    _obj3 = (PyObject *)array1;
    _arg3 = (double *)array1->data;
  }
}
{
  int expected_dims[2] = {1, 3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array2 = contiguous_typed_array(_obj5, PyArray_DOUBLE, 2, expected_dims);
  if (! array2) return NULL;
  _obj5 = (PyObject *)array2;
  _arg5 = (double *)array2->data;
}
    if (_obj6)
{
  if (_obj6 = Py_None) {
    _arg6 = NULL;
  } else {
    int expected_dims[2] = {1, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array3 = contiguous_typed_array(_obj6, PyArray_FLOAT, 2, expected_dims);
    if (! array3) return NULL;
    _obj6 = (PyObject *)array3;
    _arg6 = (float *)array3->data;
  }
}
    if (_obj7)
{
  int expected_dims[1] = {1};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array4 = contiguous_typed_array(_obj7, PyArray_DOUBLE, 1, expected_dims);
  if (! array4) return NULL;
  _obj7 = (PyObject *)array4;
  _arg7 = (double *)array4->data;
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
{
   _arg4 = ((PyArrayObject *)(_obj5))->dimensions[0];
}
    gleTwistExtrusion(_arg0,(double  (*)[2])_arg1,(double  (*)[2])_arg2,_arg3,_arg4,(double  (*)[3])_arg5,(float  (*)[3])_arg6,_arg7);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
{
   Py_DECREF(_obj5);
}
{
   Py_DECREF(_obj7);
}
    return _resultobj;
}

static PyObject *_wrap_gleSuperExtrusion(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    int  _arg4;
    double * _arg5;
    float * _arg6;
    double * _arg7;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;
    PyArrayObject * array2;
    PyObject * _obj5 = 0;
    PyArrayObject * array3;
    PyObject * _obj6 = 0;
    PyArrayObject * array4;
    PyObject * _obj7 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOOO:gleSuperExtrusion",&_obj1,&_obj2,&_obj3,&_obj5,&_obj6,&_obj7)) 
        return NULL;
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 2, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
{
  if (_obj3 == Py_None) {
    _arg3 = NULL;
  } else {
    int expected_dims[1] = {3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
    if (! array1) return NULL;
    _obj3 = (PyObject *)array1;
    _arg3 = (double *)array1->data;
  }
}
{
  int expected_dims[2] = {1, 3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array2 = contiguous_typed_array(_obj5, PyArray_DOUBLE, 2, expected_dims);
  if (! array2) return NULL;
  _obj5 = (PyObject *)array2;
  _arg5 = (double *)array2->data;
}
    if (_obj6)
{
  if (_obj6 = Py_None) {
    _arg6 = NULL;
  } else {
    int expected_dims[2] = {1, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array3 = contiguous_typed_array(_obj6, PyArray_FLOAT, 2, expected_dims);
    if (! array3) return NULL;
    _obj6 = (PyObject *)array3;
    _arg6 = (float *)array3->data;
  }
}
    if (_obj7)
{
  if (_obj7 == Py_None) {
    _arg7 = NULL;
  } else {
    int expected_dims[3] = {1, 2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    if (expected_dims[2]==1) expected_dims[2]=0;
    array4 = contiguous_typed_array(_obj7, PyArray_DOUBLE, 3, expected_dims);
    if (! array4) return NULL;
    _obj7 = (PyObject *)array4;
  _arg7 = (double *)array4->data;
  }
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
{
   _arg4 = ((PyArrayObject *)(_obj5))->dimensions[0];
}
    gleSuperExtrusion(_arg0,(double  (*)[2])_arg1,(double  (*)[2])_arg2,_arg3,_arg4,(double  (*)[3])_arg5,(float  (*)[3])_arg6,(double  (*)[2][3])_arg7);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
{
   Py_DECREF(_obj5);
}
    return _resultobj;
}

static PyObject *_wrap_gleSpiral(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    double * _arg8;
    double * _arg9;
    double  _arg10;
    double  _arg11;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;
    PyArrayObject * array2;
    PyObject * _obj8 = 0;
    PyArrayObject * array3;
    PyObject * _obj9 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOddddOOdd:gleSpiral",&_obj1,&_obj2,&_obj3,&_arg4,&_arg5,&_arg6,&_arg7,&_obj8,&_obj9,&_arg10,&_arg11)) 
        return NULL;
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 2, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
{
  if (_obj3 == Py_None) {
    _arg3 = NULL;
  } else {
    int expected_dims[1] = {3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
    if (! array1) return NULL;
    _obj3 = (PyObject *)array1;
    _arg3 = (double *)array1->data;
  }
}
{
  if (_obj8 == Py_None) {
    _arg8 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array2 = contiguous_typed_array(_obj8, PyArray_DOUBLE, 2, expected_dims);
    if (! array2) return NULL;
    _obj8 = (PyObject *)array2;
    _arg8 = (double *)array2->data;
  }
}
{
  if (_obj9 == Py_None) {
    _arg9 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array3 = contiguous_typed_array(_obj9, PyArray_DOUBLE, 2, expected_dims);
    if (! array3) return NULL;
    _obj9 = (PyObject *)array3;
    _arg9 = (double *)array3->data;
  }
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
    gleSpiral(_arg0,(double  (*)[2])_arg1,(double  (*)[2])_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,(double  (*)[3])_arg8,(double  (*)[3])_arg9,_arg10,_arg11);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
    return _resultobj;
}

static PyObject *_wrap_gleLathe(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    double * _arg8;
    double * _arg9;
    double  _arg10;
    double  _arg11;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;
    PyArrayObject * array2;
    PyObject * _obj8 = 0;
    PyArrayObject * array3;
    PyObject * _obj9 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOddddOOdd:gleLathe",&_obj1,&_obj2,&_obj3,&_arg4,&_arg5,&_arg6,&_arg7,&_obj8,&_obj9,&_arg10,&_arg11)) 
        return NULL;
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 2, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
{
  if (_obj3 == Py_None) {
    _arg3 = NULL;
  } else {
    int expected_dims[1] = {3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
    if (! array1) return NULL;
    _obj3 = (PyObject *)array1;
    _arg3 = (double *)array1->data;
  }
}
{
  if (_obj8 == Py_None) {
    _arg8 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array2 = contiguous_typed_array(_obj8, PyArray_DOUBLE, 2, expected_dims);
    if (! array2) return NULL;
    _obj8 = (PyObject *)array2;
    _arg8 = (double *)array2->data;
  }
}
{
  if (_obj9 == Py_None) {
    _arg9 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array3 = contiguous_typed_array(_obj9, PyArray_DOUBLE, 2, expected_dims);
    if (! array3) return NULL;
    _obj9 = (PyObject *)array3;
    _arg9 = (double *)array3->data;
  }
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
    gleLathe(_arg0,(double  (*)[2])_arg1,(double  (*)[2])_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,(double  (*)[3])_arg8,(double  (*)[3])_arg9,_arg10,_arg11);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
    return _resultobj;
}

static PyObject *_wrap_gleHelicoid(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double * _arg5;
    double * _arg6;
    double  _arg7;
    double  _arg8;
    PyArrayObject * array;
    PyObject * _obj5 = 0;
    PyArrayObject * array0;
    PyObject * _obj6 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"dddddOOdd:gleHelicoid",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_obj5,&_obj6,&_arg7,&_arg8)) 
        return NULL;
{
  if (_obj5 == Py_None) {
    _arg5 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array = contiguous_typed_array(_obj5, PyArray_DOUBLE, 2, expected_dims);
    if (! array) return NULL;
    _obj5 = (PyObject *)array;
    _arg5 = (double *)array->data;
  }
}
{
  if (_obj6 == Py_None) {
    _arg6 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array0 = contiguous_typed_array(_obj6, PyArray_DOUBLE, 2, expected_dims);
    if (! array0) return NULL;
    _obj6 = (PyObject *)array0;
    _arg6 = (double *)array0->data;
  }
}
    gleHelicoid(_arg0,_arg1,_arg2,_arg3,_arg4,(double  (*)[3])_arg5,(double  (*)[3])_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gleToroid(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double * _arg5;
    double * _arg6;
    double  _arg7;
    double  _arg8;
    PyArrayObject * array;
    PyObject * _obj5 = 0;
    PyArrayObject * array0;
    PyObject * _obj6 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"dddddOOdd:gleToroid",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_obj5,&_obj6,&_arg7,&_arg8)) 
        return NULL;
{
  if (_obj5 == Py_None) {
    _arg5 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array = contiguous_typed_array(_obj5, PyArray_DOUBLE, 2, expected_dims);
    if (! array) return NULL;
    _obj5 = (PyObject *)array;
    _arg5 = (double *)array->data;
  }
}
{
  if (_obj6 == Py_None) {
    _arg6 = NULL;
  } else {
    int expected_dims[2] = {2, 3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    if (expected_dims[1]==1) expected_dims[1]=0;
    array0 = contiguous_typed_array(_obj6, PyArray_DOUBLE, 2, expected_dims);
    if (! array0) return NULL;
    _obj6 = (PyObject *)array0;
    _arg6 = (double *)array0->data;
  }
}
    gleToroid(_arg0,_arg1,_arg2,_arg3,_arg4,(double  (*)[3])_arg5,(double  (*)[3])_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gleScrew(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    PyArrayObject * array;
    PyObject * _obj1 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;
    PyArrayObject * array1;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOddd:gleScrew",&_obj1,&_obj2,&_obj3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
{
  int expected_dims[2] = {1, 2};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 2, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
{
  if (_obj3 == Py_None) {
    _arg3 = NULL;
  } else {
    int expected_dims[1] = {3};
    if (expected_dims[0]==1) expected_dims[0]=0;
    array1 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
    if (! array1) return NULL;
    _obj3 = (PyObject *)array1;
    _arg3 = (double *)array1->data;
  }
}
{
   _arg0 = ((PyArrayObject *)(_obj1))->dimensions[0];
}
    gleScrew(_arg0,(double  (*)[2])_arg1,(double  (*)[2])_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
    return _resultobj;
}

static PyObject *_wrap_gleTextureMode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gleTextureMode",&_arg0)) 
        return NULL;
    gleTextureMode(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_rot_axis(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double * _arg1;
    PyArrayObject * array;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"dO:rot_axis",&_arg0,&_obj1)) 
        return NULL;
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 1, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
    rot_axis(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
    return _resultobj;
}

static PyObject *_wrap_rot_about_axis(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double * _arg1;
    PyArrayObject * array;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"dO:rot_about_axis",&_arg0,&_obj1)) 
        return NULL;
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array = contiguous_typed_array(_obj1, PyArray_DOUBLE, 1, expected_dims);
  if (! array) return NULL;
  _obj1 = (PyObject *)array;
  _arg1 = (double *)array->data;
}
    rot_about_axis(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj1);
}
    return _resultobj;
}

static PyObject *_wrap_rot_omega(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    PyArrayObject * array;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:rot_omega",&_obj0)) 
        return NULL;
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 1, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
    rot_omega(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
    return _resultobj;
}

static PyObject *_wrap_rot_prince(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    char  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"dc:rot_prince",&_arg0,&_arg1)) 
        return NULL;
    rot_prince(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_urot_axis(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    double  _arg1;
    double * _arg2;
    PyArrayObject * array;
    PyObject * _obj0 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OdO:urot_axis",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
  int expected_dims[2] = {4, 4};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 1, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
    urot_axis((double  (*)[4])_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
{
   Py_DECREF(_obj2);
}
    return _resultobj;
}

static PyObject *_wrap_urot_about_axis(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    double  _arg1;
    double * _arg2;
    PyArrayObject * array;
    PyObject * _obj0 = 0;
    PyArrayObject * array0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OdO:urot_about_axis",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
  int expected_dims[2] = {4, 4};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array0 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 1, expected_dims);
  if (! array0) return NULL;
  _obj2 = (PyObject *)array0;
  _arg2 = (double *)array0->data;
}
    urot_about_axis((double  (*)[4])_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
{
   Py_DECREF(_obj2);
}
    return _resultobj;
}

static PyObject *_wrap_urot_omega(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    double * _arg1;
    PyArrayObject * array;
    PyObject * _obj0 = 0;
    PyArrayObject * array0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:urot_omega",&_obj0,&_obj1)) 
        return NULL;
{
  int expected_dims[2] = {4, 4};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array0 = contiguous_typed_array(_obj1, PyArray_DOUBLE, 1, expected_dims);
  if (! array0) return NULL;
  _obj1 = (PyObject *)array0;
  _arg1 = (double *)array0->data;
}
    urot_omega((double  (*)[4])_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
{
   Py_DECREF(_obj1);
}
    return _resultobj;
}

static PyObject *_wrap_urot_prince(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    double  _arg1;
    char  _arg2;
    PyArrayObject * array;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odc:urot_prince",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
  int expected_dims[2] = {4, 4};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
    urot_prince((double  (*)[4])_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
    return _resultobj;
}

static PyObject *_wrap_uview_direction(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    double * _arg1;
    double * _arg2;
    PyArrayObject * array;
    PyObject * _obj0 = 0;
    PyArrayObject * array0;
    PyObject * _obj1 = 0;
    PyArrayObject * array1;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:uview_direction",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
  int expected_dims[2] = {4, 4};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array0 = contiguous_typed_array(_obj1, PyArray_DOUBLE, 1, expected_dims);
  if (! array0) return NULL;
  _obj1 = (PyObject *)array0;
  _arg1 = (double *)array0->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array1 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 1, expected_dims);
  if (! array1) return NULL;
  _obj2 = (PyObject *)array1;
  _arg2 = (double *)array1->data;
}
    uview_direction((double  (*)[4])_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
    return _resultobj;
}

static PyObject *_wrap_uviewpoint(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _arg0;
    double * _arg1;
    double * _arg2;
    double * _arg3;
    PyArrayObject * array;
    PyObject * _obj0 = 0;
    PyArrayObject * array0;
    PyObject * _obj1 = 0;
    PyArrayObject * array1;
    PyObject * _obj2 = 0;
    PyArrayObject * array2;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOO:uviewpoint",&_obj0,&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
  int expected_dims[2] = {4, 4};
  if (expected_dims[0]==1) expected_dims[0]=0;
  if (expected_dims[1]==1) expected_dims[1]=0;
  array = contiguous_typed_array(_obj0, PyArray_DOUBLE, 2, expected_dims);
  if (! array) return NULL;
  _obj0 = (PyObject *)array;
  _arg0 = (double *)array->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array0 = contiguous_typed_array(_obj1, PyArray_DOUBLE, 1, expected_dims);
  if (! array0) return NULL;
  _obj1 = (PyObject *)array0;
  _arg1 = (double *)array0->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array1 = contiguous_typed_array(_obj2, PyArray_DOUBLE, 1, expected_dims);
  if (! array1) return NULL;
  _obj2 = (PyObject *)array1;
  _arg2 = (double *)array1->data;
}
{
  int expected_dims[1] = {3};
  if (expected_dims[0]==1) expected_dims[0]=0;
  array2 = contiguous_typed_array(_obj3, PyArray_DOUBLE, 1, expected_dims);
  if (! array2) return NULL;
  _obj3 = (PyObject *)array2;
  _arg3 = (double *)array2->data;
}
    uviewpoint((double  (*)[4])_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
   Py_DECREF(_obj0);
}
{
   Py_DECREF(_obj1);
}
{
   Py_DECREF(_obj2);
}
{
   Py_DECREF(_obj3);
}
    return _resultobj;
}

static PyObject *_wrap_gleFeedBack(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gleFeedBack")) 
        return NULL;
    gleFeedBack();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gleFreeFeedbackBuffers(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gleFreeFeedbackBuffers")) 
        return NULL;
    gleFreeFeedbackBuffers();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyMethodDef glecMethods[] = {
	 { "gleGetTriangleMesh", gleGetTriangleMesh, 1 },
	 { "gleFreeFeedbackBuffers", _wrap_gleFreeFeedbackBuffers, 1 },
	 { "gleFeedBack", _wrap_gleFeedBack, 1 },
	 { "uviewpoint", _wrap_uviewpoint, 1 },
	 { "uview_direction", _wrap_uview_direction, 1 },
	 { "urot_prince", _wrap_urot_prince, 1 },
	 { "urot_omega", _wrap_urot_omega, 1 },
	 { "urot_about_axis", _wrap_urot_about_axis, 1 },
	 { "urot_axis", _wrap_urot_axis, 1 },
	 { "rot_prince", _wrap_rot_prince, 1 },
	 { "rot_omega", _wrap_rot_omega, 1 },
	 { "rot_about_axis", _wrap_rot_about_axis, 1 },
	 { "rot_axis", _wrap_rot_axis, 1 },
	 { "gleTextureMode", _wrap_gleTextureMode, 1 },
	 { "gleScrew", _wrap_gleScrew, 1 },
	 { "gleToroid", _wrap_gleToroid, 1 },
	 { "gleHelicoid", _wrap_gleHelicoid, 1 },
	 { "gleLathe", _wrap_gleLathe, 1 },
	 { "gleSpiral", _wrap_gleSpiral, 1 },
	 { "gleSuperExtrusion", _wrap_gleSuperExtrusion, 1 },
	 { "gleTwistExtrusion", _wrap_gleTwistExtrusion, 1 },
	 { "gleExtrusion", _wrap_gleExtrusion, 1 },
	 { "glePolyCone", _wrap_glePolyCone, 1 },
	 { "glePolyCylinder", _wrap_glePolyCylinder, 1 },
	 { "gleSetJoinStyle", _wrap_gleSetJoinStyle, 1 },
	 { "gleGetJoinStyle", _wrap_gleGetJoinStyle, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initglec)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("glec", glecMethods);
	 d = PyModule_GetDict(m);

	import_array(); /* load the Numeric PyCObjects */
	 PyDict_SetItemString(d,"TUBE_JN_RAW", PyInt_FromLong((long) 0x1));
	 PyDict_SetItemString(d,"TUBE_JN_ANGLE", PyInt_FromLong((long) 0x2));
	 PyDict_SetItemString(d,"TUBE_JN_CUT", PyInt_FromLong((long) 0x3));
	 PyDict_SetItemString(d,"TUBE_JN_ROUND", PyInt_FromLong((long) 0x4));
	 PyDict_SetItemString(d,"TUBE_JN_MASK", PyInt_FromLong((long) 0xf));
	 PyDict_SetItemString(d,"TUBE_JN_CAP", PyInt_FromLong((long) 0x10));
	 PyDict_SetItemString(d,"TUBE_NORM_FACET", PyInt_FromLong((long) 0x100));
	 PyDict_SetItemString(d,"TUBE_NORM_EDGE", PyInt_FromLong((long) 0x200));
	 PyDict_SetItemString(d,"TUBE_NORM_PATH_EDGE", PyInt_FromLong((long) 0x400));
	 PyDict_SetItemString(d,"TUBE_NORM_MASK", PyInt_FromLong((long) 0xf00));
	 PyDict_SetItemString(d,"TUBE_CONTOUR_CLOSED", PyInt_FromLong((long) 0x1000));
	 PyDict_SetItemString(d,"GLE_TEXTURE_ENABLE", PyInt_FromLong((long) 0x10000));
	 PyDict_SetItemString(d,"GLE_TEXTURE_STYLE_MASK", PyInt_FromLong((long) 0xff));
	 PyDict_SetItemString(d,"GLE_TEXTURE_VERTEX_FLAT", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"GLE_TEXTURE_NORMAL_FLAT", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"GLE_TEXTURE_VERTEX_CYL", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"GLE_TEXTURE_NORMAL_CYL", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"GLE_TEXTURE_VERTEX_SPH", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"GLE_TEXTURE_NORMAL_SPH", PyInt_FromLong((long) 6));
	 PyDict_SetItemString(d,"GLE_TEXTURE_VERTEX_MODEL_FLAT", PyInt_FromLong((long) 7));
	 PyDict_SetItemString(d,"GLE_TEXTURE_NORMAL_MODEL_FLAT", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"GLE_TEXTURE_VERTEX_MODEL_CYL", PyInt_FromLong((long) 9));
	 PyDict_SetItemString(d,"GLE_TEXTURE_NORMAL_MODEL_CYL", PyInt_FromLong((long) 10));
	 PyDict_SetItemString(d,"GLE_TEXTURE_VERTEX_MODEL_SPH", PyInt_FromLong((long) 11));
	 PyDict_SetItemString(d,"GLE_TEXTURE_NORMAL_MODEL_SPH", PyInt_FromLong((long) 12));
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_double_p","_gleAffine",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_gleAffine","_double_p",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
