//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLVulnerabilityAssessmentScanResultsClient contains the methods for the SQLVulnerabilityAssessmentScanResults group.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentScanResultsClient() instead.
type SQLVulnerabilityAssessmentScanResultsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewSQLVulnerabilityAssessmentScanResultsClient creates a new instance of SQLVulnerabilityAssessmentScanResultsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSQLVulnerabilityAssessmentScanResultsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLVulnerabilityAssessmentScanResultsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SQLVulnerabilityAssessmentScanResultsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Get - Gets the scan results of a single rule in a scan record.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// scanID - The scan Id. Type 'latest' to get the scan results for the latest scan.
// scanResultID - The rule Id of the results.
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentScanResultsClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentScanResultsClient.Get
// method.
func (client *SQLVulnerabilityAssessmentScanResultsClient) Get(ctx context.Context, scanID string, scanResultID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScanResultsClientGetOptions) (SQLVulnerabilityAssessmentScanResultsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, scanID, scanResultID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentScanResultsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentScanResultsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentScanResultsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SQLVulnerabilityAssessmentScanResultsClient) getCreateRequest(ctx context.Context, scanID string, scanResultID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScanResultsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}"
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if scanResultID == "" {
		return nil, errors.New("parameter scanResultID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanResultId}", url.PathEscape(scanResultID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLVulnerabilityAssessmentScanResultsClient) getHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentScanResultsClientGetResponse, error) {
	result := SQLVulnerabilityAssessmentScanResultsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScanResult); err != nil {
		return SQLVulnerabilityAssessmentScanResultsClientGetResponse{}, err
	}
	return result, nil
}

// List - Gets a list of scan results for a single scan record.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-07-01-preview
// scanID - The scan Id. Type 'latest' to get the scan results for the latest scan.
// workspaceID - The workspace Id.
// resourceID - The identifier of the resource.
// options - SQLVulnerabilityAssessmentScanResultsClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentScanResultsClient.List
// method.
func (client *SQLVulnerabilityAssessmentScanResultsClient) List(ctx context.Context, scanID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScanResultsClientListOptions) (SQLVulnerabilityAssessmentScanResultsClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, scanID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentScanResultsClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentScanResultsClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLVulnerabilityAssessmentScanResultsClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *SQLVulnerabilityAssessmentScanResultsClient) listCreateRequest(ctx context.Context, scanID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScanResultsClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults"
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2020-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SQLVulnerabilityAssessmentScanResultsClient) listHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentScanResultsClientListResponse, error) {
	result := SQLVulnerabilityAssessmentScanResultsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScanResults); err != nil {
		return SQLVulnerabilityAssessmentScanResultsClientListResponse{}, err
	}
	return result, nil
}
