#!/bin/sh

# This thing is intended primarily to find soundcard.h for use with the
# OSS soundcard driver.
#
# Linux typically has <sys/soundcard.h>
# NetBSD and OpenBSD have <soundcard.h>
# FreeBSD seems to have <machine/soundcard.h>
#
# This script will be replaced with something more decent when support for
# more sound drivers is added.  This file will be executed during compile
# even if you aren't using sound.

INCLUDE1="/usr/include/sys"
INCLUDE2="/usr/include"
INCLUDE3="/usr/include/machine"
INCLUDE4="/usr/include/linux"

SOUNDCARD_H="soundcard.h"
OUTFILE="$1/soundcard.h"

echo "checking for $SOUNDCARD_H"

#if [ -f $OUTFILE ] ; then
#	echo "$SOUNDCARD_H already made."
#	exit 0
#fi

cat << EOF > $OUTFILE
/*
 * This file automatically generated by findsound.sh which run by the
 * Makefile found in the Unix Frotz 2.43 source distribution.
 * Copying this nasty hack to find headers which may be in any of several
 * places is not recommended.  I don't want to use autoconf just yet for
 * this project.
 *
 */

EOF

FILE=$INCLUDE1/$SOUNDCARD_H
if [ -f $FILE ] ; then
	echo "I see we have $FILE..."
	echo
	if [ -r $FILE ] ; then
		echo '#include <sys/soundcard.h>' >> $OUTFILE
	else
		echo "====================================="
		echo "Oops...  Can't read $FILE!"
		echo "====================================="
		exit 1
	fi
	exit 0
fi

# I'm too lazy to iterate properly right now

FILE=$INCLUDE2/$SOUNDCARD_H
if [ -f $FILE ] ; then
	echo "I see we have $FILE..."
	echo
	if [ -r $FILE ] ; then
		echo '#include <soundcard.h>' >> $OUTFILE
	else
		echo "====================================="
		echo "Oops...  Can't read $FILE!"
		echo "====================================="
		exit 2
	fi
	exit 0
fi


# I'm too lazy to iterate properly right now

FILE=$INCLUDE3/$SOUNDCARD_H
if [ -f $FILE ] ; then
	echo "I see we have $FILE..."
	echo
	if [ -r $FILE ] ; then
		echo '#include <machine/soundcard.h>' >> $OUTFILE
	else
		echo "====================================="
		echo "Oops...  Can't read $FILE!"
		echo "====================================="
		exit 3
	fi
	exit 0
fi



FILE=$INCLUDE4/$SOUNDCARD_H
if [ -f $FILE ] ; then
	echo "I see we have $FILE..."
	echo
	if [ -r $FILE ] ; then
		echo '#include <linux/soundcard.h>' >> $OUTFILE
	else
		echo "====================================="
		echo "Oops...  Can't read $FILE!"
		echo "====================================="
		exit 3
	fi
	exit 0
fi
