/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;

public final class COSUtils {
    private static final Log LOGGER = LogFactory.getLog(COSUtils.class);

    private COSUtils() {
    }

    public static boolean isDictionary(COSBase elt, COSDocument doc) {
        return COSUtils.isClass(elt, doc, COSDictionary.class);
    }

    public static boolean isString(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && (obj.getObject() instanceof COSString || obj.getObject() instanceof COSName);
            }
            catch (IOException e) {
                LOGGER.debug("Couldn't get COSObject from object pool - returning false", e);
                return false;
            }
        }
        return elt instanceof COSString || elt instanceof COSName;
    }

    public static boolean isStream(COSBase elt, COSDocument doc) {
        return COSUtils.isClass(elt, doc, COSStream.class);
    }

    public static boolean isInteger(COSBase elt, COSDocument doc) {
        return COSUtils.isClass(elt, doc, COSInteger.class);
    }

    private static boolean isClass(COSBase elt, COSDocument doc, Class claz) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && claz.isInstance(obj.getObject());
            }
            catch (IOException e) {
                LOGGER.debug("Couldn't get COSObject from object pool - returning false", e);
                return false;
            }
        }
        return claz.isInstance(elt);
    }

    public static boolean isNumeric(COSBase elt, COSDocument doc) {
        return COSUtils.isInteger(elt, doc) || COSUtils.isFloat(elt, doc);
    }

    public static boolean isFloat(COSBase elt, COSDocument doc) {
        return COSUtils.isClass(elt, doc, COSFloat.class);
    }

    public static boolean isArray(COSBase elt, COSDocument doc) {
        return COSUtils.isClass(elt, doc, COSArray.class);
    }

    public static COSArray getAsArray(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            return (COSArray)COSUtils.getCOSObjectAsClass((COSObject)cbase, cDoc, COSArray.class);
        }
        if (cbase instanceof COSArray) {
            return (COSArray)cbase;
        }
        return null;
    }

    public static String getAsString(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj != null && obj.getObject() instanceof COSString) {
                    return ((COSString)obj.getObject()).getString();
                }
                if (obj != null && obj.getObject() instanceof COSName) {
                    return ((COSName)obj.getObject()).getName();
                }
                return null;
            }
            catch (IOException e) {
                LOGGER.debug("Couldn't get COSObject from object pool - returning null", e);
                return null;
            }
        }
        if (cbase instanceof COSString) {
            return ((COSString)cbase).getString();
        }
        if (cbase instanceof COSName) {
            return ((COSName)cbase).getName();
        }
        return null;
    }

    public static COSDictionary getAsDictionary(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            return (COSDictionary)COSUtils.getCOSObjectAsClass((COSObject)cbase, cDoc, COSDictionary.class);
        }
        if (cbase instanceof COSDictionary) {
            return (COSDictionary)cbase;
        }
        return null;
    }

    public static COSStream getAsStream(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            return (COSStream)COSUtils.getCOSObjectAsClass((COSObject)cbase, cDoc, COSStream.class);
        }
        if (cbase instanceof COSStream) {
            return (COSStream)cbase;
        }
        return null;
    }

    public static Float getAsFloat(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj == null) {
                    return null;
                }
                if (obj.getObject() instanceof COSNumber) {
                    return Float.valueOf(((COSNumber)obj.getObject()).floatValue());
                }
                return null;
            }
            catch (IOException e) {
                LOGGER.debug("Couldn't get COSObject from object pool - returning null", e);
                return null;
            }
        }
        if (cbase instanceof COSNumber) {
            return Float.valueOf(((COSNumber)cbase).floatValue());
        }
        return null;
    }

    public static Integer getAsInteger(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj == null) {
                    return null;
                }
                if (obj.getObject() instanceof COSNumber) {
                    return ((COSNumber)obj.getObject()).intValue();
                }
                return null;
            }
            catch (IOException e) {
                LOGGER.debug("Couldn't get COSObject from object pool - returning null", e);
                return null;
            }
        }
        if (cbase instanceof COSNumber) {
            return ((COSNumber)cbase).intValue();
        }
        return null;
    }

    public static void closeDocumentQuietly(COSDocument document) {
        try {
            if (document != null) {
                document.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error occured during the close of a COSDocument : " + e.getMessage(), e);
        }
    }

    public static void closeDocumentQuietly(PDDocument document) {
        if (document != null) {
            COSUtils.closeDocumentQuietly(document.getDocument());
        }
    }

    private static COSBase getCOSObjectAsClass(COSObject cosObject, COSDocument cDoc, Class claz) {
        try {
            COSObjectKey key = new COSObjectKey(cosObject);
            COSObject obj = cDoc.getObjectFromPool(key);
            if (obj != null && claz.isInstance(obj.getObject())) {
                return obj.getObject();
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.debug("Couldn't get COSObject from object pool - returning null", e);
            return null;
        }
    }
}

