/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.SignaturePolicyData;
import xades4j.xml.bind.xades.XmlAnyType;
import xades4j.xml.bind.xades.XmlDigestAlgAndValueType;
import xades4j.xml.bind.xades.XmlSigPolicyQualifiersListType;
import xades4j.xml.bind.xades.XmlSignaturePolicyIdType;
import xades4j.xml.bind.xades.XmlSignaturePolicyIdentifierType;
import xades4j.xml.bind.xades.XmlSignedPropertiesType;
import xades4j.xml.bind.xmldsig.XmlDigestMethodType;
import xades4j.xml.marshalling.SignedPropertyDataToXmlConverter;
import xades4j.xml.marshalling.ToXmlUtils;

class ToXmlSignaturePolicyConverter
implements SignedPropertyDataToXmlConverter {
    ToXmlSignaturePolicyConverter() {
    }

    @Override
    public void convertIntoObjectTree(PropertyDataObject propData, XmlSignedPropertiesType xmlProps, Document doc) {
        SignaturePolicyData sigPolicyData = (SignaturePolicyData)propData;
        XmlSignaturePolicyIdentifierType xmlSigPolicy = new XmlSignaturePolicyIdentifierType();
        if (null == sigPolicyData.getIdentifier()) {
            xmlSigPolicy.setSignaturePolicyImplied();
        } else {
            xmlSigPolicy.setSignaturePolicyId(this.getSignaturePolicy(sigPolicyData, doc));
        }
        xmlProps.getSignedSignatureProperties().setSignaturePolicyIdentifier(xmlSigPolicy);
    }

    private XmlSignaturePolicyIdType getSignaturePolicy(SignaturePolicyData sigPolicyData, Document doc) {
        XmlSignaturePolicyIdType xmlSigPolicyId = new XmlSignaturePolicyIdType();
        xmlSigPolicyId.setSigPolicyId(ToXmlUtils.getXmlObjectId(sigPolicyData.getIdentifier()));
        XmlDigestMethodType xmlDigestMethod = new XmlDigestMethodType();
        xmlDigestMethod.setAlgorithm(sigPolicyData.getDigestAlgorithm());
        XmlDigestAlgAndValueType xmlDigest = new XmlDigestAlgAndValueType();
        xmlDigest.setDigestMethod(xmlDigestMethod);
        xmlDigest.setDigestValue(sigPolicyData.getDigestValue());
        xmlSigPolicyId.setSigPolicyHash(xmlDigest);
        String url = sigPolicyData.getLocationUrl();
        if (url != null) {
            JAXBElement xmlSPURI = new JAXBElement(new QName("http://uri.etsi.org/01903/v1.3.2#", "SPURI"), String.class, (Object)url);
            XmlAnyType xmlQualifier = new XmlAnyType();
            xmlQualifier.getContent().add(xmlSPURI);
            XmlSigPolicyQualifiersListType xmlQualifiers = new XmlSigPolicyQualifiersListType();
            xmlQualifiers.getSigPolicyQualifier().add(xmlQualifier);
            xmlSigPolicyId.setSigPolicyQualifiers(xmlQualifiers);
        }
        return xmlSigPolicyId;
    }
}

