/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import xades4j.providers.X500NameStyleProvider;
import xades4j.utils.X500ExtensibleNameStyle;

class DistinguishedNameComparer {
    private final X500ExtensibleNameStyle x500NameStyle;
    private final X500NameStyleProvider x500NameStyleProvider;

    @Inject
    DistinguishedNameComparer(X500ExtensibleNameStyle x500NameStyle, X500NameStyleProvider x500NameStyleProvider) {
        this.x500NameStyle = x500NameStyle;
        this.x500NameStyleProvider = x500NameStyleProvider;
    }

    boolean areEqual(X500Principal parsedDn, String stringDn) {
        X500Name first = X500Name.getInstance((Object)parsedDn.getEncoded());
        X500Name second = X500Name.getInstance((X500NameStyle)this.x500NameStyle, (Object)this.x500NameStyleProvider.fromString(stringDn).getEncoded());
        return first.equals((Object)second);
    }
}

