/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.util.Collection;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import xades4j.properties.DataObjectFormatProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.DataObjectFormatData;
import xades4j.utils.StringUtils;
import xades4j.verification.DataObjectFormatMismatchException;
import xades4j.verification.DataObjectFormatReferenceException;
import xades4j.verification.DataObjectFormatVerificationException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.RawDataObjectDesc;

class DataObjFormatVerifier
implements QualifyingPropertyVerifier<DataObjectFormatData> {
    DataObjFormatVerifier() {
    }

    @Override
    public QualifyingProperty verify(DataObjectFormatData propData, QualifyingPropertyVerificationContext ctx) throws DataObjectFormatVerificationException {
        QualifyingPropertyVerificationContext.SignedObjectsData signedObjsData = ctx.getSignedObjectsData();
        String encoding = propData.getEncoding();
        String mimeType = propData.getMimeType();
        RawDataObjectDesc signedObj = signedObjsData.findSignedDataObject(propData.getObjectRef());
        if (null == signedObj) {
            throw new DataObjectFormatReferenceException(propData.getObjectRef());
        }
        Reference signedObjRef = signedObj.getReference();
        if ("http://www.w3.org/2000/09/xmldsig#Object".equals(signedObjRef.getType())) {
            ObjectContainer signedObjObj = signedObjsData.findXMLObject(signedObjRef.getURI());
            if (null == signedObjObj) {
                throw new DataObjectFormatReferenceException(signedObjRef.getURI());
            }
            String objEncoding = signedObjObj.getEncoding();
            String objMimeType = signedObjObj.getMimeType();
            if (StringUtils.differentStringsIfNotNullNorEmpty(objEncoding, encoding) || StringUtils.differentStringsIfNotNullNorEmpty(objMimeType, mimeType)) {
                throw new DataObjectFormatMismatchException(mimeType, encoding, signedObjRef, signedObjObj);
            }
        }
        DataObjectFormatProperty formatProp = new DataObjectFormatProperty(mimeType, encoding);
        formatProp.withDescription(propData.getDescription());
        Collection<String> docsUris = propData.getDocumentationUris();
        if (docsUris != null) {
            formatProp.withDocumentationUris(docsUris);
        }
        formatProp.withIdentifier(propData.getIdentifier());
        signedObj.withDataObjectFormat(formatProp);
        return formatProp;
    }
}

