/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.validation;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.CRLVerifier;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.OcspHelper;
import org.apache.pdfbox.examples.signature.cert.RevokedCertificateException;
import org.apache.pdfbox.examples.signature.validation.CertInformationCollector;
import org.apache.pdfbox.examples.signature.validation.CertificateProccessingException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class AddValidationInformation {
    private static final Log LOG = LogFactory.getLog(AddValidationInformation.class);
    private CertInformationCollector certInformationHelper;
    private COSArray correspondingOCSPs;
    private COSArray correspondingCRLs;
    private COSDictionary vriBase;
    private COSArray ocsps;
    private COSArray crls;
    private COSArray certs;
    private PDDocument document;
    private final Set<BigInteger> foundRevocationInformation = new HashSet<BigInteger>();
    private Calendar signDate;

    public void validateSignature(File file, File file2) throws IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        PDDocument pDDocument = PDDocument.load((File)file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.document = pDDocument;
        this.doValidation(file.getAbsolutePath(), fileOutputStream);
        fileOutputStream.close();
        pDDocument.close();
    }

    private void doValidation(String string, OutputStream outputStream) throws IOException {
        PDSignature pDSignature;
        this.certInformationHelper = new CertInformationCollector();
        CertInformationCollector.CertSignatureInformation certSignatureInformation = null;
        try {
            pDSignature = SigUtils.getLastRelevantSignature(this.document);
            if (pDSignature != null) {
                certSignatureInformation = this.certInformationHelper.getLastCertInfo(pDSignature, string);
                this.signDate = pDSignature.getSignDate();
            }
        }
        catch (CertificateProccessingException certificateProccessingException) {
            throw new IOException("An Error occurred processing the Signature", certificateProccessingException);
        }
        if (certSignatureInformation == null) {
            throw new IOException("No Certificate information or signature found in the given document");
        }
        pDSignature = this.document.getDocumentCatalog();
        COSDictionary cOSDictionary = pDSignature.getCOSObject();
        cOSDictionary.setNeedToBeUpdated(true);
        COSDictionary cOSDictionary2 = AddValidationInformation.getOrCreateDictionaryEntry(COSDictionary.class, cOSDictionary, "DSS");
        this.addExtensions((PDDocumentCatalog)pDSignature);
        this.vriBase = AddValidationInformation.getOrCreateDictionaryEntry(COSDictionary.class, cOSDictionary2, "VRI");
        this.ocsps = AddValidationInformation.getOrCreateDictionaryEntry(COSArray.class, cOSDictionary2, "OCSPs");
        this.crls = AddValidationInformation.getOrCreateDictionaryEntry(COSArray.class, cOSDictionary2, "CRLs");
        this.certs = AddValidationInformation.getOrCreateDictionaryEntry(COSArray.class, cOSDictionary2, "Certs");
        this.addRevocationData(certSignatureInformation);
        this.addAllCertsToCertArray();
        this.document.saveIncremental(outputStream);
    }

    private static <T extends COSBase> T getOrCreateDictionaryEntry(Class<T> clazz, COSDictionary cOSDictionary, String string) throws IOException {
        COSBase cOSBase;
        COSBase cOSBase2 = cOSDictionary.getDictionaryObject(string);
        if (cOSBase2 != null && clazz.isInstance(cOSBase2)) {
            cOSBase = (COSBase)clazz.cast(cOSBase2);
            ((COSUpdateInfo)cOSBase).setNeedToBeUpdated(true);
        } else {
            if (cOSBase2 != null) {
                throw new IOException("Element " + string + " from dictionary is not of type " + clazz.getCanonicalName());
            }
            try {
                cOSBase = (COSBase)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                LOG.error((Object)("Failed to create new instance of " + clazz.getCanonicalName()), (Throwable)instantiationException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.error((Object)("Failed to create new instance of " + clazz.getCanonicalName()), (Throwable)illegalAccessException);
                return null;
            }
            cOSBase.setDirect(false);
            cOSDictionary.setItem(COSName.getPDFName((String)string), cOSBase);
        }
        return (T)cOSBase;
    }

    private void addRevocationData(CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException {
        COSDictionary cOSDictionary = new COSDictionary();
        this.vriBase.setItem(certSignatureInformation.getSignatureHash(), (COSBase)cOSDictionary);
        this.updateVRI(certSignatureInformation, cOSDictionary);
        if (certSignatureInformation.getTsaCerts() != null) {
            this.correspondingOCSPs = null;
            this.correspondingCRLs = null;
            this.addRevocationDataRecursive(certSignatureInformation.getTsaCerts());
        }
    }

    private void addRevocationDataRecursive(CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException {
        if (certSignatureInformation.isSelfSigned()) {
            return;
        }
        boolean bl = this.foundRevocationInformation.contains(certSignatureInformation.getCertificate().getSerialNumber());
        if (!bl) {
            if (certSignatureInformation.getOcspUrl() != null && certSignatureInformation.getIssuerCertificate() != null) {
                bl = this.fetchOcspData(certSignatureInformation);
            }
            if (!bl && certSignatureInformation.getCrlUrl() != null) {
                this.fetchCrlData(certSignatureInformation);
                bl = true;
            }
            if (certSignatureInformation.getOcspUrl() == null && certSignatureInformation.getCrlUrl() == null) {
                LOG.info((Object)("No revocation information for cert " + certSignatureInformation.getCertificate().getSubjectX500Principal()));
            } else if (!bl) {
                throw new IOException("Could not fetch Revocation Info for Cert: " + certSignatureInformation.getCertificate().getSubjectX500Principal());
            }
        }
        if (certSignatureInformation.getAlternativeCertChain() != null) {
            this.addRevocationDataRecursive(certSignatureInformation.getAlternativeCertChain());
        }
        if (certSignatureInformation.getCertChain() != null && certSignatureInformation.getCertChain().getCertificate() != null) {
            this.addRevocationDataRecursive(certSignatureInformation.getCertChain());
        }
    }

    private boolean fetchOcspData(CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException {
        try {
            this.addOcspData(certSignatureInformation);
            return true;
        }
        catch (OCSPException oCSPException) {
            LOG.warn((Object)"Failed fetching Ocsp", (Throwable)oCSPException);
            return false;
        }
        catch (CertificateProccessingException certificateProccessingException) {
            LOG.warn((Object)"Failed fetching Ocsp", (Throwable)certificateProccessingException);
            return false;
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Failed fetching Ocsp", (Throwable)iOException);
            return false;
        }
        catch (RevokedCertificateException revokedCertificateException) {
            throw new IOException(revokedCertificateException);
        }
    }

    private void fetchCrlData(CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException {
        try {
            this.addCrlRevocationInfo(certSignatureInformation);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)generalSecurityException);
            throw new IOException(generalSecurityException);
        }
        catch (RevokedCertificateException revokedCertificateException) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)revokedCertificateException);
            throw new IOException(revokedCertificateException);
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)iOException);
            throw new IOException(iOException);
        }
        catch (CertificateVerificationException certificateVerificationException) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)certificateVerificationException);
            throw new IOException(certificateVerificationException);
        }
    }

    private void addOcspData(CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException, OCSPException, CertificateProccessingException, RevokedCertificateException {
        COSArray cOSArray;
        Object object;
        byte[] byArray;
        OcspHelper ocspHelper = new OcspHelper(certSignatureInformation.getCertificate(), this.signDate.getTime(), certSignatureInformation.getIssuerCertificate(), new HashSet<X509Certificate>(this.certInformationHelper.getCertificatesMap().values()), certSignatureInformation.getOcspUrl());
        OCSPResp oCSPResp = ocspHelper.getResponseOcsp();
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
        X509Certificate x509Certificate = ocspHelper.getOcspResponderCertificate();
        this.certInformationHelper.addAllCertsFromHolders(basicOCSPResp.getCerts());
        try {
            byArray = MessageDigest.getInstance("SHA-1").digest(basicOCSPResp.getSignature());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateProccessingException(noSuchAlgorithmException);
        }
        String string = Hex.getString((byte[])byArray);
        if (!this.vriBase.containsKey(string)) {
            object = this.correspondingOCSPs;
            cOSArray = this.correspondingCRLs;
            COSDictionary cOSDictionary = new COSDictionary();
            this.vriBase.setItem(string, (COSBase)cOSDictionary);
            CertInformationCollector.CertSignatureInformation certSignatureInformation2 = this.certInformationHelper.getCertInfo(x509Certificate);
            this.updateVRI(certSignatureInformation2, cOSDictionary);
            this.correspondingOCSPs = object;
            this.correspondingCRLs = cOSArray;
        }
        object = oCSPResp.getEncoded();
        cOSArray = this.writeDataToStream((byte[])object);
        this.ocsps.add((COSBase)cOSArray);
        if (this.correspondingOCSPs != null) {
            this.correspondingOCSPs.add((COSBase)cOSArray);
        }
        this.foundRevocationInformation.add(certSignatureInformation.getCertificate().getSerialNumber());
    }

    private void addCrlRevocationInfo(CertInformationCollector.CertSignatureInformation certSignatureInformation) throws IOException, RevokedCertificateException, GeneralSecurityException, CertificateVerificationException {
        X509CRL x509CRL = CRLVerifier.downloadCRLFromWeb(certSignatureInformation.getCrlUrl());
        X509Certificate x509Certificate = certSignatureInformation.getIssuerCertificate();
        for (X509Certificate object : this.certInformationHelper.getCertificatesMap().values()) {
            if (!object.getSubjectX500Principal().equals(x509CRL.getIssuerX500Principal())) continue;
            x509Certificate = object;
            break;
        }
        x509CRL.verify(x509Certificate.getPublicKey(), SecurityProvider.getProvider().getName());
        CRLVerifier.checkRevocation(x509CRL, certSignatureInformation.getCertificate(), this.signDate.getTime(), certSignatureInformation.getCrlUrl());
        COSStream cOSStream = this.writeDataToStream(x509CRL.getEncoded());
        this.crls.add((COSBase)cOSStream);
        if (this.correspondingCRLs != null) {
            byte[] byArray;
            this.correspondingCRLs.add((COSBase)cOSStream);
            try {
                byArray = MessageDigest.getInstance("SHA-1").digest(x509CRL.getSignature());
            }
            catch (NoSuchAlgorithmException string) {
                throw new CertificateVerificationException(string.getMessage(), string);
            }
            String string = Hex.getString((byte[])byArray);
            if (!this.vriBase.containsKey(string)) {
                CertInformationCollector.CertSignatureInformation certSignatureInformation2;
                COSArray cOSArray = this.correspondingOCSPs;
                COSArray cOSArray2 = this.correspondingCRLs;
                COSDictionary cOSDictionary = new COSDictionary();
                this.vriBase.setItem(string, (COSBase)cOSDictionary);
                try {
                    certSignatureInformation2 = this.certInformationHelper.getCertInfo(x509Certificate);
                }
                catch (CertificateProccessingException certificateProccessingException) {
                    throw new CertificateVerificationException(certificateProccessingException.getMessage(), certificateProccessingException);
                }
                this.updateVRI(certSignatureInformation2, cOSDictionary);
                this.correspondingOCSPs = cOSArray;
                this.correspondingCRLs = cOSArray2;
            }
        }
        this.foundRevocationInformation.add(certSignatureInformation.getCertificate().getSerialNumber());
    }

    private void updateVRI(CertInformationCollector.CertSignatureInformation certSignatureInformation, COSDictionary cOSDictionary) throws IOException {
        X509Certificate x509Certificate;
        if (certSignatureInformation.getCertificate().getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null) {
            this.correspondingOCSPs = new COSArray();
            this.correspondingCRLs = new COSArray();
            this.addRevocationDataRecursive(certSignatureInformation);
            if (this.correspondingOCSPs.size() > 0) {
                cOSDictionary.setItem("OCSP", (COSBase)this.correspondingOCSPs);
            }
            if (this.correspondingCRLs.size() > 0) {
                cOSDictionary.setItem("CRL", (COSBase)this.correspondingCRLs);
            }
        }
        COSArray cOSArray = new COSArray();
        CertInformationCollector.CertSignatureInformation certSignatureInformation2 = certSignatureInformation;
        do {
            x509Certificate = certSignatureInformation2.getCertificate();
            try {
                COSStream cOSStream = this.writeDataToStream(x509Certificate.getEncoded());
                cOSArray.add((COSBase)cOSStream);
                this.certs.add((COSBase)cOSStream);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                LOG.error((Object)certificateEncodingException, (Throwable)certificateEncodingException);
            }
        } while (x509Certificate.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null && (certSignatureInformation2 = certSignatureInformation2.getCertChain()) != null);
        cOSDictionary.setItem(COSName.CERT, (COSBase)cOSArray);
        cOSDictionary.setDate(COSName.TU, Calendar.getInstance());
    }

    private void addAllCertsToCertArray() throws IOException {
        try {
            for (X509Certificate x509Certificate : this.certInformationHelper.getCertificatesMap().values()) {
                COSStream cOSStream = this.writeDataToStream(x509Certificate.getEncoded());
                this.certs.add((COSBase)cOSStream);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(certificateEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSStream writeDataToStream(byte[] byArray) throws IOException {
        COSStream cOSStream = this.document.getDocument().createCOSStream();
        OutputStream outputStream = null;
        try {
            outputStream = cOSStream.createOutputStream((COSBase)COSName.FLATE_DECODE);
            outputStream.write(byArray);
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
        }
        return cOSStream;
    }

    private void addExtensions(PDDocumentCatalog pDDocumentCatalog) {
        COSDictionary cOSDictionary = new COSDictionary();
        cOSDictionary.setDirect(true);
        pDDocumentCatalog.getCOSObject().setItem("Extensions", (COSBase)cOSDictionary);
        COSDictionary cOSDictionary2 = new COSDictionary();
        cOSDictionary2.setDirect(true);
        cOSDictionary.setItem("ADBE", (COSBase)cOSDictionary2);
        cOSDictionary2.setName("BaseVersion", "1.7");
        cOSDictionary2.setInt("ExtensionLevel", 5);
        pDDocumentCatalog.setVersion("1.7");
    }

    public static void main(String[] stringArray) throws IOException, GeneralSecurityException {
        if (stringArray.length != 1) {
            AddValidationInformation.usage();
            System.exit(1);
        }
        Security.addProvider(SecurityProvider.getProvider());
        AddValidationInformation addValidationInformation = new AddValidationInformation();
        File file = new File(stringArray[0]);
        String string = file.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        File file2 = new File(file.getParent(), string2 + "_ocsp.pdf");
        addValidationInformation.validateSignature(file, file2);
    }

    private static void usage() {
        System.err.println("usage: java " + AddValidationInformation.class.getName() + " <pdf_to_add_ocsp>\n");
    }
}

