/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.cert;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.examples.signature.cert.CRLVerifier;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.OcspHelper;
import org.apache.pdfbox.examples.signature.cert.RevokedCertificateException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;

public final class CertificateVerifier {
    private static final Log LOG = LogFactory.getLog(CertificateVerifier.class);

    private CertificateVerifier() {
    }

    public static PKIXCertPathBuilderResult verifyCertificate(X509Certificate x509Certificate, Set<X509Certificate> set, boolean bl, Date date) throws CertificateVerificationException {
        try {
            if (!bl && CertificateVerifier.isSelfSigned(x509Certificate)) {
                throw new CertificateVerificationException("The certificate is self-signed.");
            }
            Set<X509Certificate> set2 = CertificateVerifier.downloadExtraCertificates(x509Certificate);
            int n = set2.size();
            set2.addAll(set);
            if (n > 0) {
                LOG.info((Object)("CA issuers: " + (set2.size() - set.size()) + " downloaded certificate(s) are new"));
            }
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            HashSet<TrustAnchor> hashSet2 = new HashSet<TrustAnchor>();
            for (X509Certificate x509Certificate2 : set2) {
                if (CertificateVerifier.isSelfSigned(x509Certificate2)) {
                    hashSet2.add(new TrustAnchor(x509Certificate2, null));
                    continue;
                }
                hashSet.add(x509Certificate2);
            }
            if (hashSet2.isEmpty()) {
                throw new CertificateVerificationException("No root certificate in the chain");
            }
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = CertificateVerifier.verifyCertificate(x509Certificate, hashSet2, hashSet, date);
            LOG.info((Object)"Certification chain verified successfully");
            CertificateVerifier.checkRevocations(x509Certificate, set2, date);
            return pKIXCertPathBuilderResult;
        }
        catch (CertPathBuilderException certPathBuilderException) {
            throw new CertificateVerificationException("Error building certification path: " + x509Certificate.getSubjectX500Principal(), certPathBuilderException);
        }
        catch (CertificateVerificationException certificateVerificationException) {
            throw certificateVerificationException;
        }
        catch (Exception exception) {
            throw new CertificateVerificationException("Error verifying the certificate: " + x509Certificate.getSubjectX500Principal(), exception);
        }
    }

    private static void checkRevocations(X509Certificate x509Certificate, Set<X509Certificate> set, Date date) throws IOException, CertificateVerificationException, OCSPException, RevokedCertificateException, GeneralSecurityException {
        Object object;
        if (CertificateVerifier.isSelfSigned(x509Certificate)) {
            return;
        }
        X509Certificate x509Certificate2 = null;
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!x509Certificate.getIssuerX500Principal().equals(((X509Certificate)object).getSubjectX500Principal())) continue;
            x509Certificate2 = object;
            break;
        }
        if ((object2 = CertificateVerifier.extractOCSPURL(x509Certificate)) != null) {
            object = new OcspHelper(x509Certificate, date, x509Certificate2, set, (String)object2);
            try {
                CertificateVerifier.verifyOCSP((OcspHelper)object, set);
            }
            catch (IOException iOException) {
                LOG.warn((Object)"IOException trying OCSP, will try CRL", (Throwable)iOException);
                CRLVerifier.verifyCertificateCRLs(x509Certificate, date, set);
            }
        } else {
            LOG.info((Object)"OCSP not available, will try CRL");
            CRLVerifier.verifyCertificateCRLs(x509Certificate, date, set);
        }
        CertificateVerifier.checkRevocations(x509Certificate2, set, date);
    }

    public static boolean isSelfSigned(X509Certificate x509Certificate) throws GeneralSecurityException {
        try {
            PublicKey publicKey = x509Certificate.getPublicKey();
            x509Certificate.verify(publicKey, SecurityProvider.getProvider().getName());
            return true;
        }
        catch (SignatureException signatureException) {
            LOG.debug((Object)"Couldn't get signature information - returning false", (Throwable)signatureException);
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            LOG.debug((Object)"Couldn't get signature information - returning false", (Throwable)invalidKeyException);
            return false;
        }
        catch (IOException iOException) {
            LOG.debug((Object)"Couldn't get signature information - returning false", (Throwable)iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static Set<X509Certificate> downloadExtraCertificates(X509Extension x509Extension) {
        ASN1Primitive aSN1Primitive;
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        byte[] byArray = x509Extension.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (byArray == null) {
            return hashSet;
        }
        try {
            aSN1Primitive = JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray);
        }
        catch (IOException iOException) {
            LOG.warn((Object)iOException.getMessage(), (Throwable)iOException);
            return hashSet;
        }
        if (!(aSN1Primitive instanceof ASN1Sequence)) {
            LOG.warn((Object)("ASN1Sequence expected, got " + aSN1Primitive.getClass().getSimpleName()));
            return hashSet;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0);
            if (!aSN1ObjectIdentifier.equals((Object)X509ObjectIdentifiers.id_ad_caIssuers)) continue;
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence2.getObjectAt(1);
            DEROctetString dEROctetString = (DEROctetString)dERTaggedObject.getObject();
            InputStream inputStream = null;
            try {
                String string = new String(dEROctetString.getOctets());
                LOG.info((Object)("CA issuers URL: " + string));
                inputStream = new URL(string).openStream();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
                for (Certificate certificate : collection) {
                    hashSet.add((X509Certificate)certificate);
                }
                LOG.info((Object)("CA issuers URL: " + collection.size() + " certificate(s) downloaded"));
                IOUtils.closeQuietly((Closeable)inputStream);
            }
            catch (IOException iOException) {
                LOG.warn((Object)iOException.getMessage(), (Throwable)iOException);
            }
            catch (CertificateException certificateException) {
                LOG.warn((Object)certificateException.getMessage(), (Throwable)certificateException);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
        LOG.info((Object)("CA issuers: Downloaded " + hashSet.size() + " certificate(s) total"));
        return hashSet;
    }

    private static PKIXCertPathBuilderResult verifyCertificate(X509Certificate x509Certificate, Set<TrustAnchor> set, Set<X509Certificate> set2, Date date) throws GeneralSecurityException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setCertificate(x509Certificate);
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(set, (CertSelector)x509CertSelector);
        pKIXBuilderParameters.setRevocationEnabled(false);
        pKIXBuilderParameters.setPolicyQualifiersRejected(false);
        pKIXBuilderParameters.setDate(date);
        CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(set2));
        pKIXBuilderParameters.addCertStore(certStore);
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
    }

    private static String extractOCSPURL(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (byArray != null) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray);
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence2.getObjectAt(1);
                if (!aSN1ObjectIdentifier.equals((Object)X509ObjectIdentifiers.id_ad_ocsp) || dERTaggedObject.getTagNo() != 6) continue;
                DEROctetString dEROctetString = (DEROctetString)dERTaggedObject.getObject();
                String string = new String(dEROctetString.getOctets());
                LOG.info((Object)("OCSP URL: " + string));
                return string;
            }
        }
        return null;
    }

    private static void verifyOCSP(OcspHelper ocspHelper, Set<X509Certificate> set) throws RevokedCertificateException, IOException, OCSPException, CertificateVerificationException {
        Date date = Calendar.getInstance().getTime();
        OCSPResp oCSPResp = ocspHelper.getResponseOcsp();
        if (oCSPResp.getStatus() != 0) {
            throw new CertificateVerificationException("OCSP check not successful, status: " + oCSPResp.getStatus());
        }
        LOG.info((Object)"OCSP check successful");
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
        X509Certificate x509Certificate = ocspHelper.getOcspResponderCertificate();
        if (x509Certificate.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) != null) {
            LOG.info((Object)"Revocation check of OCSP responder certificate skipped (id-pkix-ocsp-nocheck is set)");
            return;
        }
        LOG.info((Object)"Check of OCSP responder certificate");
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>(set);
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        for (X509CertificateHolder x509CertificateHolder : basicOCSPResp.getCerts()) {
            try {
                X509Certificate x509Certificate2 = jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
                if (x509Certificate.equals(x509Certificate2)) continue;
                hashSet.add(x509Certificate2);
            }
            catch (CertificateException certificateException) {
                LOG.error((Object)certificateException, (Throwable)certificateException);
            }
        }
        CertificateVerifier.verifyCertificate(x509Certificate, hashSet, true, date);
        LOG.info((Object)"Check of OCSP responder certificate done");
    }
}

