/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.ValidationTimeStamp;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;

public class CreateSignedTimeStamp
implements SignatureInterface {
    private static final Log LOG = LogFactory.getLog(CreateSignedTimeStamp.class);
    private final String tsaUrl;

    public CreateSignedTimeStamp(String string) {
        this.tsaUrl = string;
    }

    public void signDetached(File file) throws IOException {
        this.signDetached(file, file);
    }

    public void signDetached(File file, File file2) throws IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PDDocument pDDocument = PDDocument.load((File)file);
        this.signDetached(pDDocument, fileOutputStream);
        pDDocument.close();
        fileOutputStream.close();
    }

    public void signDetached(PDDocument pDDocument, OutputStream outputStream) throws IOException {
        int n = SigUtils.getMDPPermission(pDDocument);
        if (n == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature pDSignature = new PDSignature();
        pDSignature.setType(COSName.DOC_TIME_STAMP);
        pDSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        pDSignature.setSubFilter(COSName.getPDFName((String)"ETSI.RFC3161"));
        pDDocument.addSignature(pDSignature, (SignatureInterface)this);
        pDDocument.saveIncremental(outputStream);
    }

    public byte[] sign(InputStream inputStream) throws IOException {
        try {
            ValidationTimeStamp validationTimeStamp = new ValidationTimeStamp(this.tsaUrl);
            return validationTimeStamp.getTimeStampToken(inputStream);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"Hashing-Algorithm not found for TimeStamping", (Throwable)noSuchAlgorithmException);
            return new byte[0];
        }
    }

    public static void main(String[] stringArray) throws IOException, GeneralSecurityException {
        if (stringArray.length != 3) {
            CreateSignedTimeStamp.usage();
            System.exit(1);
        }
        String string = null;
        if (stringArray[1].equals("-tsa")) {
            string = stringArray[2];
        } else {
            CreateSignedTimeStamp.usage();
            System.exit(1);
        }
        CreateSignedTimeStamp createSignedTimeStamp = new CreateSignedTimeStamp(string);
        File file = new File(stringArray[0]);
        String string2 = file.getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        File file2 = new File(file.getParent(), string3 + "_timestamped.pdf");
        createSignedTimeStamp.signDetached(file, file2);
    }

    private static void usage() {
        System.err.println("usage: java " + CreateSignedTimeStamp.class.getName() + " <pdf_to_sign>\nmandatory options:\n  -tsa <url>    sign timestamp using the given TSA server\n");
    }
}

