/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.apache.pdfbox.examples.signature.CreateSignatureBase;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;

public class CreateSignature
extends CreateSignatureBase {
    public CreateSignature(KeyStore keyStore, char[] cArray) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        super(keyStore, cArray);
    }

    public void signDetached(File file) throws IOException {
        this.signDetached(file, file, null);
    }

    public void signDetached(File file, File file2) throws IOException {
        this.signDetached(file, file2, null);
    }

    public void signDetached(File file, File file2, String string) throws IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        this.setTsaUrl(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PDDocument pDDocument = PDDocument.load((File)file);
        this.signDetached(pDDocument, fileOutputStream);
        pDDocument.close();
    }

    public void signDetached(PDDocument pDDocument, OutputStream outputStream) throws IOException {
        int n = SigUtils.getMDPPermission(pDDocument);
        if (n == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature pDSignature = new PDSignature();
        pDSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        pDSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        pDSignature.setName("Example User");
        pDSignature.setLocation("Los Angeles, CA");
        pDSignature.setReason("Testing");
        pDSignature.setSignDate(Calendar.getInstance());
        if (n == 0) {
            SigUtils.setMDPPermission(pDDocument, pDSignature, 2);
        }
        if (this.isExternalSigning()) {
            System.out.println("Sign externally...");
            pDDocument.addSignature(pDSignature);
            ExternalSigningSupport externalSigningSupport = pDDocument.saveIncrementalForExternalSigning(outputStream);
            byte[] byArray = this.sign(externalSigningSupport.getContent());
            externalSigningSupport.setSignature(byArray);
        } else {
            SignatureOptions signatureOptions = new SignatureOptions();
            signatureOptions.setPreferredSignatureSize(18944);
            pDDocument.addSignature(pDSignature, (SignatureInterface)this, signatureOptions);
            pDDocument.saveIncremental(outputStream);
        }
    }

    public static void main(String[] stringArray) throws IOException, GeneralSecurityException {
        if (stringArray.length < 3) {
            CreateSignature.usage();
            System.exit(1);
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-tsa")) {
                if (++i >= stringArray.length) {
                    CreateSignature.usage();
                    System.exit(1);
                }
                string = stringArray[i];
            }
            if (!stringArray[i].equals("-e")) continue;
            bl = true;
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] cArray = stringArray[1].toCharArray();
        keyStore.load(new FileInputStream(stringArray[0]), cArray);
        CreateSignature createSignature = new CreateSignature(keyStore, cArray);
        createSignature.setExternalSigning(bl);
        File file = new File(stringArray[2]);
        String string2 = file.getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        File file2 = new File(file.getParent(), string3 + "_signed.pdf");
        createSignature.signDetached(file, file2, string);
    }

    private static void usage() {
        System.err.println("usage: java " + CreateSignature.class.getName() + " <pkcs12_keystore> <password> <pdf_to_sign>\noptions:\n  -tsa <url>    sign timestamp using the given TSA server\n  -e            sign using external signature creation scenario");
    }
}

