/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui.tree;

import com.sittinglittleduck.DirBuster.Result;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsNode
extends DefaultMutableTreeNode {
    Result result;
    Vector<ResultsNode> children = new Vector(100, 10);
    String name;

    public ResultsNode(Result result) {
        this.result = result;
    }

    public ResultsNode(String name) {
        this.result = null;
        this.name = name;
    }

    public void addChild(ResultsNode object) {
        this.children.addElement(object);
    }

    public ResultsNode getChild(int index) {
        return this.children.elementAt(index);
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    public boolean isLeaf() {
        if (this.result == null) {
            return false;
        }
        return this.result.getType() != 0;
    }

    @Override
    public String toString() {
        if (this.result == null) {
            return this.name;
        }
        String string = null;
        try {
            string = this.covertData(new URL(this.result.getItemFound().toString()));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ResultsNode.class.getName()).log(Level.SEVERE, null, ex);
        }
        return string;
    }

    private String covertData(URL url) {
        String item = url.getPath();
        if (item.equals("/")) {
            return item;
        }
        if (item.endsWith("/")) {
            item = item.substring(0, item.length() - 1);
        }
        int location = item.lastIndexOf("/");
        item = item.substring(location + 1);
        return item;
    }

    public Vector<ResultsNode> getChildrenVector() {
        return this.children;
    }

    public void clearData() {
        this.children.removeAll(this.children);
        this.result = null;
        this.name = null;
    }

    public Result getResult() {
        return this.result;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public boolean isResultSet() {
        return this.result != null;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public ResultsNode findChildBasedOnString(String name) {
        for (int a = 0; a < this.children.size(); ++a) {
            if (!this.children.elementAt(a).toString().equals(name)) continue;
            return this.children.elementAt(a);
        }
        return null;
    }
}

