/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import java.io.InputStream;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.AbstractSCPClient;
import net.schmizz.sshj.xfer.scp.SCPEngine;
import net.schmizz.sshj.xfer.scp.ScpCommandLine;

public class SCPUploadClient
extends AbstractSCPClient {
    private LocalFileFilter uploadFilter;

    SCPUploadClient(SCPEngine engine) {
        super(engine);
    }

    SCPUploadClient(SCPEngine engine, int bandwidthLimit) {
        super(engine, bandwidthLimit);
    }

    public synchronized int copy(LocalSourceFile sourceFile, String remotePath) throws IOException {
        return this.copy(sourceFile, remotePath, ScpCommandLine.EscapeMode.SingleQuote);
    }

    public synchronized int copy(LocalSourceFile sourceFile, String remotePath, ScpCommandLine.EscapeMode escapeMode) throws IOException {
        return this.copy(sourceFile, remotePath, escapeMode, true);
    }

    public synchronized int copy(LocalSourceFile sourceFile, String remotePath, ScpCommandLine.EscapeMode escapeMode, boolean preserveTimes) throws IOException {
        ScpCommandLine commandLine = ScpCommandLine.with(ScpCommandLine.Arg.SINK).and(ScpCommandLine.Arg.RECURSIVE).and(ScpCommandLine.Arg.LIMIT, String.valueOf(this.bandwidthLimit), this.bandwidthLimit > 0);
        if (preserveTimes) {
            commandLine.and(ScpCommandLine.Arg.PRESERVE_TIMES, sourceFile.providesAtimeMtime());
        }
        return this.copy(sourceFile, remotePath, escapeMode, commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int copy(LocalSourceFile sourceFile, String remotePath, ScpCommandLine.EscapeMode escapeMode, ScpCommandLine commandLine) throws IOException {
        this.engine.cleanSlate();
        try {
            commandLine.withPath(remotePath, escapeMode);
            this.startCopy(sourceFile, commandLine);
        }
        finally {
            this.engine.exit();
        }
        return this.engine.getExitStatus();
    }

    public void setUploadFilter(LocalFileFilter uploadFilter) {
        this.uploadFilter = uploadFilter;
    }

    private void startCopy(LocalSourceFile sourceFile, ScpCommandLine commandLine) throws IOException {
        this.engine.execSCPWith(commandLine);
        this.engine.check("Start status OK");
        this.process(this.engine.getTransferListener(), sourceFile, commandLine.has(ScpCommandLine.Arg.PRESERVE_TIMES));
    }

    private void process(TransferListener listener, LocalSourceFile f, boolean preserveTimes) throws IOException {
        if (f.isDirectory()) {
            this.sendDirectory(listener.directory(f.getName()), f, preserveTimes);
        } else if (f.isFile()) {
            this.sendFile(listener.file(f.getName(), f.getLength()), f, preserveTimes);
        } else {
            throw new IOException(f + " is not a regular file or directory");
        }
    }

    private void sendDirectory(TransferListener listener, LocalSourceFile f, boolean preserveTimes) throws IOException {
        this.preserveTimeIfPossible(f);
        this.engine.sendMessage("D0" + this.getPermString(f) + " 0 " + f.getName());
        for (LocalSourceFile localSourceFile : f.getChildren(this.uploadFilter)) {
            this.process(listener, localSourceFile, preserveTimes);
        }
        this.engine.sendMessage("E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(StreamCopier.Listener listener, LocalSourceFile f, boolean preserveTimes) throws IOException {
        if (preserveTimes) {
            this.preserveTimeIfPossible(f);
        }
        InputStream src = f.getInputStream();
        try {
            this.engine.sendMessage("C0" + this.getPermString(f) + " " + f.getLength() + " " + f.getName());
            this.engine.transferToRemote(listener, src, f.getLength());
            this.engine.signal("Transfer done");
            this.engine.check("Remote agrees transfer done");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(src);
            throw throwable;
        }
        IOUtils.closeQuietly(src);
    }

    private void preserveTimeIfPossible(LocalSourceFile f) throws IOException {
        if (f.providesAtimeMtime()) {
            this.engine.sendMessage("T" + f.getLastModifiedTime() + " 0 " + f.getLastAccessTime() + " 0");
        }
    }

    private String getPermString(LocalSourceFile f) throws IOException {
        return Integer.toOctalString(f.getPermissions() & 0xFFF);
    }
}

