/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumMaterializedView;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumSchemaCache;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumWithClauseBuilder;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerExtensionBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class PostgreServerGreenplum
extends PostgreServerExtensionBase {
    public PostgreServerGreenplum(PostgreDataSource dataSource) {
        super(dataSource);
    }

    public String getServerTypeName() {
        return "Greenplum";
    }

    public boolean supportsFunctionDefRead() {
        return false;
    }

    public boolean supportsSessionActivity() {
        return true;
    }

    public PostgreTableBase createRelationOfClass(PostgreSchema schema, PostgreClass.RelKind kind, JDBCResultSet dbResult) {
        if (kind == PostgreClass.RelKind.r || kind == PostgreClass.RelKind.p) {
            if (this.isRelationExternal(dbResult)) {
                return new GreenplumExternalTable(schema, (ResultSet)dbResult);
            }
            return new GreenplumTable(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.m) {
            return new GreenplumMaterializedView(schema, (ResultSet)dbResult);
        }
        return super.createRelationOfClass(schema, kind, dbResult);
    }

    public PostgreTableBase createNewRelation(DBRProgressMonitor monitor, PostgreSchema schema, PostgreClass.RelKind kind, Object copyFrom) throws DBException {
        if (kind == PostgreClass.RelKind.r || kind == PostgreClass.RelKind.p) {
            return new GreenplumTable(schema);
        }
        if (kind == PostgreClass.RelKind.m) {
            return new GreenplumMaterializedView(schema);
        }
        return super.createNewRelation(monitor, schema, kind, copyFrom);
    }

    private boolean isRelationExternal(JDBCResultSet dbResult) {
        return JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_ext_table");
    }

    public PostgreDatabase.SchemaCache createSchemaCache(PostgreDatabase database) {
        return new GreenplumSchemaCache();
    }

    public void configureDialect(PostgreDialect dialect) {
        dialect.addExtraKeywords(new String[]{"DISTRIBUTED", "SEGMENT", "REJECT", "FORMAT", "MASTER", "WEB", "WRITABLE", "READABLE", "LOG", "ERRORS"});
    }

    public boolean supportsEntityMetadataInResults() {
        return true;
    }

    public boolean supportsExplainPlanXML() {
        return false;
    }

    public boolean supportsExplainPlanVerbose() {
        return false;
    }

    public String createWithClause(PostgreTableRegular table, PostgreTableBase tableBase) {
        return GreenplumWithClauseBuilder.generateWithClause((PostgreTable)table, tableBase);
    }

    public void createUsingClause(@NotNull PostgreTableRegular table, @NotNull StringBuilder ddl) {
        String accessMethod;
        if (table instanceof GreenplumTable && CommonUtils.isNotEmpty((String)(accessMethod = ((GreenplumTable)table).getAccessMethod()))) {
            ddl.append("\nUSING ").append(accessMethod);
        }
    }

    public String readTableDDL(DBRProgressMonitor monitor, PostgreTableBase table) throws DBException {
        if (table instanceof GreenplumExternalTable) {
            return ((GreenplumExternalTable)table).generateDDL(monitor);
        }
        return super.readTableDDL(monitor, table);
    }

    public boolean supportsHasOidsColumn() {
        return true;
    }

    public boolean supportsDatabaseSize() {
        return true;
    }

    public boolean supportsPartitions() {
        return true;
    }

    public boolean supportsAlterUserChangePassword() {
        return true;
    }

    public boolean supportsRoleReplication() {
        return this.dataSource.isServerVersionAtLeast(9, 1);
    }

    public boolean supportsRoleBypassRLS() {
        return false;
    }

    public boolean supportsCopyFromStdIn() {
        return true;
    }

    public boolean supportsExternalTypes() {
        return true;
    }

    public boolean supportsDistinctForStatementsWithAcl() {
        return false;
    }

    public boolean supportsEventTriggers() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }
}

