/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class DBSObjectFilter {
    private String name;
    private String description;
    private boolean enabled = true;
    private List<String> include;
    private List<String> exclude;
    private boolean caseSensitive;
    private transient List<Object> includePatterns = null;
    private transient List<Object> excludePatterns = null;

    public DBSObjectFilter() {
    }

    public DBSObjectFilter(@Nullable String includeString, @Nullable String excludeString) {
        if (includeString != null) {
            this.include = SQLUtils.splitFilter(includeString);
        }
        if (excludeString != null) {
            this.exclude = SQLUtils.splitFilter(excludeString);
        }
    }

    public DBSObjectFilter(DBSObjectFilter filter) {
        if (filter != null) {
            this.name = filter.name;
            this.description = filter.description;
            this.enabled = filter.enabled;
            this.include = filter.include == null ? null : new ArrayList<String>(filter.include);
            this.exclude = filter.exclude == null ? null : new ArrayList<String>(filter.exclude);
            this.caseSensitive = filter.caseSensitive;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void addInclude(String name) {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        this.include.add(name);
        this.includePatterns = null;
    }

    public void setInclude(List<String> include) {
        this.include = include;
        this.includePatterns = null;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public void addExclude(String name) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(name);
        this.excludePatterns = null;
    }

    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
        this.excludePatterns = null;
    }

    public boolean isNotApplicable() {
        return !this.enabled || this.isEmpty();
    }

    public boolean isEmpty() {
        return CommonUtils.isEmpty(this.include) && CommonUtils.isEmpty(this.exclude);
    }

    public boolean hasSingleMask() {
        return this.include != null && this.include.size() == 1 && CommonUtils.isEmpty(this.exclude);
    }

    @Nullable
    public String getSingleMask() {
        return !CommonUtils.isEmpty(this.include) ? this.include.get(0) : null;
    }

    public synchronized boolean matches(String name) {
        if (this.includePatterns == null && !CommonUtils.isEmpty(this.include)) {
            this.includePatterns = new ArrayList<Object>(this.include.size());
            for (String inc : this.include) {
                if (inc.isEmpty()) continue;
                this.includePatterns.add(DBSObjectFilter.makePattern(inc, this.isCaseSensitive()));
            }
        }
        if (this.includePatterns != null) {
            boolean matched = false;
            for (Object pattern : this.includePatterns) {
                if (!DBSObjectFilter.matchesPattern(pattern, name)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        if (this.excludePatterns == null && !CommonUtils.isEmpty(this.exclude)) {
            this.excludePatterns = new ArrayList<Object>(this.exclude.size());
            for (String exc : this.exclude) {
                if (exc.isEmpty()) continue;
                this.excludePatterns.add(DBSObjectFilter.makePattern(exc, this.isCaseSensitive()));
            }
        }
        if (this.excludePatterns != null) {
            for (Object pattern : this.excludePatterns) {
                if (!DBSObjectFilter.matchesPattern(pattern, name)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchesPattern(Object pattern, String name) {
        if (pattern instanceof Pattern) {
            return ((Pattern)pattern).matcher(name).matches();
        }
        return ((String)pattern).equalsIgnoreCase(name);
    }

    @NotNull
    private static Object makePattern(String str, boolean caseSensitive) {
        if (SQLUtils.isLikePattern(str)) {
            return caseSensitive ? Pattern.compile(SQLUtils.makeLikePattern(str), 8) : Pattern.compile(SQLUtils.makeLikePattern(str), 10);
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBSObjectFilter)) {
            return false;
        }
        DBSObjectFilter source = (DBSObjectFilter)obj;
        return CommonUtils.equalObjects((Object)this.name, (Object)source.name) && CommonUtils.equalObjects((Object)this.description, (Object)source.description) && this.enabled == source.enabled && CommonUtils.equalObjects(this.include, source.include) && CommonUtils.equalObjects(this.exclude, source.exclude);
    }

    public int hashCode() {
        return CommonUtils.hashCode((Object)this.name) + CommonUtils.hashCode((Object)this.description) + (this.enabled ? 1 : 0) + CommonUtils.hashCode(this.include) + CommonUtils.hashCode(this.exclude);
    }
}

