/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAdapter;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICustomActionsProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomFormEditor;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;

public class TabbedFolderPageForm
extends TabbedFolderPage
implements IRefreshablePart,
ICustomActionsProvider {
    private IWorkbenchPart part;
    private IDatabaseEditorInput input;
    private ObjectEditorPageControl ownerControl;
    private Font boldFont;
    private Composite propertiesGroup;
    private DBPPropertySource curPropertySource;
    private boolean activated;
    private Button saveButton;
    private Button scriptButton;
    private Button revertButton;
    private CustomFormEditor formEditor;

    TabbedFolderPageForm(IWorkbenchPart part, ObjectEditorPageControl ownerControl, IDatabaseEditorInput input) {
        this.part = part;
        this.ownerControl = ownerControl;
        this.input = input;
        this.formEditor = new CustomFormEditor(input.getDatabaseObject(), input.getCommandContext(), input.getPropertySource()){

            protected void openObjectLink(Object linkData) {
                if (linkData instanceof DBSObject) {
                    NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)linkData);
                }
            }
        };
    }

    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        this.propertiesGroup = new Composite(parent, 0);
        this.curPropertySource = this.input.getPropertySource();
        DBECommandContext commandContext = this.input.getCommandContext();
        if (commandContext != null) {
            commandContext.addCommandListener((DBECommandListener)new DBECommandAdapter(){

                public void onCommandChange(DBECommand<?> command) {
                    UIUtils.asyncExec(() -> {
                        TabbedFolderPageForm.this.updateEditButtonsState();
                        if (command instanceof DBECommandProperty) {
                            String propId = ((DBECommandProperty)command).getHandler().getId();
                            TabbedFolderPageForm.this.formEditor.updateOtherPropertyValues((Object)propId);
                        }
                    });
                }

                public void onSave() {
                    UIUtils.asyncExec(() -> TabbedFolderPageForm.this.updateEditButtonsState());
                }

                public void onReset() {
                    UIUtils.asyncExec(() -> {
                        TabbedFolderPageForm.this.refreshProperties();
                        TabbedFolderPageForm.this.updateEditButtonsState();
                    });
                }
            });
        }
        this.propertiesGroup.addDisposeListener(e -> this.dispose());
        this.refreshProperties();
    }

    private void updateEditButtonsState() {
        if (this.saveButton == null || this.saveButton.isDisposed()) {
            return;
        }
        DBECommandContext commandContext = this.input.getCommandContext();
        boolean isDirty = commandContext != null && commandContext.isDirty();
        this.saveButton.setEnabled(isDirty);
        this.revertButton.setEnabled(isDirty);
        this.scriptButton.setEnabled(isDirty);
    }

    public void setFocus() {
        this.propertiesGroup.setFocus();
    }

    public void dispose() {
        if (this.curPropertySource != null && this.curPropertySource.getEditableValue() instanceof DBSObject) {
            this.curPropertySource = null;
        }
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    private void refreshProperties() {
        boolean firstInit;
        if (this.curPropertySource == null) {
            return;
        }
        this.curPropertySource = this.input.getPropertySource();
        List allProps = this.formEditor.filterProperties(this.curPropertySource.getProperties());
        boolean bl = firstInit = !this.formEditor.hasEditors();
        if (firstInit) {
            ArrayList<Object> primaryProps = new ArrayList<Object>();
            ArrayList<DBPPropertyDescriptor> secondaryProps = new ArrayList<DBPPropertyDescriptor>();
            ArrayList<DBPPropertyDescriptor> specificProps = new ArrayList<DBPPropertyDescriptor>();
            if (this.formEditor.isEditableObject()) {
                for (DBPPropertyDescriptor prop : allProps) {
                    if (prop.getId().equals("name") || prop.getId().equals("description") || prop.isEditable(this.curPropertySource.getEditableValue())) {
                        primaryProps.add(prop);
                        continue;
                    }
                    if (prop instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)prop).isSpecific()) {
                        specificProps.add(prop);
                        continue;
                    }
                    secondaryProps.add(prop);
                }
                if (primaryProps.isEmpty()) {
                    primaryProps.addAll(secondaryProps);
                    secondaryProps.clear();
                }
            } else {
                primaryProps.addAll(allProps);
            }
            boolean hasEditButtons = false;
            boolean hasSecondaryProps = !secondaryProps.isEmpty();
            boolean hasSpecificProps = !specificProps.isEmpty();
            int colCount = 1;
            if (hasEditButtons) {
                ++colCount;
            }
            if (hasSecondaryProps) {
                ++colCount;
            }
            if (hasSpecificProps) {
                ++colCount;
            }
            GridLayout propsLayout = new GridLayout(colCount, true);
            this.propertiesGroup.setLayout((Layout)propsLayout);
            Composite parent = this.propertiesGroup;
            int editorWidth = parent.getSize().x;
            while (editorWidth == 0 && parent != null) {
                editorWidth = parent.getSize().x;
                parent = parent.getParent();
            }
            Composite primaryGroup = new Composite(this.propertiesGroup, 0);
            GridLayout primaryLayout = new GridLayout(2, false);
            primaryGroup.setLayout((Layout)primaryLayout);
            int minGroupWidth = UIUtils.getFontHeight((Control)this.propertiesGroup) * 30;
            int maxGroupWidth = (editorWidth -= 2 * primaryLayout.marginWidth + (colCount - 1) * primaryLayout.horizontalSpacing) * (100 / colCount) / 100;
            int buttonPanelWidth = editorWidth / 10;
            if (maxGroupWidth < minGroupWidth) {
                minGroupWidth = maxGroupWidth;
                buttonPanelWidth = 0;
            }
            GridData gd = new GridData(1808);
            gd.widthHint = maxGroupWidth;
            primaryGroup.setLayoutData((Object)gd);
            Composite secondaryGroup = null;
            if (hasSecondaryProps) {
                secondaryGroup = new Composite(this.propertiesGroup, 0);
                secondaryGroup.setLayout((Layout)new GridLayout(2, false));
                gd = new GridData(1808);
                gd.widthHint = maxGroupWidth;
                secondaryGroup.setLayoutData((Object)gd);
            }
            Composite specificGroup = null;
            if (hasSpecificProps) {
                specificGroup = new Composite(this.propertiesGroup, 0);
                specificGroup.setLayout((Layout)new GridLayout(2, false));
                gd = new GridData(1808);
                gd.widthHint = maxGroupWidth;
                specificGroup.setLayoutData((Object)gd);
            }
            if (hasEditButtons) {
                Composite composite = new Composite(this.propertiesGroup, 0);
                gd = new GridData(2);
                gd.widthHint = buttonPanelWidth;
                composite.setLayoutData((Object)gd);
                RowLayout rowLayout = new RowLayout(512);
                rowLayout.pack = true;
                rowLayout.fill = true;
                composite.setLayout((Layout)rowLayout);
                this.saveButton = UIUtils.createPushButton((Composite)composite, (String)"Save", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.SAVE), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ActionUtils.runCommand((String)"org.eclipse.ui.file.save", (IServiceLocator)TabbedFolderPageForm.this.part.getSite());
                    }
                });
                this.scriptButton = UIUtils.createPushButton((Composite)composite, (String)"View script", (Image)DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCRIPT), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TabbedFolderPageForm.this.showAlterScript();
                    }
                });
                this.revertButton = UIUtils.createPushButton((Composite)composite, (String)"Revert", (Image)DBeaverIcons.getImage((DBPImage)UIIcon.REVERT), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ActionUtils.runCommand((String)"org.eclipse.ui.file.revert", (IServiceLocator)TabbedFolderPageForm.this.part.getSite());
                    }
                });
                this.saveButton.setEnabled(false);
                this.scriptButton.setEnabled(false);
                this.revertButton.setEnabled(false);
            }
            if (editorWidth > 1000) {
                Composite composite = UIUtils.createPlaceholder((Composite)this.propertiesGroup, (int)1);
                composite.setLayoutData((Object)new GridData(768));
                ++propsLayout.numColumns;
            }
            for (DBPPropertyDescriptor dBPPropertyDescriptor : primaryProps) {
                this.formEditor.createPropertyEditor(primaryGroup, dBPPropertyDescriptor);
            }
            if (secondaryGroup != null) {
                for (DBPPropertyDescriptor dBPPropertyDescriptor : secondaryProps) {
                    this.formEditor.createPropertyEditor(secondaryGroup, dBPPropertyDescriptor);
                }
            }
            if (specificGroup != null) {
                for (DBPPropertyDescriptor dBPPropertyDescriptor : specificProps) {
                    this.formEditor.createPropertyEditor(specificGroup, dBPPropertyDescriptor);
                }
            }
        }
        UIUtils.installAndUpdateMainFont((Control)this.propertiesGroup);
        this.refreshPropertyValues(allProps, firstInit);
    }

    private void showAlterScript() {
        EntityEditor ownerEditor = this.getOwnerEditor();
        if (ownerEditor != null) {
            ownerEditor.showChanges(false);
        }
    }

    private EntityEditor getOwnerEditor() {
        MultiPageEditorPart mainEditor;
        IWorkbenchPartSite site = this.part.getSite();
        if (site instanceof MultiPageEditorSite && (mainEditor = ((MultiPageEditorSite)site).getMultiPageEditor()) instanceof EntityEditor) {
            return (EntityEditor)mainEditor;
        }
        return null;
    }

    private void refreshPropertyValues(final List<DBPPropertyDescriptor> allProps, boolean disableControls) {
        DBSObject databaseObject = this.input.getDatabaseObject();
        if (databaseObject == null) {
            return;
        }
        disableControls = false;
        ControlEnableState blockEnableState = disableControls ? ControlEnableState.disable((Control)this.propertiesGroup) : null;
        this.ownerControl.runService(LoadingJob.createService((ILoadService)new DatabaseLoadService<Map<DBPPropertyDescriptor, Object>>("Load main properties", databaseObject.getDataSource()){

            public Map<DBPPropertyDescriptor, Object> evaluate(DBRProgressMonitor monitor) {
                DBPPropertySource propertySource = TabbedFolderPageForm.this.curPropertySource;
                monitor.beginTask("Load '" + DBValueFormatting.getDefaultValueDisplayString((Object)propertySource.getEditableValue(), (DBDDisplayFormat)DBDDisplayFormat.UI) + "' properties", allProps.size());
                HashMap<DBPPropertyDescriptor, Object> propValues = new HashMap<DBPPropertyDescriptor, Object>();
                for (DBPPropertyDescriptor prop : allProps) {
                    if (monitor.isCanceled()) break;
                    Object value = propertySource.getPropertyValue(monitor, prop.getId());
                    propValues.put(prop, value);
                    monitor.worked(1);
                }
                monitor.done();
                return propValues;
            }
        }, (ILoadVisualizer)this.ownerControl.createDefaultLoadVisualizer(editorValues -> {
            if (this.ownerControl.isDisposed()) {
                return;
            }
            this.formEditor.loadEditorValues(editorValues);
            if (blockEnableState != null) {
                blockEnableState.restore();
            }
        })));
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (force) {
            this.refreshProperties();
            this.updateEditButtonsState();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    public void aboutToBeShown() {
        if (!this.activated) {
            this.activated = true;
        }
    }

    public void fillCustomActions(IContributionManager contributionManager) {
    }
}

