/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping;

import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class ModelErrorsCollection {
    private final List<ErrorInfo> errors = new LinkedList<ErrorInfo>();

    public void add(@NotNull String message) {
        this.errors.add(new ErrorInfo(null, message));
    }

    public void add(@Nullable Throwable ex, @NotNull String message) {
        this.errors.add(new ErrorInfo(ex, message));
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public void printToStderr() {
        for (ErrorInfo error : this.errors) {
            System.err.println(error.message);
            if (error.exception == null) continue;
            System.err.println("\t" + error.exception.toString().replace("\n", "\n\t"));
        }
    }

    public static class ErrorInfo {
        public final Throwable exception;
        public final String message;

        public ErrorInfo(@Nullable Throwable exception, @NotNull String message) {
            this.exception = exception;
            this.message = message;
        }
    }
}

