/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.tipoftheday;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.dbeaver.ext.ui.tipoftheday.ShowTipOfTheDayHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.utils.CommonUtils;

public class TipOfTheDayInitializer
implements IWorkbenchWindowInitializer {
    private static final String PROP_NOT_FIRST_RUN = "tipOfTheDayInitializer.notFirstRun";

    public void initializeWorkbenchWindow(final IWorkbenchWindow window) {
        if (!TipOfTheDayInitializer.isTipsEnabled() || window.getWorkbench().getWorkbenchWindowCount() > 1) {
            return;
        }
        new UIJob(window.getShell().getDisplay(), "Show tip of the day"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ShowTipOfTheDayHandler.showTipOfTheDay(window);
                return Status.OK_STATUS;
            }
        }.schedule(3000L);
    }

    private static boolean isTipsEnabled() {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean(PROP_NOT_FIRST_RUN)) {
            DBWorkbench.getPlatform().getPreferenceStore().setValue(PROP_NOT_FIRST_RUN, true);
            return false;
        }
        String tipsEnabledStr = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.show.tip.of.the.day.on.startup");
        if (CommonUtils.isEmpty((String)tipsEnabledStr)) {
            return true;
        }
        return CommonUtils.toBoolean((Object)tipsEnabledStr);
    }
}

