/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.router.OrthogonalPath;
import org.jkiss.utils.Pair;

public class MikamiTabuchiRouter {
    private static final Log log = Log.getLog(MikamiTabuchiRouter.class);
    private static final int SOURCE_VERTICAL_LINES = 0;
    private static final int SOURCE_HORIZONTAL_LINES = 1;
    private static final int TARGET_VERTICAL_LINES = 2;
    private static final int TARGET_HORIZONTAL_LINES = 3;
    private int spacing = 15;
    private final Set<Rectangle> obstacles = new HashSet<Rectangle>();
    private PrecisionPoint start;
    private PrecisionPoint finish;
    private OrthogonalPath activePath;
    private final List<OrthogonalPath> userPaths = new ArrayList<OrthogonalPath>();
    private final Map<OrthogonalPath, List<OrthogonalPath>> pathsToChildPaths = new HashMap<OrthogonalPath, List<OrthogonalPath>>();
    private final Map<OrthogonalPath, Map<Boolean, List<Pair<Point, Point>>>> resultMap = new HashMap<OrthogonalPath, Map<Boolean, List<Pair<Point, Point>>>>();
    private final Map<Integer, Map<Integer, List<TrialLine>>> linesMap = new ConcurrentHashMap<Integer, Map<Integer, List<TrialLine>>>();
    private ResultPairWithFine result;
    private static final int MAX_LINE_COUNT = 100000;
    private final AtomicInteger currentLineCount = new AtomicInteger();
    IFigure clientArea;

    public void setClientArea(IFigure clientArea) {
        this.clientArea = clientArea;
    }

    private void createLinesFromTrial(TrialLine pos, int iteration) {
        double from = pos.vertical ? pos.from.y : pos.from.x;
        double start = pos.start;
        double end = pos.finish;
        double startPosition = pos.hasForbiddenStart() ? pos.creationForbiddenStart : from;
        double i = startPosition - (startPosition - start) / 20.0;
        while (i > start) {
            this.createTrial(pos, iteration, i);
            if (this.currentLineCount.incrementAndGet() > 100000) {
                return;
            }
            i -= (startPosition - start) / 20.0;
        }
        double finishPosition = pos.hasForbiddenFinish() ? pos.creationForbiddenFinish : from;
        double i2 = finishPosition + (end - finishPosition) / 20.0;
        while (i2 < end) {
            this.createTrial(pos, iteration, i2);
            if (this.currentLineCount.incrementAndGet() > 100000) {
                return;
            }
            i2 += (end - finishPosition) / 20.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTrial(TrialLine pos, int iteration, double i) {
        TrialLine trialLine = this.createTrialLine(i, !pos.vertical, pos);
        this.getLinesMap(trialLine, iteration).add(trialLine);
        TrialLine interception = trialLine.findIntersection();
        if (interception != null) {
            boolean isFined;
            boolean bl = isFined = trialLine.requiresStep || interception.requiresStep;
            if (!this.activePath.isSourceIsChild() && !this.activePath.isTargetIsChild() && (this.lineLiesOnPreviouslyCreatedLine((Point)trialLine.from, (Point)this.getInterceptionPoint(trialLine, interception), trialLine.vertical) || this.lineLiesOnPreviouslyCreatedLine((Point)interception.from, (Point)this.getInterceptionPoint(trialLine, interception), interception.vertical))) {
                isFined = true;
            }
            MikamiTabuchiRouter mikamiTabuchiRouter = this;
            synchronized (mikamiTabuchiRouter) {
                block10: {
                    int interceptionMultiplier;
                    int resultMultiplier;
                    Pair trialLinePair;
                    block9: {
                        block8: {
                            if (this.result != null) break block8;
                            this.result = new ResultPairWithFine(isFined, (Pair<TrialLine, TrialLine>)new Pair((Object)trialLine, (Object)interception));
                            return true;
                        }
                        trialLinePair = new Pair((Object)trialLine, (Object)interception);
                        resultMultiplier = this.result.fined ? 2 : 1;
                        int n = interceptionMultiplier = isFined ? 2 : 1;
                        if (!(this.calculateDistance(this.result.pair) * (double)resultMultiplier > this.calculateDistance((Pair<TrialLine, TrialLine>)trialLinePair) * (double)interceptionMultiplier)) break block9;
                        this.result = new ResultPairWithFine(isFined, (Pair<TrialLine, TrialLine>)trialLinePair);
                        return true;
                    }
                    if (this.calculateDistance(this.result.pair) * (double)resultMultiplier != this.calculateDistance((Pair<TrialLine, TrialLine>)trialLinePair) * (double)interceptionMultiplier || !(this.getInterceptionPoint((TrialLine)this.result.pair.getFirst(), (TrialLine)this.result.pair.getSecond()).getDistance((Point)this.start) > this.getInterceptionPoint(interception, trialLine).getDistance((Point)this.start))) break block10;
                    this.result = new ResultPairWithFine(isFined, (Pair<TrialLine, TrialLine>)trialLinePair);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    boolean lineLiesOnPreviouslyCreatedLine(Point point, Point secondPoint, boolean vertical) {
        ArrayList<Pair<Point, Point>> collect = new ArrayList<Pair<Point, Point>>();
        for (Map<Boolean, List<Pair<Point, Point>>> map : this.resultMap.values()) {
            List<Pair<Point, Point>> pairs = map.get(vertical);
            collect.addAll(pairs);
        }
        for (Pair pair : collect) {
            if (!(vertical ? point.x - 5 <= ((Point)pair.getFirst()).x && point.x + this.spacing / 5 >= ((Point)pair.getFirst()).x && (this.isInsideLine(point.y, ((Point)pair.getFirst()).y, ((Point)pair.getSecond()).y) || this.isInsideLine(secondPoint.y, ((Point)pair.getFirst()).y, ((Point)pair.getSecond()).y) || this.isInsideLine(((Point)pair.getFirst()).y, point.y, secondPoint.y) || this.isInsideLine(((Point)pair.getSecond()).y, point.y, secondPoint.y)) : point.y - this.spacing / 5 <= ((Point)pair.getFirst()).y && point.y + this.spacing / 5 >= ((Point)pair.getFirst()).y && (this.isInsideLine(point.x, ((Point)pair.getFirst()).x, ((Point)pair.getSecond()).x) || this.isInsideLine(secondPoint.x, ((Point)pair.getFirst()).x, ((Point)pair.getSecond()).x) || this.isInsideLine(((Point)pair.getFirst()).x, point.x, secondPoint.x) || this.isInsideLine(((Point)pair.getSecond()).x, point.x, secondPoint.x)))) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideLine(int pointCoordinate, int lineCoordinateFirstPoint, int lineCoordinateSecondPoint) {
        return Math.min(lineCoordinateFirstPoint, lineCoordinateSecondPoint) <= pointCoordinate && Math.max(lineCoordinateFirstPoint, lineCoordinateSecondPoint) >= pointCoordinate;
    }

    @NotNull
    private List<TrialLine> getLinesMap(TrialLine line, int iteration) {
        if (line.vertical) {
            return line.fromSource ? this.linesMap.get(iteration).get(0) : this.linesMap.get(iteration).get(2);
        }
        return line.fromSource ? this.linesMap.get(iteration).get(1) : this.linesMap.get(iteration).get(3);
    }

    @NotNull
    private List<TrialLine> getOpposingLinesMap(TrialLine line, int iteration) {
        if (line.vertical) {
            return line.fromSource ? this.linesMap.get(iteration).get(3) : this.linesMap.get(iteration).get(1);
        }
        return line.fromSource ? this.linesMap.get(iteration).get(2) : this.linesMap.get(iteration).get(0);
    }

    private PrecisionPoint getInterceptionPoint(TrialLine source, TrialLine target) {
        if (source.vertical) {
            return new PrecisionPoint(source.from.x, target.from.y);
        }
        return new PrecisionPoint(target.from.x, source.from.y);
    }

    @NotNull
    private TrialLine createTrialLine(double pos, boolean vertical, @NotNull TrialLine parentLine) {
        PrecisionPoint point = vertical ? new PrecisionPoint(pos, (double)parentLine.from.y) : new PrecisionPoint((double)parentLine.from.x, pos);
        TrialLine trialLine = new TrialLine(point, parentLine);
        if (trialLine.parent != null && trialLine.parent.requiresStep || this.lineLiesOnPreviouslyCreatedLine((Point)point, (Point)parentLine.from, !vertical)) {
            trialLine.requiresStep = true;
        }
        return trialLine;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public boolean updateObstacle(Rectangle rectangle, Rectangle newBounds) {
        this.obstacles.remove(rectangle);
        this.obstacles.add(newBounds);
        return true;
    }

    public void addObstacle(Rectangle bounds) {
        this.obstacles.add(bounds);
    }

    public boolean removeObstacle(Rectangle bounds) {
        return this.obstacles.remove(bounds);
    }

    private PointList traceback(Pair<TrialLine, TrialLine> res) {
        PointList points = new PointList();
        TrialLine line = ((TrialLine)res.getFirst()).fromSource ? (TrialLine)res.getFirst() : (TrialLine)res.getSecond();
        TrialLine previousLine = (TrialLine)res.getFirst();
        PrecisionPoint point = null;
        while (line != null) {
            if (point == null || !point.equals((Object)line.from)) {
                points.addPoint((Point)line.from);
            }
            previousLine = line;
            point = line.from;
            line = line.getParent();
        }
        points.reverse();
        point = this.getInterceptionPoint((TrialLine)res.getFirst(), (TrialLine)res.getSecond());
        points.addPoint((Point)point);
        line = ((TrialLine)res.getFirst()).fromSource ? (TrialLine)res.getSecond() : (TrialLine)res.getFirst();
        while (line != null) {
            if (!line.from.equals((Object)point)) {
                points.addPoint((Point)line.from);
            }
            point = line.from;
            line = line.getParent();
        }
        boolean vertical = !previousLine.vertical;
        int i = 1;
        while (i < points.size() - 2) {
            this.resultMap.get(this.activePath).get(vertical).add((Pair<Point, Point>)new Pair((Object)points.getPoint(i), (Object)points.getPoint(i + 1)));
            vertical = !vertical;
            ++i;
        }
        return points;
    }

    public void sortWorkingPaths() {
        this.userPaths.sort(Comparator.comparingInt(o -> o.start.x + o.start.y + o.end.x + o.end.y));
    }

    public List<OrthogonalPath> solve() {
        this.sortWorkingPaths();
        this.updateChildPaths();
        List<OrthogonalPath> dirtyPaths = this.userPaths.stream().filter(OrthogonalPath::isDirty).collect(Collectors.toList());
        this.refreshResultMap(dirtyPaths);
        for (OrthogonalPath orthogonalPath : dirtyPaths) {
            List<OrthogonalPath> childPaths = this.pathsToChildPaths.get(orthogonalPath);
            if (childPaths == null) {
                this.updatePath(orthogonalPath, null);
                continue;
            }
            Point point = null;
            for (OrthogonalPath childPath : childPaths) {
                point = this.updatePath(childPath, point);
            }
        }
        this.linesMap.clear();
        this.recombineChildrenPaths();
        this.userPaths.stream().filter(Objects::nonNull).filter(path -> path.getPoints().size() != 2).forEach(path -> path.setDirty(false));
        for (List list : this.pathsToChildPaths.values()) {
            list.stream().filter(path -> path.getPoints().size() != 2).forEach(path -> path.setDirty(false));
        }
        return Collections.unmodifiableList(this.userPaths);
    }

    private void refreshResultMap(List<OrthogonalPath> dirtyPaths) {
        for (OrthogonalPath dirtyPath : dirtyPaths) {
            List<OrthogonalPath> childPaths = this.pathsToChildPaths.get(dirtyPath);
            if (childPaths == null) {
                this.init(dirtyPath);
                continue;
            }
            for (OrthogonalPath childPath : childPaths) {
                this.init(childPath);
            }
        }
    }

    @Nullable
    private Point updatePath(OrthogonalPath userPath, @Nullable Point point) {
        PointList pointList;
        this.activePath = userPath;
        if (userPath.isSourceIsChild() && point != null) {
            userPath.updateForbiddenDirection(point);
        }
        if ((pointList = this.solvePath(userPath)).size() >= 2) {
            point = pointList.getPoint(pointList.size() - 2);
        }
        userPath.setPoints(pointList);
        return point;
    }

    private void init(OrthogonalPath path) {
        if (path.isDirty() || this.resultMap.get(path) == null) {
            this.resultMap.put(path, new HashMap());
            this.resultMap.get(path).put(false, new ArrayList());
            this.resultMap.get(path).put(true, new ArrayList());
        }
    }

    private void resetUserPaths() {
        for (OrthogonalPath path : this.userPaths) {
            path.reset();
        }
    }

    private void updateChildPaths() {
        for (OrthogonalPath path : this.userPaths) {
            if (!path.isDirty()) continue;
            List<OrthogonalPath> children = this.pathsToChildPaths.get(path);
            int previousCount = 1;
            int newCount = 1;
            if (children == null) {
                children = new ArrayList<OrthogonalPath>();
            } else {
                previousCount = children.size();
            }
            if (path.getBendpoints() != null) {
                newCount = path.getBendpoints().size() + 1;
            }
            if (previousCount != newCount) {
                children = this.regenerateChildPaths(path, children, previousCount, newCount, path.getConnection());
            }
            this.refreshChildrenEndpoints(path, children);
        }
    }

    private void refreshChildrenEndpoints(OrthogonalPath path, List<OrthogonalPath> children) {
        Point previous = path.getStart();
        PointList bendPoints = path.getBendpoints();
        int i = 0;
        while (i < children.size()) {
            Point next = i < bendPoints.size() ? bendPoints.getPoint(i) : path.getEnd();
            OrthogonalPath child = children.get(i);
            child.setStartPoint(previous);
            child.setEndPoint(next);
            previous = next;
            ++i;
        }
        if (children.size() > 1) {
            children.get(0).setTargetIsChild(true);
            children.get(0).setSourceIsChild(false);
            children.get(children.size() - 1).setSourceIsChild(true);
            children.get(children.size() - 1).setTargetIsChild(false);
        }
        i = 1;
        while (i < children.size() - 1) {
            children.get(i).setSourceIsChild(true);
            children.get(i).setTargetIsChild(true);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<OrthogonalPath> regenerateChildPaths(OrthogonalPath path, List<OrthogonalPath> orthogonalPaths, int currentCount, int newCount, Connection connection) {
        block2: {
            if (currentCount != 1) break block2;
            currentCount = 0;
            orthogonalPaths = new ArrayList<OrthogonalPath>();
            this.pathsToChildPaths.put(path, orthogonalPaths);
            ** GOTO lbl16
        }
        if (newCount != 1) ** GOTO lbl16
        this.pathsToChildPaths.remove(path);
        return Collections.emptyList();
lbl-1000:
        // 1 sources

        {
            child = new OrthogonalPath(connection);
            orthogonalPaths.add(child);
            ++currentCount;
lbl16:
            // 3 sources

            ** while (currentCount < newCount)
        }
lbl17:
        // 2 sources

        while (currentCount > newCount) {
            orthogonalPaths.remove(orthogonalPaths.size() - 1);
            --currentCount;
        }
        return orthogonalPaths;
    }

    private double calculateDistance(Pair<TrialLine, TrialLine> res) {
        PrecisionPoint interceptionPoint = this.getInterceptionPoint((TrialLine)res.getFirst(), (TrialLine)res.getSecond());
        return ((TrialLine)res.getFirst()).distance + interceptionPoint.getDistance((Point)((TrialLine)res.getFirst()).from) + interceptionPoint.getDistance((Point)((TrialLine)res.getSecond()).from) + ((TrialLine)res.getSecond()).distance;
    }

    @NotNull
    private PointList solvePath(OrthogonalPath path) {
        if (path.getStart().equals((Object)path.getEnd())) {
            log.debug((Object)"Origin point is the same as Destination point");
            PointList pointList = new PointList();
            pointList.addPoint(path.getStart());
            pointList.addPoint(path.getEnd());
            return pointList;
        }
        if (!this.clientArea.getClientArea().contains(path.start) || !this.clientArea.getClientArea().contains(path.end)) {
            this.clientArea.getUpdateManager().performUpdate();
        }
        this.linesMap.clear();
        this.start = new PrecisionPoint(path.start);
        this.result = null;
        this.finish = new PrecisionPoint(path.end);
        int iteration = 0;
        this.currentLineCount.lazySet(0);
        this.initStartingTrialLines(path, path.getForbiddenDirection());
        while (true) {
            this.linesMap.put(iteration + 1, new ConcurrentHashMap());
            this.initNewLayer(iteration + 1);
            boolean hasValues = false;
            int i = 0;
            while (i < 4) {
                int finalIteration = iteration;
                this.linesMap.get(iteration).get(i).parallelStream().forEach(it -> this.createLinesFromTrial((TrialLine)it, finalIteration + 1));
                ++i;
            }
            if (this.currentLineCount.get() > 100000) {
                if (this.result != null) {
                    return this.traceback(this.result.pair);
                }
                log.debug((Object)"[Routing] Max amount of tries exceeded, path can't be found");
                PointList pointList = new PointList();
                pointList.addPoint((Point)this.start);
                pointList.addPoint((Point)this.finish);
                return pointList;
            }
            if (this.result != null && !this.result.fined) {
                return this.traceback(this.result.pair);
            }
            i = 0;
            while (i < 4) {
                if (this.linesMap.get(iteration + 1).get(i).size() != 0) {
                    hasValues = true;
                }
                ++i;
            }
            if (!hasValues) {
                PointList pointList = new PointList();
                pointList.addPoint((Point)this.start);
                pointList.addPoint((Point)this.finish);
                return pointList;
            }
            ++iteration;
        }
    }

    private void recombineChildrenPaths() {
        for (OrthogonalPath path : this.pathsToChildPaths.keySet()) {
            if (path.getPoints() != null) {
                path.getPoints().removeAllPoints();
            } else {
                path.setPoints(new PointList());
            }
            List<OrthogonalPath> childPaths = this.pathsToChildPaths.get(path);
            OrthogonalPath childPath = null;
            for (OrthogonalPath orthogonalPath : childPaths) {
                childPath = orthogonalPath;
                if (!childPath.getStart().equals((Object)childPath.getPoints().getPoint(0))) {
                    childPath.getPoints().reverse();
                }
                path.getPoints().addAll(childPath.getPoints());
                path.getPoints().removePoint(path.getPoints().size() - 1);
            }
            path.getPoints().addPoint(childPath.getPoints().getLastPoint());
        }
    }

    private void initStartingTrialLines(OrthogonalPath path, OrthogonalPath.Direction forbiddenDirection) {
        this.linesMap.put(0, new HashMap());
        this.initNewLayer(0);
        TrialLine horizontalStartTrial = new TrialLine(this.start, true, false, forbiddenDirection);
        TrialLine horizontalFinishTrial = new TrialLine(this.finish, false, false, forbiddenDirection);
        if (path.isSourceIsChild()) {
            TrialLine verticalStartTrial = new TrialLine(this.start, true, true, forbiddenDirection);
            this.linesMap.get(0).get(0).add(verticalStartTrial);
        }
        if (path.isTargetIsChild()) {
            TrialLine verticalFinishTrial = new TrialLine(this.finish, false, true, forbiddenDirection);
            this.linesMap.get(0).get(2).add(verticalFinishTrial);
        }
        this.linesMap.get(0).get(1).add(horizontalStartTrial);
        this.linesMap.get(0).get(3).add(horizontalFinishTrial);
    }

    private void initNewLayer(int iteration) {
        int i = 0;
        while (i < 4) {
            this.linesMap.get(iteration).put(i, Collections.synchronizedList(new ArrayList()));
            ++i;
        }
    }

    public void removePath(OrthogonalPath path) {
        this.userPaths.remove(path);
        List<OrthogonalPath> orthogonalPaths = this.pathsToChildPaths.get(path);
        this.resultMap.remove(path);
        if (orthogonalPaths != null) {
            for (OrthogonalPath orthogonalPath : orthogonalPaths) {
                this.resultMap.remove(orthogonalPath);
            }
            this.userPaths.remove(path);
        }
    }

    public void addPath(OrthogonalPath path) {
        path.setDirty(true);
        this.userPaths.add(path);
    }

    private class ResultPairWithFine {
        boolean fined;
        private final Pair<TrialLine, TrialLine> pair;

        public ResultPairWithFine(boolean fined, Pair<TrialLine, TrialLine> pair) {
            this.fined = fined;
            this.pair = pair;
        }
    }

    private class TrialLine {
        @Nullable
        private TrialLine parent;
        @NotNull
        private final PrecisionPoint from;
        private final boolean fromSource;
        private final boolean vertical;
        double distance = 0.0;
        private boolean requiresStep = false;
        private double start = Double.MIN_VALUE;
        private double finish = Double.MIN_VALUE;
        private double creationForbiddenStart = Double.MIN_VALUE;
        private double creationForbiddenFinish = Double.MIN_VALUE;

        private void calculateForbiddenRange() {
            for (Rectangle it : MikamiTabuchiRouter.this.obstacles) {
                if (!this.isInsideFigure(it)) continue;
                if (this.vertical) {
                    this.creationForbiddenStart = it.getTop().y - MikamiTabuchiRouter.this.spacing;
                    this.creationForbiddenFinish = it.getBottom().y + MikamiTabuchiRouter.this.spacing;
                    continue;
                }
                this.creationForbiddenStart = it.getLeft().x - MikamiTabuchiRouter.this.spacing;
                this.creationForbiddenFinish = it.getRight().x + MikamiTabuchiRouter.this.spacing;
            }
        }

        private void restrictByDirection(OrthogonalPath.Direction forbiddenDirection) {
            if (forbiddenDirection != null) {
                switch (forbiddenDirection) {
                    case UP: {
                        if (!this.vertical) break;
                        this.start = this.from.y + MikamiTabuchiRouter.this.spacing;
                        break;
                    }
                    case DOWN: {
                        if (!this.vertical) break;
                        this.finish = this.from.y - MikamiTabuchiRouter.this.spacing;
                        break;
                    }
                    case LEFT: {
                        if (this.vertical) break;
                        this.start = this.from.x - MikamiTabuchiRouter.this.spacing;
                        break;
                    }
                    case RIGHT: {
                        if (this.vertical) break;
                        this.finish = this.from.x + MikamiTabuchiRouter.this.spacing;
                    }
                }
            }
        }

        public boolean hasForbiddenStart() {
            return this.creationForbiddenStart != Double.MIN_VALUE;
        }

        public boolean hasForbiddenFinish() {
            return this.creationForbiddenFinish != Double.MIN_VALUE;
        }

        TrialLine(@NotNull PrecisionPoint start, TrialLine parent) {
            this.from = start;
            this.parent = parent;
            this.distance += start.getDistance((Point)parent.from);
            this.fromSource = parent.fromSource;
            this.vertical = !parent.vertical;
            this.cutByObstacles(false);
        }

        TrialLine(PrecisionPoint start, boolean fromSource, boolean vertical, OrthogonalPath.Direction forbiddenDirection) {
            this.from = start;
            this.vertical = vertical;
            this.fromSource = fromSource;
            this.calculateForbiddenRange();
            if (fromSource) {
                this.restrictByDirection(forbiddenDirection);
            }
            this.cutByObstacles(true);
        }

        private boolean isInsideFigure(Rectangle it) {
            return it.getLeft().x <= this.from.x && it.getRight().x > this.from.x && it.getTop().y <= this.from.y && it.getBottom().y > this.from.y;
        }

        private void cutByObstacles(boolean startingLine) {
            for (Rectangle it : MikamiTabuchiRouter.this.obstacles) {
                if (this.isInsideFigure(it)) {
                    if (startingLine) continue;
                    this.cut(it);
                }
                if ((!this.vertical || it.getLeft().x - MikamiTabuchiRouter.this.spacing > this.from.x || it.getRight().x + MikamiTabuchiRouter.this.spacing <= this.from.x) && (this.vertical || it.getTop().y - MikamiTabuchiRouter.this.spacing > this.from.y || it.getBottom().y + MikamiTabuchiRouter.this.spacing <= this.from.y)) continue;
                this.cut(it);
            }
            if (this.finish == Double.MIN_VALUE) {
                this.finish = this.vertical ? (double)(MikamiTabuchiRouter.this.clientArea.getClientArea().getBottom().y - 1) : (double)(MikamiTabuchiRouter.this.clientArea.getClientArea().getRight().x - 1);
            }
            if (this.start == Double.MIN_VALUE) {
                this.start = this.vertical ? MikamiTabuchiRouter.this.clientArea.getClientArea().getTop().y + 1 : MikamiTabuchiRouter.this.clientArea.getClientArea().getLeft().x + 1;
            }
        }

        private void cut(Rectangle bound) {
            double fromPosition = this.vertical ? this.from.y : this.from.x;
            double startPoint = this.vertical ? bound.getTop().y : bound.getLeft().x;
            double endPoint = this.vertical ? bound.getBottom().y : bound.getRight().x;
            if (fromPosition > endPoint && (this.start == Double.MIN_VALUE || this.start < endPoint + (double)MikamiTabuchiRouter.this.spacing)) {
                this.start = endPoint + (double)MikamiTabuchiRouter.this.spacing;
            }
            if (fromPosition <= startPoint && (this.finish == Double.MIN_VALUE || this.finish > startPoint - (double)MikamiTabuchiRouter.this.spacing)) {
                this.finish = startPoint - (double)MikamiTabuchiRouter.this.spacing;
            }
        }

        @Nullable
        public TrialLine findIntersection() {
            int i = MikamiTabuchiRouter.this.linesMap.values().size() - 1;
            while (i >= 0) {
                for (TrialLine trialLine : MikamiTabuchiRouter.this.getOpposingLinesMap(this, i)) {
                    if (!this.intersect(trialLine)) continue;
                    return trialLine;
                }
                --i;
            }
            return null;
        }

        private boolean intersect(TrialLine line) {
            double firstLinePos = this.vertical ? this.from.x : this.from.y;
            double secondLinePos = this.vertical ? line.from.y : line.from.x;
            return firstLinePos >= line.start && firstLinePos < line.finish && secondLinePos >= this.start && secondLinePos < this.finish;
        }

        @Nullable
        public TrialLine getParent() {
            return this.parent;
        }
    }
}

