/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.utils.CommonUtils;

public class TaskPropertyTester
extends PropertyTester {
    private static final Log log = Log.getLog(TaskPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.task";
    public static final String PROP_SCHEDULED = "scheduled";
    public static final String TASK_EDITABLE = "editable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof DBTTaskFolder && TASK_EDITABLE.equals(property)) {
            return ((DBTTaskFolder)receiver).getProject().hasRealmPermission("project-datasource-edit");
        }
        if (!(receiver instanceof DBTTask)) {
            return false;
        }
        DBTTask task = (DBTTask)receiver;
        switch (property) {
            case "scheduled": {
                DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
                return (scheduler != null && scheduler.getScheduledTaskInfo(task) != null) == CommonUtils.getBoolean((Object)expectedValue, (boolean)true);
            }
            case "editable": {
                return task.getProject().hasRealmPermission("project-datasource-edit") && task.getProject().hasRealmPermission("database-developer");
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.task." + propName));
    }
}

