/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLToolTableTruncateSettings;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;

public class MySQLToolTableTruncate
extends MySQLToolWithStatus<MySQLTableBase, MySQLToolTableTruncateSettings> {
    @NotNull
    public MySQLToolTableTruncateSettings createToolSettings() {
        return new MySQLToolTableTruncateSettings();
    }

    public void generateObjectQueries(DBCSession session, MySQLToolTableTruncateSettings settings, List<DBEPersistAction> queries, MySQLTableBase object) throws DBCException {
        String sql = "";
        boolean force = settings.isForce();
        if (force) {
            queries.add((DBEPersistAction)new SQLDatabasePersistAction("Disable foreign key checks", "SET FOREIGN_KEY_CHECKS = 0", DBEPersistAction.ActionType.INITIALIZER));
        }
        sql = String.valueOf(sql) + "TRUNCATE TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
        if (force) {
            queries.add((DBEPersistAction)new SQLDatabasePersistAction("Enable foreign key checks", "SET FOREIGN_KEY_CHECKS = 1", DBEPersistAction.ActionType.FINALIZER));
        }
    }

    public boolean isNeedConfirmation() {
        return true;
    }

    public boolean needsRefreshOnFinish() {
        return true;
    }
}

