/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.model.DPIController;
import org.jkiss.dbeaver.dpi.model.DPISerializer;
import org.jkiss.dbeaver.model.DPIClientObject;
import org.jkiss.dbeaver.model.DPIContainer;
import org.jkiss.dbeaver.model.DPIElement;
import org.jkiss.dbeaver.model.DPIFactory;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestProxy;

public class DPIClientProxy
implements DPIClientObject,
InvocationHandler {
    public static final Object SELF_REFERENCE = new Object();
    private final DPIContext context;
    private final String objectId;
    private final String objectType;
    private final String objectToString;
    private final Integer objectHashCode;
    private transient Object objectInstance;
    private Map<String, Object> objectContainers;
    private Map<String, Object> objectProperties;
    private Map<Class<?>, Object> factoryObjects;

    public DPIClientProxy(@NotNull DPIContext context, @NotNull Class<?>[] allInterfaces, @NotNull String objectId, @Nullable String objectType, @Nullable String objectToString, @Nullable Integer objectHashCode, @Nullable Map<String, Object> objectContainers, @Nullable Map<String, Object> objectProperties) {
        this.context = context;
        this.objectId = objectId;
        this.objectType = objectType;
        this.objectToString = objectToString;
        this.objectHashCode = objectHashCode;
        this.objectContainers = objectContainers;
        this.objectProperties = objectProperties;
        this.objectInstance = Proxy.newProxyInstance(context.getClassLoader(), allInterfaces, (InvocationHandler)this);
    }

    public String dpiObjectId() {
        return this.objectId;
    }

    public String dpiObjectType() {
        return this.objectType;
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public String toString() {
        return this.objectToString;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        DPIController controller;
        Class<?>[] parameterTypes;
        Object result;
        Object result2;
        boolean isElement;
        if (method.getDeclaringClass() == Object.class) {
            if (method.getName().equals("toString") && this.objectToString != null) {
                return this.objectToString;
            }
            if (method.getName().equals("hashCode") && this.objectHashCode != null) {
                return this.objectHashCode;
            }
            return BeanUtils.handleObjectMethod((Object)proxy, (Method)method, (Object[])args);
        }
        if (method.getDeclaringClass() == DPIClientObject.class) {
            if (method.getName().equals("dpiObjectId")) {
                return this.dpiObjectId();
            }
            if (method.getName().equals("dpiObjectType")) {
                return this.dpiObjectType();
            }
            return null;
        }
        DPIContainer containerAnno = DPISerializer.getMethodAnno(method, DPIContainer.class);
        if (containerAnno != null) {
            Object container;
            if (containerAnno.root()) {
                return this.context.getRootObject();
            }
            if (this.objectContainers != null && (container = this.objectContainers.get(method.getName())) != null) {
                if (container == SELF_REFERENCE) {
                    return this.objectInstance;
                }
                return container;
            }
        }
        boolean bl = isElement = DPISerializer.getMethodAnno(method, DPIElement.class) != null || method.getDeclaringClass().getAnnotation(DPIElement.class) != null;
        if (isElement && this.objectProperties != null && (result2 = this.objectProperties.get(DPIClientProxy.getElementKey(method, args))) != null) {
            return result2;
        }
        Property propAnnotation = method.getAnnotation(Property.class);
        if (propAnnotation != null && this.objectProperties != null && (result = this.objectProperties.get(DPIClientProxy.getPropertyKey(method, propAnnotation))) != null) {
            return result;
        }
        DPIFactory dpiFactory = DPISerializer.getMethodAnno(method, DPIFactory.class);
        Type dpiFactoryClass = null;
        if (dpiFactory != null && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0] == Class.class) {
            Object cachedResult;
            dpiFactoryClass = (Class)args[0];
            if (this.factoryObjects != null && (cachedResult = this.factoryObjects.get(dpiFactoryClass)) != null) {
                return cachedResult;
            }
        }
        if ((controller = this.context.getDpiController()) == null) {
            throw new DBException("No DPI controller in client context");
        }
        if (controller instanceof RestProxy) {
            Type returnType = dpiFactoryClass != null ? dpiFactoryClass : method.getGenericReturnType();
            ((RestProxy)controller).setNextCallResultType(returnType);
        }
        Object result3 = controller.callMethod(this.objectId, method.getName(), args);
        if (propAnnotation != null) {
            if (this.objectProperties == null) {
                this.objectProperties = new HashMap<String, Object>();
            }
            this.objectProperties.put(DPIClientProxy.getPropertyKey(method, propAnnotation), result3);
        } else if (dpiFactoryClass != null) {
            if (this.factoryObjects == null) {
                this.factoryObjects = new HashMap();
            }
            this.factoryObjects.put((Class<?>)dpiFactoryClass, result3);
        } else if (isElement) {
            if (this.objectProperties == null) {
                this.objectProperties = new HashMap<String, Object>();
            }
            this.objectProperties.put(DPIClientProxy.getElementKey(method, args), result3);
        } else if (containerAnno != null) {
            if (this.objectContainers == null) {
                this.objectContainers = new HashMap<String, Object>();
            }
            this.objectContainers.put(method.getName(), result3);
        }
        return result3;
    }

    private static String getPropertyKey(Method method, Property propAnnotation) {
        String propId = propAnnotation.id();
        if (CommonUtils.isEmpty((String)propId)) {
            propId = BeanUtils.getPropertyNameFromGetter((String)method.getName());
        }
        return propId;
    }

    private static String getElementKey(Method method, Object[] args) {
        if (!ArrayUtils.isEmpty((Object[])args)) {
            StringBuilder buf = new StringBuilder(method.getName());
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                if (!(arg instanceof DBRProgressMonitor)) {
                    buf.append(":").append(arg);
                }
                ++n2;
            }
            return buf.toString();
        }
        return method.getName();
    }
}

