set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(ExecutablePathSet FALSE)
set(IncludePathSet FALSE)
set(ReferencePathSet FALSE)
set(LibraryPathSet FALSE)
set(LibraryWPathSet FALSE)
set(SourcePathSet FALSE)
set(ExcludePathSet FALSE)

file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "^ *<ExecutablePath[^>]*>([^<>]+)</ExecutablePath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(VC_ExecutablePath_x86);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has executable path set")
        set(ExecutablePathSet TRUE)
    endif()
  elseif(line MATCHES "^ *<IncludePath[^>]*>([^<>]+)</IncludePath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(VC_IncludePath);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has include path set")
        set(IncludePathSet TRUE)
    endif()
  elseif(line MATCHES "^ *<ReferencePath[^>]*>([^<>]+)</ReferencePath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(VC_ReferencesPath_x86);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has reference path set")
        set(ReferencePathSet TRUE)
    endif()
  elseif(line MATCHES "^ *<LibraryPath[^>]*>([^<>]+)</LibraryPath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(VC_LibraryPath_x86);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has library path set")
        set(LibraryPathSet TRUE)
    endif()
  elseif(line MATCHES "^ *<LibraryWPath[^>]*>([^<>]+)</LibraryWPath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(WindowsSDK_MetadataPath);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has library WinRT path set")
        set(LibraryWPathSet TRUE)
    endif()
  elseif(line MATCHES "^ *<SourcePath[^>]*>([^<>]+)</SourcePath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(VC_SourcePath);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has source path set")
        set(SourcePathSet TRUE)
    endif()
  elseif(line MATCHES "^ *<ExcludePath[^>]*>([^<>]+)</ExcludePath>$")
    if("${CMAKE_MATCH_1}" STREQUAL "$(VC_IncludePath);C:\\Program Files\\Custom-SDK\\;")
        message(STATUS "foo.vcxproj has exclude path set")
        set(ExcludePathSet TRUE)
    endif()
  endif()
endforeach()

if(NOT ExecutablePathSet)
  set(RunCMake_TEST_FAILED "ExecutablePath not found or not set correctly.")
  return()
endif()

if(NOT IncludePathSet)
  set(RunCMake_TEST_FAILED "IncludePath not found or not set correctly.")
  return()
endif()

if(NOT ReferencePathSet)
  set(RunCMake_TEST_FAILED "ReferencePath not found or not set correctly.")
  return()
endif()

if(NOT LibraryPathSet)
  set(RunCMake_TEST_FAILED "LibraryPath not found or not set correctly.")
  return()
endif()

if(NOT LibraryWPathSet)
  set(RunCMake_TEST_FAILED "LibraryWPath not found or not set correctly.")
  return()
endif()

if(NOT SourcePathSet)
  set(RunCMake_TEST_FAILED "SourcePath not found or not set correctly.")
  return()
endif()

if(NOT ExcludePathSet)
  set(RunCMake_TEST_FAILED "ExcludePath not found or not set correctly.")
  return()
endif()
