//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// UNSUPPORTED: libcpp-has-no-threads

// <atomic>

// Test the feature test macros defined by <atomic>

/*  Constant                                Value
    __cpp_lib_atomic_is_always_lock_free    201603L [C++17]
    __cpp_lib_atomic_ref                    201806L [C++2a]
    __cpp_lib_char8_t                       201811L [C++2a]
*/

#include <atomic>
#include "test_macros.h"

#if TEST_STD_VER < 14

# ifdef __cpp_lib_atomic_is_always_lock_free
#   error "__cpp_lib_atomic_is_always_lock_free should not be defined before c++17"
# endif

# ifdef __cpp_lib_atomic_ref
#   error "__cpp_lib_atomic_ref should not be defined before c++2a"
# endif

# ifdef __cpp_lib_char8_t
#   error "__cpp_lib_char8_t should not be defined before c++2a"
# endif

#elif TEST_STD_VER == 14

# ifdef __cpp_lib_atomic_is_always_lock_free
#   error "__cpp_lib_atomic_is_always_lock_free should not be defined before c++17"
# endif

# ifdef __cpp_lib_atomic_ref
#   error "__cpp_lib_atomic_ref should not be defined before c++2a"
# endif

# ifdef __cpp_lib_char8_t
#   error "__cpp_lib_char8_t should not be defined before c++2a"
# endif

#elif TEST_STD_VER == 17

# if !defined(_LIBCUDACXX_HAS_NO_THREADS)
#   ifndef __cpp_lib_atomic_is_always_lock_free
#     error "__cpp_lib_atomic_is_always_lock_free should be defined in c++17"
#   endif
#   if __cpp_lib_atomic_is_always_lock_free != 201603L
#     error "__cpp_lib_atomic_is_always_lock_free should have the value 201603L in c++17"
#   endif
# else
#   ifdef __cpp_lib_atomic_is_always_lock_free
#     error "__cpp_lib_atomic_is_always_lock_free should not be defined when !defined(_LIBCUDACXX_HAS_NO_THREADS) is not defined!"
#   endif
# endif

# ifdef __cpp_lib_atomic_ref
#   error "__cpp_lib_atomic_ref should not be defined before c++2a"
# endif

# ifdef __cpp_lib_char8_t
#   error "__cpp_lib_char8_t should not be defined before c++2a"
# endif

#elif TEST_STD_VER > 17

# if !defined(_LIBCUDACXX_HAS_NO_THREADS)
#   ifndef __cpp_lib_atomic_is_always_lock_free
#     error "__cpp_lib_atomic_is_always_lock_free should be defined in c++2a"
#   endif
#   if __cpp_lib_atomic_is_always_lock_free != 201603L
#     error "__cpp_lib_atomic_is_always_lock_free should have the value 201603L in c++2a"
#   endif
# else
#   ifdef __cpp_lib_atomic_is_always_lock_free
#     error "__cpp_lib_atomic_is_always_lock_free should not be defined when !defined(_LIBCUDACXX_HAS_NO_THREADS) is not defined!"
#   endif
# endif

# if !defined(_LIBCUDACXX_VERSION)
#   ifndef __cpp_lib_atomic_ref
#     error "__cpp_lib_atomic_ref should be defined in c++2a"
#   endif
#   if __cpp_lib_atomic_ref != 201806L
#     error "__cpp_lib_atomic_ref should have the value 201806L in c++2a"
#   endif
# else // _LIBCUDACXX_VERSION
#   ifdef __cpp_lib_atomic_ref
#     error "__cpp_lib_atomic_ref should not be defined because it is unimplemented in libc++!"
#   endif
# endif

# if defined(__cpp_char8_t)
#   ifndef __cpp_lib_char8_t
#     error "__cpp_lib_char8_t should be defined in c++2a"
#   endif
#   if __cpp_lib_char8_t != 201811L
#     error "__cpp_lib_char8_t should have the value 201811L in c++2a"
#   endif
# else
#   ifdef __cpp_lib_char8_t
#     error "__cpp_lib_char8_t should not be defined when defined(__cpp_char8_t) is not defined!"
#   endif
# endif

#endif // TEST_STD_VER > 17

int main(int, char**) { return 0; }
