/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.storage;

import eu.bibl.banalysis.storage.ClassMappingData;
import eu.bibl.banalysis.storage.Identifiable;
import eu.bibl.banalysis.storage.MappingData;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;

public class FieldMappingData
extends Identifiable {
    protected ClassMappingData fieldOwner;
    protected ClassMappingData methodOwner;
    protected MappingData name;
    protected MappingData desc;
    protected boolean isStatic;

    public FieldMappingData(MappingData name, MappingData desc, boolean isStatic) {
        this(null, null, name, desc, isStatic);
    }

    public FieldMappingData(ClassMappingData fieldOwner, ClassMappingData methodOwner, MappingData name, MappingData desc, boolean isStatic) {
        this.fieldOwner = fieldOwner;
        this.methodOwner = methodOwner;
        this.name = name;
        this.desc = desc;
        this.isStatic = isStatic;
    }

    public FieldMappingData buildObf(FieldInsnNode fin) {
        if (this.name != null) {
            this.name.setObfuscatedName(fin.name);
        }
        if (this.desc != null) {
            this.desc.setObfuscatedName(fin.desc);
        }
        return this;
    }

    public FieldMappingData buildObf(FieldNode fn) {
        if (this.name != null) {
            this.name.setObfuscatedName(fn.name);
        }
        if (this.desc != null) {
            this.desc.setObfuscatedName(fn.desc);
        }
        return this;
    }

    public FieldMappingData buildRefac(FieldInsnNode fin) {
        if (this.name != null) {
            this.name.setRefactoredName(fin.name);
        }
        if (this.desc != null) {
            this.desc.setRefactoredName(fin.desc);
        }
        return this;
    }

    public FieldMappingData buildRefac(FieldNode fn) {
        if (this.name != null) {
            this.name.setRefactoredName(fn.name);
        }
        if (this.desc != null) {
            this.desc.setRefactoredName(fn.desc);
        }
        return this;
    }

    public MappingData getFieldOwner() {
        return this.fieldOwner;
    }

    public FieldMappingData setFieldOwner(ClassMappingData fieldOwner) {
        this.fieldOwner = fieldOwner;
        return this;
    }

    public MappingData getMethodOwner() {
        return this.methodOwner;
    }

    public FieldMappingData setMethodOwner(ClassMappingData methodOwner) {
        this.methodOwner = methodOwner;
        return this;
    }

    public MappingData getName() {
        return this.name;
    }

    public FieldMappingData setName(MappingData name) {
        this.name = name;
        return this;
    }

    public MappingData getDesc() {
        return this.desc;
    }

    public FieldMappingData setDesc(MappingData desc) {
        this.desc = desc;
        return this;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public FieldMappingData setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    @Override
    public FieldMappingData identify() {
        super.identify();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 31 * result + (this.fieldOwner == null ? 0 : this.fieldOwner.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.methodOwner == null ? 0 : this.methodOwner.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMappingData other = (FieldMappingData)obj;
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        if (this.fieldOwner == null ? other.fieldOwner != null : !this.fieldOwner.equals(other.fieldOwner)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        if (this.methodOwner == null ? other.methodOwner != null : !this.methodOwner.equals(other.methodOwner)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

