/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.analyse.stack;

import eu.bibl.banalysis.analyse.stack.CallStack;
import eu.bibl.banalysis.analyse.stack.ConstantValue;
import eu.bibl.banalysis.analyse.stack.FieldRefValue;
import eu.bibl.banalysis.analyse.stack.LocalValue;
import eu.bibl.banalysis.analyse.stack.ReturnValue;
import eu.bibl.banalysis.analyse.stack.StackValue;
import eu.bibl.banalysis.asm.ClassNode;
import eu.bibl.banalysis.asm.desc.OpcodeInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class StackTracer
implements Opcodes {
    protected final MethodNode m;
    protected final Stack<StackValue<?>> stack;
    protected Map<Label, AbstractInsnNode> labelMap;
    protected Map<Integer, StackValue<?>> locals;
    protected final CallStack[] callStacks;

    public StackTracer(MethodNode m) {
        this.m = m;
        this.stack = new Stack();
        this.locals = new HashMap();
        this.callStacks = new CallStack[m.instructions.size()];
        this.calcLabels();
    }

    public void calcLabels() {
        this.labelMap = new HashMap<Label, AbstractInsnNode>();
        for (AbstractInsnNode ain : this.m.instructions) {
            if (!(ain instanceof LabelNode)) continue;
            LabelNode labelNode = (LabelNode)ain;
            Label label = labelNode.getLabel();
            this.labelMap.put(label, labelNode.getNext());
        }
    }

    public void trace() {
        AbstractInsnNode[] ains = this.m.instructions.toArray();
        for (int i = 0; i < ains.length; ++i) {
            AbstractInsnNode ain = ains[i];
            if (ain instanceof LdcInsnNode) {
                LdcInsnNode ldc = (LdcInsnNode)ain;
                this.stack.push(new ConstantValue(ldc.cst));
                continue;
            }
            if (ain instanceof FieldInsnNode) {
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (fin.getOpcode() == 179 || fin.getOpcode() == 181) {
                    this.stack.pop();
                    continue;
                }
                if (fin.getOpcode() != 178 && fin.getOpcode() != 180) continue;
                this.stack.push(new FieldRefValue(fin.owner, fin.name, fin.desc, fin.getOpcode() == 178));
                continue;
            }
            if (ain instanceof MethodInsnNode) {
                MethodInsnNode min = (MethodInsnNode)ain;
                Type[] consumedTypes = Type.getArgumentTypes((String)min.desc);
                for (int j = 0; j < consumedTypes.length; ++j) {
                    this.stack.pop();
                }
                Type returnType = Type.getReturnType((String)min.desc);
                if (returnType.getDescriptor().equals("V")) continue;
                this.stack.push(new ReturnValue(returnType.getDescriptor()));
                continue;
            }
            if (ain instanceof VarInsnNode) {
                VarInsnNode vin = (VarInsnNode)ain;
                String opcodeName = OpcodeInfo.OPCODES.get(vin.getOpcode());
                if (opcodeName.contains("LOAD")) {
                    this.stack.push(new LocalValue(vin.var, this.locals.get(vin.var)));
                    continue;
                }
                if (!opcodeName.contains("STORE")) continue;
                this.locals.put(vin.var, this.stack.pop());
                continue;
            }
            if (ain instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lus = (LookupSwitchInsnNode)ain;
                continue;
            }
            if (!(ain instanceof TableSwitchInsnNode)) continue;
        }
    }

    public static void voidCall() {
    }

    public static int intCall() {
        return 1;
    }

    public static int longCall(long l) {
        return 1;
    }

    public static void main(String[] args) throws IOException, AnalyzerException {
        ClassNode cn = new ClassNode();
        ClassReader cr = new ClassReader("eu/bibl/banalysis/analyse/stack/StackTracer");
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode m : cn.methods()) {
            Frame[] frames;
            if (!m.name.equals("test")) continue;
            Analyzer a = new Analyzer((Interpreter)new SourceInterpreter());
            a.analyze(cn.name, m);
            for (Frame frame : frames = a.getFrames()) {
                if (frame == null) continue;
                System.out.println("STACK");
                int size = frame.getStackSize();
                for (int i = 0; i < frame.getMaxStackSize(); ++i) {
                    if (i < size) {
                        SourceValue val = (SourceValue)frame.getStack(i);
                        System.out.println("\t" + val.insns);
                        continue;
                    }
                    System.out.println("\tnull");
                }
            }
        }
    }
}

