"use strict";
exports.uk = void 0;
var _index = require("./uk/_lib/formatDistance.js");
var _index2 = require("./uk/_lib/formatLong.js");
var _index3 = require("./uk/_lib/formatRelative.js");
var _index4 = require("./uk/_lib/localize.js");
var _index5 = require("./uk/_lib/match.js");

/**
 * @category Locales
 * @summary Ukrainian locale.
 * @language Ukrainian
 * @iso-639-2 ukr
 * @author Andrii Korzh [@korzhyk](https://github.com/korzhyk)
 * @author Andriy Shcherbyak [@shcherbyakdev](https://github.com/shcherbyakdev)
 */
const uk = (exports.uk = {
  code: "uk",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 1,
  },
});
