"use strict";
exports.te = void 0;
var _index = require("./te/_lib/formatDistance.js");
var _index2 = require("./te/_lib/formatLong.js");
var _index3 = require("./te/_lib/formatRelative.js");
var _index4 = require("./te/_lib/localize.js");
var _index5 = require("./te/_lib/match.js");

/**
 * @category Locales
 * @summary Telugu locale
 * @language Telugu
 * @iso-639-2 tel
 * @author Kranthi Lakum [@kranthilakum](https://github.com/kranthilakum)
 */
const te = (exports.te = {
  code: "te",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 0 /* Sunday */,
    firstWeekContainsDate: 1,
  },
});
