"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parse = void 0;
var _antlr4Browser = _interopRequireDefault(require("@neo4j-cypher/antlr4-browser"));
var _ReferencesProvider = require("../references/ReferencesProvider");
var CypherTypes = _interopRequireWildcard(require("../lang/CypherTypes"));
var _antlr = require("@neo4j-cypher/antlr4");
var _ErrorListener = require("../errors/ErrorListener");
var _ReferencesListener = require("../references/ReferencesListener");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const parse = input => {
  const referencesListener = new _ReferencesListener.ReferencesListener();
  const errorListener = new _ErrorListener.ErrorListener();
  const chars = new _antlr4Browser.default.InputStream(input);
  const lexer = new _antlr.CypherLexer(chars);
  lexer.removeErrorListeners();
  lexer.addErrorListener(errorListener);
  const tokens = new _antlr4Browser.default.CommonTokenStream(lexer);
  const parser = new _antlr.CypherParser(tokens);
  parser.buildParseTrees = true;
  parser.removeErrorListeners();
  parser.addErrorListener(errorListener);
  parser.addParseListener(referencesListener);
  const parseTree = parser.cypher();
  const {
    queries,
    indexes
  } = referencesListener;
  const referencesProviders = new Map();
  CypherTypes.SYMBOLIC_CONTEXTS.forEach(sc => {
    referencesProviders.set(sc, new _ReferencesProvider.ReferencesProvider(queries, indexes.get(sc)));
  });
  return {
    parseTree,
    referencesListener,
    errorListener,
    referencesProviders
  };
};
exports.parse = parse;