// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
import { useQuery } from 'react-query';
import { apiClient, Permission } from '../utils';
import { usePermissions } from './usePermissions';

export const useSelf = () =>
    useQuery({
        queryKey: ['getSelf'],
        queryFn: ({ signal }) => apiClient.getSelf({ signal }).then((res) => res.data?.data),
    });

export const useBloodHoundUsers = () => {
    const { checkPermission } = usePermissions();
    const hasPermission = checkPermission(Permission.AUTH_MANAGE_USERS);

    return useQuery({
        queryKey: ['listUsers'],
        queryFn: ({ signal }) => apiClient.listUsers({ signal }).then((res) => res.data?.data?.users),
        enabled: hasPermission,
    });
};
