//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_5.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot5(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[5] = {1.175813202117782e-01,1.074562012436904e+00,3.085937443717551e+00,6.414729733662032e+00,1.180718948997173e+01
    };
  constexpr double aw[5] = {6.108626337353256e-01,2.401386110823146e-01,3.387439445548104e-02,1.343645746781236e-03,7.640432855232646e-06
    };
  constexpr double x[1920] = {  4.058358437870611e-02, -1.810678466366126e-03,  5.936951645218651e-05, -1.684476592591675e-06,  4.312953239145675e-08,
 -1.007349208066596e-09,  2.118072581995054e-11, -3.860556235070740e-13,  5.278150623010092e-15, -1.882544570761491e-17, -2.223259728516612e-18,  1.207841045011638e-19,
  3.484811057708894e-01, -1.328418381772604e-02,  3.033269445756231e-04, -3.552795480592078e-06, -4.534461376700926e-08,  3.371801960725916e-09, -7.442873513890367e-11,
 -6.547940389986966e-15,  5.463917502775690e-14, -1.812753752790780e-15,  1.655795260954178e-17,  1.003809627892172e-18,  8.764106730908152e-01, -2.328598228461027e-02,
  1.141115078537608e-04,  7.957219726280624e-06, -1.162421594817999e-07, -4.502816806755154e-09,  1.202983954776114e-10,  2.709918516475594e-12, -1.260791384659866e-13,
 -1.470928125965832e-15,  1.285392963170639e-16,  4.778666514504530e-19,  1.458898943107543e+00, -1.919965192986979e-02, -3.131210634832076e-04,  1.575442119748774e-06,
  2.045436790567240e-07,  3.046729087439092e-09, -9.219841379222144e-11, -4.514008301365212e-12, -2.003537491025645e-14,  3.603043088093150e-15,  9.852741420885335e-17,
 -1.148769890058626e-18,  1.886702898975964e+00, -5.313107679109947e-03, -1.751838977341282e-04, -4.649593382131144e-06, -9.793768137460642e-08, -1.360005599542476e-09,
  4.364035105953287e-12,  1.103625316783568e-12,  4.491670791008173e-14,  1.151217335853332e-15,  1.599471651393754e-17, -1.943242673932584e-19,  3.417751097210101e-02,
 -1.406214599556388e-03,  4.271160747744800e-05, -1.131304495124371e-06,  2.728477735912366e-08, -6.106728172282981e-10,  1.255868809367566e-11, -2.373716485405431e-13,
  3.895071804131370e-15, -4.200017559120439e-17,  2.804571739104845e-19,  1.196158885700583e-20,  2.999161534788669e-01, -1.103592998278967e-02,  2.582581346805383e-04,
 -3.833098339794875e-06,  5.000624749508571e-09,  1.726682740421968e-09, -5.869427568795652e-11,  8.796532075085128e-13,  7.155772276039595e-15, -7.713601302436664e-16,
  2.583566598812410e-17, -3.240652469033995e-19,  7.856450151778875e-01, -2.202849300388231e-02,  1.960252536185588e-04,  5.551077876312198e-06, -1.737172047226206e-07,
 -1.175199600150692e-09,  1.385861524571507e-10, -1.230296762838588e-12, -9.504135107106485e-14,  2.659633083992768e-15,  5.159223737641428e-17, -3.056155697798414e-18,
  1.377293539091521e+00, -2.156972598639071e-02, -2.730748956656797e-04,  5.172884534249719e-06,  2.333328917064475e-07, -6.124110670375286e-10, -2.037015140225514e-10,
 -2.516609592001701e-12,  1.534986161318668e-13,  4.914034195027068e-15, -6.848351465205787e-17, -5.752721433786053e-18,  1.862253949696433e+00, -6.966362776830131e-03,
 -2.412233166319758e-04, -6.414549772879317e-06, -1.205718150933909e-07, -6.801078995925195e-10,  6.230092998736721e-11,  3.289499231143773e-12,  9.240620054961431e-14,
  1.216114735012604e-15, -2.666184298728804e-17, -2.127855295230575e-18,  2.915943422004751e-02, -1.112234971058317e-03,  3.139969417236797e-05, -7.781025920269669e-07,
  1.761422926593352e-08, -3.762458343756025e-10,  7.447457865433720e-12, -1.344957844348712e-13,  2.600670234824212e-15, -3.150832339896057e-17,  8.184864130791298e-20,
 -1.106304295492989e-20,  2.596180541917716e-01, -9.150323633946755e-03,  2.136561149143482e-04, -3.544781579637896e-06,  2.749090987643017e-08,  6.201115906974748e-10,
 -3.380526542959029e-11,  8.295992338513692e-13, -6.319060070349813e-15, -1.047224511283672e-16,  7.147989749785176e-18, -3.877599932090830e-19,  7.010216497750029e-01,
 -2.024178155387209e-02,  2.457268640030092e-04,  2.747613367392149e-06, -1.681203643141445e-07,  1.490137375636825e-09,  7.730850723364828e-11, -2.594575597954726e-12,
  7.340787958497146e-15,  2.305983767708953e-15, -5.523052090940120e-17, -1.240113886707271e-18,  1.287124685458993e+00, -2.344528871921265e-02, -1.899023610734958e-04,
  8.530437995610898e-06,  1.699431580661883e-07, -5.659212156441242e-09, -1.853519462140671e-10,  4.225624831891975e-12,  2.248785296042832e-13, -2.161028788332165e-15,
 -2.423154027011261e-16,  1.059878803529316e-20,  1.829994642431753e+00, -9.237167832243357e-03, -3.298575789441531e-04, -8.333545709570182e-06, -1.099073467562510e-07,
  2.281939353113724e-09,  1.995504896806047e-10,  6.494713450548834e-12,  8.466600880547736e-14, -2.811958791558320e-15, -2.028485147300112e-16, -5.815684308724320e-18,
  2.515983600485922e-02, -8.941097866425393e-04,  2.353344449731241e-05, -5.478873554845095e-07,  1.161583284036036e-08, -2.343400735439582e-10,  4.675817581676244e-12,
 -6.959715528700064e-14,  1.432131939611976e-15, -3.502329836671341e-17, -1.519202422589149e-19,  2.825161719537074e-21,  2.261773382280429e-01, -7.603053103112505e-03,
  1.740448639528161e-04, -3.042335669688858e-06,  3.353335106212144e-08,  6.244480149339264e-11, -1.374695453224638e-11,  5.944563919290253e-13, -8.193313283295122e-15,
 -6.370744264088806e-17, -2.555041298574210e-18, -4.708535083477770e-20,  6.241340812479735e-01, -1.818700775059710e-02,  2.638041840273073e-04,  3.735149196765750e-07,
 -1.252467209570717e-07,  2.560049311171936e-09,  1.701473566762535e-11, -1.515410208408635e-12,  4.479912482708723e-14, -2.074965695520493e-16, -5.396316841217539e-17,
  9.877916931160435e-19,  1.191005653356042e+00, -2.451874036312282e-02, -7.559872405936852e-05,  1.015566058607527e-05,  2.552280778171208e-08, -8.009783380286088e-09,
  9.649970052346258e-12,  8.502095370800194e-12,  1.912325299346937e-15, -8.735805202402673e-15, -2.508483656270328e-17,  8.014171596515764e-18,  1.787099792333145e+00,
 -1.230045110768688e-02, -4.378839648461444e-04, -9.401249065618709e-06, -7.056517740321868e-10,  9.397425666886406e-09,  3.900244674390223e-10,  5.519324970210727e-12,
 -2.224265013657901e-13, -1.553685995004696e-14, -3.775004167571800e-16,  2.547382020105481e-18,  2.192232967160806e-02, -7.293008645040469e-04,  1.793738307941677e-05,
 -3.940158168189143e-07,  7.915084904220200e-09, -1.415215880474912e-10,  3.173745966617144e-12, -4.455676125270120e-14,  1.396716187255565e-16, -3.338830754260410e-17,
  3.604256411839217e-19,  2.030966604231290e-20,  1.983315129130965e-01, -6.347600964835474e-03,  1.407532903827223e-04, -2.508644916652560e-06,  3.266648993253115e-08,
 -1.001989413229505e-10, -1.255898104906923e-12,  2.769828061979976e-13, -1.204945758134267e-14, -1.241546437804701e-16,  1.343161790856780e-18,  2.036182665687752e-19,
  5.555924474402106e-01, -1.608873773855320e-02,  2.579913248080896e-04, -1.210365744377993e-06, -7.263784751998995e-08,  2.601811257468929e-09, -8.874326268372575e-12,
 -5.187466643024200e-13,  1.096232964287544e-14, -1.299290741053383e-15,  1.542898180125280e-18,  1.323520625723974e-18,  1.092487270298709e+00, -2.464081978765241e-02,
  4.368714428863761e-05,  9.372450454626492e-06, -1.142433563700322e-07, -5.195630833563039e-09,  2.037117632878629e-10,  3.983032355638461e-12, -2.536811421762376e-13,
 -3.765264976939084e-15,  2.249593103452600e-16,  1.793336872133099e-18,  1.730200291360724e+00, -1.623721010005536e-02, -5.428245016957461e-04, -7.369815317833809e-06,
  2.866853639535815e-07,  1.920329865479348e-08,  3.442255056292323e-10, -1.263561905142015e-11, -9.306127193069817e-13, -1.729677946668702e-14,  6.252313185652701e-16,
  4.679170316967788e-17,  1.926496621745757e-02, -6.027519952405741e-04,  1.388787759090029e-05, -2.863073091892415e-07,  5.743712183955503e-09, -8.078019433200472e-11,
  1.839408151050981e-12, -5.450642345677518e-14, -5.460318462648050e-16,  3.130639929980592e-18,  1.517148201004107e-18,  2.542177003669686e-20,  1.750148464009735e-01,
 -5.333257509400003e-03,  1.137193151928990e-04, -2.001843020776680e-06,  3.074951115249509e-08, -8.411049616581445e-11,  6.206810276504836e-13, -1.490912576724038e-13,
 -1.293446608721675e-14,  1.555550879916214e-16,  1.323636763619525e-17,  2.668807566870303e-19,  4.952505676664853e-01, -1.409880609170126e-02,  2.381604782514311e-04,
 -1.972606169080631e-06, -2.387600101109992e-08,  2.214152597105019e-09, -2.478676008360307e-11, -7.929653586723247e-13, -2.106266809050314e-14, -1.219628345119849e-16,
  5.508564592145775e-17,  9.622343280142556e-19,  9.952833296874273e-01, -2.387857315301199e-02,  1.426821860328491e-04,  6.999330883201128e-06, -1.652723945709851e-07,
  5.276312990686063e-11,  1.938758396271703e-10, -4.532710261376638e-12, -2.256539266521155e-13,  5.047178441258781e-15,  1.903923793327680e-16, -1.818575139865050e-18,
  1.656157355169773e+00, -2.082433469250791e-02, -5.900977750718579e-04,  5.528934993377708e-07,  7.058509513053398e-07,  1.955940781325732e-08, -4.603269484467051e-10,
 -4.317564501119423e-11, -5.692454689759215e-13,  5.022030146033665e-14,  2.391251827648105e-15, -6.754267609223292e-18,  1.705646496283517e-02, -5.039393403294656e-04,
  1.095654950075497e-05, -2.054828017222462e-07,  4.437840220458087e-09, -5.636113211816172e-11,  1.774876456751025e-13, -5.719504336825518e-14,  7.760648985539029e-16,
  6.728899564458300e-17,  9.564849141967059e-19, -7.354958126626958e-20,  1.553608189646493e-01, -4.511360288995019e-03,  9.259058096360644e-05, -1.524654241999428e-06,
  2.867308901410866e-08, -1.568301485726180e-10, -7.686108477002307e-12, -3.571550343188457e-13,  3.542796070362519e-15,  7.355012485857146e-16,  8.517904213540391e-18,
 -7.107428760937899e-19,  4.425109451744295e-01, -1.229158884595900e-02,  2.135300366098924e-04, -2.041489030740664e-06,  1.230931083557183e-08,  1.289297834916252e-09,
 -5.373267754705536e-11, -1.063189410925520e-12,  1.882070409111792e-14,  2.243542397207737e-15,  3.731727490037009e-17, -2.549233374806518e-18,  9.025222896707488e-01,
 -2.244464404922547e-02,  2.115141893339199e-04,  4.561030198817303e-06, -1.312938999262175e-07,  2.582976984282803e-09,  2.629807836506581e-12, -7.563132086142475e-12,
  6.820874871349545e-14,  1.024776300068422e-14,  2.263953685754664e-17, -8.406049983708955e-18,  1.563763244012639e+00, -2.530285444703577e-02, -5.058900855372667e-04,
  1.395497865817749e-05,  8.872422372909478e-07, -5.808180278321492e-09, -1.543102565384954e-09, -1.845006447706454e-11,  2.298471166087050e-12,  7.541805963977825e-14,
 -2.547751049948115e-15, -1.810976190866565e-16,  1.520198584629265e-02, -4.250295863427718e-04,  8.879038586937579e-06, -1.437279847683162e-07,  3.247826002266744e-09,
 -6.621043268941148e-11, -7.073902344826549e-13,  5.250951370201466e-15,  2.793889624184759e-15,  1.052335877578539e-17, -3.940820796402693e-18, -8.349380442448236e-20,
  1.386915493719249e-01, -3.836338288817946e-03,  7.690333937230247e-05, -1.103848538069420e-06,  2.305421001718983e-08, -4.236251481484232e-10, -1.211786530964125e-11,
  1.621807023647284e-13,  2.544002536099188e-14,  1.424729674193267e-16, -3.980107155022964e-17, -8.306988014290873e-19,  3.966126030180699e-01, -1.067652917696161e-02,
  1.908153126767785e-04, -1.716213861789982e-06,  2.347188139814332e-08, -2.115389172802928e-10, -6.255439677210664e-11,  8.197301218639483e-13,  8.794567347110177e-14,
  3.754916601818227e-16, -1.370530026304934e-16, -3.027470762130010e-18,  8.164289692842281e-01, -2.056568916864265e-02,  2.551814908373699e-04,  2.813725977809283e-06,
 -9.348260824018167e-08,  6.765155287798137e-10, -1.271628004877825e-10, -2.418298932213019e-13,  3.336385342972904e-13,  8.144069079882032e-16, -5.016064581581845e-16,
 -7.951475822472625e-18,  1.455830513216035e+00, -2.846088981168547e-02, -2.636755716548514e-04,  2.520570617802833e-05,  4.088288405410698e-07, -3.925858653628439e-08,
 -8.373209242010924e-10,  6.663614365823650e-11,  1.831062969291365e-12, -1.131327590284014e-13, -3.995457413288732e-15,  1.868622379830611e-16,  1.363411688038854e-02,
 -3.601184782833672e-04,  7.419967945236323e-06, -1.030541240888479e-07,  1.815185074807777e-09, -7.214288132208632e-11,  5.149821156098645e-13,  6.834101512495653e-14,
  2.632181923368180e-16, -1.293093397272225e-16, -7.233894750278272e-19,  2.104744907389831e-19,  1.245006488902138e-01, -3.268557887721172e-03,  6.554768447308757e-05,
 -8.154190086963318e-07,  1.249376317104303e-08, -5.750502513374154e-10,  2.239687122512786e-12,  7.320235245796368e-13,  1.259237176750420e-15, -1.264725963183330e-15,
 -7.170061924736473e-18,  2.119684604015598e-18,  3.568370948844956e-01, -9.226790777973275e-03,  1.721048394628811e-04, -1.442796180989420e-06,  7.634942750602435e-09,
 -1.147799253594938e-09, -6.305391871991233e-12,  2.721860761469565e-12,  2.568245809067436e-16, -4.449996860769462e-15, -1.966243833655980e-17,  7.608357164177272e-18,
  7.384271483277015e-01, -1.841458110270684e-02,  2.799250935393833e-04,  1.278759578407884e-06, -1.051947094318410e-07, -1.366735514326360e-09, -8.451875363971015e-12,
  7.003616533746136e-12,  1.911940203077592e-14, -1.492253909553074e-14, -9.432729372161910e-18,  2.640258278514370e-17,  1.339757352505878e+00, -2.931254288250142e-02,
  5.049317486463785e-05,  2.507200015365982e-05, -4.103795063161998e-07, -3.472118900227745e-08,  1.132298184182837e-09,  4.946630109679283e-11, -2.597835255640777e-12,
 -6.530940916278446e-14,  5.458071697857134e-15,  7.149829714807567e-17,  1.230509209550054e-02, -3.053137845585707e-04,  6.313838681254174e-06, -8.426825089385170e-08,
  6.382975498088259e-10, -3.992680996961873e-11,  1.909207132934134e-12,  1.399087853706626e-14, -2.871594509124220e-15, -4.501105607480662e-18,  4.984578030040952e-18,
 -3.905324567139133e-20,  1.124169179919058e-01, -2.780740224298716e-03,  5.661007622936055e-05, -6.980780137768037e-07,  3.042758802402619e-09, -3.103831558576718e-10,
  1.708891720843785e-11,  1.619363913513737e-13, -2.898754209024035e-14, -1.552987393420711e-17,  4.941084777871834e-17, -4.264363162347269e-19,  3.225746704910181e-01,
 -7.918805332787045e-03,  1.548068964046553e-04, -1.488400189293898e-06, -1.125282955195082e-08, -5.212769551668594e-10,  4.850622206109619e-11,  6.295612217598179e-13,
 -1.019745453904953e-13,  1.360380211899935e-16,  1.731342621387136e-16, -1.909735793971297e-18,  6.693019723240398e-01, -1.614424680910190e-02,  2.844058286128124e-04,
 -5.720926796005347e-07, -1.202603243871305e-07,  4.064723880229426e-10,  1.270093574030721e-10,  9.609383778339630e-13, -2.921319909192025e-13,  1.528862833008068e-15,
  5.421979272181078e-16, -9.794005594156732e-18,  1.225007434647133e+00, -2.785834723555480e-02,  2.946769374590071e-04,  1.471606753925399e-05, -7.731215720069277e-07,
 -9.924088366078288e-10,  1.294238761233244e-09, -3.132174100474035e-11, -1.481020620954997e-12,  9.074477456409895e-14,  4.860727350817989e-16, -1.726914580513182e-16,
  1.117863939637849e-02, -2.587189144958713e-04,  5.345543804277745e-06, -7.799756579413079e-08,  2.798416432840172e-10,  1.252149460957782e-12,  1.218607206583788e-12,
 -5.051285188268131e-14, -5.884909697325755e-16,  8.941378202459382e-17, -8.916263603118943e-19, -1.241400522770197e-19,  1.021473937917172e-01, -2.360866389311215e-03,
  4.839247774411642e-05, -6.770022998339144e-07,  8.035231507342682e-10,  6.054182560519369e-11,  1.079805094100527e-11, -4.807198507818823e-13, -5.693314838344706e-15,
  8.872149072225469e-16, -9.778866505073459e-18, -1.213221622603909e-18,  2.932583989622972e-01, -6.755231235522339e-03,  1.357280447081946e-04, -1.688767501330125e-06,
 -1.034499683587968e-08,  5.304208761787455e-10,  2.886580648695667e-11, -1.556556318793015e-12, -1.704441849914452e-14,  3.049527355046639e-15, -4.164885124865997e-17,
 -4.043831371154832e-18,  6.091879599950700e-01, -1.392750321135208e-02,  2.667836783655049e-04, -2.273572641551229e-06, -8.426458894284698e-08,  2.891011394092617e-09,
  5.377006396387487e-11, -4.640042678239655e-12, -1.562526610075842e-14,  8.683480494399875e-15, -1.810516963466314e-16, -1.063485802769381e-17,  1.119120125404060e+00,
 -2.499713354681673e-02,  4.008975391062480e-04,  3.517979812315283e-06, -5.687649608282632e-07,  1.704075563826423e-08,  2.034391105105090e-10, -3.383489573763490e-11,
  8.833302609759707e-13,  2.317231205250803e-14, -2.212997566090797e-15,  3.805466329844919e-17,  1.022348464249567e-02, -2.196125255972211e-04,  4.441080626915264e-06,
 -7.221582458792390e-08,  4.828628871902973e-10,  1.393104956135302e-11, -6.804820083499208e-14, -3.166621671901621e-14,  1.239336716276934e-15,  5.959267129324372e-18,
 -1.946407605523740e-18,  5.006159397419610e-20,  9.342727271506379e-02, -2.005843652521177e-03,  4.041850175220441e-05, -6.449898002521817e-07,  3.518340632616954e-09,
  1.625155166100880e-10, -1.367312388749353e-12, -2.938352277770105e-13,  1.207723720887111e-14,  4.775281418489358e-17, -1.898748840024938e-17,  5.132203398051167e-19,
  2.682780845930792e-01, -5.752304815600013e-03,  1.149010724290853e-04, -1.746571233781564e-06,  3.710778052538663e-09,  7.224726935595016e-10, -9.472482711829889e-12,
 -8.763858518784672e-13,  4.070687346308268e-14,  5.521929299407050e-17, -6.271607124402568e-17,  1.912567073448464e-18,  5.575474448730059e-01, -1.192064779454661e-02,
  2.334303028821010e-04, -3.131230270015105e-06, -2.335886294747269e-08,  2.790877675077415e-09, -4.912213678663509e-11, -1.990529215867718e-12,  1.221691364351530e-13,
 -7.536062238096872e-16, -1.619947561649280e-16,  6.547666029301124e-18,  1.025629582567132e+00, -2.174951646880900e-02,  3.998872509275187e-04, -2.850423955617504e-06,
 -2.379806373477971e-07,  1.401168125886560e-08, -3.202101342903704e-10, -5.025837172020966e-12,  6.596585294502555e-13, -2.064905677696415e-14, -7.051849992026280e-17,
  3.183441281806283e-17,  9.410814597741785e-03, -1.873994768074420e-04,  3.629119640881171e-06, -6.257244166091585e-08,  6.957516318548084e-10,  5.916477816219657e-12,
 -4.471907399644173e-13,  1.084393274514193e-15,  6.253206772296830e-16, -2.561789421323791e-17,  1.579836725317640e-19,  2.653855645584121e-20,  8.600322383379132e-02,
 -1.712273478855571e-03,  3.311207578366220e-05, -5.665103073681320e-07,  5.991200232367692e-09,  7.216121957940274e-11, -4.696942593920251e-12,  2.067216947066316e-14,
  5.866852889914695e-15, -2.502489448204111e-16,  1.800908073996725e-18,  2.519252757340606e-19,  2.469772766532850e-01, -4.914935428908924e-03,  9.471862272819657e-05,
 -1.589763200826132e-06,  1.461826805679513e-08,  3.366012760077604e-10, -1.794664499502131e-11,  1.417910679032663e-13,  1.784581579083134e-14, -8.407902431504071e-16,
  8.274324439725673e-18,  7.743884922741470e-19,  5.133577851095842e-01, -1.020609602749163e-02,  1.952135489643152e-04, -3.134141331814593e-06,  1.821226786127592e-08,
  1.328518688739375e-09, -6.002203778910698e-11,  7.584291324978325e-13,  4.074103156394417e-14, -2.414687897694427e-15,  3.905977691277564e-17,  1.619374323128379e-18,
  9.447462407872897e-01, -1.873347782240315e-02,  3.506849635969090e-04, -4.847297589268400e-06, -3.648653956854496e-08,  6.367374416241693e-09, -2.697532249702216e-10,
  5.468779002295138e-12,  6.749192968764293e-14, -9.683566955743213e-15,  3.547200389167871e-16, -4.195209750418691e-18,  8.714801569424528e-03, -1.611753671724309e-04,
  2.947162271040190e-06, -5.103606011370317e-08,  7.175770432825515e-10, -2.959127007012185e-12, -2.577502127835682e-13,  8.975352078318742e-15, -2.971297710029707e-17,
 -9.309852594503397e-18,  4.159634523274436e-19, -6.558068562530077e-21,  7.964326608433153e-02, -1.472867687674646e-03,  2.691813362421776e-05, -4.647502184102347e-07,
  6.431419915084224e-09, -1.985801124840223e-11, -2.662099913706507e-12,  9.134820815716320e-14, -4.270237982462692e-16, -8.707657127822241e-17,  4.035299683748239e-18,
 -6.727454862735306e-20,  2.287183197730413e-01, -4.229149054282518e-03,  7.719693296666485e-05, -1.323232690726790e-06,  1.759152079083979e-08, -6.527830623297821e-12,
 -9.833975553506825e-12,  3.305783578851153e-13, -2.436666920046426e-15, -2.615818932833521e-16,  1.327806873510614e-17, -2.510995977802482e-19,  4.754276911201403e-01,
 -8.788318430723316e-03,  1.599996306523470e-04, -2.699485729565804e-06,  3.256395854308292e-08,  2.225584826863179e-10, -3.103428126150156e-11,  1.035418580434233e-12,
 -1.204976010392141e-14, -5.657820445283790e-16,  3.582366237144620e-17, -8.612739895607273e-19,  8.750510876355051e-01, -1.616293499405748e-02,  2.922233111839901e-04,
 -4.710858029496313e-06,  3.873860599096416e-08,  1.739427267821296e-09, -1.219394988287965e-10,  4.320796606683870e-12, -8.458459060371978e-14, -4.620221042478917e-16,
  1.086383440054762e-16, -4.493901641486329e-18,  8.113643320680139e-03, -1.398588947697176e-04,  2.400797386744589e-06, -4.028384305258650e-08,  6.153892398253910e-10,
 -6.447331351669066e-12, -5.091195868669452e-14,  5.236184169212661e-15, -1.441232688771586e-16,  8.340253130600758e-19,  1.052561926382007e-19, -5.228066259435138e-21,
  7.414957092906266e-02, -1.278129914567905e-03,  2.193644436868677e-05, -3.676817018751626e-07,  5.585813862311149e-09, -5.653934711829851e-11, -5.816939408213266e-13,
  5.229273717431094e-14, -1.443114546966060e-15,  9.781516946129696e-18,  9.739542228812031e-19, -5.021164286873028e-20,  2.129429638583163e-01, -3.670382410372748e-03,
  6.296911799119017e-05, -1.052727636123894e-06,  1.577963628584680e-08, -1.458791688242292e-10, -2.485890383693320e-12,  1.817715366601656e-13, -5.064043335253957e-15,
  4.485007744839387e-17,  2.837129413676224e-18, -1.609442743721569e-19,  4.426419251420527e-01, -7.628918762820757e-03,  1.307724306233594e-04, -2.174406757352078e-06,
  3.164037604144616e-08, -2.286641269492763e-10, -8.947996213708619e-12,  5.294412624231808e-13, -1.518148813066464e-14,  1.888022590276638e-16,  5.561056110385316e-18,
 -4.064583404536857e-19,  8.147341779634437e-01, -1.403894002889110e-02,  2.401440545862029e-04, -3.936078591991777e-06,  5.249783781237288e-08, -3.472030558032722e-11,
 -3.723341232077225e-11,  1.876306865209792e-12, -5.918606512774232e-14,  1.157984164671021e-15, -1.479509088269662e-18, -9.468181963934001e-19,  7.589782032048020e-03,
 -1.224287742406931e-04,  1.972113184434398e-06, -3.149454087003831e-08,  4.835988899579934e-10, -6.383573110011114e-12,  3.930655471660937e-14,  1.562251345680897e-15,
 -7.953356864051002e-17,  1.963092356422639e-18, -1.698091363711214e-20, -9.017926029550806e-22,  6.936211859492389e-02, -1.118856497065838e-03,  1.802187629460726e-05,
 -2.877034850661400e-07,  4.409117812393503e-09, -5.764318986089003e-11,  3.221429846963550e-13,  1.587854461988234e-14, -7.825762535733827e-16,  1.944330312688830e-17,
 -1.822515577016324e-19, -8.188471912789985e-21,  1.991946822937891e-01, -3.213103792009020e-03,  5.174843874875984e-05, -8.254102280182052e-07,  1.259131300559021e-08,
 -1.607851888695292e-10,  6.694281024730416e-13,  5.676889847170309e-14, -2.642116782677372e-15,  6.674179456498902e-17, -7.304750324169725e-19, -2.260104189066592e-20,
  4.140649763349016e-01, -6.678906714898499e-03,  1.075399002747729e-04, -1.712272770875267e-06,  2.586658615098724e-08, -3.133006067633396e-10,  2.451208932675207e-13,
  1.692882405051640e-13, -7.364426310537813e-15,  1.931204406603061e-16, -2.663087837975549e-18, -3.666116919684473e-20,  7.621413644531916e-01, -1.229273345783259e-02,
  1.978112972626638e-04, -3.135731603594458e-06,  4.617395521309432e-08, -4.752386573684105e-10, -5.350374808179124e-12,  5.857386305571830e-13, -2.433189320926388e-14,
  7.048282593641775e-16, -1.387144817044719e-17,  8.949811606440291e-20,  7.129400557925088e-03, -1.080413822965682e-04,  1.636586953308191e-06, -2.471659653425520e-08,
  3.676736651831974e-10, -5.143538445957029e-12,  5.683127532017686e-14, -2.672380669150943e-17, -2.569764587550335e-17,  9.972781097805660e-19, -2.315931195701017e-20,
  2.590107822282276e-22,  6.515475888528854e-02, -9.873762916932443e-04,  1.495633338070051e-05, -2.258524900827426e-07,  3.357479752948818e-09, -4.682108550841751e-11,
  5.088945936374544e-13,  2.456193351105510e-16, -2.539020326631599e-16,  9.727296441756041e-18, -2.274971553546950e-19,  2.664119744234741e-21,  1.871120335116450e-01,
 -2.835547780877901e-03,  4.295011196801768e-05, -6.484071585797336e-07,  9.624236784882376e-09, -1.332088008911088e-10,  1.390054451421604e-12,  4.070464399559143e-15,
 -8.614488841603761e-16,  3.225444119461192e-17, -7.674161632917168e-19,  9.884442827482455e-21,  3.889491704275636e-01, -5.894208716285867e-03,  8.927349084306946e-05,
 -1.347008589096031e-06,  1.993018594842643e-08, -2.715112956469099e-10,  2.577795296044220e-12,  2.341482890710773e-14, -2.391836941752812e-15,  8.727539383075483e-17,
 -2.154182077362470e-18,  3.245532170082123e-20,  7.159138442949990e-01, -1.084894438308651e-02,  1.642909690393248e-04, -2.475705439361643e-06,  3.634520042951544e-08,
 -4.749474700760974e-10,  3.262797287452348e-12,  1.170711202626043e-13, -7.529506451386582e-15,  2.731514170821029e-16, -7.390505966429244e-18,  1.456989834512139e-19,
  6.721673436093365e-03, -9.604241952663988e-05,  1.372125876551820e-06, -1.958423543666710e-08,  2.780209793345104e-10, -3.854106027576699e-12,  4.883471112060671e-14,
 -4.288002148971451e-16, -3.422024885239307e-18,  3.241352727915401e-19, -1.074905216038476e-20,  2.395749980597955e-22,  6.142859108617660e-02, -8.777202092087168e-04,
  1.253964372635805e-05, -1.789711933433602e-07,  2.540168848394570e-09, -3.517632375255263e-11,  4.435777164275810e-13, -3.784552345513046e-15, -3.687985782899666e-17,
  3.161336625752977e-18, -1.042151788761187e-19,  2.337954953506306e-21,  1.764112088394329e-01, -2.520643330551390e-03,  3.601110366675831e-05, -5.139256047003076e-07,
  7.290658873796411e-09, -1.007118216728494e-10,  1.255545708131894e-12, -9.957464768520363e-15, -1.442717140003163e-16,  1.045455961657216e-17, -3.411615102168629e-19,
  7.774337753703151e-21,  3.667054760855316e-01, -5.239646461810341e-03,  7.485468165508325e-05, -1.068106783347587e-06,  1.513741236182528e-08, -2.080486792800545e-10,
  2.531580575219593e-12, -1.675141506235153e-14, -4.688528118304850e-16,  2.791812985099241e-17, -9.026959062285152e-19,  2.125891685453242e-20,  6.749716130249442e-01,
 -9.644254981933879e-03,  1.377740437027004e-04, -1.965195830456233e-06,  2.778618440009985e-08, -3.771992523237925e-10,  4.305065929410214e-12, -1.241462602903885e-14,
 -1.680649066471259e-15,  8.272489001284503e-17, -2.702444682382373e-18,  6.896551881012744e-20,  6.358068902392625e-03, -8.593529939238828e-05,  1.161456192933963e-06,
 -1.569306839959639e-08,  2.116591687947779e-10, -2.830247679210638e-12,  3.656408086736783e-14, -4.166399576952909e-16,  2.643390423668699e-18,  6.100801139375858e-20,
 -3.423828574621746e-21,  1.018167450924713e-22,  5.810565217850796e-02, -7.853526454757860e-04,  1.061440113283547e-05, -1.434156058978889e-07,  1.934184545751978e-09,
 -2.585454264146115e-11,  3.334955219955154e-13, -3.773687916053255e-15,  2.266659228575275e-17,  6.140119385907249e-19, -3.313966022526464e-20,  9.826612570392560e-22,
  1.668683654116431e-01, -2.255382811787953e-03,  3.048245975917732e-05, -4.118522543850230e-07,  5.553654880626102e-09, -7.417767168240153e-11,  9.533255120826494e-13,
 -1.060913611353471e-14,  5.500707447926912e-17,  2.148147434208839e-18, -1.078920321929700e-19,  3.185122388454484e-21,  3.468688108109689e-01, -4.688256425333775e-03,
  6.336348558306837e-05, -8.560749963556643e-07,  1.154042847675357e-08, -1.538948593915686e-10,  1.963154603892485e-12, -2.108443950831169e-14,  7.096760579434474e-17,
  6.145654110560917e-18, -2.808867277534731e-19,  8.277230607048175e-21,  6.384595817211663e-01, -8.629371988288894e-03,  1.166278785012389e-04, -1.575553525071643e-06,
  2.122522845649117e-08, -2.819926258767828e-10,  3.532798269934226e-12, -3.448945613409334e-14, -6.820947457394829e-17,  1.927592952481835e-17, -7.966632929272512e-19,
  2.386548282506637e-20,  6.031794303126376e-03, -7.734335697129822e-05,  9.917347527657777e-07, -1.271545798686571e-08,  1.629398333352281e-10, -2.081871762409128e-12,
  2.626676884269017e-14, -3.162035453405843e-16,  3.213191381452123e-18, -1.182079723383098e-20, -7.258409020799476e-22,  3.145009251219373e-23,  5.512386669255463e-02,
 -7.068319325266792e-04,  9.063346071396120e-06, -1.162047663903560e-07,  1.489056715397975e-09, -1.902357393738154e-11,  2.398971439851684e-13, -2.881679307045631e-15,
  2.899676127114760e-17, -9.342610207368016e-20, -7.140227168335932e-21,  3.028461913658428e-22,  1.583052462833555e-01, -2.029886605765203e-03,  2.602818730549266e-05,
 -3.337158177916685e-07,  4.276079785411334e-09, -5.461613729157249e-11,  6.879307421770720e-13, -8.221817479812528e-15,  8.080480982028655e-17, -1.698462917025710e-19,
 -2.394618886328383e-20,  9.753302716322466e-22,  3.290686820648441e-01, -4.219519402966724e-03,  5.410465559463573e-05, -6.936854924539215e-07,  8.887829470932448e-09,
 -1.134649571208752e-10,  1.425827772295896e-12, -1.686596318257327e-14,  1.575561636788070e-16,  6.724957888535325e-20, -6.467569190081188e-20,  2.492740077063679e-21,
  6.056960188504650e-01, -7.766602591503582e-03,  9.958677194802691e-05, -1.276788295563935e-06,  1.635581147749335e-08, -2.085762921960751e-10,  2.606835053719560e-12,
 -3.007818842529857e-14,  2.442541692914790e-16,  2.018347830486390e-18, -1.882846535127186e-19,  6.833082941130895e-21,  5.737380916384401e-03, -6.997845732919750e-05,
  8.535206604211738e-07, -1.041007603936210e-08,  1.269471045913335e-10, -1.546632947056886e-12,  1.876128578142906e-14, -2.236934106101219e-16,  2.509167626497415e-18,
 -2.252240438055331e-20,  1.592275904785296e-23,  6.990719477651234e-24,  5.243325701489787e-02, -6.395249814629610e-04,  7.800225551422217e-06, -9.513640686156634e-08,
  1.160148179237867e-09, -1.413397924632139e-11,  1.714237389398118e-13, -2.042482434359027e-15,  2.284514076031639e-17, -2.023033075358979e-19,  1.784718053005852e-23,
  6.798126164378452e-23,  1.505783279116436e-01, -1.836593928909668e-03,  2.240075884693814e-05, -2.732131995689852e-07,  3.331681010220756e-09, -4.058667924529096e-11,
  4.920753938195581e-13, -5.853525175710037e-15,  6.503575650885358e-17, -5.574067786527652e-19, -8.067079313614426e-22,  2.229166226314459e-22,  3.130067586814330e-01,
 -3.817722715213540e-03,  4.656438287366698e-05, -5.679257593501705e-07,  6.925380296915207e-09, -8.435354840512758e-11,  1.021972919700463e-12, -1.211790621758507e-14,
  1.328181366667447e-16, -1.059865396873765e-18, -5.314105733965790e-21,  5.823021447291299e-22,  5.761318497354593e-01, -7.027041779621504e-03,  8.570807811404876e-05,
 -1.045338212109304e-06,  1.274640841272934e-08, -1.552081034792536e-10,  1.877373901286716e-12, -2.209694241979483e-14,  2.344009365353527e-16, -1.522661092139144e-18,
 -2.591821878876853e-20,  1.614367481786391e-21,  5.470378088170868e-03, -6.361764796234408e-05,  7.398396934885946e-07, -8.603894701847996e-09,  1.000535837933205e-10,
 -1.163183185806676e-12,  1.350356682286559e-14, -1.558229337294039e-16,  1.758383359121650e-18, -1.838342567473036e-20,  1.442187431073016e-22,  3.823286472661379e-25,
  4.999314922191898e-02, -5.813942864191445e-04,  6.761308824332976e-06, -7.862997954119115e-08,  9.143767044402348e-10, -1.063008752357901e-11,  1.234004101294967e-13,
 -1.423651071264293e-15,  1.605055237002084e-17, -1.671969191123002e-19,  1.287814233423000e-21,  4.499999111654897e-24,  1.435708030977770e-01, -1.669653657668794e-03,
  1.941719055370371e-05, -2.258102369427207e-07,  2.625906846403968e-09, -3.052687742634573e-11,  3.543357468546727e-13, -4.085842424572353e-15,  4.596782415583481e-17,
 -4.748022037526422e-19,  3.497176429363785e-21,  1.966188691938888e-23,  2.984402361384313e-01, -3.470704483708953e-03,  4.036245833204869e-05, -4.693907693432200e-07,
  5.458429805566785e-09, -6.345328578532977e-11,  7.363678572641739e-13, -8.482601851601021e-15,  9.503567407000557e-17, -9.648510227791334e-19,  6.431121735166053e-21,
  6.924849130980559e-23,  5.493201685792816e-01, -6.388307361869745e-03,  7.429262786458342e-05, -8.639766885236028e-07,  1.004684875407708e-08, -1.167831638913163e-10,
  1.354627831353162e-12, -1.557016904235434e-14,  1.727902270754766e-16, -1.683120591526418e-18,  8.251751127019560e-21,  2.514890605394962e-22,  5.227127260629735e-03,
 -5.808636334777879e-05,  6.454836450858389e-07, -7.172914499725590e-09,  7.970778088243361e-11, -8.856673852283331e-13,  9.836729019170099e-15, -1.090343824614810e-16,
  1.199090109789018e-18, -1.282638301797627e-20,  1.250797917316099e-22, -8.483637900891894e-25,  4.777010819660195e-02, -5.308445199468709e-04,  5.898999952321909e-06,
 -6.555242882072779e-08,  7.284398682493009e-10, -8.093989268485285e-12,  8.989525552003049e-14, -9.963692924259577e-16,  1.095425220845540e-17, -1.170419776017234e-19,
  1.136301750774152e-21, -7.519989807582996e-24,  1.371866526699965e-01, -1.524484358512281e-03,  1.694080423878375e-05, -1.882540733244469e-07,  2.091938794847825e-09,
 -2.324425238524932e-11,  2.581524648052567e-13, -2.860837286192741e-15,  3.143162346230025e-17, -3.349559851976080e-19,  3.218310253064485e-21, -2.004651243171525e-23,
  2.851695201130538e-01, -3.168941468743691e-03,  3.521480298402205e-05, -3.913231590527096e-07,  4.348500433275261e-09, -4.831719326026010e-11,  5.365824331000456e-13,
 -5.944618107413365e-15,  6.522785194236881e-17, -6.915157210720009e-19,  6.505266095587303e-21, -3.524968822986052e-23,  5.248935965165796e-01, -5.832871203810792e-03,
  6.481767067800222e-05, -7.202836584353452e-07,  8.003984087705077e-09, -8.893219508553273e-11,  9.875024398571008e-13, -1.093314195566552e-14,  1.196216251279898e-16,
 -1.253394366913454e-18,  1.120762343925947e-20, -3.776260408916432e-23,  5.004593336018509e-03, -5.324638129890012e-05,  5.665149682393180e-07, -6.027434831681746e-09,
  6.412867600003781e-11, -6.822795198916580e-13,  7.257992279973487e-15, -7.716097523952608e-17,  8.181401097371193e-19, -8.589793051790941e-21,  8.724472170328738e-23,
 -7.947568085113723e-25,  4.573639653721139e-02, -4.866124869008374e-04,  5.177314413585709e-06, -5.508402550579918e-08,  5.860644595287695e-10, -6.235268844551065e-12,
  6.632965299911726e-14, -7.051482113741967e-16,  7.476038707466885e-18, -7.846374893918126e-20,  7.958540059160410e-22, -7.211636387979000e-24,  1.313462201166813e-01,
 -1.397458384345106e-03,  1.486826092450048e-05, -1.581908268534796e-07,  1.683065163870955e-09, -1.790647634350456e-11,  1.904842142824639e-13, -2.024940663375396e-15,
  2.146420851396610e-17, -2.250877971311324e-19,  2.275898210689334e-21, -2.037000413570870e-23,  2.730290289254483e-01, -2.904892925298784e-03,  3.090661326888478e-05,
 -3.288308264523004e-07,  3.498581600725165e-09, -3.722203183873955e-11,  3.959514073585680e-13, -4.208796963174685e-15,  4.459532825865871e-17, -4.669004418452740e-19,
  4.691753587587756e-21, -4.095106716237061e-23,  5.025473581280288e-01, -5.346853668037570e-03,  5.688785844606531e-05, -6.052581668504303e-07,  6.439613905348621e-09,
 -6.851182449758607e-11,  7.287734119364329e-13, -7.745142412700981e-15,  8.199590987722212e-17, -8.554433869285828e-19,  8.477362744205716e-21, -6.965981899994660e-23,
  4.800237296644761e-03, -4.898711444298651e-05,  4.999205699140826e-07, -5.101761100248589e-09,  5.206416202118755e-11, -5.313186667392492e-13,  5.421949795948848e-15,
 -5.531894925281012e-17,  5.639283297872215e-19, -5.729536024202219e-21,  5.752845822188847e-23, -5.558170336821706e-25,  4.386881045701629e-02, -4.476875424099199e-04,
  4.568715954321938e-06, -4.662440133705803e-08,  4.758083122265461e-10, -4.855658668661004e-12,  4.955051096558538e-14, -5.055500728501973e-16,  5.153504320359668e-18,
 -5.235390555296116e-20,  5.254401871990120e-22, -5.068575130487977e-24,  1.259828685862300e-01, -1.285673357325975e-03,  1.312048208018713e-05, -1.338964001430349e-07,
  1.366430786706048e-09, -1.394452146135783e-11,  1.422992560510786e-13, -1.451821616946839e-15,  1.479876850142238e-17, -1.503004459555064e-19,  1.506962689246781e-21,
 -1.448393168521542e-23,  2.618802447524319e-01, -2.672525695405659e-03,  2.727351023792489e-05, -2.783300787099764e-07,  2.840395685974242e-09, -2.898641727733010e-11,
  2.957955998454551e-13, -3.017810926826625e-15,  3.075772882407312e-17, -3.122293242769100e-19,  3.124477160944325e-21, -2.981644898775779e-23,  4.820264924398868e-01,
 -4.919149926900911e-03,  5.020063453693459e-05, -5.123046577869076e-07,  5.228136692680677e-09, -5.335339396418475e-11,  5.444467322131024e-13, -5.554361502918551e-15,
  5.659662913377242e-17, -5.739179727336392e-19,  5.719165574605125e-21, -5.371309941170640e-23,  4.611918816866458e-03, -4.521923710765180e-05,  4.433684725911499e-07,
 -4.347167515332038e-09,  4.262337741445049e-11, -4.179156959819514e-13,  4.097559028339526e-15, -4.017335824729724e-17,  3.937661695306614e-19, -3.855372719398191e-21,
  3.759507712405384e-23, -3.615789563030632e-25,  4.214778976899967e-02, -4.132533495938564e-04,  4.051892913645306e-06, -3.972825839264384e-08,  3.895300878025949e-10,
 -3.819282788161659e-12,  3.744710438887079e-14, -3.671389943537199e-16,  3.598549560896847e-18, -3.523227479679440e-20,  3.435150945820760e-22, -3.302167026756585e-24,
  1.210404249477576e-01, -1.186784913750042e-03,  1.163626474277496e-05, -1.140919915296104e-07,  1.118656211771490e-09, -1.096825173320870e-11,  1.075408801741114e-13,
 -1.054349026896521e-15,  1.033413051430565e-17, -1.011704467534910e-19,  9.861061953230945e-22, -9.468419664249189e-24,  2.516064006637755e-01, -2.466966557972217e-03,
  2.418827172797624e-05, -2.371627106437966e-07,  2.325347563343579e-09, -2.279967088863407e-11,  2.235446534354897e-13, -2.191655776731988e-15,  2.148066696029750e-17,
 -2.102633553019952e-19,  2.048208631376943e-21, -1.962283720213907e-23,  4.631160739222718e-01, -4.540790153976656e-03,  4.452183014846605e-05, -4.365304806273263e-07,
  4.280120801483528e-09, -4.196590491985554e-11,  4.114635267760830e-13, -4.033979783347763e-15,  3.953482056537421e-17, -3.868668191892334e-19,  3.763755261794345e-21,
 -3.588605424358848e-23,  4.437820950671521e-03, -4.186996212646248e-05,  3.950348036567685e-07, -3.727075150894761e-09,  3.516421443010795e-11, -3.317672592100234e-13,
  3.130148947692929e-15, -2.953180076701385e-17,  2.786004428277128e-19, -2.627404652797826e-21,  2.474527257497897e-23, -2.319304415526563e-25,  4.055672961486724e-02,
 -3.826447150127178e-04,  3.610177133856493e-06, -3.406130639663163e-08,  3.213616662411526e-10, -3.031982372398996e-12,  2.860606515286222e-14, -2.698875683069281e-16,
  2.546090563217130e-18, -2.401124761909397e-20,  2.261319295652329e-22, -2.119132104518761e-24,  1.164712032108935e-01, -1.098882744812201e-03,  1.036774115101159e-05,
 -9.781758479416876e-08,  9.228894981438906e-10, -8.707275724398493e-12,  8.215115748014960e-14, -7.750648893656722e-16,  7.311845243401107e-18, -6.895379980322035e-20,
  6.493283802851017e-22, -6.082794762629149e-24,  2.421083719222250e-01, -2.284244559557396e-03,  2.155139520597923e-05, -2.033331461968314e-07,  1.918407869710153e-09,
 -1.809978951557093e-11,  1.707673342441822e-13, -1.611122124328777e-15,  1.519894841394838e-17, -1.433264823882245e-19,  1.349443272148919e-21, -1.263258621946583e-23,
  4.456336499093899e-01, -4.204465266016584e-03,  3.966829742198053e-05, -3.742625308426024e-07,  3.531092652360255e-09, -3.331514120882506e-11,  3.143204950944512e-13,
 -2.965479385156997e-15,  2.797512922722003e-17, -2.637832154306456e-19,  2.482633876284082e-21, -2.320680152713295e-23,  4.276391271295824e-03, -3.887949773161120e-05,
  3.534791949248468e-07, -3.213712841297740e-09,  2.921798585393610e-11, -2.656399812484160e-13,  2.415106686040033e-15, -2.195722446465631e-17,  1.996223751933846e-19,
 -1.814668223328580e-21,  1.648931326102082e-23, -1.495845403697875e-25,  3.908144254695090e-02, -3.553152086553015e-04,  3.230405257981327e-06, -2.936974794846513e-08,
  2.670197750323569e-10, -2.427652893114909e-12,  2.207137877481497e-14, -2.006644977257699e-16,  1.824324447645173e-18, -1.658398494543168e-20,  1.506915509652120e-22,
 -1.366947018854855e-24,  1.122344597280403e-01, -1.020397607602894e-03,  9.277108653180162e-06, -8.434432248074196e-08,  7.668299381546664e-10, -6.971756714510338e-12,
  6.338479374134731e-14, -5.762700695880148e-16,  5.239104459210790e-18, -4.762567870105092e-20,  4.327421328698507e-22, -3.925036546666741e-24,  2.333014648189498e-01,
 -2.121097719259356e-03,  1.928430041276307e-05, -1.753263127022180e-07,  1.594007295915854e-09, -1.449217150015525e-11,  1.317577879547908e-13, -1.197890436119228e-15,
  1.089048135677979e-17, -9.899793199001368e-20,  8.994798738019656e-22, -8.156698569438400e-24,  4.294233300196615e-01, -3.904171140150809e-03,  3.549539865378198e-05,
 -3.227121145016207e-07,  2.933988949736461e-09, -2.667482792604813e-11,  2.425182364110106e-13, -2.204879413781029e-15,  2.004530944718833e-17, -1.822138846822097e-19,
  1.655389500474054e-21, -1.500490823572613e-23,  4.126295417244719e-03, -3.619835939602768e-05,  3.175539050039436e-07, -2.785774942418985e-09,  2.443850284622313e-11,
 -2.143893245977222e-13,  1.880752485420305e-15, -1.649907798474509e-17,  1.447388613088675e-19, -1.269691011900778e-21,  1.113667717299070e-23, -9.762503245230039e-26,
  3.770973399071861e-02, -3.308125971833835e-04,  2.902088210980676e-06, -2.545887325399671e-08,  2.233406356614800e-10, -1.959279106177392e-12,  1.718797818960691e-14,
 -1.507831508004713e-16,  1.322751394637860e-18, -1.160354783065289e-20,  1.017763492978867e-22, -8.921668209279994e-25,  1.082951740036687e-01, -9.500307741072062e-04,
  8.334244623929667e-06, -7.311303520813333e-08,  6.413917691437194e-10, -5.626676431535770e-12,  4.936059936585890e-14, -4.330204640473873e-16,  3.798688616030860e-18,
 -3.332311066153785e-20,  2.922794003771725e-22, -2.562023388316251e-24,  2.251128823455889e-01, -1.974826374710197e-03,  1.732437153109398e-05, -1.519798665441241e-07,
  1.333259317990920e-09, -1.169615690204130e-11,  1.026057413053851e-13, -9.001183490609495e-16,  7.896317978386558e-18, -6.926839205633233e-20,  6.075491243157849e-22,
 -5.325241548340380e-24,  4.143511213793118e-01, -3.634938677717909e-03,  3.188788085466203e-05, -2.797397797555587e-07,  2.454046554385074e-09, -2.152838015201956e-11,
  1.888599270551535e-13, -1.656790831470593e-15,  1.453423490174057e-17, -1.274969829542139e-19,  1.118235460062922e-21, -9.800225150373743e-24,  3.986380097157924e-03,
 -3.378530876185700e-05,  2.863367416831666e-07, -2.426756854939929e-09,  2.056721325831067e-11, -1.743109361069289e-13,  1.477317362390531e-15, -1.252053403041531e-17,
  1.061136434650745e-19, -8.993238282851741e-22,  7.621576691488402e-24, -6.457661563277273e-26,  3.643106415053970e-02, -3.087600080400061e-04,  2.616798185489779e-06,
 -2.217784870113943e-08,  1.879613703011668e-10, -1.593007375104437e-12,  1.350103157184307e-14, -1.144237037688247e-16,  9.697602064650471e-19, -8.218813916979477e-21,
  6.965261958774646e-23, -5.901549836057900e-25,  1.046230777520882e-01, -8.866999381193269e-04,  7.514946005713464e-06, -6.369055758132520e-08,  5.397892572577007e-10,
 -4.574813783508473e-12,  3.877239125012097e-14, -3.286030796261677e-16,  2.784966349691936e-18, -2.360285559704899e-20,  2.000285207933011e-22, -1.694792124802741e-24,
  2.174797058993726e-01, -1.843180738958261e-03,  1.562129773169734e-05, -1.323933880451006e-07,  1.122058454339813e-09, -9.509652909318360e-12,  8.059606345527352e-14,
 -6.830663046861076e-16,  5.789100912970577e-18, -4.906314255661741e-20,  4.157966591078341e-22, -3.522879719750946e-24,  4.003012136742510e-01, -3.392626837408795e-03,
  2.875314004726549e-05, -2.436881809149628e-07,  2.065302411501262e-09, -1.750381987175833e-11,  1.483481028258300e-13, -1.257277107810143e-15,  1.065563012350684e-17,
 -9.030726094992026e-20,  7.653230857215709e-22, -6.484046250418102e-24,  3.855643380023498e-03, -3.160575787721651e-05,  2.590809970051195e-07, -2.123757426393956e-09,
  1.740901748018832e-11, -1.427064529660849e-13,  1.169803611875411e-15, -9.589197768522311e-18,  7.860522562388783e-20, -6.443467128344889e-22,  5.281815803684139e-24,
 -4.329102272674619e-26,  3.523627649540594e-02, -2.888413459549953e-04,  2.367711104319534e-06, -1.940877215805165e-08,  1.590989863383398e-10, -1.304177678963529e-12,
  1.069069917569984e-14, -8.763456318383005e-17,  7.183640088160290e-19, -5.888609321900442e-21,  4.826988511541005e-23, -3.956310310987152e-25,  1.011918751601528e-01,
 -8.294973342254008e-04,  6.799615348541227e-06, -5.573829713490656e-08,  4.569019875205494e-10, -3.745349906266869e-12,  3.070165191809433e-14, -2.516697741051950e-16,
  2.063004568962719e-18, -1.691096215935951e-20,  1.386218185836904e-22, -1.136173172971573e-24,  2.103472744453536e-01, -1.724273842518009e-03,  1.413434184887600e-05,
 -1.158630459806074e-07,  9.497609132216978e-10, -7.785448617324262e-12,  6.381943991181494e-14, -5.231452684662692e-16,  4.288361776916480e-18, -3.515276201344352e-20,
  2.881524170119602e-22, -2.361745387098436e-24,  3.871729957760108e-01, -3.173762393195846e-03,  2.601619389355499e-05, -2.132618201508440e-07,  1.748165166418499e-09,
 -1.433018550872561e-11,  1.174684281645452e-13, -9.629205739252300e-16,  7.893317088615302e-18, -6.470344564914861e-20,  5.303826460242151e-22, -4.347062291922319e-24,
  3.733210649936472e-03, -2.963052244148665e-05,  2.351776908624988e-07, -1.866607191571936e-09,  1.481527603560026e-11, -1.175889629841291e-13,  9.333045265254414e-16,
 -7.407645269703455e-18,  5.879453204217216e-20, -4.666523435467443e-22,  3.703810101236516e-24, -2.939482802298817e-26,  3.411737801226677e-02, -2.707898989986961e-04,
  2.149261569085155e-06, -1.705870606480696e-08,  1.353950848905395e-10, -1.074631858839165e-12,  8.529361537923834e-15, -6.769760869480756e-17,  5.373163900517489e-19,
 -4.264681438488615e-21,  3.384868704676616e-23, -2.686358073186086e-25,  9.797861181669301e-02, -7.776570165601649e-04,  6.172269888214043e-06, -4.898935489760440e-08,
  3.888288970973965e-10, -3.086138029247169e-12,  2.449470187249372e-14, -1.944146386469327e-16,  1.543070328925410e-18, -1.224735244899808e-20,  9.720696482051323e-23,
 -7.714701850573309e-25,  2.036678727117440e-01, -1.616513515811884e-03,  1.283028055436403e-05, -1.018340381896946e-07,  8.082575661379087e-10, -6.415146690121487e-12,
  5.091706985464273e-14, -4.041291776245057e-16,  3.207576044471410e-18, -2.545853650293342e-20,  2.020637842436722e-22, -1.603650310344900e-24,  3.748786411854312e-01,
 -2.975414738696289e-03,  2.361589030320558e-05, -1.874395080317779e-07,  1.487708857004518e-09, -1.180795695502667e-11,  9.371984741191759e-14, -7.438551525918514e-16,
  5.903983329290623e-18, -4.685992096093620e-20,  3.719258507496097e-22, -2.951728596415393e-24,  };
  constexpr double w[1920] = {  5.556471639830202e-01, -1.707743567554543e-02,  6.010297533195059e-04, -2.141050577561195e-05,  7.411885932341078e-07,
 -2.477415246769695e-08,  8.000210532424675e-10, -2.505045109383974e-11,  7.617657068347102e-13, -2.257919159670135e-14,  6.522815734076673e-16, -1.832784545034155e-17,
  4.490360159053517e-01, -4.133350951223668e-02,  3.197563458385448e-03, -2.054437774592271e-04,  1.157734416333559e-05, -5.885694466689300e-07,  2.745674027615711e-08,
 -1.188816881791059e-09,  4.816612998847584e-11, -1.837202228959463e-12,  6.628083240048359e-14, -2.267663929128982e-15,  3.020000558977205e-01, -5.983961037079307e-02,
  7.479315187657782e-03, -7.083057654866716e-04,  5.518098292668621e-05, -3.692213995566633e-06,  2.179132249923556e-07, -1.155033233065470e-08,  5.569785055573944e-10,
 -2.467426484643119e-11,  1.011838631139328e-12, -3.859841979776170e-14,  1.710234573057120e-01, -5.336343219608752e-02,  9.303000864084201e-03, -1.151691324054498e-03,
  1.118437333696190e-04, -8.993454356704473e-06,  6.194143209914280e-07, -3.739640784642523e-08,  2.012711796812155e-09, -9.781230309396670e-11,  4.335486088100624e-12,
 -1.764725024571656e-13,  6.765529812863690e-02, -2.640795757908088e-02,  5.541574574341993e-03, -7.979985981977880e-04,  8.772442759175873e-05, -7.814004371034196e-06,
  5.858265007662569e-07, -3.795239655221377e-08,  2.166039565892450e-09, -1.105245036058475e-10,  5.101207417733165e-12, -2.146848295395904e-13,  4.955689679735768e-01,
 -1.312718901889837e-02,  4.017358940061909e-04, -1.266916387112285e-05,  3.924942221486956e-07, -1.183953845922018e-08,  3.461742789005694e-10, -9.878757547283288e-12,
  2.744029494869871e-13, -7.410828344446979e-15,  1.990916448126453e-16, -5.166747508671766e-18,  3.227524806425064e-01, -2.317299783033763e-02,  1.546397811934342e-03,
 -8.739276219867694e-05,  4.393970445361141e-06, -2.015919396659677e-07,  8.568307297210656e-09, -3.407416262165182e-10,  1.277126901321901e-11, -4.535502852930314e-13,
  1.532157120652235e-14, -4.936338150566158e-16,  1.440700829903389e-01, -2.318891170204981e-02,  2.528977801964457e-03, -2.140330255923062e-04,  1.516887974812536e-05,
 -9.356318629176818e-07,  5.144435160299145e-08, -2.562482645708939e-09,  1.169809735552248e-10, -4.937215185602498e-12,  1.939526467791076e-13, -7.122424471747080e-15,
  4.876701248118452e-02, -1.357275561183466e-02,  2.171034001113994e-03, -2.508382241193754e-04,  2.301697260805087e-05, -1.765175307172596e-06,  1.167989854436161e-07,
 -6.814462494452397e-09,  3.561313080475521e-10, -1.687232554291595e-11,  7.315041914589709e-13, -2.920723029653744e-14,  1.266181519386198e-02, -4.783334718410587e-03,
  9.759768555417994e-04, -1.373064699432439e-04,  1.480283598675052e-05, -1.296971312790101e-06,  9.587078738837921e-08, -6.135411159589555e-09,  3.464427667812651e-10,
 -1.751215784416458e-11,  8.015543506300008e-13, -3.348400785307556e-14,  4.486553212904784e-01, -1.043013054903234e-02,  2.808135796866044e-04, -7.911058656867674e-06,
  2.206318873649870e-07, -6.059249747888569e-09,  1.612217492777462e-10, -4.185779786423095e-12,  1.091600197246989e-13, -2.641038535283938e-15,  6.424353866472265e-17,
 -1.662533472955526e-18,  2.495194586109282e-01, -1.404863114032381e-02,  8.154331379262732e-04, -4.074258444283927e-05,  1.832961727227427e-06, -7.597518077554352e-08,
  2.942740966642307e-09, -1.074060615457292e-10,  3.716472111503560e-12, -1.226657045878197e-13,  3.869751078790188e-15, -1.169116980487237e-16,  7.989253711800848e-02,
 -1.018724316184034e-02,  9.645238180722636e-04, -7.240993829700913e-05,  4.635639255983888e-06, -2.617332292018923e-07,  1.331499163051429e-08, -6.191017160150211e-10,
  2.658107820340445e-11, -1.062143430741631e-12,  3.973261385417937e-14, -1.396609803173216e-15,  1.639221424801860e-02, -3.925655370817589e-03,  5.650101966187369e-04,
 -6.000053408358681e-05,  5.138500064099983e-06, -3.719808069452131e-07,  2.344015437197780e-08, -1.311681580119242e-09,  6.613155204194315e-11, -3.037216019337787e-12,
  1.281689361863826e-13, -4.998443088541948e-15,  2.548378437797335e-03, -9.180328358346161e-04,  1.802192032797159e-04, -2.457650110269247e-05,  2.582750405608613e-06,
 -2.215278460457454e-07,  1.608346854660366e-08, -1.013597989016389e-09,  5.647962781548023e-11, -2.822140511793096e-12,  1.278676032859275e-13, -5.293835186650329e-15,
  4.109006654477402e-01, -8.511357481733425e-03,  2.036494966744811e-04, -5.173917994407771e-06,  1.303686106375562e-07, -3.274780325354138e-09,  8.147121752349397e-11,
 -1.834364223238849e-12,  4.664750445832654e-14, -1.120425943454778e-15,  1.982544566044685e-17, -5.368292539220617e-19,  2.038532342018206e-01, -9.077044472549155e-03,
  4.624650761543175e-04, -2.055806224164638e-05,  8.314749035887953e-07, -3.121636605055834e-08,  1.102720345337537e-09, -3.703880841021148e-11,  1.181184554852979e-12,
 -3.615210020981666e-14,  1.067703349980301e-15, -3.015235095644281e-17,  5.044162012364532e-02, -4.994400780675926e-03,  4.113756741695012e-04, -2.728324519395876e-05,
  1.571361631895349e-06, -8.082629519326940e-08,  3.784369313122931e-09, -1.634358961089901e-10,  6.562865511158005e-12, -2.469016316948489e-13,  8.749455926587212e-15,
 -2.928007949839915e-16,  6.588558581918015e-03, -1.302900136392677e-03,  1.657863903886243e-04, -1.593591311187913e-05,  1.258010208617997e-06, -8.504667728083711e-08,
  5.056176567702456e-09, -2.691627873440917e-10,  1.299762636316352e-11, -5.750042924301331e-13,  2.348594039725536e-14, -8.902030509833163e-16,  5.668744198392726e-04,
 -1.902085399176281e-04,  3.539013560043812e-05, -4.627235237857316e-06,  4.701239711324377e-07, -3.922222709101478e-08,  2.782682873497472e-09, -1.719838259778540e-10,
  9.425072982201877e-12, -4.642317319556864e-13,  2.077250380919097e-14, -8.506446148702849e-16,  3.797646852297503e-01, -7.099412641651424e-03,  1.522192886751069e-04,
 -3.520606358845598e-06,  8.099618018565664e-08, -1.799882505180741e-09,  4.581951562857801e-11, -8.696120776331965e-13,  1.646678799263188e-14, -6.321029511449510e-16,
  8.161252330153123e-18, -3.890893811545082e-20,  1.736487649857190e-01, -6.177540683095421e-03,  2.788379350840060e-04, -1.109984494843272e-05,  4.056653610998215e-07,
 -1.388630898481905e-08,  4.457007258155080e-10, -1.385839997450103e-11,  4.106131123451155e-13, -1.147547523905985e-14,  3.189643025986166e-16, -8.548109305594107e-18,
  3.544660329649685e-02, -2.682670575893021e-03,  1.940541799320406e-04, -1.135340996492868e-05,  5.873433956174566e-07, -2.748754346258905e-08,  1.178755241965388e-09,
 -4.715440523692800e-11,  1.765372560277030e-12, -6.216033734424118e-14,  2.078826194380101e-15, -6.597405533155408e-17,  3.172778780067353e-03, -4.957672655206969e-04,
  5.515524964123484e-05, -4.732460782919768e-06,  3.405005791029528e-07, -2.128335056815660e-08,  1.182676651331249e-09, -5.940163855237325e-11,  2.726837650070606e-12,
 -1.154064757841775e-13,  4.534764701756674e-15, -1.661413760421348e-16,  1.446464293938970e-04, -4.354961732673910e-05,  7.524740441461091e-06, -9.294275258000307e-07,
  9.029414009585002e-08, -7.265462925915170e-09,  5.003308971960573e-10, -3.016312528722203e-11,  1.618581233685109e-12, -7.830217442600781e-14,  3.449776996510680e-15,
 -1.393810884344132e-16,  3.535629158016994e-01, -6.031001733088744e-03,  1.167326805436872e-04, -2.460354459150994e-06,  5.424973981618138e-08, -9.515921538081363e-10,
  2.588929465336235e-11, -6.404594673343283e-13,  1.735156461574152e-16, -2.327349654103705e-16,  1.405176632763441e-17,  2.552605766379450e-19,  1.526884381213183e-01,
 -4.387181193500834e-03,  1.769960037626504e-04, -6.359183423230122e-06,  2.098004671829854e-07, -6.670215121156174e-09,  1.935478869338787e-10, -5.455338746415411e-12,
  1.580376663295386e-13, -3.997874540924131e-15,  9.594833317292478e-17, -2.753735719854156e-18,  2.713871022206461e-02, -1.549077700586618e-03,  1.000371856655625e-04,
 -5.172674027614596e-06,  2.394771868365219e-07, -1.026652843309380e-08,  4.011488491117148e-10, -1.476800299965299e-11,  5.189764098029913e-13, -1.698924156978838e-14,
  5.305766860098105e-16, -1.610759075547572e-17,  1.810519130421615e-03, -2.136250185435374e-04,  2.079736340135807e-05, -1.574872550407946e-06,  1.022529041943521e-07,
 -5.867003524278695e-09,  3.020368011821765e-10, -1.419881269987646e-11,  6.154985336378368e-13, -2.474216879747502e-14,  9.293091929789727e-16, -3.273525379007410e-17,
  4.432192598664019e-05, -1.129950034145917e-05,  1.769332699061954e-06, -2.025379171890301e-07,  1.855231362158120e-08, -1.424217976367008e-09,  9.437800244841735e-11,
 -5.511574641011548e-12,  2.879693092824289e-13, -1.361919376021193e-14,  5.885168643743539e-16, -2.338442323122048e-17,  3.311388089104130e-01, -5.201738900596616e-03,
  9.188094344747560e-05, -1.716996575252671e-06,  3.996493349085468e-08, -5.481744499927990e-10,  7.663030417621077e-12, -6.415366837065021e-13,  4.037143018460644e-15,
  4.687251414243980e-16,  1.612499053305087e-17, -4.206521073574973e-19,  1.375573424587829e-01, -3.228108548919726e-03,  1.171214279718435e-04, -3.860361165551506e-06,
  1.129441403729246e-07, -3.398092381233945e-09,  9.410138663325916e-11, -2.150990544469951e-12,  6.088622139713200e-14, -1.847872229646361e-15,  2.736477946858342e-17,
 -5.453798838056930e-19,  2.222482441197988e-02, -9.447196244935991e-04,  5.555724685930175e-05, -2.573445429573921e-06,  1.046693989049808e-07, -4.171421292035248e-09,
  1.509364593929430e-10, -4.926940442587890e-12,  1.640006530616289e-13, -5.224720432708299e-15,  1.426078571709606e-16, -4.073422739908251e-18,  1.199157432682360e-03,
 -1.019248521275626e-04,  8.827007922258764e-06, -5.873022307571381e-07,  3.395887696116369e-08, -1.785770570971748e-09,  8.473598970353921e-11, -3.686994723896485e-12,
  1.503305872778586e-13, -5.717156512796376e-15,  2.030104152736781e-16, -6.850067671027799e-18,  1.707148941426636e-05, -3.386257014457967e-06,  4.702416654607590e-07,
 -4.877144741385304e-08,  4.140415285930752e-09, -2.994164914680646e-10,  1.888915441692833e-11, -1.059242373754320e-12,  5.351527923954286e-14, -2.459768207619525e-15,
  1.037368433640525e-16, -4.037891333968986e-18,  3.116857516678312e-01, -4.539033485107595e-03,  7.476864117458006e-05, -1.160884591570571e-06,  2.953913554498935e-08,
 -5.465392139307763e-10, -5.399739927627668e-12, -1.787674586122316e-13,  2.439884002558856e-14,  3.620434167351159e-16, -2.740680010909756e-17, -1.119636767132220e-18,
  1.262629209175291e-01, -2.450169629943625e-03,  7.974647916111803e-05, -2.491476573457746e-06,  6.359050812240642e-08, -1.696772652782121e-09,  5.252389040096861e-11,
 -1.074869421748708e-12,  1.237412386607776e-14, -8.098476277344671e-16,  3.129390406837039e-17,  3.279598398159775e-19,  1.917248410235459e-02, -6.005750259304966e-04,
  3.250191839764523e-05, -1.407473351952928e-06,  4.873906015442290e-08, -1.752819985826120e-09,  6.443339864296350e-11, -1.851196669220508e-12,  4.816028258933343e-14,
 -1.775290943481703e-15,  5.389812763742015e-17, -7.364018186419105e-19,  8.982475445560644e-04, -5.240055849684038e-05,  4.141996966720765e-06, -2.464900021006325e-07,
  1.238570107827438e-08, -5.932742750576413e-10,  2.639867816719756e-11, -1.046892447495275e-12,  3.920473539707738e-14, -1.441236563231989e-15,  4.847934885272369e-17,
 -1.483468921181748e-18,  8.487515477254186e-06, -1.173104483064674e-06,  1.436389247758014e-07, -1.322494359783945e-08,  1.017970766226966e-09, -6.843653824291410e-11,
  4.065858330246243e-12, -2.163898686328104e-13,  1.048058617835580e-14, -4.655296457530455e-16,  1.903080829593440e-17, -7.211247624459092e-19,  2.946478765779798e-01,
 -3.989450394512636e-03,  6.328958747727036e-05, -7.827955816624183e-07,  1.738054397095718e-08, -6.452669854586864e-10,  5.870234682473787e-13,  5.384565657259838e-13,
  1.159474723415129e-14, -1.039992502607913e-15, -2.140092579785948e-17,  1.595124178779957e-18,  1.175703536611289e-01, -1.916674627648957e-03,  5.502884349773112e-05,
 -1.686705361429088e-06,  3.997271042606763e-08, -7.705363837968452e-10,  2.538487203332900e-11, -8.945941054951708e-13,  6.157012349746536e-15,  3.679043684881696e-16,
  1.630096723754531e-17, -1.091869878265088e-18,  1.719904337094213e-02, -3.970567626040553e-04,  1.936450584014105e-05, -8.391898887929634e-07,  2.564733668746555e-08,
 -6.998157991819713e-10,  2.721726849717802e-11, -9.709119003665479e-13,  1.637318247997044e-14, -1.820341222133309e-16,  2.366079792511277e-17, -9.287547716594698e-19,
  7.399828360029382e-04, -2.844623072809622e-05,  2.070884340468338e-06, -1.167383096243882e-07,  5.051066810568550e-09, -2.068262541852705e-10,  8.932772551633701e-12,
 -3.454197314842678e-13,  1.092970247775361e-14, -3.528377407864716e-16,  1.342042438047218e-17, -4.109270957478676e-19,  5.375539459617286e-06, -4.594972564480379e-07,
  5.033565754107113e-08, -4.120316480471781e-09,  2.795523742040035e-10, -1.711329662582527e-11,  9.544482567631527e-13, -4.779909589848465e-14,  2.177270864423834e-15,
 -9.270648244866912e-17,  3.692530457273482e-18, -1.348066964691801e-19,  2.796486359803386e-01, -3.516929329619209e-03,  5.515597053561410e-05, -6.017749796924693e-07,
  5.897811226918668e-09, -4.450529600386653e-10,  1.493821714987388e-11,  2.982484476118509e-13, -2.256939357070130e-14, -4.016877818041681e-16,  4.296556059178370e-17,
  2.933810866200600e-19,  1.106699544247310e-01, -1.547529343277638e-03,  3.820251950115437e-05, -1.145260468636903e-06,  2.880088760536493e-08, -4.253342947200280e-10,
  5.410811918765377e-12, -4.578459091686418e-13,  1.929105252358905e-14,  8.695809254198811e-17, -2.280732663880241e-17, -1.377972786436145e-19,  1.586555564742835e-02,
 -2.763205711242939e-04,  1.138669697339809e-05, -5.135193280947497e-07,  1.627858804767192e-08, -3.152009819397729e-10,  7.204420297253959e-12, -4.515312719060986e-13,
  1.684913547707543e-14, -3.419798798110359e-17, -1.132627488607835e-17, -2.812382072840148e-19,  6.520634402029348e-04, -1.636126839973515e-05,  1.048613867933331e-06,
 -6.006262938556163e-08,  2.440423309653376e-09, -7.778177724556186e-11,  2.809554823383040e-12, -1.250988874936262e-13,  4.363281756935829e-15, -8.863958653279523e-17,
  1.789391573849744e-18, -1.283268124915683e-19,  4.110814788200319e-06, -1.982708086050064e-07,  1.949373426426675e-08, -1.485778869298221e-09,  8.850510371154932e-11,
 -4.688303313817335e-12,  2.408116434209586e-13, -1.165817069362428e-14,  5.004551898943246e-16, -1.928885210051328e-17,  7.266482144855325e-19, -2.741436692825074e-20,
  2.664192213897245e-01, -3.103504592750405e-03,  4.827430614571139e-05, -5.578249198550832e-07,  8.219444960719093e-10, -6.987654608202710e-11,  1.323674745454090e-11,
 -3.536322003681056e-13, -1.104594781158474e-14,  7.519447108828668e-16,  2.906248980086496e-18, -1.271602812943607e-18,  1.050142820995610e-01, -1.289665115440287e-03,
  2.695748443103510e-05, -7.485707629009059e-07,  2.090508710679501e-08, -3.826503411427034e-10,  5.369349531429370e-13,  5.262284984025726e-14,  9.042868793121084e-15,
 -4.900152266146153e-16,  1.400147536661372e-19,  6.901934577615270e-19,  1.490910834881533e-02, -2.058832560173901e-04,  6.600404677033658e-06, -2.973488479173020e-07,
  1.097764717382209e-08, -2.374843658535437e-10,  1.282410902346681e-12, -1.959694683495121e-14,  8.017374344728646e-15, -3.704608743616969e-16,  1.617159710845615e-19,
  4.661649263226552e-19,  5.996366812507688e-04, -1.029087502597773e-05,  5.200280592200229e-07, -3.073889292702879e-08,  1.345543588735577e-09, -3.925432681053446e-11,
  8.378599338540361e-13, -2.946050167054994e-14,  1.735325686657135e-15, -6.359981702378300e-17,  6.372276160327425e-19,  2.933668877350114e-20,  3.543330529860664e-06,
 -9.509336526808246e-08,  7.844221445988759e-09, -5.908645792714728e-10,  3.330065344746640e-11, -1.503763559134069e-12,  6.366947024393930e-14, -2.881040690894490e-15,
  1.295621228391917e-16, -4.947407243768856e-18,  1.524624706133434e-19, -4.502224704415327e-21,  2.547354914963884e-01, -2.743874788664271e-03,  4.165885834337738e-05,
 -5.423688128891614e-07,  1.694420878483041e-09,  1.126072407757392e-10,  2.106530846631277e-12, -3.351167386177381e-13,  8.666786619924166e-15,  2.039849825403703e-16,
 -1.842431288876275e-17,  2.521255126291222e-19,  1.002373215245723e-01, -1.104823352468190e-03,  1.973359158489146e-05, -4.737224572270288e-07,  1.360422393494381e-08,
 -3.344425122989859e-10,  3.688860421040158e-12,  1.052169141478200e-13, -3.506560374563779e-15, -1.376770820697939e-16,  1.086734454051326e-17, -1.603174992588528e-19,
  1.417233724512195e-02, -1.647162906746637e-04,  3.935165233378598e-06, -1.578472420345273e-07,  6.591736085986273e-09, -1.957445601930481e-10,  2.518370314806810e-12,
  5.583506612627509e-14, -1.694862193661846e-15, -1.177556392620413e-16,  7.969623992987341e-18, -1.069356993205834e-19,  5.649031843626779e-04, -7.293719265678056e-06,
  2.574154673779042e-07, -1.459079519229635e-08,  7.190048570223457e-10, -2.465282531182598e-11,  4.940576869751489e-13, -3.541903519034152e-15,  1.413195103477665e-16,
 -2.188060107336828e-17,  1.077993539405402e-18, -1.549312980767254e-20,  3.253879703720203e-06, -5.349779613018167e-08,  3.168629850485613e-09, -2.363863469946531e-10,
  1.382321902429154e-11, -6.052561776597322e-13,  2.094800030593773e-14, -6.913280206574065e-16,  2.838669090602047e-17, -1.315486165867288e-18,  5.040854323457935e-20,
 -1.303228039080826e-21,  2.443861964552834e-01, -2.436001117617014e-03,  3.538905551078807e-05, -4.970778482594774e-07,  3.866662281937103e-09,  8.434166925608106e-11,
 -3.127697949972488e-12, -5.122736708174783e-14,  6.721134755050516e-15, -1.930905519313994e-16, -1.407868130271880e-18,  2.958466069982765e-19,  9.610236065638279e-02,
 -9.664661258533776e-04,  1.515189000236861e-05, -3.040145015000018e-07,  7.963877739984495e-09, -2.252621497566177e-10,  4.810959290449008e-12, -2.111787300835296e-14,
 -3.001716983761407e-15,  9.672863889590316e-17,  9.601448023018932e-19, -1.683126632142530e-19,  1.356660671655310e-02, -1.392928036945414e-04,  2.556367791477144e-06,
 -8.002428847476988e-08,  3.366627412597423e-09, -1.246970833335680e-10,  3.050206407359744e-12, -1.774359451805772e-14, -1.851232799120893e-15,  5.969127720753490e-17,
  8.962260333840338e-19, -1.238557598004651e-19,  5.389698323442656e-04, -5.772625381119326e-06,  1.370813810162354e-07, -6.418161426947276e-09,  3.369947271845234e-10,
 -1.394579116374436e-11,  3.893766561992481e-13, -5.012511350209709e-15, -8.543827080397813e-17,  3.080440739467809e-18,  1.826000633268679e-19, -1.542783643993183e-20,
  3.076907202585200e-06, -3.650466367323250e-08,  1.333515035519852e-09, -8.991833593277981e-11,  5.565009292695214e-12, -2.644923513738687e-13,  9.386227483037360e-15,
 -2.489448196757019e-16,  5.734016918662406e-18, -2.027098313740193e-19,  1.106681612408739e-20, -5.034153264951083e-22,  2.351722582234489e-01, -2.175595908037975e-03,
  2.983731567115860e-05, -4.259275277913320e-07,  4.785228831161096e-09,  1.005020416010346e-11, -2.562214817465048e-12,  5.993120101736682e-14,  8.027982490894863e-16,
 -1.052783934017146e-16,  3.436511054398606e-18, -2.212309228203373e-20,  9.245847734542803e-02, -8.579808137753888e-04,  1.213896804039630e-05, -2.067157481669968e-07,
  4.522963748863036e-09, -1.245475189503520e-10,  3.387824623393950e-12, -6.440489622091146e-14,  3.752237126824332e-18,  5.268552145716133e-17, -1.832743059734216e-18,
  1.092042455098735e-20,  1.304532948601107e-02, -1.219322395589423e-04,  1.849162200272359e-06, -4.239552883447806e-08,  1.538536294673738e-09, -6.212330883369569e-11,
  2.049414480055494e-12, -4.337136060513392e-14,  7.402082151754166e-17,  3.393653357452431e-17, -1.217720575729710e-18,  6.196497416475500e-21,  5.176901573416703e-04,
 -4.910536335106763e-06,  8.471512561954140e-08, -2.801511782185357e-09,  1.390960740858380e-10, -6.467289531912572e-12,  2.315322536702602e-13, -5.537642802798435e-15,
  4.608730656576278e-17,  2.430758881139922e-18, -1.005383260850679e-19,  9.600026843538994e-24,  2.947085274783859e-06, -2.897192838120866e-08,  6.480993017291011e-10,
 -3.301771172312059e-11,  2.050072285530674e-12, -1.066876046676024e-13,  4.300325485039137e-15, -1.291997614701343e-16,  2.680377765263687e-18, -3.350047676330408e-20,
  6.094446751830960e-22, -6.035203128373455e-23,  2.269167350296173e-01, -1.956043836732885e-03,  2.518298210826916e-05, -3.505103201941749e-07,  4.510575170694033e-09,
 -3.103534614724722e-11, -9.242051447020416e-13,  4.805853887535858e-14, -9.630311470226750e-16, -7.790067674151021e-18,  1.293410450687306e-18, -4.716514488484253e-20,
  8.920658692596307e-02, -7.697247692438089e-04,  1.002305721349215e-05, -1.504533114788222e-07,  2.704814370771333e-09, -6.357833444605703e-11,  1.780454155870987e-12,
 -4.626701310993787e-14,  8.193731044341036e-16,  6.962772042966787e-19, -6.797515574108737e-19,  2.574693805055591e-20,  1.258445080844045e-02, -1.088344999552375e-04,
  1.454679354793555e-06, -2.544296698879459e-08,  6.945950982136328e-10, -2.642328473526459e-11,  9.912913988434267e-13, -2.967247744410259e-14,  5.755034121301826e-16,
 -6.312772060035753e-19, -4.432491630077963e-19,  1.756053321740302e-20,  4.992331611106477e-04, -4.337569263510657e-06,  6.102469183443801e-08, -1.357768455389507e-09,
  5.386691100447885e-11, -2.549758667932276e-12,  1.051686292348590e-13, -3.357654191623681e-15,  7.260598255391771e-17, -4.899097154798953e-19, -3.547717347524852e-20,
  1.627659185731016e-21,  2.839670465640329e-06, -2.494554205990483e-08,  3.934743313236754e-10, -1.274786648478402e-11,  7.010749525720154e-13, -3.822591193707785e-14,
  1.717978271560240e-15, -6.081635925555062e-17,  1.616162135614217e-18, -2.799502005783592e-20,  1.194692059756529e-22,  7.427603964007780e-24,  2.194705110783958e-01,
 -1.770230588178323e-03,  2.138658406021303e-05, -2.841175990559027e-07,  3.758971000512960e-09, -4.054131429456791e-11, -1.218302483620278e-15,  1.934577514439809e-14,
 -7.112041368277833e-16,  1.349032733963222e-17,  2.874734218844570e-20, -1.260303135239429e-20,  8.627755013873085e-02, -6.961098898336258e-04,  8.441761089828807e-06,
 -1.154154143318034e-07,  1.770507933257665e-09, -3.354654858409412e-11,  8.294689159506561e-13, -2.303998862195729e-14,  5.729325964791435e-16, -9.863356529116876e-18,
  1.016085431302518e-20,  6.802798434944566e-21,  1.217067683059342e-02, -9.826241709262910e-05,  1.202108510730348e-06, -1.751077320564441e-08,  3.470695842891953e-10,
 -1.063177846402418e-11,  3.979910104072871e-13, -1.378268728950652e-14,  3.814866221151873e-16, -7.102834759514519e-18,  2.130195224055799e-20,  4.409560391991109e-21,
  4.827726144828513e-04, -3.903017922963315e-06,  4.858751411258311e-08, -7.942410461387557e-10,  2.175898991653946e-11, -9.144003720435384e-13,  3.977141636747496e-14,
 -1.474280610297067e-15,  4.302072341989503e-17, -8.785477589155603e-19,  6.518603902241475e-21,  3.591435135543042e-22,  2.745422947643006e-06, -2.226498881161279e-08,
  2.884767656195148e-10, -5.891885132521894e-12,  2.373584684124071e-13, -1.246849079723710e-14,  5.975347512652174e-16, -2.375047268937716e-17,  7.583555911188128e-19,
 -1.849806049786364e-20,  2.926796638435329e-22, -3.336290993337660e-25,  2.127115442345177e-01, -1.611814007275985e-03,  1.831167589514028e-05, -2.303187005028915e-07,
  2.980304112598036e-09, -3.620550577939701e-11,  2.919221744370670e-13,  3.845883974068451e-15, -2.870459560567568e-16,  8.881948711304757e-18, -1.656841393278508e-19,
  5.112632858193455e-22,  8.362002752090146e-02, -6.336790781837512e-04,  7.207589301015601e-06, -9.155926044031553e-08,  1.255755386311094e-09, -1.962354024615225e-11,
  3.906144705825747e-13, -9.917671813155936e-15,  2.688388390618665e-16, -6.420915995785152e-18,  1.102233885188431e-19, -4.526732166676181e-22,  1.179564560939794e-02,
 -8.940501252165525e-05,  1.019656903866365e-06, -1.324906827167427e-08,  2.048634896386333e-10, -4.555067335102202e-12,  1.472442063232676e-13, -5.254760194694079e-15,
  1.684959299131589e-16, -4.375978524810505e-18,  8.030667048577673e-20, -4.695881472367878e-22,  4.678844552543792e-04, -3.547635427435591e-06,  4.067759058058207e-08,
 -5.521279145167812e-10,  1.036071560434724e-11, -3.265835511832118e-13,  1.348466871782815e-14, -5.349561248776366e-16,  1.806445117745211e-17, -4.903941004510664e-19,
  9.712201255937153e-21, -8.861753758232234e-23,  2.660602213548785e-06, -2.019026062938478e-08,  2.343406772589790e-10, -3.493796713167529e-12,  8.937856514238551e-14,
 -3.902639421032309e-15,  1.876315585343927e-16, -7.998393740294011e-18,  2.864680854834463e-19, -8.409919159836199e-21,  1.932051469538574e-22, -2.993728428978658e-24,
  2.065408459400458e-01, -1.475617696480244e-03,  1.581136059666108e-05, -1.880247592428260e-07,  2.330707511373587e-09, -2.869318808395745e-11,  3.105025957194860e-13,
 -1.402968908167095e-15, -7.329001368310910e-17,  3.475187169180695e-18, -9.642210647905843e-20,  1.790150499279208e-21,  8.119412068921940e-02, -5.800985676446328e-04,
  6.217907846708347e-06, -7.417695459408835e-08,  9.387623462948824e-10, -1.279374846487319e-11,  2.042933621016079e-13, -4.231712589812314e-15,  1.079549407425611e-16,
 -2.828844291401536e-18,  6.509102210413852e-20, -1.124558865783808e-21,  1.145340399452033e-02, -8.183387562839121e-05,  8.778366467395956e-07, -1.054877751596920e-08,
  1.397904845475496e-10, -2.302299430323013e-12,  5.600376967878778e-14, -1.822483202368619e-15,  6.119920497262570e-17, -1.827393165886673e-18,  4.497602680068188e-20,
 -8.219227968663295e-22,  4.543062353126356e-04, -3.246302053987459e-06,  3.487660617685929e-08, -4.251276815705512e-10,  6.129524462898885e-12, -1.312231396044710e-13,
  4.428375061295747e-15, -1.732878939350233e-16,  6.289624835240521e-18, -1.957023048574369e-19,  5.001310514220351e-21, -9.724429171084622e-23,  2.583353212482831e-06,
 -1.846358220722512e-08,  1.990422262933869e-10, -2.504106888133412e-12,  4.255769018481947e-14, -1.283649486909301e-15,  5.570405848261203e-17, -2.428184467560512e-18,
  9.326667545447458e-20, -3.053074031259129e-21,  8.350735848224762e-23, -1.834335198070390e-24,  2.008779077474727e-01, -1.357559112027003e-03,  1.376114025180295e-05,
 -1.549363302019535e-07,  1.827218003121920e-09, -2.188498359326988e-11,  2.527127413177234e-13, -2.350475967819571e-15, -7.432883918798999e-19,  9.544692256575721e-19,
 -3.611824459812618e-20,  9.256438976206229e-22,  7.896791230767554e-02, -5.336783462382203e-04,  5.410229161099891e-06, -6.097166775879875e-08,  7.239965580537392e-10,
 -9.000576564409050e-12,  1.219222731431007e-13, -1.992434768241262e-15,  4.236311443358281e-17, -1.067844079048739e-18,  2.691444516767888e-20, -5.976710176471916e-22,
  1.113936174611698e-02, -7.528259813021520e-05,  7.633489454392897e-07, -8.621507076195111e-09,  1.039776795677309e-10, -1.399266636279673e-12,  2.460081928355634e-14,
 -6.333435441981995e-16,  2.013731922141730e-17, -6.339196529960827e-19,  1.772955059882520e-20, -4.161125508239010e-22,  4.418488728133219e-04, -2.986196825447615e-06,
  3.029192647584113e-08, -3.435882578996281e-10,  4.269181003610826e-12, -6.574285131949345e-14,  1.566364328431366e-15, -5.355762223019185e-17,  1.958148428984844e-18,
 -6.542726304429362e-20,  1.893028527004344e-21, -4.588469063114855e-23,  2.512507496165390e-06, -1.698143908514471e-08,  1.724155762830745e-10, -1.974080871311313e-12,
  2.613115729554844e-14, -5.073605642124820e-16,  1.676991981449014e-17, -6.926545949382289e-19,  2.744337369955705e-20, -9.606795418732554e-22,  2.905532319769162e-23,
 -7.469599797218851e-25,  1.956567347391165e-01, -1.254441164895515e-03,  1.206388004659580e-05, -1.288950042951591e-07,  1.444928672852636e-09, -1.658881939332563e-11,
  1.901403108037513e-13, -2.036740545585389e-15,  1.547581333759485e-17,  1.164131288802499e-19, -1.010817495424425e-20,  3.305948295281607e-22,  7.691538991810842e-02,
 -4.931389582486489e-04,  4.742601381028739e-06, -5.068543149341121e-08,  5.693918711840166e-10, -6.619930580988809e-12,  8.055670534062943e-14, -1.087584514235118e-15,
  1.815084003130522e-17, -3.904157196793734e-19,  9.611646644408853e-21, -2.323968263062007e-22,  1.084982705691001e-02, -6.956330086699923e-05,  6.690392903952251e-07,
 -7.154615075221608e-09,  8.076224934353496e-11, -9.658048725552099e-13,  1.325508179619145e-14, -2.472616278101894e-16,  6.528675181164386e-18, -1.994451117248930e-19,
  5.889210463978390e-21, -1.550159934393680e-22,  4.303641653926001e-04, -2.759281188702142e-06,  2.654079652863138e-08, -2.841635912827924e-10,  3.237765705137120e-12,
 -4.080396055889914e-14,  6.745233200528276e-16, -1.725739972730431e-17,  5.774738368612821e-19, -1.965430031466402e-20,  6.085389750537080e-22, -1.648367743404951e-23,
  2.447199522774574e-06, -1.569041849356409e-08,  1.509567001673398e-10, -1.620442428992462e-12,  1.883976799486894e-14, -2.636871422036425e-16,  5.755831193833767e-18,
 -1.962124111702103e-19,  7.575706308018795e-21, -2.745046298304732e-22,  8.841754337541500e-24, -2.490216261857792e-25,  1.908227196653591e-01, -1.163747760340204e-03,
  1.064565718565168e-05, -1.082007695962900e-07,  1.154464064196045e-09, -1.265215846993291e-11,  1.402545422012806e-13, -1.529762699294620e-15,  1.504892209948697e-17,
 -8.582340128300895e-20, -1.715491546371845e-21,  9.216788083386307e-23,  7.501506979669244e-02, -4.574856002567302e-04,  4.184983175402646e-06, -4.253862121823038e-08,
  4.541525892683045e-10, -4.997124838727833e-12,  5.655427133500649e-14, -6.738200032980797e-16,  9.087338518338836e-18, -1.540691407867799e-19,  3.309070130539649e-21,
 -7.893616479619890e-23,  1.058176393753915e-02, -6.453380667627176e-05,  5.903500767626933e-07, -6.001663739103737e-09,  6.416543371577487e-11, -7.124464070244654e-13,
  8.436664190046708e-15, -1.185883766147483e-16,  2.316770494274832e-18, -6.120103257830780e-20,  1.781341887645845e-21, -4.942960087613090e-23,  4.197312648368236e-04,
 -2.559770991833474e-06,  2.341720364292494e-08, -2.381420844277566e-10,  2.552963700023252e-12, -2.884147100805892e-14,  3.703019694690786e-16, -6.546681667643915e-18,
  1.736460861200774e-19, -5.577984068971317e-21,  1.769073133108557e-22, -5.103959276278897e-24,  2.386736760519202e-06, -1.455578136821227e-08,  1.331661565903738e-10,
 -1.355162206359770e-12,  1.461266162063526e-14, -1.712200637342513e-16,  2.554241794319154e-18, -6.078621428435291e-20,  2.052123368243575e-21, -7.365102339868504e-23,
  2.457493557495860e-24, -7.336810143503068e-26,  1.863302552529641e-01, -1.083480237078614e-03,  9.450280989181951e-06, -9.158442221761465e-08,  9.318804046191128e-10,
 -9.748800910382790e-12,  1.036406766625069e-13, -1.104825957329483e-15,  1.142453812268340e-17, -1.022008887859267e-19,  3.666966926981019e-22,  1.777645257915306e-23,
  7.324901913895018e-02, -4.259312053198689e-04,  3.715042920583527e-06, -3.600385440673250e-08,  3.664058275820106e-10, -3.837721078724484e-12,  4.107390206784781e-14,
 -4.517211964409785e-16,  5.277443278684159e-18, -7.114970859316742e-20,  1.216777795863691e-21, -2.580797726305395e-23,  1.033264148124138e-02, -6.008264943743750e-05,
  5.240526449402832e-07, -5.079007023311689e-09,  5.170850352404729e-11, -5.430676052273829e-13,  5.900632734241860e-15, -6.934088799038361e-17,  9.993758710015001e-19,
 -2.012052988748914e-20,  5.225542263612276e-22, -1.443163405663985e-23,  4.098496834901059e-04, -2.383210748990888e-06,  2.078696447153206e-08, -2.014794257016383e-10,
  2.052764548126472e-12, -2.167185079320051e-14,  2.422512010257117e-16, -3.185311365854647e-18,  5.951318267716942e-20, -1.590861591806787e-21,  4.858793392386352e-23,
 -1.439249282484199e-24,  2.330546593654983e-06, -1.355176629476930e-08,  1.182034926495923e-10, -1.145895060947208e-12,  1.169341182429429e-14, -1.248240780762595e-16,
  1.478439735024756e-18, -2.353746189745390e-20,  5.901114177098103e-22, -1.926405931584262e-23,  6.427557698419611e-25, -1.986448593617946e-26,  1.821409177356699e-01,
 -1.012034559442583e-03,  8.434704968911341e-06, -7.810881346486474e-08,  7.594719411057980e-10, -7.594605257396002e-12,  7.729714878389996e-14, -7.942480268725995e-16,
  8.124661184081389e-18, -7.944973612702556e-20,  6.398388895436854e-22, -7.810847389867926e-25,  7.160213213436528e-02, -3.978448899915816e-04,  3.315801243497856e-06,
 -3.070582062051680e-08,  2.985742899115887e-10, -2.986720416193031e-12,  3.046113910572397e-14, -3.162366169265002e-16,  3.379789922944205e-18, -3.877777471928727e-20,
  5.221459035952626e-22, -8.934502949024162e-24,  1.010032854829408e-02, -5.612073441397675e-05,  4.677334132189196e-07, -4.331469833513946e-09,  4.212231535078521e-11,
 -4.216880032448232e-13,  4.320799232571171e-15, -4.589671694096170e-17,  5.366888921940958e-19, -7.911279635861069e-21,  1.615628971411727e-22, -4.075736986448199e-24,
  4.006348667386304e-04, -2.226058719391752e-06,  1.855292181820144e-08, -1.718138128151300e-10,  1.671171638722740e-12, -1.675494546447822e-14,  1.732066080591725e-16,
 -1.919153757126202e-18,  2.590725914276206e-20, -5.033036878023202e-22,  1.328739417105656e-23, -3.840268935813370e-25,  2.278147951035298e-06, -1.265813889627176e-08,
  1.054986457107214e-10, -9.770368758062320e-13,  9.507212878314061e-15, -9.561468459465661e-17,  1.006891058934932e-18, -1.211792482579661e-20,  2.044714504044344e-22,
 -5.240627001045246e-24,  1.633336385817105e-25, -5.075481955330315e-27,  1.782220757067824e-01, -9.481104908131621e-04,  7.565603119359594e-06, -6.707866858731561e-08,
  6.244710482749097e-10, -5.979431992725291e-12,  5.830241412695767e-14, -5.752444179410286e-16,  5.703201039342546e-18, -5.592422547125473e-20,  5.163297944891864e-22,
 -3.705889812911027e-24,  7.006158072692460e-02, -3.727154430818228e-04,  2.974144230164002e-06, -2.636959185849768e-08,  2.454914890061324e-10, -2.350849588443242e-12,
  2.293573477743923e-14, -2.270268707716003e-16,  2.284224368646668e-18, -2.374119613318548e-20,  2.677877636614639e-22, -3.591888048867775e-24,  9.883015527071697e-03,
 -5.257592678840493e-05,  4.195383380640365e-07, -3.719753559788928e-09,  3.463050484981381e-11, -3.316952932819284e-13,  3.240542104302535e-15, -3.230971820901423e-17,
  3.357629530976551e-19, -3.914311194442657e-21,  5.870298990786099e-23, -1.198716155826077e-24,  3.920150306586271e-04, -2.085451933798043e-06,  1.664121563288704e-08,
 -1.475467653076225e-10,  1.373713919345866e-12, -1.316289430819754e-14,  1.289295049563535e-16, -1.303209486805670e-18,  1.435216588013686e-20, -1.986748135978608e-22,
  3.946409160308719e-24, -1.014557416497440e-25,  2.229132588240700e-06, -1.185859886798180e-08,  9.462775574602438e-11, -8.390107565035909e-13,  7.812305995568560e-15,
 -7.491969570818501e-17,  7.377908822560490e-19, -7.669973772333615e-21,  9.415183338843786e-23, -1.662671184008911e-24,  4.257482990275047e-26, -1.258190469510873e-27,
  1.745458138194819e-01, -8.906442063840331e-04,  6.816894041849903e-06, -5.797294237224387e-08,  5.176695144606694e-10, -4.754559033449513e-12,  4.447452164325566e-14,
 -4.212850016091364e-16,  4.022867783453004e-18, -3.845744332126313e-20,  3.613656996031145e-22, -3.147595093600146e-24,  6.861639096329440e-02, -3.501246451042677e-04,
  2.679816062214389e-06, -2.278997790683940e-08,  2.035037599843102e-10, -1.869135864097555e-12,  1.748699477765543e-14, -1.658048029171125e-16,  1.590712123646900e-18,
 -1.551185178572344e-20,  1.569275320834536e-22, -1.740394334760963e-24,  9.679154398273467e-03, -4.938922692414310e-05,  3.780198017595087e-07, -3.214798333384778e-09,
  2.870682477441966e-11, -2.636804009521550e-13,  2.467842016807631e-15, -2.344986696281080e-17,  2.273495900335207e-19, -2.314246998874185e-21,  2.691351861705725e-23,
 -4.076225264697046e-25,  3.839287712521384e-04, -1.959049776660395e-06,  1.499435625609347e-08, -1.275168298806548e-10,  1.138686982090983e-12, -1.046026645873546e-14,
  9.797032663872883e-17, -9.347561883981720e-19,  9.242011031674020e-21, -1.013898600150730e-22,  1.433032609599720e-24, -2.865186670229893e-26,  2.183151329288420e-06,
 -1.113983235826284e-08,  8.526309135932013e-11, -7.251064365230041e-13,  6.475146771673167e-15, -5.949513322068097e-17,  5.580539834989325e-19, -5.369727350776022e-21,
  5.522441114355401e-23, -6.920981899020605e-25,  1.260192574172201e-26, -3.169845687105986e-28,  1.710880910635081e-01, -8.387578182195051e-04,  6.167954495861845e-06,
 -5.039672918622927e-08,  4.323668380123661e-10, -3.815361484599172e-12,  3.429105945056394e-14, -3.121687336792700e-16,  2.867812679452644e-18, -2.648683644191740e-20,
  2.441282899601216e-22, -2.198512361790080e-24,  6.725711197878828e-02, -3.297273828980905e-04,  2.424708846275279e-06, -1.981165763052937e-08,  1.699695605385918e-10,
 -1.499882446341675e-12,  1.348100409160819e-14, -1.227580967713531e-16,  1.129351939190456e-18, -1.049775132425663e-20,  9.926037946085738e-23, -9.780548968363295e-25,
  9.487412002790048e-03, -4.651195151186587e-05,  3.420338956480536e-07, -2.794669306512261e-09,  2.397626115969505e-11, -2.115795630697375e-13,  1.901880621589543e-15,
 -1.732925787561182e-17,  1.599370529347803e-19, -1.508079458498204e-21,  1.505412704406463e-23, -1.744586536269341e-25,  3.763232078543643e-04, -1.844921123064934e-06,
  1.356695534387162e-08, -1.108520648545151e-10,  9.510341785652167e-13, -8.392666392237480e-15,  7.545589105951914e-17, -6.883296518105035e-19,  6.391199494687459e-21,
 -6.187456422681420e-23,  6.769189722170685e-25, -9.702201528870812e-27,  2.139903474118431e-06, -1.049085744132456e-08,  7.714638703121888e-11, -6.303433994755495e-13,
  5.407943693832563e-15, -4.772647825195565e-17,  4.292622974256901e-19, -3.925207570094833e-21,  3.689693586716621e-23, -3.761969401238174e-25,  4.803874608391987e-27,
 -8.882285079955598e-29,  1.678280756428496e-01, -7.917211443430937e-04,  5.602319974564107e-06, -4.404739800914045e-08,  3.636315499024663e-10, -3.087712832999296e-12,
  2.670418080083259e-14, -2.339452070695949e-16,  2.068926811333413e-18, -1.842061936578135e-20,  1.645414742713594e-22, -1.462543382845629e-24,  6.597555450243599e-02,
 -3.112366111023365e-04,  2.202350028302912e-06, -1.731564602851251e-08,  1.429486542471084e-10, -1.213825064499733e-12,  1.049792915445089e-14, -9.197535431982973e-17,
  8.137340309700997e-19, -7.259412971045952e-21,  6.538924514015007e-23, -5.998137541841737e-25,  9.306633146430527e-03, -4.390360919746789e-05,  3.106675490272533e-07,
 -2.442576979737200e-09,  2.016460856116582e-11, -1.712250716043581e-13,  1.480902619236341e-15, -1.297681999224163e-17,  1.149169065608914e-19, -1.029751195312580e-21,
  9.448737593488371e-24, -9.255166171853625e-26,  3.691525190364051e-04, -1.741459846651912e-06,  1.232279245460513e-08, -9.688611192136925e-11,  7.998404591031507e-13,
 -6.791782656200595e-15,  5.874414808609810e-17, -5.149262008258022e-19,  4.567944419529775e-21, -4.127443728910271e-23,  3.917011876219641e-25, -4.271321944987850e-27,
  2.099128465819665e-06, -9.902540951394340e-09,  7.007164591030461e-11, -5.509278950167930e-13,  4.548175439928492e-15, -3.862098225975482e-17,  3.340779070391099e-19,
 -2.930276926685359e-21,  2.608734800590966e-23, -2.397081671637914e-25,  2.426533923208650e-27, -3.142370486610103e-29,  1.647476143016855e-01, -7.489224294916293e-04,
  5.106728957592426e-06, -3.869060499924465e-08,  3.077919287302891e-10, -2.518507102808914e-12,  2.098927852146115e-14, -1.771954754754219e-16,  1.510242494911202e-18,
 -1.296471086429822e-20,  1.118579097515073e-22, -9.665358475620634e-25,  6.476458223613653e-02, -2.944118400693152e-04,  2.007526294043361e-06, -1.520981586324039e-08,
  1.209973000585340e-10, -9.900606453721358e-13,  8.251206247516341e-15, -6.965966024975088e-17,  5.937805855813674e-19, -5.100313368044459e-21,  4.412022272960697e-23,
 -3.852343012742853e-25,  9.135811169740073e-03, -4.153027602707322e-05,  2.831853540130859e-07, -2.145524635023277e-09,  1.706810344820438e-11, -1.396599086087157e-13,
  1.163939312271031e-15, -9.826840935450084e-18,  8.378610125934014e-20, -7.206333969374674e-22,  6.270445404094812e-24, -5.602008004843534e-26,  3.623767751111806e-04,
 -1.647320332800186e-06,  1.123269663911035e-08, -8.510336894474751e-11,  6.770154554076775e-13, -5.539693715238553e-15,  4.616892859823236e-17, -3.898253429137988e-19,
  3.325371485576847e-21, -2.867165230327960e-23,  2.522139887478342e-25, -2.347954655531727e-27,  2.060599250335773e-06, -9.367231224877830e-09,  6.387298496175213e-11,
 -4.839271026647445e-13,  3.849744554820427e-15, -3.150071677524912e-17,  2.625399170128169e-19, -2.217119320947841e-21,  1.893155194118237e-23, -1.640439152843877e-25,
  1.474754124161778e-27, -1.482548393213918e-29,  1.618308051203124e-01, -7.098456857701008e-04,  4.670411782620573e-06, -3.414311914276754e-08,  2.620838337070330e-10,
 -2.069243383242831e-12,  1.663993599877227e-14, -1.355485147784939e-16,  1.114779931743077e-18, -9.235590321563116e-21,  7.694456696064863e-23, -6.434087221619849e-25,
  6.361794391366082e-02, -2.790502277434544e-04,  1.836003934050859e-06, -1.342213578293830e-08,  1.030288070245876e-10, -8.134484807019267e-13,  6.541396186953793e-15,
 -5.328633396097380e-17,  4.382520674478062e-19, -3.631384708873581e-21,  3.027801074893763e-23, -2.540235053792135e-25,  8.974064257577406e-03, -3.936333871881381e-05,
  2.589900941322166e-07, -1.893351179995303e-09,  1.453343344991596e-11, -1.147465651788510e-13,  9.227431273929988e-16, -7.516770527163547e-18,  6.182586152632957e-20,
 -5.124853007288117e-22,  4.280574370472879e-24, -3.617876666417204e-26,  3.559609984138026e-04, -1.561367619970584e-06,  1.027297887049040e-08, -7.510077473956297e-11,
  5.764763359215195e-13, -4.551484963572082e-15,  3.660122119201279e-17, -2.981641856782455e-19,  2.452740257205101e-21, -2.034542135888401e-23,  1.704966411704894e-25,
 -1.460810456774335e-27,  2.024116932590059e-06, -8.878474472463157e-09,  5.841569885081253e-11, -4.270488939034890e-13,  3.278043398348295e-15, -2.588133299471733e-17,
  2.081285902035361e-19, -1.695548945838532e-21,  1.395148542075765e-23, -1.158896384461309e-25,  9.775960328066632e-28, -8.604356504664177e-30,  1.590636507522327e-01,
 -6.740529848267021e-04,  4.284555627910294e-06, -3.026037990316094e-08,  2.244047291580701e-10, -1.711685443196875e-12,  1.329795125837406e-14, -1.046523888702003e-16,
  8.315114712286615e-19, -6.655577834455699e-21,  5.358193187064768e-23, -4.332688594930838e-25,  6.253013698309423e-02, -2.649796183839649e-04,  1.684318504321597e-06,
 -1.189577689080285e-08,  8.821662533690208e-11, -6.728874080583937e-13,  5.227610950434373e-15, -4.114037466443846e-17,  3.268819727058669e-19, -2.616547441340659e-21,
  2.106979671689589e-23, -1.705443720101356e-25,  8.820616209837841e-03, -3.737851266545834e-05,  2.375930682194574e-07, -1.678040182998658e-09,  1.244399959061874e-11,
 -9.491874103140052e-14,  7.374167548490102e-16, -5.803356670061001e-18,  4.611158868771842e-20, -3.691413319939691e-22,  2.974035222617234e-24, -2.412694575307537e-26,
  3.498744005568681e-04, -1.482638446275518e-06,  9.424254535591318e-09, -6.656035015264178e-11,  4.935978202160204e-13, -3.765002343555510e-15,  2.925004933212949e-17,
 -2.301946489441069e-19,  1.829115065696017e-21, -1.464559544062271e-23,  1.181062533586414e-25, -9.621656115743325e-28,  1.989506439195988e-06, -8.430793253736356e-09,
  5.358955972323909e-11, -3.784850939825265e-13,  2.806767389143424e-15, -2.140910494046783e-17,  1.663261323817278e-19, -1.308982208441114e-21,  1.040181505039329e-23,
 -8.331836650337915e-26,  6.731767531166555e-28, -5.530105372077834e-30,  1.564337747914334e-01, -6.411704937900844e-04,  3.941897783320662e-06, -2.692737827208402e-08,
  1.931398278273955e-10, -1.424898543749656e-12,  1.070692841018701e-14, -8.149850449331075e-17,  6.263109291107216e-19, -4.848793038880190e-21,  3.775855549802578e-23,
 -2.953943686792765e-25,  6.149629610681823e-02, -2.520530530803944e-04,  1.549614932129963e-06, -1.058552751705294e-08,  7.592595693140826e-11, -5.601474702876781e-13,
  4.209042913439899e-15, -3.203820938157548e-17,  2.462121712206687e-19, -1.906156596838652e-21,  1.484458765458111e-23, -1.161672648594773e-25,  8.674780713041459e-03,
 -3.555506757231855e-05,  2.185915344003321e-07, -1.493213994368530e-09,  1.071025523747466e-11, -7.901543400901690e-14,  5.937354027727040e-16, -4.519372521657623e-18,
  3.473133660933851e-20, -2.688949160015234e-22,  2.094374156247876e-24, -1.640051749862465e-26,  3.440897585536638e-04, -1.410310533605528e-06,  8.670548660793378e-09,
 -5.922912173241181e-11,  4.248279313692600e-13, -3.134188986838691e-15,  2.355083288445177e-17, -1.792635704436522e-19,  1.377651021809480e-21, -1.066651486702815e-23,
  8.310157656824373e-26, -6.515478695394440e-28,  1.956612970867034e-06, -8.019511811693609e-09,  4.930372832294322e-11, -3.367972018384019e-13,  2.415718059437062e-15,
 -1.782207961091991e-17,  1.339182036531126e-19, -1.019357467514681e-21,  7.833956616862020e-24, -6.066081193490890e-26,  4.728489229669480e-28, -3.716368970892077e-30,
  1.539301881200113e-01, -6.108773704774364e-04,  3.636413434389556e-06, -2.405190004770460e-08,  1.670377372521927e-10, -1.193202482902047e-12,  8.681255965725398e-15,
 -6.398155625606082e-17,  4.760832359023529e-19, -3.568745864203782e-21,  2.690871896060014e-23, -2.038479789019835e-25,  6.051210130949822e-02, -2.401444043009339e-04,
  1.429524778943990e-06, -9.455136969279969e-09,  6.566486147731771e-11, -4.690645187371466e-13,  3.412722693578258e-15, -2.515204331165123e-17,  1.871550694525365e-19,
 -1.402929151226719e-21,  1.057841816644140e-23, -8.014396032567942e-26,  8.535948383516474e-03, -3.387521165756257e-05,  2.016513963648505e-07, -1.333759023127823e-09,
  9.262806218420349e-12, -6.616710449373966e-14,  4.814049559231235e-16, -3.547994221944756e-18,  2.640047526917896e-20, -1.979014728328101e-22,  1.492282053084114e-24,
 -1.130792054682997e-26,  3.385829008789930e-04, -1.343678161533444e-06,  7.998609138667744e-09, -5.290425607628231e-11,  3.674141009300320e-13, -2.624553157733733e-15,
  1.909518267242844e-17, -1.407331154737591e-19,  1.047191465062962e-21, -7.849990721222062e-24,  5.919733918273290e-26, -4.487300262315514e-28,  1.925299079979168e-06,
 -7.640617176687169e-09,  4.548284858994723e-11, -3.008318355448097e-13,  2.089243222777508e-15, -1.492411403795182e-17,  1.085817997802414e-19, -8.002575616153480e-22,
  5.954721082374492e-24, -4.463913033358954e-26,  3.366741954199881e-28, -2.553820468689320e-30,  };
  int offset = -5;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 5;
    if (std::isnan(t)) {
      fill_n(rr+offset, 5, 0.5);
      fill_n(ww+offset, 5, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 5; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=5; ++j) {
        const int boxof = it*60+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
