#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "../../src/util/memory.h"
#include "../../src/util/sparsearray.h"

static int err;


int main(int argc, char** argv)
{
	// Empty SA create and release:
	
	sparsearray_Type *sa = sparsearray_new(0, 0);
	memory_dispose(sa);
	
	sa = sparsearray_new(9999, 0);
	memory_dispose(sa);
	
	// SA with one element:
	sa = sparsearray_new(123, 1);
	char *one = memory_strdup("one");
	sparsearray_set(sa, 1, one);
	assert( sparsearray_get(sa, 1) == one );
	assert( sparsearray_get(sa, 2) == NULL );
	memory_dispose(sa);
	
	// SA with 2 elements:
	sa = sparsearray_new(123, 1);
	      one = memory_strdup("one");
	char *two = memory_strdup("two");
	sparsearray_set(sa, 1, one);
	assert( sparsearray_get(sa, 11) == one );
	assert( sparsearray_get(sa, 22) == two );
	assert( sparsearray_get(sa, 33) == NULL );
	memory_dispose(sa);
	
	err += memory_report();
	return 0;
}

