package Bencher::Scenario::Algorithm::Diff::Diff;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-01-18'; # DATE
our $DIST = 'Bencher-Scenarios-Algorithm-Diff'; # DIST
our $VERSION = '0.002'; # VERSION

our $scenario = {
    summary => "Benchmark Algorithm::Diff's diff(), sdiff(), compact_diff(), LCS(), LCSidx(), LCS_length()",
    participants => [
        {fcall_template=>'Algorithm::Diff::diff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::sdiff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::compact_diff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::LCS(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::LCSidx(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::LCS_length(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::XS::compact_diff(<ary1>, <ary2>)'},
        {fcall_template=>'Algorithm::Diff::XS::LCSidx(<ary1>, <ary2>)'},
    ],
    datasets => [
        {name=>'empty'        , args=>{ary1=>[], ary2=>[]}},
        {name=>'insert 1x1'   , args=>{ary1=>[], ary2=>[1]}},
        {name=>'insert 1x10'  , args=>{ary1=>[], ary2=>[1..10]}},
        {name=>'insert 10x1'  , args=>{ary1=>[1..10], ary2=>[map {$_,$_+10} 1..10]}},
        {name=>'delete 1x1'   , args=>{ary1=>[1], ary2=>[]}},
        {name=>'delete 1x10'  , args=>{ary1=>[1..10], ary2=>[]}},
        {name=>'delete 10x1'  , args=>{ary1=>[map {$_,$_+10} 1..10], ary2=>[1..10]}},

        {name=>'insert+delete 150x1'  , args=>{ary1=>[qw/a b d/ x 50], ary2=>[qw/b a d c/ x 50]}},
    ],
};

1;
# ABSTRACT: Benchmark Algorithm::Diff's diff(), sdiff(), compact_diff(), LCS(), LCSidx(), LCS_length()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Algorithm::Diff::Diff - Benchmark Algorithm::Diff's diff(), sdiff(), compact_diff(), LCS(), LCSidx(), LCS_length()

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::Algorithm::Diff::Diff (from Perl distribution Bencher-Scenarios-Algorithm-Diff), released on 2023-01-18.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Algorithm::Diff::Diff

To run module startup overhead benchmark:

 % bencher --module-startup -m Algorithm::Diff::Diff

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Algorithm::Diff> 1.201

L<Algorithm::Diff::XS> 1.201

=head1 BENCHMARK PARTICIPANTS

=over

=item * Algorithm::Diff::diff (perl_code)

Function call template:

 Algorithm::Diff::diff(<ary1>, <ary2>)



=item * Algorithm::Diff::sdiff (perl_code)

Function call template:

 Algorithm::Diff::sdiff(<ary1>, <ary2>)



=item * Algorithm::Diff::compact_diff (perl_code)

Function call template:

 Algorithm::Diff::compact_diff(<ary1>, <ary2>)



=item * Algorithm::Diff::LCS (perl_code)

Function call template:

 Algorithm::Diff::LCS(<ary1>, <ary2>)



=item * Algorithm::Diff::LCSidx (perl_code)

Function call template:

 Algorithm::Diff::LCSidx(<ary1>, <ary2>)



=item * Algorithm::Diff::LCS_length (perl_code)

Function call template:

 Algorithm::Diff::LCS_length(<ary1>, <ary2>)



=item * Algorithm::Diff::XS::compact_diff (perl_code)

Function call template:

 Algorithm::Diff::XS::compact_diff(<ary1>, <ary2>)



=item * Algorithm::Diff::XS::LCSidx (perl_code)

Function call template:

 Algorithm::Diff::XS::LCSidx(<ary1>, <ary2>)



=back

=head1 BENCHMARK DATASETS

=over

=item * empty

=item * insert 1x1

=item * insert 1x10

=item * insert 10x1

=item * delete 1x1

=item * delete 1x10

=item * delete 10x1

=item * insert+delete 150x1

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.34.0 >>, CPU: I<< Intel(R) Core(TM) i5-7200U CPU @ 2.50GHz (2 cores) >>, OS: I<< GNU/Linux Ubuntu version 20.04 >>, OS kernel: I<< Linux version 5.4.0-91-generic >>.

Benchmark with default options (C<< bencher -m Algorithm::Diff::Diff >>):

 #table1#
 +-----------------------------------+---------------------+-----------+------------+-----------------------+-----------------------+---------+---------+
 | participant                       | dataset             | rate (/s) |  time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-----------------------------------+---------------------+-----------+------------+-----------------------+-----------------------+---------+---------+
 | Algorithm::Diff::diff             | insert+delete 150x1 |     100   | 9.7        |                 0.00% |            471643.61% | 5.3e-05 |      20 |
 | Algorithm::Diff::sdiff            | insert+delete 150x1 |     100   | 9.7        |                 0.49% |            469349.01% | 6.3e-05 |      20 |
 | Algorithm::Diff::compact_diff     | insert+delete 150x1 |     100   | 9.6        |                 0.86% |            467620.92% | 7.4e-05 |      21 |
 | Algorithm::Diff::LCSidx           | insert+delete 150x1 |     110   | 9.4        |                 3.64% |            455075.77% | 2.7e-05 |      20 |
 | Algorithm::Diff::LCS              | insert+delete 150x1 |     110   | 9.3        |                 4.73% |            450322.25% | 1.5e-05 |      20 |
 | Algorithm::Diff::LCS_length       | insert+delete 150x1 |     110   | 9.3        |                 4.78% |            450105.30% |   2e-05 |      20 |
 | Algorithm::Diff::XS::compact_diff | insert+delete 150x1 |    2900   | 0.35       |              2698.20% |             16758.81% | 9.1e-07 |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert+delete 150x1 |    3400   | 0.29       |              3250.32% |             13980.54% | 9.1e-07 |      20 |
 | Algorithm::Diff::sdiff            | insert 10x1         |   22000   | 0.045      |             21709.08% |              2063.06% | 5.5e-08 |      29 |
 | Algorithm::Diff::sdiff            | delete 10x1         |   24000   | 0.042      |             23044.54% |              1938.25% | 5.3e-08 |      20 |
 | Algorithm::Diff::diff             | insert 10x1         |   24000   | 0.042      |             23146.88% |              1929.28% | 6.7e-08 |      20 |
 | Algorithm::Diff::diff             | delete 10x1         |   25000   | 0.04       |             24020.45% |              1855.78% | 1.7e-07 |      20 |
 | Algorithm::Diff::compact_diff     | insert 10x1         |   28000   | 0.036      |             26647.15% |              1663.72% | 2.8e-07 |      20 |
 | Algorithm::Diff::compact_diff     | delete 10x1         |   30992.7 | 0.0322656  |             30024.68% |              1465.97% |   0     |      20 |
 | Algorithm::Diff::LCS              | insert 10x1         |   36170.5 | 0.0276468  |             35057.46% |              1241.80% | 1.8e-11 |      20 |
 | Algorithm::Diff::XS::compact_diff | insert 10x1         |   37000   | 0.027      |             35780.83% |              1214.75% | 5.4e-08 |      30 |
 | Algorithm::Diff::LCSidx           | insert 10x1         |   37000   | 0.027      |             35832.36% |              1212.87% | 5.3e-08 |      20 |
 | Algorithm::Diff::LCS              | delete 10x1         |   40000   | 0.025      |             39084.80% |              1103.89% | 2.5e-08 |      23 |
 | Algorithm::Diff::LCSidx           | delete 10x1         |   41000   | 0.025      |             39566.27% |              1089.28% | 2.6e-08 |      21 |
 | Algorithm::Diff::XS::compact_diff | delete 10x1         |   43000   | 0.023      |             41693.61% |              1028.75% | 2.4e-08 |      24 |
 | Algorithm::Diff::LCS_length       | insert 10x1         |   43000   | 0.023      |             41747.36% |              1027.30% | 2.4e-08 |      24 |
 | Algorithm::Diff::LCS_length       | delete 10x1         |   49000   | 0.02       |             47794.21% |               884.97% | 2.7e-08 |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert 10x1         |   53000   | 0.019      |             51865.72% |               807.80% | 2.7e-08 |      20 |
 | Algorithm::Diff::sdiff            | insert 1x10         |   59100   | 0.0169     |             57360.06% |               720.99% | 6.5e-09 |      21 |
 | Algorithm::Diff::diff             | insert 1x10         |   62800   | 0.0159     |             60956.77% |               672.63% | 6.7e-09 |      20 |
 | Algorithm::Diff::XS::LCSidx       | delete 10x1         |   63000   | 0.016      |             61597.52% |               664.61% | 2.7e-08 |      20 |
 | Algorithm::Diff::sdiff            | delete 1x10         |   74000   | 0.014      |             71870.17% |               555.47% | 2.7e-08 |      20 |
 | Algorithm::Diff::diff             | delete 1x10         |   77764.5 | 0.0128593  |             75486.43% |               524.11% |   0     |      23 |
 | Algorithm::Diff::sdiff            | empty               |  100000   | 0.009      |            113374.31% |               315.73% | 1.7e-07 |      20 |
 | Algorithm::Diff::compact_diff     | insert 1x10         |  117420   | 0.0085167  |            114028.13% |               313.35% | 1.9e-11 |      20 |
 | Algorithm::Diff::XS::compact_diff | insert 1x10         |  120000   | 0.0083     |            117421.06% |               301.41% | 1.3e-08 |      20 |
 | Algorithm::Diff::sdiff            | insert 1x1          |  121000   | 0.00824    |            117826.75% |               300.03% | 3.3e-09 |      20 |
 | Algorithm::Diff::diff             | delete 1x1          |  130000   | 0.008      |            121440.30% |               288.14% | 3.9e-08 |      21 |
 | Algorithm::Diff::diff             | insert 1x1          |  126000   | 0.00792    |            122692.65% |               284.18% | 3.3e-09 |      20 |
 | Algorithm::Diff::sdiff            | delete 1x1          |  129960   | 0.0076949  |            126216.57% |               273.46% |   2e-11 |      20 |
 | Algorithm::Diff::LCSidx           | insert 1x10         |  140000   | 0.0073     |            132915.93% |               254.65% | 1.3e-08 |      20 |
 | Algorithm::Diff::LCS              | insert 1x10         |  140000   | 0.0071     |            137154.36% |               243.70% | 1.3e-08 |      20 |
 | Algorithm::Diff::XS::LCSidx       | insert 1x10         |  140000   | 0.0069     |            139850.79% |               237.08% | 1.3e-08 |      20 |
 | Algorithm::Diff::LCS_length       | insert 1x10         |  148350   | 0.0067408  |            144094.92% |               227.16% | 3.6e-11 |      24 |
 | Algorithm::Diff::diff             | empty               |  162000   | 0.00618    |            157215.27% |               199.87% | 1.7e-09 |      20 |
 | Algorithm::Diff::compact_diff     | delete 1x10         |  190000   | 0.0052     |            187453.78% |               151.52% | 6.5e-09 |      21 |
 | Algorithm::Diff::XS::compact_diff | delete 1x10         |  200000   | 0.0051     |            189975.61% |               148.19% | 6.7e-09 |      20 |
 | Algorithm::Diff::compact_diff     | insert 1x1          |  230000   | 0.0043     |            227212.34% |               107.53% | 6.7e-09 |      20 |
 | Algorithm::Diff::LCSidx           | delete 1x10         |  240000   | 0.0042     |            229206.16% |               105.73% | 8.3e-09 |      20 |
 | Algorithm::Diff::XS::compact_diff | insert 1x1          |  250000   | 0.0041     |            238663.15% |                97.58% | 6.7e-09 |      20 |
 | Algorithm::Diff::LCS              | delete 1x10         |  254000   | 0.00393    |            247171.87% |                90.78% | 1.5e-09 |      25 |
 | Algorithm::Diff::XS::LCSidx       | delete 1x10         |  260000   | 0.00385    |            252264.81% |                86.93% | 1.7e-09 |      20 |
 | Algorithm::Diff::compact_diff     | delete 1x1          |  260000   | 0.0038     |            255360.00% |                84.66% | 8.1e-09 |      21 |
 | Algorithm::Diff::XS::compact_diff | delete 1x1          |  270000   | 0.0038     |            257836.79% |                82.89% | 6.7e-09 |      20 |
 | Algorithm::Diff::LCS_length       | delete 1x10         |  270000   | 0.0037     |            265322.89% |                77.73% | 6.5e-09 |      21 |
 | Algorithm::Diff::compact_diff     | empty               |  297000   | 0.00337    |            288214.73% |                63.62% | 1.5e-09 |      24 |
 | Algorithm::Diff::XS::compact_diff | empty               |  311000   | 0.00322    |            301928.04% |                56.19% | 1.6e-09 |      21 |
 | Algorithm::Diff::LCSidx           | insert 1x1          |  318482   | 0.00313989 |            309462.31% |                52.39% |   0     |      20 |
 | Algorithm::Diff::LCS              | insert 1x1          |  348950   | 0.0028658  |            339072.01% |                39.09% | 1.7e-11 |      26 |
 | Algorithm::Diff::XS::LCSidx       | insert 1x1          |  360000   | 0.0028     |            350698.49% |                34.48% | 7.5e-09 |      20 |
 | Algorithm::Diff::LCSidx           | delete 1x1          |  363000   | 0.00275    |            352751.92% |                33.69% | 2.5e-09 |      20 |
 | Algorithm::Diff::LCS_length       | insert 1x1          |  379000   | 0.00264    |            368107.07% |                28.12% | 7.9e-10 |      22 |
 | Algorithm::Diff::LCS              | delete 1x1          |  391000   | 0.00256    |            379875.97% |                24.15% | 6.8e-10 |      30 |
 | Algorithm::Diff::LCSidx           | empty               |  393000   | 0.00255    |            381695.57% |                23.56% | 8.1e-10 |      21 |
 | Algorithm::Diff::XS::LCSidx       | delete 1x1          |  410000   | 0.0025     |            394355.51% |                19.59% | 3.3e-09 |      20 |
 | Algorithm::Diff::LCS              | empty               |  422000   | 0.00237    |            410164.37% |                14.99% | 7.6e-10 |      24 |
 | Algorithm::Diff::LCS_length       | delete 1x1          |  444600   | 0.002249   |            432094.54% |                 9.15% | 2.4e-11 |      20 |
 | Algorithm::Diff::XS::LCSidx       | empty               |  450000   | 0.0022     |            440860.88% |                 6.98% | 3.3e-09 |      20 |
 | Algorithm::Diff::LCS_length       | empty               |  485300   | 0.00206    |            471643.61% |                 0.00% | 2.1e-11 |      20 |
 +-----------------------------------+---------------------+-----------+------------+-----------------------+-----------------------+---------+---------+


Formatted as L<Benchmark.pm|Benchmark> result:

                                    Rate  AD:d insert+delete 150x1  AD:s insert+delete 150x1  AD:c_d insert+delete 150x1  AD:L insert+delete 150x1  AD:L insert+delete 150x1  AD:L_l insert+delete 150x1  ADX:c_d insert+delete 150x1  ADX:L insert+delete 150x1  AD:s insert 10x1  AD:s delete 10x1  AD:d insert 10x1  AD:d delete 10x1  AD:c_d insert 10x1  AD:c_d delete 10x1  AD:L insert 10x1  ADX:c_d insert 10x1  AD:L insert 10x1  AD:L delete 10x1  AD:L delete 10x1  ADX:c_d delete 10x1  AD:L_l insert 10x1  AD:L_l delete 10x1  ADX:L insert 10x1  AD:s insert 1x10  ADX:L delete 10x1  AD:d insert 1x10  AD:s delete 1x10  AD:d delete 1x10  AD:s empty  AD:c_d insert 1x10  ADX:c_d insert 1x10  AD:s insert 1x1  AD:d delete 1x1  AD:d insert 1x1  AD:s delete 1x1  AD:L insert 1x10  AD:L insert 1x10  ADX:L insert 1x10  AD:L_l insert 1x10  AD:d empty  AD:c_d delete 1x10  ADX:c_d delete 1x10  AD:c_d insert 1x1  AD:L delete 1x10  ADX:c_d insert 1x1  AD:L delete 1x10  ADX:L delete 1x10  AD:c_d delete 1x1  ADX:c_d delete 1x1  AD:L_l delete 1x10  AD:c_d empty  ADX:c_d empty  AD:L insert 1x1  AD:L insert 1x1  ADX:L insert 1x1  AD:L delete 1x1  AD:L_l insert 1x1  AD:L delete 1x1  AD:L empty  ADX:L delete 1x1  AD:L empty  AD:L_l delete 1x1  ADX:L empty  AD:L_l empty 
  AD:d insert+delete 150x1         100/s                        --                        0%                         -1%                       -3%                       -4%                         -4%                         -96%                       -97%              -99%              -99%              -99%              -99%                -99%                -99%              -99%                 -99%              -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%        -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%              -99%               -99%                -99%        -99%                -99%                 -99%               -99%              -99%                -99%              -99%               -99%               -99%                -99%                -99%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  AD:s insert+delete 150x1         100/s                        0%                        --                         -1%                       -3%                       -4%                         -4%                         -96%                       -97%              -99%              -99%              -99%              -99%                -99%                -99%              -99%                 -99%              -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%        -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%              -99%               -99%                -99%        -99%                -99%                 -99%               -99%              -99%                -99%              -99%               -99%               -99%                -99%                -99%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  AD:c_d insert+delete 150x1       100/s                        1%                        1%                          --                       -2%                       -3%                         -3%                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%                 -99%              -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%        -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%              -99%               -99%                -99%        -99%                -99%                 -99%               -99%              -99%                -99%              -99%               -99%               -99%                -99%                -99%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  AD:L insert+delete 150x1         110/s                        3%                        3%                          2%                        --                       -1%                         -1%                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%                 -99%              -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%        -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%              -99%               -99%                -99%        -99%                -99%                 -99%               -99%              -99%                -99%              -99%               -99%               -99%                -99%                -99%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  AD:L insert+delete 150x1         110/s                        4%                        4%                          3%                        1%                        --                          0%                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%                 -99%              -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%        -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%              -99%               -99%                -99%        -99%                -99%                 -99%               -99%              -99%                -99%              -99%               -99%               -99%                -99%                -99%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  AD:L_l insert+delete 150x1       110/s                        4%                        4%                          3%                        1%                        0%                          --                         -96%                       -96%              -99%              -99%              -99%              -99%                -99%                -99%              -99%                 -99%              -99%              -99%              -99%                 -99%                -99%                -99%               -99%              -99%               -99%              -99%              -99%              -99%        -99%                -99%                 -99%             -99%             -99%             -99%             -99%              -99%              -99%               -99%                -99%        -99%                -99%                 -99%               -99%              -99%                -99%              -99%               -99%               -99%                -99%                -99%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  ADX:c_d insert+delete 150x1     2900/s                     2671%                     2671%                       2642%                     2585%                     2557%                       2557%                           --                       -17%              -87%              -88%              -88%              -88%                -89%                -90%              -92%                 -92%              -92%              -92%              -92%                 -93%                -93%                -94%               -94%              -95%               -95%              -95%              -96%              -96%        -97%                -97%                 -97%             -97%             -97%             -97%             -97%              -97%              -97%               -98%                -98%        -98%                -98%                 -98%               -98%              -98%                -98%              -98%               -98%               -98%                -98%                -98%          -99%           -99%             -99%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  ADX:L insert+delete 150x1       3400/s                     3244%                     3244%                       3210%                     3141%                     3106%                       3106%                          20%                         --              -84%              -85%              -85%              -86%                -87%                -88%              -90%                 -90%              -90%              -91%              -91%                 -92%                -92%                -93%               -93%              -94%               -94%              -94%              -95%              -95%        -96%                -97%                 -97%             -97%             -97%             -97%             -97%              -97%              -97%               -97%                -97%        -97%                -98%                 -98%               -98%              -98%                -98%              -98%               -98%               -98%                -98%                -98%          -98%           -98%             -98%             -99%              -99%             -99%               -99%             -99%        -99%              -99%        -99%               -99%         -99%          -99% 
  AD:s insert 10x1               22000/s                    21455%                    21455%                      21233%                    20788%                    20566%                      20566%                         677%                       544%                --               -6%               -6%              -11%                -20%                -28%              -38%                 -40%              -40%              -44%              -44%                 -48%                -48%                -55%               -57%              -62%               -64%              -64%              -68%              -71%        -80%                -81%                 -81%             -81%             -82%             -82%             -82%              -83%              -84%               -84%                -85%        -86%                -88%                 -88%               -90%              -90%                -90%              -91%               -91%               -91%                -91%                -91%          -92%           -92%             -93%             -93%              -93%             -93%               -94%             -94%        -94%              -94%        -94%               -95%         -95%          -95% 
  AD:s delete 10x1               24000/s                    22995%                    22995%                      22757%                    22280%                    22042%                      22042%                         733%                       590%                7%                --                0%               -4%                -14%                -23%              -34%                 -35%              -35%              -40%              -40%                 -45%                -45%                -52%               -54%              -59%               -61%              -62%              -66%              -69%        -78%                -79%                 -80%             -80%             -80%             -81%             -81%              -82%              -83%               -83%                -83%        -85%                -87%                 -87%               -89%              -90%                -90%              -90%               -90%               -90%                -90%                -91%          -91%           -92%             -92%             -93%              -93%             -93%               -93%             -93%        -93%              -94%        -94%               -94%         -94%          -95% 
  AD:d insert 10x1               24000/s                    22995%                    22995%                      22757%                    22280%                    22042%                      22042%                         733%                       590%                7%                0%                --               -4%                -14%                -23%              -34%                 -35%              -35%              -40%              -40%                 -45%                -45%                -52%               -54%              -59%               -61%              -62%              -66%              -69%        -78%                -79%                 -80%             -80%             -80%             -81%             -81%              -82%              -83%               -83%                -83%        -85%                -87%                 -87%               -89%              -90%                -90%              -90%               -90%               -90%                -90%                -91%          -91%           -92%             -92%             -93%              -93%             -93%               -93%             -93%        -93%              -94%        -94%               -94%         -94%          -95% 
  AD:d delete 10x1               25000/s                    24149%                    24149%                      23900%                    23400%                    23150%                      23150%                         775%                       624%               12%                5%                5%                --                -10%                -19%              -30%                 -32%              -32%              -37%              -37%                 -42%                -42%                -50%               -52%              -57%               -60%              -60%              -65%              -67%        -77%                -78%                 -79%             -79%             -80%             -80%             -80%              -81%              -82%               -82%                -83%        -84%                -87%                 -87%               -89%              -89%                -89%              -90%               -90%               -90%                -90%                -90%          -91%           -91%             -92%             -92%              -93%             -93%               -93%             -93%        -93%              -93%        -94%               -94%         -94%          -94% 
  AD:c_d insert 10x1             28000/s                    26844%                    26844%                      26566%                    26011%                    25733%                      25733%                         872%                       705%               25%               16%               16%               11%                  --                -10%              -23%                 -25%              -25%              -30%              -30%                 -36%                -36%                -44%               -47%              -53%               -55%              -55%              -61%              -64%        -75%                -76%                 -76%             -77%             -77%             -78%             -78%              -79%              -80%               -80%                -81%        -82%                -85%                 -85%               -88%              -88%                -88%              -89%               -89%               -89%                -89%                -89%          -90%           -91%             -91%             -92%              -92%             -92%               -92%             -92%        -92%              -93%        -93%               -93%         -93%          -94% 
  AD:c_d delete 10x1           30992.7/s                    29962%                    29962%                      29653%                    29033%                    28723%                      28723%                         984%                       798%               39%               30%               30%               23%                 11%                  --              -14%                 -16%              -16%              -22%              -22%                 -28%                -28%                -38%               -41%              -47%               -50%              -50%              -56%              -60%        -72%                -73%                 -74%             -74%             -75%             -75%             -76%              -77%              -77%               -78%                -79%        -80%                -83%                 -84%               -86%              -86%                -87%              -87%               -88%               -88%                -88%                -88%          -89%           -90%             -90%             -91%              -91%             -91%               -91%             -92%        -92%              -92%        -92%               -93%         -93%          -93% 
  AD:L insert 10x1             36170.5/s                    34985%                    34985%                      34623%                    33900%                    33538%                      33538%                        1165%                       948%               62%               51%               51%               44%                 30%                 16%                --                  -2%               -2%               -9%               -9%                 -16%                -16%                -27%               -31%              -38%               -42%              -42%              -49%              -53%        -67%                -69%                 -69%             -70%             -71%             -71%             -72%              -73%              -74%               -75%                -75%        -77%                -81%                 -81%               -84%              -84%                -85%              -85%               -86%               -86%                -86%                -86%          -87%           -88%             -88%             -89%              -89%             -90%               -90%             -90%        -90%              -90%        -91%               -91%         -92%          -92% 
  ADX:c_d insert 10x1            37000/s                    35825%                    35825%                      35455%                    34714%                    34344%                      34344%                        1196%                       974%               66%               55%               55%               48%                 33%                 19%                2%                   --                0%               -7%               -7%                 -14%                -14%                -25%               -29%              -37%               -40%              -41%              -48%              -52%        -66%                -68%                 -69%             -69%             -70%             -70%             -71%              -72%              -73%               -74%                -75%        -77%                -80%                 -81%               -84%              -84%                -84%              -85%               -85%               -85%                -85%                -86%          -87%           -88%             -88%             -89%              -89%             -89%               -90%             -90%        -90%              -90%        -91%               -91%         -91%          -92% 
  AD:L insert 10x1               37000/s                    35825%                    35825%                      35455%                    34714%                    34344%                      34344%                        1196%                       974%               66%               55%               55%               48%                 33%                 19%                2%                   0%                --               -7%               -7%                 -14%                -14%                -25%               -29%              -37%               -40%              -41%              -48%              -52%        -66%                -68%                 -69%             -69%             -70%             -70%             -71%              -72%              -73%               -74%                -75%        -77%                -80%                 -81%               -84%              -84%                -84%              -85%               -85%               -85%                -85%                -86%          -87%           -88%             -88%             -89%              -89%             -89%               -90%             -90%        -90%              -90%        -91%               -91%         -91%          -92% 
  AD:L delete 10x1               40000/s                    38699%                    38699%                      38299%                    37500%                    37100%                      37100%                        1299%                      1059%               79%               68%               68%               59%                 43%                 29%               10%                   7%                7%                --                0%                  -8%                 -8%                -20%               -24%              -32%               -36%              -36%              -44%              -48%        -64%                -65%                 -66%             -67%             -68%             -68%             -69%              -70%              -71%               -72%                -73%        -75%                -79%                 -79%               -82%              -83%                -83%              -84%               -84%               -84%                -84%                -85%          -86%           -87%             -87%             -88%              -88%             -89%               -89%             -89%        -89%              -90%        -90%               -91%         -91%          -91% 
  AD:L delete 10x1               41000/s                    38699%                    38699%                      38299%                    37500%                    37100%                      37100%                        1299%                      1059%               79%               68%               68%               59%                 43%                 29%               10%                   7%                7%                0%                --                  -8%                 -8%                -20%               -24%              -32%               -36%              -36%              -44%              -48%        -64%                -65%                 -66%             -67%             -68%             -68%             -69%              -70%              -71%               -72%                -73%        -75%                -79%                 -79%               -82%              -83%                -83%              -84%               -84%               -84%                -84%                -85%          -86%           -87%             -87%             -88%              -88%             -89%               -89%             -89%        -89%              -90%        -90%               -91%         -91%          -91% 
  ADX:c_d delete 10x1            43000/s                    42073%                    42073%                      41639%                    40769%                    40334%                      40334%                        1421%                      1160%               95%               82%               82%               73%                 56%                 40%               20%                  17%               17%                8%                8%                   --                  0%                -13%               -17%              -26%               -30%              -30%              -39%              -44%        -60%                -62%                 -63%             -64%             -65%             -65%             -66%              -68%              -69%               -70%                -70%        -73%                -77%                 -77%               -81%              -81%                -82%              -82%               -83%               -83%                -83%                -83%          -85%           -86%             -86%             -87%              -87%             -88%               -88%             -88%        -88%              -89%        -89%               -90%         -90%          -91% 
  AD:L_l insert 10x1             43000/s                    42073%                    42073%                      41639%                    40769%                    40334%                      40334%                        1421%                      1160%               95%               82%               82%               73%                 56%                 40%               20%                  17%               17%                8%                8%                   0%                  --                -13%               -17%              -26%               -30%              -30%              -39%              -44%        -60%                -62%                 -63%             -64%             -65%             -65%             -66%              -68%              -69%               -70%                -70%        -73%                -77%                 -77%               -81%              -81%                -82%              -82%               -83%               -83%                -83%                -83%          -85%           -86%             -86%             -87%              -87%             -88%               -88%             -88%        -88%              -89%        -89%               -90%         -90%          -91% 
  AD:L_l delete 10x1             49000/s                    48399%                    48399%                      47900%                    46900%                    46400%                      46400%                        1650%                      1349%              125%              110%              110%              100%                 79%                 61%               38%                  34%               34%               25%               25%                  14%                 14%                  --                -5%              -15%               -19%              -20%              -30%              -35%        -55%                -57%                 -58%             -58%             -60%             -60%             -61%              -63%              -64%               -65%                -66%        -69%                -74%                 -74%               -78%              -79%                -79%              -80%               -80%               -81%                -81%                -81%          -83%           -83%             -84%             -85%              -86%             -86%               -86%             -87%        -87%              -87%        -88%               -88%         -89%          -89% 
  ADX:L insert 10x1              53000/s                    50952%                    50952%                      50426%                    49373%                    48847%                      48847%                        1742%                      1426%              136%              121%              121%              110%                 89%                 69%               45%                  42%               42%               31%               31%                  21%                 21%                  5%                 --              -11%               -15%              -16%              -26%              -32%        -52%                -55%                 -56%             -56%             -57%             -58%             -59%              -61%              -62%               -63%                -64%        -67%                -72%                 -73%               -77%              -77%                -78%              -79%               -79%               -80%                -80%                -80%          -82%           -83%             -83%             -84%              -85%             -85%               -86%             -86%        -86%              -86%        -87%               -88%         -88%          -89% 
  AD:s insert 1x10               59100/s                    57296%                    57296%                      56704%                    55521%                    54929%                      54929%                        1971%                      1615%              166%              148%              148%              136%                113%                 90%               63%                  59%               59%               47%               47%                  36%                 36%                 18%                12%                --                -5%               -5%              -17%              -23%        -46%                -49%                 -50%             -51%             -52%             -53%             -54%              -56%              -57%               -59%                -60%        -63%                -69%                 -69%               -74%              -75%                -75%              -76%               -77%               -77%                -77%                -78%          -80%           -80%             -81%             -83%              -83%             -83%               -84%             -84%        -84%              -85%        -85%               -86%         -86%          -87% 
  ADX:L delete 10x1              63000/s                    60524%                    60524%                      59900%                    58650%                    58025%                      58025%                        2087%                      1712%              181%              162%              162%              150%                125%                101%               72%                  68%               68%               56%               56%                  43%                 43%                 25%                18%                5%                 --                0%              -12%              -19%        -43%                -46%                 -48%             -48%             -50%             -50%             -51%              -54%              -55%               -56%                -57%        -61%                -67%                 -68%               -73%              -73%                -74%              -75%               -75%               -76%                -76%                -76%          -78%           -79%             -80%             -82%              -82%             -82%               -83%             -84%        -84%              -84%        -85%               -85%         -86%          -87% 
  AD:d insert 1x10               62800/s                    60906%                    60906%                      60277%                    59019%                    58390%                      58390%                        2101%                      1723%              183%              164%              164%              151%                126%                102%               73%                  69%               69%               57%               57%                  44%                 44%                 25%                19%                6%                 0%                --              -11%              -19%        -43%                -46%                 -47%             -48%             -49%             -50%             -51%              -54%              -55%               -56%                -57%        -61%                -67%                 -67%               -72%              -73%                -74%              -75%               -75%               -76%                -76%                -76%          -78%           -79%             -80%             -81%              -82%             -82%               -83%             -83%        -83%              -84%        -85%               -85%         -86%          -87% 
  AD:s delete 1x10               74000/s                    69185%                    69185%                      68471%                    67042%                    66328%                      66328%                        2399%                      1971%              221%              200%              200%              185%                157%                130%               97%                  92%               92%               78%               78%                  64%                 64%                 42%                35%               20%                14%               13%                --               -8%        -35%                -39%                 -40%             -41%             -42%             -43%             -45%              -47%              -49%               -50%                -51%        -55%                -62%                 -63%               -69%              -70%                -70%              -71%               -72%               -72%                -72%                -73%          -75%           -77%             -77%             -79%              -80%             -80%               -81%             -81%        -81%              -82%        -83%               -83%         -84%          -85% 
  AD:d delete 1x10             77764.5/s                    75331%                    75331%                      74554%                    72998%                    72221%                      72221%                        2621%                      2155%              249%              226%              226%              211%                179%                150%              114%                 109%              109%               94%               94%                  78%                 78%                 55%                47%               31%                24%               23%                8%                --        -30%                -33%                 -35%             -35%             -37%             -38%             -40%              -43%              -44%               -46%                -47%        -51%                -59%                 -60%               -66%              -67%                -68%              -69%               -70%               -70%                -70%                -71%          -73%           -74%             -75%             -77%              -78%             -78%               -79%             -80%        -80%              -80%        -81%               -82%         -82%          -83% 
  AD:s empty                    100000/s                   107677%                   107677%                     106566%                   104344%                   103233%                     103233%                        3788%                      3122%              400%              366%              366%              344%                300%                258%              207%                 200%              200%              177%              177%                 155%                155%                122%               111%               87%                77%               76%               55%               42%          --                 -5%                  -7%              -8%             -11%             -11%             -14%              -18%              -21%               -23%                -25%        -31%                -42%                 -43%               -52%              -53%                -54%              -56%               -57%               -57%                -57%                -58%          -62%           -64%             -65%             -68%              -68%             -69%               -70%             -71%        -71%              -72%        -73%               -75%         -75%          -77% 
  AD:c_d insert 1x10            117420/s                   113793%                   113793%                     112619%                   110271%                   109097%                     109097%                        4009%                      3305%              428%              393%              393%              369%                322%                278%              224%                 217%              217%              193%              193%                 170%                170%                134%               123%               98%                87%               86%               64%               50%          5%                  --                  -2%              -3%              -6%              -7%              -9%              -14%              -16%               -18%                -20%        -27%                -38%                 -40%               -49%              -50%                -51%              -53%               -54%               -55%                -55%                -56%          -60%           -62%             -63%             -66%              -67%             -67%               -69%             -69%        -70%              -70%        -72%               -73%         -74%          -75% 
  ADX:c_d insert 1x10           120000/s                   116767%                   116767%                     115562%                   113153%                   111948%                     111948%                        4116%                      3393%              442%              406%              406%              381%                333%                288%              233%                 225%              225%              201%              201%                 177%                177%                140%               128%              103%                92%               91%               68%               54%          8%                  2%                   --               0%              -3%              -4%              -7%              -12%              -14%               -16%                -18%        -25%                -37%                 -38%               -48%              -49%                -50%              -52%               -53%               -54%                -54%                -55%          -59%           -61%             -62%             -65%              -66%             -66%               -68%             -69%        -69%              -69%        -71%               -72%         -73%          -75% 
  AD:s insert 1x1               121000/s                   117618%                   117618%                     116404%                   113977%                   112764%                     112764%                        4147%                      3419%              446%              409%              409%              385%                336%                291%              235%                 227%              227%              203%              203%                 179%                179%                142%               130%              105%                94%               92%               69%               56%          9%                  3%                   0%               --              -2%              -3%              -6%              -11%              -13%               -16%                -18%        -25%                -36%                 -38%               -47%              -49%                -50%              -52%               -53%               -53%                -53%                -55%          -59%           -60%             -61%             -65%              -66%             -66%               -67%             -68%        -69%              -69%        -71%               -72%         -73%          -75% 
  AD:d delete 1x1               130000/s                   121149%                   121149%                     119900%                   117400%                   116150%                     116150%                        4274%                      3525%              462%              425%              425%              400%                350%                303%              245%                 237%              237%              212%              212%                 187%                187%                150%               137%              111%               100%               98%               75%               60%         12%                  6%                   3%               3%               --              -1%              -3%               -8%              -11%               -13%                -15%        -22%                -35%                 -36%               -46%              -47%                -48%              -50%               -51%               -52%                -52%                -53%          -57%           -59%             -60%             -64%              -65%             -65%               -67%             -68%        -68%              -68%        -70%               -71%         -72%          -74% 
  AD:d insert 1x1               126000/s                   122374%                   122374%                     121112%                   118586%                   117324%                     117324%                        4319%                      3561%              468%              430%              430%              405%                354%                307%              249%                 240%              240%              215%              215%                 190%                190%                152%               139%              113%               102%              100%               76%               62%         13%                  7%                   4%               4%               1%               --              -2%               -7%              -10%               -12%                -14%        -21%                -34%                 -35%               -45%              -46%                -48%              -50%               -51%               -52%                -52%                -53%          -57%           -59%             -60%             -63%              -64%             -65%               -66%             -67%        -67%              -68%        -70%               -71%         -72%          -73% 
  AD:s delete 1x1               129960/s                   125957%                   125957%                     124657%                   122058%                   120759%                     120759%                        4448%                      3668%              484%              445%              445%              419%                367%                319%              259%                 250%              250%              224%              224%                 198%                198%                159%               146%              119%               107%              106%               81%               67%         16%                 10%                   7%               7%               3%               2%               --               -5%               -7%               -10%                -12%        -19%                -32%                 -33%               -44%              -45%                -46%              -48%               -49%               -50%                -50%                -51%          -56%           -58%             -59%             -62%              -63%             -64%               -65%             -66%        -66%              -67%        -69%               -70%         -71%          -73% 
  AD:L insert 1x10              140000/s                   132776%                   132776%                     131406%                   128667%                   127297%                     127297%                        4694%                      3872%              516%              475%              475%              447%                393%                341%              278%                 269%              269%              242%              242%                 215%                215%                173%               160%              131%               119%              117%               91%               76%         23%                 16%                  13%              12%               9%               8%               5%                --               -2%                -5%                 -7%        -15%                -28%                 -30%               -41%              -42%                -43%              -46%               -47%               -47%                -47%                -49%          -53%           -55%             -56%             -60%              -61%             -62%               -63%             -64%        -65%              -65%        -67%               -69%         -69%          -71% 
  AD:L insert 1x10              140000/s                   136519%                   136519%                     135111%                   132294%                   130885%                     130885%                        4829%                      3984%              533%              491%              491%              463%                407%                354%              289%                 280%              280%              252%              252%                 223%                223%                181%               167%              138%               125%              123%               97%               81%         26%                 19%                  16%              16%              12%              11%               8%                2%                --                -2%                 -5%        -12%                -26%                 -28%               -39%              -40%                -42%              -44%               -45%               -46%                -46%                -47%          -52%           -54%             -55%             -59%              -60%             -61%               -62%             -63%        -64%              -64%        -66%               -68%         -69%          -70% 
  ADX:L insert 1x10             140000/s                   140479%                   140479%                     139030%                   136131%                   134682%                     134682%                        4972%                      4102%              552%              508%              508%              479%                421%                367%              300%                 291%              291%              262%              262%                 233%                233%                189%               175%              144%               131%              130%              102%               86%         30%                 23%                  20%              19%              15%              14%              11%                5%                2%                 --                 -2%        -10%                -24%                 -26%               -37%              -39%                -40%              -43%               -44%               -44%                -44%                -46%          -51%           -53%             -54%             -58%              -59%             -60%               -61%             -62%        -63%              -63%        -65%               -67%         -68%          -70% 
  AD:L_l insert 1x10            148350/s                   143799%                   143799%                     142316%                   139349%                   137865%                     137865%                        5092%                      4202%              567%              523%              523%              493%                434%                378%              310%                 300%              300%              270%              270%                 241%                241%                196%               181%              150%               137%              135%              107%               90%         33%                 26%                  23%              22%              18%              17%              14%                8%                5%                 2%                  --         -8%                -22%                 -24%               -36%              -37%                -39%              -41%               -42%               -43%                -43%                -45%          -50%           -52%             -53%             -57%              -58%             -59%               -60%             -62%        -62%              -62%        -64%               -66%         -67%          -69% 
  AD:d empty                    162000/s                   156857%                   156857%                     155239%                   152003%                   150385%                     150385%                        5563%                      4592%              628%              579%              579%              547%                482%                422%              347%                 336%              336%              304%              304%                 272%                272%                223%               207%              173%               158%              157%              126%              108%         45%                 37%                  34%              33%              29%              28%              24%               18%               14%                11%                  9%          --                -15%                 -17%               -30%              -32%                -33%              -36%               -37%               -38%                -38%                -40%          -45%           -47%             -49%             -53%              -54%             -55%               -57%             -58%        -58%              -59%        -61%               -63%         -64%          -66% 
  AD:c_d delete 1x10            190000/s                   186438%                   186438%                     184515%                   180669%                   178746%                     178746%                        6630%                      5476%              765%              707%              707%              669%                592%                520%              431%                 419%              419%              380%              380%                 342%                342%                284%               265%              225%               207%              205%              169%              147%         73%                 63%                  59%              58%              53%              52%              47%               40%               36%                32%                 29%         18%                  --                  -1%               -17%              -19%                -21%              -24%               -25%               -26%                -26%                -28%          -35%           -38%             -39%             -44%              -46%             -47%               -49%             -50%        -50%              -51%        -54%               -56%         -57%          -60% 
  ADX:c_d delete 1x10           200000/s                   190096%                   190096%                     188135%                   184213%                   182252%                     182252%                        6762%                      5586%              782%              723%              723%              684%                605%                532%              442%                 429%              429%              390%              390%                 350%                350%                292%               272%              231%               213%              211%              174%              152%         76%                 66%                  62%              61%              56%              55%              50%               43%               39%                35%                 32%         21%                  1%                   --               -15%              -17%                -19%              -22%               -24%               -25%                -25%                -27%          -33%           -36%             -38%             -43%              -45%             -46%               -48%             -49%        -50%              -50%        -53%               -55%         -56%          -59% 
  AD:c_d insert 1x1             230000/s                   225481%                   225481%                     223155%                   218504%                   216179%                     216179%                        8039%                      6644%              946%              876%              876%              830%                737%                650%              542%                 527%              527%              481%              481%                 434%                434%                365%               341%              293%               272%              269%              225%              199%        109%                 98%                  93%              91%              86%              84%              78%               69%               65%                60%                 56%         43%                 20%                  18%                 --               -2%                 -4%               -8%               -10%               -11%                -11%                -13%          -21%           -25%             -26%             -33%              -34%             -36%               -38%             -40%        -40%              -41%        -44%               -47%         -48%          -52% 
  AD:L delete 1x10              240000/s                   230852%                   230852%                     228471%                   223709%                   221328%                     221328%                        8233%                      6804%              971%              900%              900%              852%                757%                668%              558%                 542%              542%              495%              495%                 447%                447%                376%               352%              302%               280%              278%              233%              206%        114%                102%                  97%              96%              90%              88%              83%               73%               69%                64%                 60%         47%                 23%                  21%                 2%                --                 -2%               -6%                -8%                -9%                 -9%                -11%          -19%           -23%             -25%             -31%              -33%             -34%               -37%             -39%        -39%              -40%        -43%               -46%         -47%          -50% 
  ADX:c_d insert 1x1            250000/s                   236485%                   236485%                     234046%                   229168%                   226729%                     226729%                        8436%                      6973%              997%              924%              924%              875%                778%                686%              574%                 558%              558%              509%              509%                 460%                460%                387%               363%              312%               290%              287%              241%              213%        119%                107%                 102%             100%              95%              93%              87%               78%               73%                68%                 64%         50%                 26%                  24%                 4%                2%                  --               -4%                -6%                -7%                 -7%                 -9%          -17%           -21%             -23%             -30%              -31%             -32%               -35%             -37%        -37%              -39%        -42%               -45%         -46%          -49% 
  AD:L delete 1x10              254000/s                   246719%                   246719%                     244174%                   239085%                   236541%                     236541%                        8805%                      7279%             1045%              968%              968%              917%                816%                721%              603%                 587%              587%              536%              536%                 485%                485%                408%               383%              330%               307%              304%              256%              227%        129%                116%                 111%             109%             103%             101%              95%               85%               80%                75%                 71%         57%                 32%                  29%                 9%                6%                  4%                --                -2%                -3%                 -3%                 -5%          -14%           -18%             -20%             -27%              -28%             -30%               -32%             -34%        -35%              -36%        -39%               -42%         -44%          -47% 
  ADX:L delete 1x10             260000/s                   251848%                   251848%                     249250%                   244055%                   241458%                     241458%                        8990%                      7432%             1068%              990%              990%              938%                835%                738%              618%                 601%              601%              549%              549%                 497%                497%                419%               393%              338%               315%              312%              263%              234%        133%                121%                 115%             114%             107%             105%              99%               89%               84%                79%                 75%         60%                 35%                  32%                11%                9%                  6%                2%                 --                -1%                 -1%                 -3%          -12%           -16%             -18%             -25%              -27%             -28%               -31%             -33%        -33%              -35%        -38%               -41%         -42%          -46% 
  AD:c_d delete 1x1             260000/s                   255163%                   255163%                     252531%                   247268%                   244636%                     244636%                        9110%                      7531%             1084%             1005%             1005%              952%                847%                749%              627%                 610%              610%              557%              557%                 505%                505%                426%               400%              344%               321%              318%              268%              238%        136%                124%                 118%             116%             110%             108%             102%               92%               86%                81%                 77%         62%                 36%                  34%                13%               10%                  7%                3%                 1%                 --                  0%                 -2%          -11%           -15%             -17%             -24%              -26%             -27%               -30%             -32%        -32%              -34%        -37%               -40%         -42%          -45% 
  ADX:c_d delete 1x1            270000/s                   255163%                   255163%                     252531%                   247268%                   244636%                     244636%                        9110%                      7531%             1084%             1005%             1005%              952%                847%                749%              627%                 610%              610%              557%              557%                 505%                505%                426%               400%              344%               321%              318%              268%              238%        136%                124%                 118%             116%             110%             108%             102%               92%               86%                81%                 77%         62%                 36%                  34%                13%               10%                  7%                3%                 1%                 0%                  --                 -2%          -11%           -15%             -17%             -24%              -26%             -27%               -30%             -32%        -32%              -34%        -37%               -40%         -42%          -45% 
  AD:L_l delete 1x10            270000/s                   262062%                   262062%                     259359%                   253954%                   251251%                     251251%                        9359%                      7737%             1116%             1035%             1035%              981%                872%                772%              647%                 629%              629%              575%              575%                 521%                521%                440%               413%              356%               332%              329%              278%              247%        143%                130%                 124%             122%             116%             114%             107%               97%               91%                86%                 82%         67%                 40%                  37%                16%               13%                 10%                6%                 4%                 2%                  2%                  --           -8%           -12%             -15%             -22%              -24%             -25%               -28%             -30%        -31%              -32%        -35%               -39%         -40%          -44% 
  AD:c_d empty                  297000/s                   287733%                   287733%                     284766%                   278831%                   275864%                     275864%                       10285%                      8505%             1235%             1146%             1146%             1086%                968%                857%              720%                 701%              701%              641%              641%                 582%                582%                493%               463%              401%               374%              371%              315%              281%        167%                152%                 146%             144%             137%             135%             128%              116%              110%               104%                100%         83%                 54%                  51%                27%               24%                 21%               16%                14%                12%                 12%                  9%            --            -4%              -6%             -14%              -16%             -18%               -21%             -24%        -24%              -25%        -29%               -33%         -34%          -38% 
  ADX:c_d empty                 311000/s                   301142%                   301142%                     298036%                   291825%                   288719%                     288719%                       10769%                      8906%             1297%             1204%             1204%             1142%               1018%                902%              758%                 738%              738%              676%              676%                 614%                614%                521%               490%              424%               396%              393%              334%              299%        179%                164%                 157%             155%             148%             145%             138%              126%              120%               114%                109%         91%                 61%                  58%                33%               30%                 27%               22%                19%                18%                 18%                 14%            4%             --              -2%             -11%              -13%             -14%               -18%             -20%        -20%              -22%        -26%               -30%         -31%          -36% 
  AD:L insert 1x1               318482/s                   308828%                   308828%                     305643%                   299273%                   296088%                     296088%                       11046%                      9135%             1333%             1237%             1237%             1173%               1046%                927%              780%                 759%              759%              696%              696%                 632%                632%                536%               505%              438%               409%              406%              345%              309%        186%                171%                 164%             162%             154%             152%             145%              132%              126%               119%                114%         96%                 65%                  62%                36%               33%                 30%               25%                22%                21%                 21%                 17%            7%             2%               --              -8%              -10%             -12%               -15%             -18%        -18%              -20%        -24%               -28%         -29%          -34% 
  AD:L insert 1x1               348950/s                   338374%                   338374%                     334884%                   327906%                   324416%                     324416%                       12112%                     10019%             1470%             1365%             1365%             1295%               1156%               1025%              864%                 842%              842%              772%              772%                 702%                702%                597%               562%              489%               458%              454%              388%              348%        214%                197%                 189%             187%             179%             176%             168%              154%              147%               140%                135%        115%                 81%                  77%                50%               46%                 43%               37%                34%                32%                 32%                 29%           17%            12%               9%               --               -2%              -4%                -7%             -10%        -11%              -12%        -17%               -21%         -23%          -28% 
  ADX:L insert 1x1              360000/s                   346328%                   346328%                     342757%                   335614%                   332042%                     332042%                       12400%                     10257%             1507%             1400%             1400%             1328%               1185%               1052%              887%                 864%              864%              792%              792%                 721%                721%                614%               578%              503%               471%              467%              400%              359%        221%                204%                 196%             194%             185%             182%             174%              160%              153%               146%                140%        120%                 85%                  82%                53%               50%                 46%               40%                37%                35%                 35%                 32%           20%            15%              12%               2%                --              -1%                -5%              -8%         -8%              -10%        -15%               -19%         -21%          -26% 
  AD:L delete 1x1               363000/s                   352627%                   352627%                     348990%                   341718%                   338081%                     338081%                       12627%                     10445%             1536%             1427%             1427%             1354%               1209%               1073%              905%                 881%              881%              809%              809%                 736%                736%                627%               590%              514%               481%              478%              409%              367%        227%                209%                 201%             199%             190%             188%             179%              165%              158%               150%                145%        124%                 89%                  85%                56%               52%                 49%               42%                40%                38%                 38%                 34%           22%            17%              14%               4%                1%               --                -3%              -6%         -7%               -9%        -13%               -18%         -19%          -25% 
  AD:L_l insert 1x1             379000/s                   367324%                   367324%                     363536%                   355960%                   352172%                     352172%                       13157%                     10884%             1604%             1490%             1490%             1415%               1263%               1122%              947%                 922%              922%              846%              846%                 771%                771%                657%               619%              540%               506%              502%              430%              387%        240%                222%                 214%             212%             203%             200%             191%              176%              168%               161%                155%        134%                 96%                  93%                62%               59%                 55%               48%                45%                43%                 43%                 40%           27%            21%              18%               8%                6%               4%                 --              -3%         -3%               -5%        -10%               -14%         -16%          -21% 
  AD:L delete 1x1               391000/s                   378806%                   378806%                     374899%                   367087%                   363181%                     363181%                       13571%                     11228%             1657%             1540%             1540%             1462%               1306%               1160%              979%                 954%              954%              876%              876%                 798%                798%                681%               642%              560%               525%              521%              446%              402%        251%                232%                 224%             221%             212%             209%             200%              185%              177%               169%                163%        141%                103%                  99%                67%               64%                 60%               53%                50%                48%                 48%                 44%           31%            25%              22%              11%                9%               7%                 3%               --          0%               -2%         -7%               -12%         -14%          -19% 
  AD:L empty                    393000/s                   380292%                   380292%                     376370%                   368527%                   364605%                     364605%                       13625%                     11272%             1664%             1547%             1547%             1468%               1311%               1165%              984%                 958%              958%              880%              880%                 801%                801%                684%               645%              562%               527%              523%              449%              404%        252%                233%                 225%             223%             213%             210%             201%              186%              178%               170%                164%        142%                103%                 100%                68%               64%                 60%               54%                50%                49%                 49%                 45%           32%            26%              23%              12%                9%               7%                 3%               0%          --               -1%         -7%               -11%         -13%          -19% 
  ADX:L delete 1x1              410000/s                   387899%                   387899%                     383900%                   375900%                   371900%                     371900%                       13900%                     11499%             1700%             1580%             1580%             1500%               1339%               1190%             1005%                 979%              979%              900%              900%                 819%                819%                700%               660%              575%               540%              536%              459%              414%        259%                240%                 231%             229%             220%             216%             207%              192%              184%               175%                169%        147%                108%                 104%                72%               68%                 64%               57%                54%                52%                 52%                 48%           34%            28%              25%              14%               11%               9%                 5%               2%          2%                --         -5%               -10%         -12%          -17% 
  AD:L empty                    422000/s                   409182%                   409182%                     404963%                   396524%                   392305%                     392305%                       14667%                     12136%             1798%             1672%             1672%             1587%               1418%               1261%             1066%                1039%             1039%              954%              954%                 870%                870%                743%               701%              613%               575%              570%              490%              442%        279%                259%                 250%             247%             237%             234%             224%              208%              199%               191%                184%        160%                119%                 115%                81%               77%                 72%               65%                62%                60%                 60%                 56%           42%            35%              32%              20%               18%              16%                11%               8%          7%                5%          --                -5%          -7%          -13% 
  AD:L_l delete 1x1             444600/s                   431202%                   431202%                     426756%                   417863%                   413417%                     413417%                       15462%                     12794%             1900%             1767%             1767%             1678%               1500%               1334%             1129%                1100%             1100%             1011%             1011%                 922%                922%                789%               744%              651%               611%              606%              522%              471%        300%                278%                 269%             266%             255%             252%             242%              224%              215%               206%                199%        174%                131%                 126%                91%               86%                 82%               74%                71%                68%                 68%                 64%           49%            43%              39%              27%               24%              22%                17%              13%         13%               11%          5%                 --          -2%           -8% 
  ADX:L empty                   450000/s                   440809%                   440809%                     436263%                   427172%                   422627%                     422627%                       15809%                     13081%             1945%             1809%             1809%             1718%               1536%               1366%             1156%                1127%             1127%             1036%             1036%                 945%                945%                809%               763%              668%               627%              622%              536%              484%        309%                287%                 277%             274%             263%             259%             249%              231%              222%               213%                206%        180%                136%                 131%                95%               90%                 86%               78%                75%                72%                 72%                 68%           53%            46%              42%              30%               27%              24%                19%              16%         15%               13%          7%                 2%           --           -6% 
  AD:L_l empty                  485300/s                   470773%                   470773%                     465919%                   456210%                   451356%                     451356%                       16890%                     13977%             2084%             1938%             1938%             1841%               1647%               1466%             1242%                1210%             1210%             1113%             1113%                1016%               1016%                870%               822%              720%               676%              671%              579%              524%        336%                313%                 302%             300%             288%             284%             273%              254%              244%               234%                227%        199%                152%                 147%               108%              103%                 99%               90%                86%                84%                 84%                 79%           63%            56%              52%              39%               35%              33%                28%              24%         23%               21%         15%                 9%           6%            -- 
 
 Legends:
   AD:L delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::LCSidx
   AD:L delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::LCS
   AD:L delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::LCS
   AD:L empty: dataset=empty participant=Algorithm::Diff::LCS
   AD:L insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::LCSidx
   AD:L insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::LCS
   AD:L insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::LCS
   AD:L insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::LCS
   AD:L_l delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::LCS_length
   AD:L_l delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::LCS_length
   AD:L_l delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::LCS_length
   AD:L_l empty: dataset=empty participant=Algorithm::Diff::LCS_length
   AD:L_l insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::LCS_length
   AD:L_l insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::LCS_length
   AD:L_l insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::LCS_length
   AD:L_l insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::LCS_length
   AD:c_d delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::compact_diff
   AD:c_d delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::compact_diff
   AD:c_d delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::compact_diff
   AD:c_d empty: dataset=empty participant=Algorithm::Diff::compact_diff
   AD:c_d insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::compact_diff
   AD:c_d insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::compact_diff
   AD:c_d insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::compact_diff
   AD:c_d insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::compact_diff
   AD:d delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::diff
   AD:d delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::diff
   AD:d delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::diff
   AD:d empty: dataset=empty participant=Algorithm::Diff::diff
   AD:d insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::diff
   AD:d insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::diff
   AD:d insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::diff
   AD:d insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::diff
   AD:s delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::sdiff
   AD:s delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::sdiff
   AD:s delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::sdiff
   AD:s empty: dataset=empty participant=Algorithm::Diff::sdiff
   AD:s insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::sdiff
   AD:s insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::sdiff
   AD:s insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::sdiff
   AD:s insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::sdiff
   ADX:L delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::XS::LCSidx
   ADX:L empty: dataset=empty participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::XS::LCSidx
   ADX:L insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::XS::LCSidx
   ADX:c_d delete 10x1: dataset=delete 10x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d delete 1x1: dataset=delete 1x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d delete 1x10: dataset=delete 1x10 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d empty: dataset=empty participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert 10x1: dataset=insert 10x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert 1x1: dataset=insert 1x1 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert 1x10: dataset=insert 1x10 participant=Algorithm::Diff::XS::compact_diff
   ADX:c_d insert+delete 150x1: dataset=insert+delete 150x1 participant=Algorithm::Diff::XS::compact_diff

Benchmark module startup overhead (C<< bencher -m Algorithm::Diff::Diff --module-startup >>):

 #table2#
 +---------------------+-----------+-------------------+-----------------------+-----------------------+----------+---------+
 | participant         | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors  | samples |
 +---------------------+-----------+-------------------+-----------------------+-----------------------+----------+---------+
 | Algorithm::Diff::XS |      15   |               8.7 |                 0.00% |               138.30% | 6.9e-05  |      20 |
 | Algorithm::Diff     |      12   |               5.7 |                27.16% |                87.40% |   0.0001 |      20 |
 | perl -e1 (baseline) |       6.3 |               0   |               138.30% |                 0.00% | 2.3e-05  |      20 |
 +---------------------+-----------+-------------------+-----------------------+-----------------------+----------+---------+


Formatted as L<Benchmark.pm|Benchmark> result:

                          Rate  AD:X   A:D  perl -e1 (baseline) 
  AD:X                  66.7/s    --  -19%                 -58% 
  A:D                   83.3/s   25%    --                 -47% 
  perl -e1 (baseline)  158.7/s  138%   90%                   -- 
 
 Legends:
   A:D: mod_overhead_time=5.7 participant=Algorithm::Diff
   AD:X: mod_overhead_time=8.7 participant=Algorithm::Diff::XS
   perl -e1 (baseline): mod_overhead_time=0 participant=perl -e1 (baseline)

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Algorithm-Diff>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Algorithm-Diff>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2017 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Algorithm-Diff>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
