# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V20::Enums::UserListSizeRangeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                            => "UNSPECIFIED",
  UNKNOWN                                => "UNKNOWN",
  LESS_THAN_FIVE_HUNDRED                 => "LESS_THAN_FIVE_HUNDRED",
  LESS_THAN_ONE_THOUSAND                 => "LESS_THAN_ONE_THOUSAND",
  ONE_THOUSAND_TO_TEN_THOUSAND           => "ONE_THOUSAND_TO_TEN_THOUSAND",
  TEN_THOUSAND_TO_FIFTY_THOUSAND         => "TEN_THOUSAND_TO_FIFTY_THOUSAND",
  FIFTY_THOUSAND_TO_ONE_HUNDRED_THOUSAND =>
    "FIFTY_THOUSAND_TO_ONE_HUNDRED_THOUSAND",
  ONE_HUNDRED_THOUSAND_TO_THREE_HUNDRED_THOUSAND =>
    "ONE_HUNDRED_THOUSAND_TO_THREE_HUNDRED_THOUSAND",
  THREE_HUNDRED_THOUSAND_TO_FIVE_HUNDRED_THOUSAND =>
    "THREE_HUNDRED_THOUSAND_TO_FIVE_HUNDRED_THOUSAND",
  FIVE_HUNDRED_THOUSAND_TO_ONE_MILLION =>
    "FIVE_HUNDRED_THOUSAND_TO_ONE_MILLION",
  ONE_MILLION_TO_TWO_MILLION       => "ONE_MILLION_TO_TWO_MILLION",
  TWO_MILLION_TO_THREE_MILLION     => "TWO_MILLION_TO_THREE_MILLION",
  THREE_MILLION_TO_FIVE_MILLION    => "THREE_MILLION_TO_FIVE_MILLION",
  FIVE_MILLION_TO_TEN_MILLION      => "FIVE_MILLION_TO_TEN_MILLION",
  TEN_MILLION_TO_TWENTY_MILLION    => "TEN_MILLION_TO_TWENTY_MILLION",
  TWENTY_MILLION_TO_THIRTY_MILLION => "TWENTY_MILLION_TO_THIRTY_MILLION",
  THIRTY_MILLION_TO_FIFTY_MILLION  => "THIRTY_MILLION_TO_FIFTY_MILLION",
  OVER_FIFTY_MILLION               => "OVER_FIFTY_MILLION"
];

1;
