package Tk::Scale;
use vars qw($VERSION);
$VERSION = '3.012'; # $Id: //depot/Tk8/Scale/Scale.pm#12 $
use Tk qw($XS_VERSION);
use AutoLoader;
use base  qw(Tk::Widget);
Construct Tk::Widget 'Scale';
bootstrap Tk::Scale;
sub Tk_cmd{\&Tk::scale}Tk::Methods('coords','get','identify','set');
import Tk qw(Ev);
sub ClassInit{my($class,$mw)=@_;
$mw->bind($class,'<Enter>',['Enter',Ev('x'),Ev('y')]);
$mw->bind($class,'<Motion>',['Activate',Ev('x'),Ev('y')]);
$mw->bind($class,'<Leave>','Leave');
$mw->bind($class,'<1>',['ButtonDown',Ev('x'),Ev('y')]);
$mw->bind($class,'<B1-Motion>',['Drag',Ev('x'),Ev('y')]);
$mw->bind($class,'<B1-Leave>','NoOp');
$mw->bind($class,'<B1-Enter>','NoOp');
$mw->bind($class,'<ButtonRelease-1>',['ButtonUp',Ev('x'),Ev('y')]);
$mw->bind($class,'<2>',['ButtonDown',Ev('x'),Ev('y')]);
$mw->bind($class,'<B2-Motion>',['Drag',Ev('x'),Ev('y')]);
$mw->bind($class,'<B2-Leave>','NoOp');
$mw->bind($class,'<B2-Enter>','NoOp');
$mw->bind($class,'<ButtonRelease-2>',['ButtonUp',Ev('x'),Ev('y')]);
$mw->bind($class,'<Control-1>',['ControlPress',Ev('x'),Ev('y')]);
$mw->bind($class,'<Up>',['Increment','up','little','noRepeat']);
$mw->bind($class,'<Down>',['Increment','down','little','noRepeat']);
$mw->bind($class,'<Left>',['Increment','up','little','noRepeat']);
$mw->bind($class,'<Right>',['Increment','down','little','noRepeat']);
$mw->bind($class,'<Control-Up>',['Increment','up','big','noRepeat']);
$mw->bind($class,'<Control-Down>',['Increment','down','big','noRepeat']);
$mw->bind($class,'<Control-Left>',['Increment','up','big','noRepeat']);
$mw->bind($class,'<Control-Right>',['Increment','down','big','noRepeat']);
$mw->bind($class,'<Home>',['set',Ev('cget','-from')]);
$mw->bind($class,'<End>',['set',Ev('cget','-to')]);
return$class;}1;
__END__
sub Activate{my$w=shift;
my$x=shift;
my$y=shift;
return if($w->cget('-state')eq 'disabled');
my$ident=$w->identify($x,$y);
if(defined($ident)&&$ident eq 'slider'){$w->configure(-state=>'active')}else{$w->configure(-state=>'normal')}}sub Leave{my($w)=@_;
$w->configure('-activebackground',$w->{'activeBg'})if($Tk::strictMotif);
$w->configure('-state','normal')if($w->cget('-state')eq 'active');}sub Enter{my($w,$x,$y)=@_;
if($Tk::strictMotif){$w->{'activeBg'}=$w->cget('-activebackground');
$w->configure('-activebackground',$w->cget('-background'));}$w->Activate($x,$y);}sub ButtonUp{my($w,$x,$y)=@_;
$w->CancelRepeat();
$w->EndDrag();
$w->Activate($x,$y)}sub ButtonDown{my$w=shift;
my$x=shift;
my$y=shift;
$Tk::dragging=0;
$el=$w->identify($x,$y);
return unless($el);
if($el eq 'trough1'){$w->Increment('up','little','initial')}elsif($el eq 'trough2'){$w->Increment('down','little','initial')}elsif($el eq 'slider'){$Tk::dragging=1;
my@coords=$w->coords();
$Tk::deltaX=$x-$coords[0];
$Tk::deltaY=$y-$coords[1];}}sub Drag{my$w=shift;
my$x=shift;
my$y=shift;
if(!$Tk::dragging){return;}$w->set($w->get($x-$Tk::deltaX,$y-$Tk::deltaY))}sub EndDrag{my$w=shift;
if(!$Tk::dragging){return;}$Tk::dragging=0;}sub Increment{my$w=shift;
my$dir=shift;
my$big=shift;
my$repeat=shift;
my$inc;
if($big eq 'big'){$inc=$w->cget('-bigincrement');
if($inc==0){$inc=abs(($w->cget('-to')-$w->cget('-from')))/10.0}if($inc<$w->cget('-resolution')){$inc=$w->cget('-resolution')}}else{$inc=$w->cget('-resolution')}if(($w->cget('-from')>$w->cget('-to'))^($dir eq 'up')){$inc=-$inc}$w->set($w->get()+$inc);
if($repeat eq 'again'){$w->RepeatId($w->after($w->cget('-repeatinterval'),'Increment',$w,$dir,$big,'again'));}elsif($repeat eq 'initial'){$w->RepeatId($w->after($w->cget('-repeatdelay'),'Increment',$w,$dir,$big,'again'));}}sub ControlPress{my($w,$x,$y)=@_;
my$el=$w->identify($x,$y);
return unless($el);
if($el eq 'trough1'){$w->set($w->cget('-from'))}elsif($el eq 'trough2'){$w->set($w->cget('-to'))}}
