BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( File::Copy File::Glob experimental feature parent strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  require './inc/need-zig.pl';
  require './inc/size.pl';
  unless(eval q{ use 5.020; 1}) {
    print "Perl 5.020 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.79.
use strict;
use warnings;
use 5.020;
use ExtUtils::MakeMaker;
use File::ShareDir::Install;

$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS  = 1;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Documentation and tools for using Platypus with the Zig programming language",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Capture::Tiny"           => 0,
    "ExtUtils::MakeMaker"     => 0,
    "File::ShareDir::Install" => "0.06",
    "File::Which"             => 0,
    "File::chdir"             => 0,
    "Path::Tiny"              => 0
  },
  "DISTNAME"         => "FFI-Platypus-Lang-Zig",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020",
  "NAME"             => "FFI::Platypus::Lang::Zig",
  "PM"               => {
    "lib/FFI/Build/File/Zig.pm"    => "\$(INST_LIB)/FFI/Build/File/Zig.pm",
    "lib/FFI/Platypus/Lang/Zig.pm" => "\$(INST_LIB)/FFI/Platypus/Lang/Zig.pm"
  },
  "PREREQ_PM" => {
    "FFI::Build::File::Base" => 0,
    "FFI::CheckLib"          => "0.11",
    "FFI::Platypus"          => "2.03",
    "File::ShareDir::Dist"   => 0,
    "File::chdir"            => 0,
    "Path::Tiny"             => "0.130"
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => 0,
    "FFI::Build"    => 0,
    "FFI::Platypus" => "2.03",
    "Test2::V0"     => "0.000121",
    "Test::Script"  => 0
  },
  "VERSION" => "0.02",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny"          => 0,
  "FFI::Build"             => 0,
  "FFI::Build::File::Base" => 0,
  "FFI::CheckLib"          => "0.11",
  "FFI::Platypus"          => "2.03",
  "File::ShareDir::Dist"   => 0,
  "File::chdir"            => 0,
  "Path::Tiny"             => "0.130",
  "Test2::V0"              => "0.000121",
  "Test::Script"           => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
  package
    MY;
  use File::ShareDir::Install qw(postamble);
}