#!/usr/bin/perl -w

use strict;

my $n;
use Test::More tests => ($n = 19) * 6 + 4;
use lib "t/lib";
use Test::FloatNear;

BEGIN { use_ok("MPEG::Audio::Frame") };

my $s = 0;
for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg25, "MPEG 2.5");
	ok($frame->layer3, "layer III");
	ok(!$frame->broken, "frame is not broken");
	is($frame->sample, 11025, "sample rate");
	is($frame->length, length("$frame"), "actual frame is as large as calced");
	$s += $frame->seconds;
}

is_near($s, 0.992653061224489, "total duration is correct");

is(MPEG::Audio::Frame->read(*DATA), undef, "nothing left on __DATA__");
ok(eof(DATA), "eof(DATA)");

__DATA__
  ˂h    Oc7MM7	`?2\' (7&tdt?AMˆ$(?Aq}<8"{_  fE?KgeWw-!Tu~ap]ft[-v9[$Uyp*>9&ʣ3 ~^AD*`o2JZTm~uB3?(f.0o@x$6AZ1ЇQzs߹Z"#~^AJQTm+Ҥ׳O #/*rƠ}@Z;̒\ rT"O0 ,[~^@vvugggcyJ(-5]`
LH9A~<FWAfg*+ 0bvF"5z^0{CD3?M`*PEI )YkNVD}XGÅn:qO A{~^H>g
L5mP`s=?,ﱳ!ъw,GdJ9QsN4ӍJ?"N3z^0=du\ VXHq0m1ɲ*N)3ś7pr2WuSlڛ4:m
]AF Y[z1ڼD%Hbg.ͲFl5.Wپ$;Hug ("b^2iXɆJTr
_gZkIA&j@ ǲu}Cic?ܬ k~^2iɻ/|5O\79$	ZGvxyxvh rK!4R	5U5$x<V"uz^yڼ̳sۿTWg@[?IӌM}@b$nkBUH"#MEo_z;?YA ĂkzIڼ:⻿X07S	G'k/K.~VGlɞ[-I;/уA{,"ċîVL_/̓Xwwf ԭ5MP|xuL5*=ycsqxK{ao Ę;FdH-UzjFAKOW,IB;Y/_'5'ojﳷ9H[c &&"ĢKzz-vzb6(4,$~HI[n#eYoASNRSl[=mS2{oY9u Ĭs~`4-_PT5͊U_/pPbCk.x8"KK~<8ePPO
!j*R瞆"ĵzIh +,/"bpPU^VXP` 
a،
3ABҤLAME3.89 (beta)UUUUUUUUU Į%c@UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
