#!/usr/bin/perl
# $Id: 00-install.t 1858 2021-12-08 10:32:12Z willem $ -*-perl-*-
#

use strict;
use warnings;
use Test::More;
use File::Spec;
use File::Find;
use IO::File;
use ExtUtils::MakeMaker;


my %manifest;
my $handle = IO::File->new( 'MANIFEST', '<' ) or BAIL_OUT("MANIFEST: $!");
while (<$handle>) {
	my ($filename) = split;
	$manifest{$filename}++;
}
close $handle;

plan skip_all => 'No versions from git checkouts' if -e '.git';

plan skip_all => 'Not sure how to parse versions.' unless eval { MM->can('parse_version') };

plan tests => scalar keys %manifest;

my @diag;

foreach ( sort keys %manifest ) {				# reconcile files with MANIFEST
	next unless ok( -f $_, "file exists\t$_" );
	next unless /\.pm$/;
	next unless /^lib/;

	my $module = File::Spec->catfile( 'blib', $_ );		# library component
	push @diag, "Missing module: $module" unless -f $module;

	my $version = MM->parse_version($_);			# module version
	push @diag, "\$VERSION = $version\t$_" unless $version =~ /^\d/;
}


my @files;							# flag MANIFEST omissions
find( sub { push( @files, $File::Find::name ) if /\.pm$/ }, 'lib' );
foreach ( sort @files ) {
	next if /Template.pm$/;
	push @diag, "Filename not in MANIFEST: $_" unless $manifest{$_};
}


diag join "\n\t", '', @diag if @diag;

exit;

__END__

